/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.internal.zzda;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzla;
import java.util.HashMap;

@zzig
public class zzk
extends FrameLayout
implements zzh {
    private final zzla zzBb;
    private final FrameLayout zzHP;
    private final zzy zzHQ;
    @Nullable
    private zzi zzHR;
    private boolean zzHS;
    private boolean zzHT;
    private TextView zzHU;
    private long zzHV;
    private long zzHW;
    private String zzHX;
    private String zzCv;

    public static void zzh(zzla zzla2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzla2.zza("onVideoEvent", hashMap);
    }

    public zzk(Context context, zzla zzla2, int n, boolean bl, zzdc zzdc2, zzda zzda2) {
        super(context);
        this.zzBb = zzla2;
        this.zzHP = new FrameLayout(context);
        this.addView((View)this.zzHP, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzb.zzv((Object)zzla2.zzjA());
        this.zzHR = zzla2.zzjA().zzqn.zza(context, zzla2, n, bl, zzdc2, zzda2);
        if (this.zzHR != null) {
            this.zzHP.addView((View)this.zzHR, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        }
        this.zzHU = new TextView(context);
        this.zzHU.setBackgroundColor(-16777216);
        this.zzgJ();
        this.zzHQ = new zzy(this);
        this.zzHQ.zzhf();
        if (this.zzHR != null) {
            this.zzHR.zza(this);
        }
        if (this.zzHR == null) {
            this.zzj("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3 + 2, n4 + 2);
        layoutParams.setMargins(n - 1, n2 - 1, 0, 0);
        this.zzHP.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public void setMimeType(String string) {
        this.zzHX = string;
    }

    public void zzav(String string) {
        this.zzCv = string;
    }

    public void zza(float f, float f2) {
        if (this.zzHR != null) {
            this.zzHR.zza(f, f2);
        }
    }

    public void zzfp() {
        if (this.zzHR == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzCv)) {
            this.zzHR.setMimeType(this.zzHX);
            this.zzHR.setVideoPath(this.zzCv);
        } else {
            this.zza("no_src", new String[0]);
        }
    }

    public void pause() {
        if (this.zzHR == null) {
            return;
        }
        this.zzHR.pause();
    }

    public void play() {
        if (this.zzHR == null) {
            return;
        }
        this.zzHR.play();
    }

    public void seekTo(int n) {
        if (this.zzHR == null) {
            return;
        }
        this.zzHR.seekTo(n);
    }

    public void zzgi() {
        if (this.zzHR == null) {
            return;
        }
        this.zzHR.zzgi();
    }

    public void zzgj() {
        if (this.zzHR == null) {
            return;
        }
        this.zzHR.zzgj();
    }

    public void zza(float f) {
        if (this.zzHR == null) {
            return;
        }
        this.zzHR.zza(f);
    }

    public void zzd(MotionEvent motionEvent) {
        if (this.zzHR == null) {
            return;
        }
        this.zzHR.dispatchTouchEvent(motionEvent);
    }

    public void zzgH() {
        if (this.zzHR == null) {
            return;
        }
        Context context = this.zzHR.getContext();
        TextView textView = new TextView(context);
        String string = String.valueOf(this.zzHR.zzgc());
        textView.setText((CharSequence)(string.length() != 0 ? "AdMob - ".concat(string) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzHP.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzHP.bringChildToFront((View)textView);
    }

    @Override
    public void zzgC() {
        zzka.zzQu.post(new Runnable(){

            @Override
            public void run() {
                zzk.this.zza("surfaceCreated", new String[0]);
            }
        });
    }

    @Override
    public void zzgD() {
        if (this.zzHR == null) {
            return;
        }
        if (this.zzHW == 0L) {
            float f = (float)this.zzHR.getDuration() / 1000.0f;
            int n = this.zzHR.getVideoWidth();
            int n2 = this.zzHR.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public void zzgE() {
        this.zzgM();
    }

    @Override
    public void onPaused() {
        this.zza("pause", new String[0]);
        this.zzgN();
    }

    @Override
    public void zzgF() {
        this.zza("ended", new String[0]);
        this.zzgN();
    }

    @Override
    public void zzj(String string, String string2) {
        this.zza("error", "what", string, "extra", string2);
    }

    @Override
    public void zzgG() {
        this.zzgJ();
        this.zzHW = this.zzHV;
        zzka.zzQu.post(new Runnable(){

            @Override
            public void run() {
                zzk.this.zza("surfaceDestroyed", new String[0]);
            }
        });
    }

    public void destroy() {
        this.zzHQ.cancel();
        if (this.zzHR != null) {
            this.zzHR.stop();
        }
        this.zzgN();
    }

    void zzgI() {
        if (this.zzHR == null) {
            return;
        }
        long l = this.zzHR.getCurrentPosition();
        if (this.zzHV != l && l > 0L) {
            this.zzgK();
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzHV = l;
        }
    }

    private void zzgJ() {
        if (!this.zzgL()) {
            this.zzHP.addView((View)this.zzHU, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.zzHP.bringChildToFront((View)this.zzHU);
        }
    }

    private void zzgK() {
        if (this.zzgL()) {
            this.zzHP.removeView((View)this.zzHU);
        }
    }

    private boolean zzgL() {
        return this.zzHU.getParent() != null;
    }

    private void zza(String string, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string);
        String string2 = null;
        for (String string3 : stringArray) {
            if (string2 == null) {
                string2 = string3;
                continue;
            }
            hashMap.put(string2, string3);
            string2 = null;
        }
        this.zzBb.zza("onVideoEvent", hashMap);
    }

    private void zzgM() {
        if (this.zzBb.zzjy() == null) {
            return;
        }
        if (this.zzHS) {
            return;
        }
        WindowManager.LayoutParams layoutParams = this.zzBb.zzjy().getWindow().getAttributes();
        boolean bl = this.zzHT = (layoutParams.flags & 0x80) != 0;
        if (!this.zzHT) {
            this.zzBb.zzjy().getWindow().addFlags(128);
            this.zzHS = true;
        }
    }

    private void zzgN() {
        if (this.zzBb.zzjy() == null) {
            return;
        }
        if (this.zzHS && !this.zzHT) {
            this.zzBb.zzjy().getWindow().clearFlags(128);
            this.zzHS = false;
        }
    }
}

