/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Debug;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.ThinAdSizeParcel;
import com.google.android.gms.ads.internal.client.VideoOptionsParcel;
import com.google.android.gms.ads.internal.client.zzab;
import com.google.android.gms.ads.internal.client.zzf;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.client.zzw;
import com.google.android.gms.ads.internal.client.zzy;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzcd;
import com.google.android.gms.internal.zzcg;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzda;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzed;
import com.google.android.gms.internal.zzhh;
import com.google.android.gms.internal.zzhl;
import com.google.android.gms.internal.zzhv;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zziw;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzjs;
import com.google.android.gms.internal.zzjt;
import com.google.android.gms.internal.zzjw;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;

@zzig
public abstract class zza
extends zzu.zza
implements com.google.android.gms.ads.internal.client.zza,
zzp,
zza.zza,
zzed,
zzhv.zza,
zzjs {
    protected zzdc zzpQ;
    protected zzda zzpR;
    protected zzda zzpS;
    protected boolean zzpT = false;
    protected final zzr zzpU;
    protected final zzv zzpV;
    @Nullable
    protected transient AdRequestParcel zzpW;
    protected final zzby zzpX;
    protected final zzd zzpY;

    zza(zzv zzv2, @Nullable zzr zzr2, zzd zzd2) {
        this.zzpV = zzv2;
        this.zzpU = zzr2 != null ? zzr2 : new zzr(this);
        this.zzpY = zzd2;
        zzu.zzck().zzC(this.zzpV.zzov);
        zzu.zzcn().zzb(this.zzpV.zzov, this.zzpV.zzsx);
        this.zzpX = zzu.zzcn().zziP();
        this.zzbf();
    }

    private void zzbf() {
        if (zzcu.zzzg.get().booleanValue()) {
            Timer timer = new Timer();
            CountDownLatch countDownLatch = new CountDownLatch(zzcu.zzzi.get());
            TimerTask timerTask = this.zza(timer, countDownLatch);
            timer.schedule(timerTask, 0L, (long)zzcu.zzzh.get());
        }
    }

    private TimerTask zza(final Timer timer, final CountDownLatch countDownLatch) {
        return new TimerTask(){

            @Override
            public void run() {
                if ((long)zzcu.zzzi.get().intValue() != countDownLatch.getCount()) {
                    zzjw.zzaU((String)"Stopping method tracing");
                    Debug.stopMethodTracing();
                    if (countDownLatch.getCount() == 0L) {
                        timer.cancel();
                        return;
                    }
                }
                String string = String.valueOf(zza.this.zzpV.zzov.getPackageName()).concat("_adsTrace_");
                try {
                    zzjw.zzaU((String)"Starting method tracing");
                    countDownLatch.countDown();
                    long l = zzu.zzco().currentTimeMillis();
                    Debug.startMethodTracing((String)new StringBuilder(20 + String.valueOf(string).length()).append(string).append(l).toString(), (int)zzcu.zzzj.get());
                }
                catch (Exception exception) {
                    zzjw.zzd((String)"Exception occurred while starting method tracing.", (Throwable)exception);
                    return;
                }
            }
        };
    }

    public void zzbg() {
        this.zzpQ = new zzdc(zzcu.zzxF.get(), "load_ad", this.zzpV.zzsB.zzvs);
        this.zzpR = new zzda(-1L, null, null);
        this.zzpS = new zzda(-1L, null, null);
    }

    public void destroy() {
        zzaa.zzdc((String)"destroy must be called on the main UI thread.");
        this.zzpU.cancel();
        this.zzpX.zzj(this.zzpV.zzsC);
        this.zzpV.destroy();
    }

    public com.google.android.gms.dynamic.zzd zzbh() {
        zzaa.zzdc((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzD((Object)((Object)this.zzpV.zzsy));
    }

    @Nullable
    public AdSizeParcel zzbi() {
        zzaa.zzdc((String)"getAdSize must be called on the main UI thread.");
        return this.zzpV.zzsB == null ? null : new ThinAdSizeParcel(this.zzpV.zzsB);
    }

    public boolean isReady() {
        zzaa.zzdc((String)"isLoaded must be called on the main UI thread.");
        return this.zzpV.zzsz == null && this.zzpV.zzsA == null && this.zzpV.zzsC != null;
    }

    public void setManualImpressionsEnabled(boolean bl) {
        throw new UnsupportedOperationException("Attempt to call setManualImpressionsEnabled for an unsupported ad type.");
    }

    private AdRequestParcel zza(AdRequestParcel adRequestParcel) {
        if (zzi.zzaC((Context)this.zzpV.zzov) && adRequestParcel.zzuV != null) {
            return new zzf(adRequestParcel).zza(null).zzdA();
        }
        return adRequestParcel;
    }

    public boolean zzb(AdRequestParcel adRequestParcel) {
        zzaa.zzdc((String)"loadAd must be called on the main UI thread.");
        adRequestParcel = this.zza(adRequestParcel);
        if (this.zzpV.zzsz != null || this.zzpV.zzsA != null) {
            if (this.zzpW != null) {
                zzjw.zzaW((String)"Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            } else {
                zzjw.zzaW((String)"Loading already in progress, saving this object for future refreshes.");
            }
            this.zzpW = adRequestParcel;
            return false;
        }
        zzjw.zzaV((String)"Starting ad request.");
        this.zzbg();
        this.zzpR = this.zzpQ.zzeA();
        if (!adRequestParcel.zzuQ) {
            String string = String.valueOf(zzm.zzdQ().zzP(this.zzpV.zzov));
            zzjw.zzaV((String)new StringBuilder(71 + String.valueOf(string).length()).append("Use AdRequest.Builder.addTestDevice(\"").append(string).append("\") to get test ads on this device.").toString());
        }
        this.zzpT = this.zza(adRequestParcel, this.zzpQ);
        return this.zzpT;
    }

    protected abstract boolean zza(AdRequestParcel var1, zzdc var2);

    @Override
    public void zza(zzjn.zza zza2) {
        long l;
        if (zza2.zzPi.zzLT != -1L && !TextUtils.isEmpty((CharSequence)zza2.zzPi.zzMd) && (l = this.zzs(zza2.zzPi.zzMd)) != -1L) {
            zzda zzda2 = this.zzpQ.zzc(zza2.zzPi.zzLT + l);
            this.zzpQ.zza(zzda2, "stc");
        }
        this.zzpQ.zzS(zza2.zzPi.zzMd);
        this.zzpQ.zza(this.zzpR, "arf");
        this.zzpS = this.zzpQ.zzeA();
        this.zzpQ.zzf("gqi", zza2.zzPi.zzMe);
        this.zzpV.zzsz = null;
        this.zzpV.zzsD = zza2;
        this.zza(zza2, this.zzpQ);
    }

    protected abstract void zza(zzjn.zza var1, zzdc var2);

    boolean zza(zzjn zzjn2) {
        return false;
    }

    @Override
    public void zzb(zzjn zzjn2) {
        this.zzpQ.zza(this.zzpS, "awr");
        this.zzpV.zzsA = null;
        if (zzjn2.errorCode != -2 && zzjn2.errorCode != 3) {
            zzu.zzcn().zzb(this.zzpV.zzcF());
        }
        if (zzjn2.errorCode == -1) {
            this.zzpT = false;
            return;
        }
        if (this.zza(zzjn2)) {
            zzjw.zzaU((String)"Ad refresh scheduled.");
        }
        if (zzjn2.errorCode != -2) {
            this.zzf(zzjn2.errorCode);
            return;
        }
        if (this.zzpV.zzsV == null) {
            this.zzpV.zzsV = new zzjt(this.zzpV.zzsv);
        }
        this.zzpX.zzi(this.zzpV.zzsC);
        if (this.zza(this.zzpV.zzsC, zzjn2)) {
            this.zzpV.zzsC = zzjn2;
            this.zzpV.zzcO();
            this.zzpQ.zzf("is_mraid", this.zzpV.zzsC.zzdi() ? "1" : "0");
            this.zzpQ.zzf("is_mediation", this.zzpV.zzsC.zzLP ? "1" : "0");
            if (this.zzpV.zzsC.zzHF != null && this.zzpV.zzsC.zzHF.zzjD() != null) {
                this.zzpQ.zzf("is_delay_pl", this.zzpV.zzsC.zzHF.zzjD().zzjS() ? "1" : "0");
            }
            this.zzpQ.zza(this.zzpR, "ttc");
            if (zzu.zzcn().zziG() != null) {
                zzu.zzcn().zziG().zza(this.zzpQ);
            }
            if (this.zzpV.zzcJ()) {
                this.zzbp();
            }
        }
        if (zzjn2.zzEI != null) {
            zzu.zzck().zza(this.zzpV.zzov, zzjn2.zzEI);
        }
    }

    protected abstract boolean zza(@Nullable zzjn var1, zzjn var2);

    public void onAdClicked() {
        if (this.zzpV.zzsC == null) {
            zzjw.zzaW((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        zzjw.zzaU((String)"Pinging click URLs.");
        this.zzpV.zzsE.zziu();
        if (this.zzpV.zzsC.zzEF != null) {
            zzu.zzck().zza(this.zzpV.zzov, this.zzpV.zzsx.afmaVersion, this.zzpV.zzsC.zzEF);
        }
        if (this.zzpV.zzsF != null) {
            try {
                this.zzpV.zzsF.onAdClicked();
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not notify onAdClicked event.", (Throwable)remoteException);
            }
        }
    }

    @Override
    public void zzbj() {
        this.zzbn();
    }

    @Override
    public void onAppEvent(String string, @Nullable String string2) {
        if (this.zzpV.zzsH != null) {
            try {
                this.zzpV.zzsH.onAppEvent(string, string2);
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not call the AppEventListener.", (Throwable)remoteException);
            }
        }
    }

    public void zzbk() {
        zzaa.zzdc((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzpV.zzsC == null) {
            zzjw.zzaW((String)"Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzjw.zzaU((String)"Pinging manual tracking URLs.");
        if (this.zzpV.zzsC.zzLR != null && !this.zzpV.zzsC.zzPg) {
            zzu.zzck().zza(this.zzpV.zzov, this.zzpV.zzsx.afmaVersion, this.zzpV.zzsC.zzLR);
            this.zzpV.zzsC.zzPg = true;
        }
    }

    public void pause() {
        zzaa.zzdc((String)"pause must be called on the main UI thread.");
    }

    public void resume() {
        zzaa.zzdc((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzc(AdRequestParcel adRequestParcel) {
        if (this.zzpV.zzsy == null) {
            return false;
        }
        ViewParent viewParent = this.zzpV.zzsy.getParent();
        if (!(viewParent instanceof View)) {
            return false;
        }
        View view = (View)viewParent;
        return zzu.zzck().zza(view, view.getContext());
    }

    public void zzd(AdRequestParcel adRequestParcel) {
        if (this.zzc(adRequestParcel)) {
            this.zzb(adRequestParcel);
        } else {
            zzjw.zzaV((String)"Ad is not visible. Not refreshing ad.");
            this.zzpU.zzg(adRequestParcel);
        }
    }

    public void zza(zzq zzq2) {
        zzaa.zzdc((String)"setAdListener must be called on the main UI thread.");
        this.zzpV.zzsG = zzq2;
    }

    public void zza(com.google.android.gms.ads.internal.reward.client.zzd zzd2) {
        zzaa.zzdc((String)"setRewardedVideoAdListener can only be called from the UI thread.");
        this.zzpV.zzsS = zzd2;
    }

    public void setUserId(String string) {
        zzjw.zzaW((String)"RewardedVideoAd.setUserId() is deprecated. Please do not call this method.");
    }

    public void zza(com.google.android.gms.ads.internal.client.zzp zzp2) {
        zzaa.zzdc((String)"setAdListener must be called on the main UI thread.");
        this.zzpV.zzsF = zzp2;
    }

    public void zza(AdSizeParcel adSizeParcel) {
        zzaa.zzdc((String)"setAdSize must be called on the main UI thread.");
        this.zzpV.zzsB = adSizeParcel;
        if (this.zzpV.zzsC != null && this.zzpV.zzsC.zzHF != null && this.zzpV.zzsX == 0) {
            this.zzpV.zzsC.zzHF.zza(adSizeParcel);
        }
        if (this.zzpV.zzsy == null) {
            return;
        }
        if (this.zzpV.zzsy.getChildCount() > 1) {
            this.zzpV.zzsy.removeView(this.zzpV.zzsy.getNextView());
        }
        this.zzpV.zzsy.setMinimumWidth(adSizeParcel.widthPixels);
        this.zzpV.zzsy.setMinimumHeight(adSizeParcel.heightPixels);
        this.zzpV.zzsy.requestLayout();
    }

    public void zza(zzw zzw2) {
        zzaa.zzdc((String)"setAppEventListener must be called on the main UI thread.");
        this.zzpV.zzsH = zzw2;
    }

    public void zza(zzhh zzhh2) {
        throw new IllegalStateException("setInAppPurchaseListener is not supported for current ad type");
    }

    public void zza(zzdg zzdg2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    public void zza(zzhl zzhl2, String string) {
        throw new IllegalStateException("setPlayStorePurchaseParams is not supported for current ad type");
    }

    public void zza(zzy zzy2) {
        zzaa.zzdc((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzpV.zzsI = zzy2;
    }

    public void stopLoading() {
        zzaa.zzdc((String)"stopLoading must be called on the main UI thread.");
        this.zzpT = false;
        this.zzpV.zzh(true);
    }

    public boolean isLoading() {
        return this.zzpT;
    }

    public zzab zzbl() {
        return null;
    }

    public void zza(@Nullable VideoOptionsParcel videoOptionsParcel) {
        zzaa.zzdc((String)"setVideoOptions must be called on the main UI thread.");
        this.zzpV.zzsQ = videoOptionsParcel;
    }

    Bundle zza(@Nullable zzcg zzcg2) {
        if (zzcg2 == null) {
            return null;
        }
        if (zzcg2.zzdx()) {
            zzcg2.wakeup();
        }
        zzcd zzcd2 = zzcg2.zzdv();
        String string = null;
        String string2 = null;
        if (zzcd2 != null) {
            string = zzcd2.zzdl();
            string2 = zzcd2.zzdm();
            String string3 = String.valueOf(zzcd2.toString());
            zzjw.zzaU((String)(string3.length() != 0 ? "In AdManager: loadAd, ".concat(string3) : new String("In AdManager: loadAd, ")));
            if (string != null) {
                zzu.zzcn().zzaL(string);
            }
        } else {
            string = zzu.zzcn().zziK();
        }
        if (string != null) {
            Bundle bundle = new Bundle(1);
            bundle.putString("fingerprint", string);
            if (!string.equals(string2)) {
                bundle.putString("v_fp", string2);
            }
            return bundle;
        }
        return null;
    }

    long zzs(String string) {
        int n = string.indexOf("ufe");
        int n2 = string.indexOf(44, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        try {
            return Long.parseLong(string.substring(n + 4, n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzjw.zzaW((String)"Invalid index for Url fetch time in CSI latency info.");
        }
        catch (NumberFormatException numberFormatException) {
            zzjw.zzaW((String)"Cannot find valid format of Url fetch time in CSI latency info.");
        }
        return -1L;
    }

    protected void zzb(View view) {
        this.zzpV.zzsy.addView(view, zzu.zzcm().zzjh());
    }

    protected void zzbm() {
        zzjw.zzaV((String)"Ad closing.");
        if (this.zzpV.zzsG != null) {
            try {
                this.zzpV.zzsG.onAdClosed();
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not call AdListener.onAdClosed().", (Throwable)remoteException);
            }
        }
        if (this.zzpV.zzsS != null) {
            try {
                this.zzpV.zzsS.onRewardedVideoAdClosed();
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdClosed().", (Throwable)remoteException);
            }
        }
    }

    protected void zzbn() {
        zzjw.zzaV((String)"Ad leaving application.");
        if (this.zzpV.zzsG != null) {
            try {
                this.zzpV.zzsG.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not call AdListener.onAdLeftApplication().", (Throwable)remoteException);
            }
        }
        if (this.zzpV.zzsS != null) {
            try {
                this.zzpV.zzsS.onRewardedVideoAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not call  RewardedVideoAdListener.onRewardedVideoAdLeftApplication().", (Throwable)remoteException);
            }
        }
    }

    protected void zzbo() {
        zzjw.zzaV((String)"Ad opening.");
        if (this.zzpV.zzsG != null) {
            try {
                this.zzpV.zzsG.onAdOpened();
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not call AdListener.onAdOpened().", (Throwable)remoteException);
            }
        }
        if (this.zzpV.zzsS != null) {
            try {
                this.zzpV.zzsS.onRewardedVideoAdOpened();
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdOpened().", (Throwable)remoteException);
            }
        }
    }

    protected void zzbp() {
        zzjw.zzaV((String)"Ad finished loading.");
        this.zzpT = false;
        if (this.zzpV.zzsG != null) {
            try {
                this.zzpV.zzsG.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not call AdListener.onAdLoaded().", (Throwable)remoteException);
            }
        }
        if (this.zzpV.zzsS != null) {
            try {
                this.zzpV.zzsS.onRewardedVideoAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdLoaded().", (Throwable)remoteException);
            }
        }
    }

    protected void zzf(int n) {
        zzjw.zzaW((String)new StringBuilder(30).append("Failed to load ad: ").append(n).toString());
        this.zzpT = false;
        if (this.zzpV.zzsG != null) {
            try {
                this.zzpV.zzsG.onAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
            }
        }
        if (this.zzpV.zzsS != null) {
            try {
                this.zzpV.zzsS.onRewardedVideoAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdFailedToLoad().", (Throwable)remoteException);
            }
        }
    }

    protected void zzbq() {
        if (this.zzpV.zzsS == null) {
            return;
        }
        try {
            this.zzpV.zzsS.onRewardedVideoStarted();
        }
        catch (RemoteException remoteException) {
            zzjw.zzd((String)"Could not call RewardedVideoAdListener.onVideoStarted().", (Throwable)remoteException);
        }
    }

    protected void zza(@Nullable RewardItemParcel rewardItemParcel) {
        if (this.zzpV.zzsS == null) {
            return;
        }
        try {
            String string = "";
            int n = 0;
            if (rewardItemParcel != null) {
                string = rewardItemParcel.type;
                n = rewardItemParcel.zzOV;
            }
            this.zzpV.zzsS.zza((com.google.android.gms.ads.internal.reward.client.zza)new zziw(string, n));
        }
        catch (RemoteException remoteException) {
            zzjw.zzd((String)"Could not call RewardedVideoAdListener.onRewarded().", (Throwable)remoteException);
        }
    }

    protected void zzc(@Nullable zzjn zzjn2) {
        if (zzjn2 == null) {
            zzjw.zzaW((String)"Ad state was null when trying to ping impression URLs.");
            return;
        }
        zzjw.zzaU((String)"Pinging Impression URLs.");
        this.zzpV.zzsE.zzit();
        if (zzjn2.zzEG != null && !zzjn2.zzPf) {
            zzu.zzck().zza(this.zzpV.zzov, this.zzpV.zzsx.afmaVersion, zzjn2.zzEG);
            zzjn2.zzPf = true;
        }
    }

    @Override
    public void zza(HashSet<zzjo> hashSet) {
        this.zzpV.zza(hashSet);
    }
}

