/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzkz;
import com.google.android.gms.internal.zzla;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.JSONObject;

@zzig
public final class zzeq
implements zzeh {
    private final Map<zzla, Integer> zzCs = new WeakHashMap<zzla, Integer>();
    private boolean zzCt;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                n2 = zzm.zzdQ().zza(context, Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzjw.zzaW((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    @Override
    public void zza(zzla zzla2, Map<String, String> map) {
        Object object;
        String string2 = map.get("action");
        if (string2 == null) {
            zzjw.zzaW((String)"Action missing from video GMSG.");
            return;
        }
        if (zzjw.zzX((int)3)) {
            object = new JSONObject(map);
            object.remove("google.afma.Notify_dt");
            String string3 = String.valueOf(object.toString());
            zzjw.zzaU((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Video GMSG: ").append(string2).append(" ").append(string3).toString());
        }
        if ("background".equals(string2)) {
            object = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object)) {
                zzjw.zzaW((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                zzk zzk2;
                int n = Color.parseColor((String)object);
                zzkz zzkz2 = zzla2.zzjK();
                if (zzkz2 != null && (zzk2 = zzkz2.zzjv()) != null) {
                    zzk2.setBackgroundColor(n);
                    return;
                }
                this.zzCs.put(zzla2, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzjw.zzaW((String)"Invalid color parameter in video GMSG.");
            }
            return;
        }
        object = zzla2.zzjK();
        if (object == null) {
            zzjw.zzaW((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzla2.getContext();
            int n2 = zzeq.zza(context, map, "x", 0);
            int n3 = zzeq.zza(context, map, "y", 0);
            int n4 = zzeq.zza(context, map, "w", -1);
            int n5 = zzeq.zza(context, map, "h", -1);
            try {
                n = Integer.parseInt(map.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean(map.get("spherical"));
            if (bl && ((zzkz)object).zzjv() == null) {
                ((zzkz)object).zza(n2, n3, n4, n5, n, bl3);
                if (this.zzCs.containsKey(zzla2)) {
                    int n6 = this.zzCs.get(zzla2);
                    zzk zzk3 = ((zzkz)object).zzjv();
                    zzk3.setBackgroundColor(n6);
                }
            } else {
                ((zzkz)object).zze(n2, n3, n4, n5);
            }
        } else {
            zzk zzk4 = ((zzkz)object).zzjv();
            if (zzk4 == null) {
                zzk.zzh(zzla2);
                return;
            }
            if ("click".equals(string2)) {
                Context context = zzla2.getContext();
                int n = zzeq.zza(context, map, "x", 0);
                int n7 = zzeq.zza(context, map, "y", 0);
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n7, (int)0);
                zzk4.zzd(motionEvent);
                motionEvent.recycle();
            } else if ("currentTime".equals(string2)) {
                String string4 = map.get("time");
                if (string4 == null) {
                    zzjw.zzaW((String)"Time parameter missing from currentTime video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    int n = (int)(f * 1000.0f);
                    zzk4.seekTo(n);
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = String.valueOf(string4);
                    zzjw.zzaW((String)(string5.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string5) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                }
            } else if ("hide".equals(string2)) {
                zzk4.setVisibility(4);
            } else if ("load".equals(string2)) {
                zzk4.zzfp();
            } else if ("mimetype".equals(string2)) {
                zzk4.setMimeType(map.get("mimetype"));
            } else if ("muted".equals(string2)) {
                boolean bl4 = Boolean.parseBoolean(map.get("muted"));
                if (bl4) {
                    zzk4.zzgi();
                } else {
                    zzk4.zzgj();
                }
            } else if ("pause".equals(string2)) {
                zzk4.pause();
            } else if ("play".equals(string2)) {
                zzk4.play();
            } else if ("show".equals(string2)) {
                zzk4.setVisibility(0);
            } else if ("src".equals(string2)) {
                zzk4.zzav(map.get("src"));
            } else if ("touchMove".equals(string2)) {
                Context context = zzla2.getContext();
                int n = zzeq.zza(context, map, "dx", 0);
                int n8 = zzeq.zza(context, map, "dy", 0);
                zzk4.zza(n, n8);
                if (!this.zzCt) {
                    zzd zzd2 = zzla2.zzjB();
                    zzd2.zzgv();
                    this.zzCt = true;
                }
            } else if ("volume".equals(string2)) {
                String string6 = map.get("volume");
                if (string6 == null) {
                    zzjw.zzaW((String)"Level parameter missing from volume video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string6);
                    zzk4.zza(f);
                }
                catch (NumberFormatException numberFormatException) {
                    String string7 = String.valueOf(string6);
                    zzjw.zzaW((String)(string7.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string7) : new String("Could not parse volume parameter from volume video GMSG: ")));
                }
            } else if ("watermark".equals(string2)) {
                zzk4.zzgH();
            } else {
                String string8 = String.valueOf(string2);
                zzjw.zzaW((String)(string8.length() != 0 ? "Unknown video action: ".concat(string8) : new String("Unknown video action: ")));
            }
        }
    }
}

