/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.SearchAdRequestParcel;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.AutoClickProtectionConfigurationParcel;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcn;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzii;
import com.google.android.gms.internal.zzio;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzjw;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
public final class zzij {
    private static final SimpleDateFormat zzNd = new SimpleDateFormat("yyyyMMdd", Locale.US);

    public static JSONObject zza(Context context, AdRequestInfoParcel adRequestInfoParcel, zzio zzio2, zzis.zza zza2, Location location, zzcn zzcn2, String string2, String string3, List<String> list, Bundle bundle, String string4) {
        try {
            CharSequence charSequence;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (list.size() > 0) {
                hashMap.put("eid", TextUtils.join((CharSequence)",", list));
            }
            if (adRequestInfoParcel.zzLh != null) {
                hashMap.put("ad_pos", adRequestInfoParcel.zzLh);
            }
            zzij.zza(hashMap, adRequestInfoParcel.zzLi);
            hashMap.put("format", adRequestInfoParcel.zzsB.zzvs);
            if (adRequestInfoParcel.zzsB.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (adRequestInfoParcel.zzsB.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (adRequestInfoParcel.zzsB.zzvw) {
                hashMap.put("fluid", "height");
            }
            if (adRequestInfoParcel.zzsB.zzvu != null) {
                charSequence = new StringBuilder();
                for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzsB.zzvu) {
                    if (charSequence.length() != 0) {
                        charSequence.append("|");
                    }
                    charSequence.append(adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / zzio2.zzLu) : adSizeParcel.width);
                    charSequence.append("x");
                    charSequence.append(adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / zzio2.zzLu) : adSizeParcel.height);
                }
                hashMap.put("sz", charSequence);
            }
            if (adRequestInfoParcel.zzLo != 0) {
                hashMap.put("native_version", adRequestInfoParcel.zzLo);
                if (!adRequestInfoParcel.zzsB.zzvx) {
                    hashMap.put("native_templates", adRequestInfoParcel.zzsT);
                    hashMap.put("native_image_orientation", zzij.zzc(adRequestInfoParcel.zzsP));
                    if (!adRequestInfoParcel.zzLz.isEmpty()) {
                        hashMap.put("native_custom_templates", adRequestInfoParcel.zzLz);
                    }
                }
            }
            hashMap.put("slotname", adRequestInfoParcel.zzsv);
            hashMap.put("pn", adRequestInfoParcel.applicationInfo.packageName);
            if (adRequestInfoParcel.zzLj != null) {
                hashMap.put("vc", adRequestInfoParcel.zzLj.versionCode);
            }
            hashMap.put("ms", string3);
            hashMap.put("seq_num", adRequestInfoParcel.zzLl);
            hashMap.put("session_id", adRequestInfoParcel.zzLm);
            hashMap.put("js", adRequestInfoParcel.zzsx.afmaVersion);
            zzij.zza(hashMap, zzio2, zza2, adRequestInfoParcel.zzLM);
            zzij.zza(hashMap, string4, string2);
            hashMap.put("platform", Build.MANUFACTURER);
            hashMap.put("submodel", Build.MODEL);
            if (location != null) {
                zzij.zza(hashMap, location);
            } else if (adRequestInfoParcel.zzLi.versionCode >= 2 && adRequestInfoParcel.zzLi.zzuV != null) {
                zzij.zza(hashMap, adRequestInfoParcel.zzLi.zzuV);
            }
            if (adRequestInfoParcel.versionCode >= 2) {
                hashMap.put("quality_signals", adRequestInfoParcel.zzLn);
            }
            if (adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzLq) {
                hashMap.put("forceHttps", adRequestInfoParcel.zzLq);
            }
            if (bundle != null) {
                hashMap.put("content_info", bundle);
            }
            if (adRequestInfoParcel.versionCode >= 5) {
                hashMap.put("u_sd", Float.valueOf(adRequestInfoParcel.zzLu));
                hashMap.put("sh", adRequestInfoParcel.zzLt);
                hashMap.put("sw", adRequestInfoParcel.zzLs);
            } else {
                hashMap.put("u_sd", Float.valueOf(zzio2.zzLu));
                hashMap.put("sh", zzio2.zzLt);
                hashMap.put("sw", zzio2.zzLs);
            }
            if (adRequestInfoParcel.versionCode >= 6) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzLv)) {
                    try {
                        hashMap.put("view_hierarchy", new JSONObject(adRequestInfoParcel.zzLv));
                    }
                    catch (JSONException jSONException) {
                        zzjw.zzd((String)"Problem serializing view hierarchy to JSON", (Throwable)jSONException);
                    }
                }
                hashMap.put("correlation_id", adRequestInfoParcel.zzLw);
            }
            if (adRequestInfoParcel.versionCode >= 7) {
                hashMap.put("request_id", adRequestInfoParcel.zzLx);
            }
            if (adRequestInfoParcel.versionCode >= 11 && adRequestInfoParcel.zzLB != null) {
                hashMap.put("capability", adRequestInfoParcel.zzLB.toBundle());
            }
            if (adRequestInfoParcel.versionCode >= 12 && !TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzLC)) {
                hashMap.put("anchor", adRequestInfoParcel.zzLC);
            }
            if (adRequestInfoParcel.versionCode >= 13) {
                hashMap.put("android_app_volume", Float.valueOf(adRequestInfoParcel.zzLD));
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                hashMap.put("android_app_muted", adRequestInfoParcel.zzLJ);
            }
            if (adRequestInfoParcel.versionCode >= 14 && adRequestInfoParcel.zzLE > 0) {
                hashMap.put("target_api", adRequestInfoParcel.zzLE);
            }
            if (adRequestInfoParcel.versionCode >= 15) {
                hashMap.put("scroll_index", adRequestInfoParcel.zzLF == -1 ? -1 : adRequestInfoParcel.zzLF);
            }
            if (adRequestInfoParcel.versionCode >= 16) {
                hashMap.put("_activity_context", adRequestInfoParcel.zzLG);
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzLK)) {
                    try {
                        hashMap.put("app_settings", new JSONObject(adRequestInfoParcel.zzLK));
                    }
                    catch (JSONException jSONException) {
                        zzjw.zzd((String)"Problem creating json from app settings", (Throwable)jSONException);
                    }
                }
                hashMap.put("render_in_browser", adRequestInfoParcel.zzEJ);
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                hashMap.put("android_num_video_cache_tasks", adRequestInfoParcel.zzLL);
            }
            if (zzjw.zzX((int)2)) {
                charSequence = zzu.zzck().zzM(hashMap).toString(2);
                String string5 = String.valueOf(charSequence);
                zzjw.v(string5.length() != 0 ? "Ad Request JSON: ".concat(string5) : new String("Ad Request JSON: "));
            }
            return zzu.zzck().zzM(hashMap);
        }
        catch (JSONException jSONException) {
            String string6 = String.valueOf(jSONException.getMessage());
            zzjw.zzaW((String)(string6.length() != 0 ? "Problem serializing ad request to JSON: ".concat(string6) : new String("Problem serializing ad request to JSON: ")));
            return null;
        }
    }

    private static void zza(HashMap<String, Object> hashMap, String string2, String string3) {
        Bundle bundle = new Bundle();
        bundle.putString("doritos", string2);
        bundle.putString("token", string3);
        hashMap.put("pii", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, AdRequestParcel adRequestParcel) {
        String string2 = zzju.zziT();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (adRequestParcel.zzuN != -1L) {
            hashMap.put("cust_age", zzNd.format(new Date(adRequestParcel.zzuN)));
        }
        if (adRequestParcel.extras != null) {
            hashMap.put("extras", adRequestParcel.extras);
        }
        if (adRequestParcel.zzuO != -1) {
            hashMap.put("cust_gender", adRequestParcel.zzuO);
        }
        if (adRequestParcel.zzuP != null) {
            hashMap.put("kw", adRequestParcel.zzuP);
        }
        if (adRequestParcel.zzuR != -1) {
            hashMap.put("tag_for_child_directed_treatment", adRequestParcel.zzuR);
        }
        if (adRequestParcel.zzuQ) {
            hashMap.put("adtest", "on");
        }
        if (adRequestParcel.versionCode >= 2) {
            if (adRequestParcel.zzuS) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)adRequestParcel.zzuT)) {
                hashMap.put("ppid", adRequestParcel.zzuT);
            }
            if (adRequestParcel.zzuU != null) {
                zzij.zza(hashMap, adRequestParcel.zzuU);
            }
        }
        if (adRequestParcel.versionCode >= 3 && adRequestParcel.zzuW != null) {
            hashMap.put("url", adRequestParcel.zzuW);
        }
        if (adRequestParcel.versionCode >= 5) {
            if (adRequestParcel.zzuY != null) {
                hashMap.put("custom_targeting", adRequestParcel.zzuY);
            }
            if (adRequestParcel.zzuZ != null) {
                hashMap.put("category_exclusions", adRequestParcel.zzuZ);
            }
            if (adRequestParcel.zzva != null) {
                hashMap.put("request_agent", adRequestParcel.zzva);
            }
        }
        if (adRequestParcel.versionCode >= 6 && adRequestParcel.zzvb != null) {
            hashMap.put("request_pkg", adRequestParcel.zzvb);
        }
        if (adRequestParcel.versionCode >= 7) {
            hashMap.put("is_designed_for_families", adRequestParcel.zzvc);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zzio zzio2, zzis.zza zza2, Bundle bundle) {
        Bundle bundle2;
        hashMap.put("am", zzio2.zzNV);
        hashMap.put("cog", zzij.zzA(zzio2.zzNW));
        hashMap.put("coh", zzij.zzA(zzio2.zzNX));
        if (!TextUtils.isEmpty((CharSequence)zzio2.zzNY)) {
            hashMap.put("carrier", zzio2.zzNY);
        }
        hashMap.put("gl", zzio2.zzNZ);
        if (zzio2.zzOa) {
            hashMap.put("simulator", 1);
        }
        if (zzio2.zzOb) {
            hashMap.put("is_sidewinder", 1);
        }
        hashMap.put("ma", zzij.zzA(zzio2.zzOc));
        hashMap.put("sp", zzij.zzA(zzio2.zzOd));
        hashMap.put("hl", zzio2.zzOe);
        if (!TextUtils.isEmpty((CharSequence)zzio2.zzOf)) {
            hashMap.put("mv", zzio2.zzOf);
        }
        hashMap.put("muv", zzio2.zzOg);
        if (zzio2.zzOh != -2) {
            hashMap.put("cnt", zzio2.zzOh);
        }
        hashMap.put("gnt", zzio2.zzOi);
        hashMap.put("pt", zzio2.zzOj);
        hashMap.put("rm", zzio2.zzOk);
        hashMap.put("riv", zzio2.zzOl);
        Bundle bundle3 = new Bundle();
        bundle3.putString("build", zzio2.zzOq);
        Bundle bundle4 = new Bundle();
        bundle4.putBoolean("is_charging", zzio2.zzOn);
        bundle4.putDouble("battery_level", zzio2.zzOm);
        bundle3.putBundle("battery", bundle4);
        Bundle bundle5 = new Bundle();
        bundle5.putInt("active_network_state", zzio2.zzOp);
        bundle5.putBoolean("active_network_metered", zzio2.zzOo);
        if (zza2 != null) {
            bundle2 = new Bundle();
            bundle2.putInt("predicted_latency_micros", 0);
            bundle2.putLong("predicted_down_throughput_bps", 0L);
            bundle2.putLong("predicted_up_throughput_bps", 0L);
            bundle5.putBundle("predictions", bundle2);
        }
        bundle3.putBundle("network", bundle5);
        bundle2 = new Bundle();
        bundle2.putBoolean("is_browser_custom_tabs_capable", zzio2.zzOr);
        bundle3.putBundle("browser", bundle2);
        if (bundle != null) {
            bundle3.putBundle("android_mem_info", zzij.zzf(bundle));
        }
        hashMap.put("device", bundle3);
    }

    private static Bundle zzf(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        bundle2.putString("runtime_free", Long.toString(bundle.getLong("runtime_free_memory", -1L)));
        bundle2.putString("runtime_max", Long.toString(bundle.getLong("runtime_max_memory", -1L)));
        bundle2.putString("runtime_total", Long.toString(bundle.getLong("runtime_total_memory", -1L)));
        Debug.MemoryInfo memoryInfo = (Debug.MemoryInfo)bundle.getParcelable("debug_memory_info");
        if (memoryInfo != null) {
            bundle2.putString("debug_info_dalvik_private_dirty", Integer.toString(memoryInfo.dalvikPrivateDirty));
            bundle2.putString("debug_info_dalvik_pss", Integer.toString(memoryInfo.dalvikPss));
            bundle2.putString("debug_info_dalvik_shared_dirty", Integer.toString(memoryInfo.dalvikSharedDirty));
            bundle2.putString("debug_info_native_private_dirty", Integer.toString(memoryInfo.nativePrivateDirty));
            bundle2.putString("debug_info_native_pss", Integer.toString(memoryInfo.nativePss));
            bundle2.putString("debug_info_native_shared_dirty", Integer.toString(memoryInfo.nativeSharedDirty));
            bundle2.putString("debug_info_other_private_dirty", Integer.toString(memoryInfo.otherPrivateDirty));
            bundle2.putString("debug_info_other_pss", Integer.toString(memoryInfo.otherPss));
            bundle2.putString("debug_info_other_shared_dirty", Integer.toString(memoryInfo.otherSharedDirty));
        }
        return bundle2;
    }

    private static void zza(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l = location.getTime() * 1000L;
        Long l2 = (long)(location.getLatitude() * 1.0E7);
        Long l3 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f);
        hashMap2.put("lat", l2);
        hashMap2.put("long", l3);
        hashMap2.put("time", l);
        hashMap.put("uule", hashMap2);
    }

    private static void zza(HashMap<String, Object> hashMap, SearchAdRequestParcel searchAdRequestParcel) {
        String string2;
        String string3;
        if (Color.alpha((int)searchAdRequestParcel.zzwA) != 0) {
            hashMap.put("acolor", zzij.zzS(searchAdRequestParcel.zzwA));
        }
        if (Color.alpha((int)searchAdRequestParcel.backgroundColor) != 0) {
            hashMap.put("bgcolor", zzij.zzS(searchAdRequestParcel.backgroundColor));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzwB) != 0 && Color.alpha((int)searchAdRequestParcel.zzwC) != 0) {
            hashMap.put("gradientto", zzij.zzS(searchAdRequestParcel.zzwB));
            hashMap.put("gradientfrom", zzij.zzS(searchAdRequestParcel.zzwC));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzwD) != 0) {
            hashMap.put("bcolor", zzij.zzS(searchAdRequestParcel.zzwD));
        }
        hashMap.put("bthick", Integer.toString(searchAdRequestParcel.zzwE));
        switch (searchAdRequestParcel.zzwF) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (searchAdRequestParcel.zzwG) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (searchAdRequestParcel.zzwH != null) {
            hashMap.put("channel", searchAdRequestParcel.zzwH);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzwI) != 0) {
            hashMap.put("dcolor", zzij.zzS(searchAdRequestParcel.zzwI));
        }
        if (searchAdRequestParcel.zzwJ != null) {
            hashMap.put("font", searchAdRequestParcel.zzwJ);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzwK) != 0) {
            hashMap.put("hcolor", zzij.zzS(searchAdRequestParcel.zzwK));
        }
        hashMap.put("headersize", Integer.toString(searchAdRequestParcel.zzwL));
        if (searchAdRequestParcel.zzwM != null) {
            hashMap.put("q", searchAdRequestParcel.zzwM);
        }
    }

    private static Integer zzA(boolean bl) {
        return bl ? 1 : 0;
    }

    private static String zzS(int n) {
        return String.format(Locale.US, "#%06x", n & 0xFFFFFF);
    }

    private static String zzc(NativeAdOptionsParcel nativeAdOptionsParcel) {
        int n = nativeAdOptionsParcel != null ? nativeAdOptionsParcel.zzBm : 0;
        switch (n) {
            case 1: {
                return "portrait";
            }
            case 2: {
                return "landscape";
            }
        }
        return "any";
    }

    public static AdResponseParcel zza(Context context, AdRequestInfoParcel adRequestInfoParcel, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            boolean bl = adRequestInfoParcel != null && adRequestInfoParcel.zzLo != 0;
            String string6 = jSONObject.optString("ad_json", null);
            if (string6 == null) {
                string6 = jSONObject.optString("ad_html", null);
            }
            if (string6 == null) {
                string6 = jSONObject.optString("body", null);
            }
            long l = -1L;
            String string7 = jSONObject.optString("debug_dialog", null);
            long l2 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string8 = jSONObject.optString("orientation", null);
            int n = -1;
            if ("portrait".equals(string8)) {
                n = zzu.zzcm().zzjf();
            } else if ("landscape".equals(string8)) {
                n = zzu.zzcm().zzje();
            }
            AdResponseParcel adResponseParcel = null;
            if (TextUtils.isEmpty((CharSequence)string6) && !TextUtils.isEmpty((CharSequence)string4)) {
                adResponseParcel = zzii.zza(adRequestInfoParcel, context, adRequestInfoParcel.zzsx.afmaVersion, string4, null, null, null, null, null);
                string3 = adResponseParcel.zzHH;
                string6 = adResponseParcel.body;
                l = adResponseParcel.zzLT;
            }
            if (string6 == null) {
                return new AdResponseParcel(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = adResponseParcel == null ? null : adResponseParcel.zzEF;
            if (jSONArray != null) {
                list3 = zzij.zza(jSONArray, list3);
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = adResponseParcel == null ? null : adResponseParcel.zzEG;
            if (jSONArray2 != null) {
                list2 = zzij.zza(jSONArray2, list2);
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = adResponseParcel == null ? null : adResponseParcel.zzLR;
            if (jSONArray3 != null) {
                list = zzij.zza(jSONArray3, list);
            }
            if (adResponseParcel != null) {
                if (adResponseParcel.orientation != -1) {
                    n = adResponseParcel.orientation;
                }
                if (adResponseParcel.zzLO > 0L) {
                    l2 = adResponseParcel.zzLO;
                }
            }
            String string9 = jSONObject.optString("active_view");
            String string10 = null;
            boolean bl2 = jSONObject.optBoolean("ad_is_javascript", false);
            if (bl2) {
                string10 = jSONObject.optString("ad_passback_url", null);
            }
            boolean bl3 = jSONObject.optBoolean("mediation", false);
            boolean bl4 = jSONObject.optBoolean("custom_render_allowed", false);
            boolean bl5 = jSONObject.optBoolean("content_url_opted_out", true);
            boolean bl6 = jSONObject.optBoolean("prefetch", false);
            int n2 = jSONObject.optInt("oauth2_token_status", 0);
            long l3 = jSONObject.optLong("refresh_interval_milliseconds", -1L);
            long l4 = jSONObject.optLong("mediation_config_cache_time_milliseconds", -1L);
            String string11 = jSONObject.optString("gws_query_id", "");
            boolean bl7 = "height".equals(jSONObject.optString("fluid", ""));
            boolean bl8 = jSONObject.optBoolean("native_express", false);
            List<String> list7 = zzij.zza(jSONObject.optJSONArray("video_start_urls"), null);
            List<String> list8 = zzij.zza(jSONObject.optJSONArray("video_complete_urls"), null);
            RewardItemParcel rewardItemParcel = RewardItemParcel.zza((JSONArray)jSONObject.optJSONArray("rewards"));
            boolean bl9 = jSONObject.optBoolean("use_displayed_impression", false);
            AutoClickProtectionConfigurationParcel autoClickProtectionConfigurationParcel = AutoClickProtectionConfigurationParcel.zzg(jSONObject.optJSONObject("auto_protection_configuration"));
            String string12 = jSONObject.optString("set_cookie", "");
            List<String> list9 = zzij.zza(jSONObject.optJSONArray("remote_ping_urls"), null);
            String string13 = jSONObject.optString("safe_browsing");
            boolean bl10 = jSONObject.optBoolean("render_in_browser", adRequestInfoParcel.zzEJ);
            return new AdResponseParcel(adRequestInfoParcel, string3, string6, list3, list2, l2, bl3, l4, list, l3, n, string5, l, string7, bl2, string10, string9, bl4, bl, adRequestInfoParcel.zzLq, bl5, bl6, n2, string11, bl7, bl8, rewardItemParcel, list7, list8, bl9, autoClickProtectionConfigurationParcel, adRequestInfoParcel.zzLH, string12, list9, string13, bl10);
        }
        catch (JSONException jSONException) {
            String string14 = String.valueOf(jSONException.getMessage());
            zzjw.zzaW((String)(string14.length() != 0 ? "Could not parse the mediation config: ".concat(string14) : new String("Could not parse the mediation config: ")));
            return new AdResponseParcel(0);
        }
    }

    @Nullable
    private static List<String> zza(@Nullable JSONArray jSONArray, @Nullable List<String> list) throws JSONException {
        if (jSONArray == null) {
            return null;
        }
        if (list == null) {
            list = new LinkedList<String>();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            list.add(jSONArray.getString(i));
        }
        return list;
    }

    public static JSONObject zzc(AdResponseParcel adResponseParcel) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (adResponseParcel.zzHH != null) {
            jSONObject.put("ad_base_url", (Object)adResponseParcel.zzHH);
        }
        if (adResponseParcel.zzLS != null) {
            jSONObject.put("ad_size", (Object)adResponseParcel.zzLS);
        }
        jSONObject.put("native", adResponseParcel.zzvv);
        if (adResponseParcel.zzvv) {
            jSONObject.put("ad_json", (Object)adResponseParcel.body);
        } else {
            jSONObject.put("ad_html", (Object)adResponseParcel.body);
        }
        if (adResponseParcel.zzLU != null) {
            jSONObject.put("debug_dialog", (Object)adResponseParcel.zzLU);
        }
        if (adResponseParcel.zzLO != -1L) {
            jSONObject.put("interstitial_timeout", (double)adResponseParcel.zzLO / 1000.0);
        }
        if (adResponseParcel.orientation == zzu.zzcm().zzjf()) {
            jSONObject.put("orientation", (Object)"portrait");
        } else if (adResponseParcel.orientation == zzu.zzcm().zzje()) {
            jSONObject.put("orientation", (Object)"landscape");
        }
        if (adResponseParcel.zzEF != null) {
            jSONObject.put("click_urls", (Object)zzij.zzk(adResponseParcel.zzEF));
        }
        if (adResponseParcel.zzEG != null) {
            jSONObject.put("impression_urls", (Object)zzij.zzk(adResponseParcel.zzEG));
        }
        if (adResponseParcel.zzLR != null) {
            jSONObject.put("manual_impression_urls", (Object)zzij.zzk(adResponseParcel.zzLR));
        }
        if (adResponseParcel.zzLX != null) {
            jSONObject.put("active_view", (Object)adResponseParcel.zzLX);
        }
        jSONObject.put("ad_is_javascript", adResponseParcel.zzLV);
        if (adResponseParcel.zzLW != null) {
            jSONObject.put("ad_passback_url", (Object)adResponseParcel.zzLW);
        }
        jSONObject.put("mediation", adResponseParcel.zzLP);
        jSONObject.put("custom_render_allowed", adResponseParcel.zzLY);
        jSONObject.put("content_url_opted_out", adResponseParcel.zzLZ);
        jSONObject.put("prefetch", adResponseParcel.zzMa);
        jSONObject.put("oauth2_token_status", adResponseParcel.zzMb);
        if (adResponseParcel.zzEL != -1L) {
            jSONObject.put("refresh_interval_milliseconds", adResponseParcel.zzEL);
        }
        if (adResponseParcel.zzLQ != -1L) {
            jSONObject.put("mediation_config_cache_time_milliseconds", adResponseParcel.zzLQ);
        }
        if (!TextUtils.isEmpty((CharSequence)adResponseParcel.zzMe)) {
            jSONObject.put("gws_query_id", (Object)adResponseParcel.zzMe);
        }
        jSONObject.put("fluid", (Object)(adResponseParcel.zzvw ? "height" : ""));
        jSONObject.put("native_express", adResponseParcel.zzvx);
        if (adResponseParcel.zzMg != null) {
            jSONObject.put("video_start_urls", (Object)zzij.zzk(adResponseParcel.zzMg));
        }
        if (adResponseParcel.zzMh != null) {
            jSONObject.put("video_complete_urls", (Object)zzij.zzk(adResponseParcel.zzMh));
        }
        if (adResponseParcel.zzMf != null) {
            jSONObject.put("rewards", (Object)adResponseParcel.zzMf.zzir());
        }
        jSONObject.put("use_displayed_impression", adResponseParcel.zzMi);
        jSONObject.put("auto_protection_configuration", (Object)adResponseParcel.zzMj);
        jSONObject.put("render_in_browser", adResponseParcel.zzEJ);
        return jSONObject;
    }

    @Nullable
    static JSONArray zzk(List<String> list) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (String string2 : list) {
            jSONArray.put((Object)string2);
        }
        return jSONArray;
    }
}

