/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.AdapterView;
import android.widget.PopupWindow;
import com.google.android.gms.ads.internal.ClientApi;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zza;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzamp;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzcm;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzjx;
import com.google.android.gms.internal.zzkj;
import com.google.android.gms.internal.zzla;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
public class zzka {
    public static final Handler zzQu = new zzjx(Looper.getMainLooper());
    private final Object zzpp = new Object();
    private boolean zzQv = true;
    private String zzCy;
    private boolean zzQw = false;
    private zzfj zzMS;

    public void zza(Context context, String string, boolean bl, HttpURLConnection httpURLConnection) {
        this.zza(context, string, bl, httpURLConnection, false);
    }

    public void zza(Context context, String string, boolean bl, HttpURLConnection httpURLConnection, boolean bl2) {
        httpURLConnection.setConnectTimeout(60000);
        httpURLConnection.setInstanceFollowRedirects(bl);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.setRequestProperty("User-Agent", this.zzg(context, string));
        httpURLConnection.setUseCaches(bl2);
    }

    public boolean zzB(Context context) {
        Intent intent = new Intent();
        intent.setClassName(context, "com.google.android.gms.ads.AdActivity");
        PackageManager packageManager = context.getPackageManager();
        ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
        boolean bl = true;
        if (resolveInfo == null || resolveInfo.activityInfo == null) {
            zzjw.zzaW((String)"Could not find com.google.android.gms.ads.AdActivity, please make sure it is declared in AndroidManifest.xml.");
            bl = false;
        } else {
            String string = "com.google.android.gms.ads.AdActivity requires the android:configChanges value to contain \"%s\".";
            if ((resolveInfo.activityInfo.configChanges & 0x10) == 0) {
                zzjw.zzaW((String)String.format(string, "keyboard"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x20) == 0) {
                zzjw.zzaW((String)String.format(string, "keyboardHidden"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x80) == 0) {
                zzjw.zzaW((String)String.format(string, "orientation"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x100) == 0) {
                zzjw.zzaW((String)String.format(string, "screenLayout"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x200) == 0) {
                zzjw.zzaW((String)String.format(string, "uiMode"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x400) == 0) {
                zzjw.zzaW((String)String.format(string, "screenSize"));
                bl = false;
            }
            if ((resolveInfo.activityInfo.configChanges & 0x800) == 0) {
                zzjw.zzaW((String)String.format(string, "smallestScreenSize"));
                bl = false;
            }
        }
        return bl;
    }

    public boolean zza(PackageManager packageManager, String string, String string2) {
        return packageManager.checkPermission(string2, string) == 0;
    }

    public boolean zziX() {
        return this.zzQv;
    }

    public void zza(Context context, String string, List<String> list) {
        for (String string2 : list) {
            Future cfr_ignored_0 = (Future)new zzkj(context, string, string2).zzhs();
        }
    }

    public void zzc(Context context, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        this.zza(context, string, arrayList);
    }

    public void zza(List<String> list, String string) {
        for (String string2 : list) {
            Future cfr_ignored_0 = (Future)new zzkj(string2, string).zzhs();
        }
    }

    public void zza(final Context context, final List<String> list) {
        if (!(context instanceof Activity)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)zzamp.zzbH((Context)((Activity)context)))) {
            return;
        }
        if (list == null) {
            zzjw.v("Cannot ping urls: empty list.");
            return;
        }
        if (!zzdi.zzo(context)) {
            zzjw.v("Cannot ping url because custom tabs is not supported");
            return;
        }
        final zzdi zzdi2 = new zzdi();
        zzdi.zza zza2 = new zzdi.zza(){

            @Override
            public void zzeH() {
                for (String string : list) {
                    String string2 = String.valueOf(string);
                    zzjw.zzaV((String)(string2.length() != 0 ? "Pinging url: ".concat(string2) : new String("Pinging url: ")));
                    Uri uri = Uri.parse((String)string);
                    zzdi2.mayLaunchUrl(uri, null, null);
                }
                zzdi2.zzd((Activity)context);
            }

            @Override
            public void zzeI() {
            }
        };
        zzdi2.zza(zza2);
        zzdi2.zze((Activity)context);
    }

    public String zza(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder(8192);
        char[] cArray = new char[2048];
        while ((n = inputStreamReader.read(cArray)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }

    public boolean zzC(Context context) {
        if (this.zzQw) {
            return false;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        context.getApplicationContext().registerReceiver((BroadcastReceiver)new zza(), intentFilter);
        this.zzQw = true;
        return true;
    }

    public void zza(Context context, String string, WebSettings webSettings) {
        webSettings.setUserAgentString(this.zzg(context, string));
    }

    String zziY() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("Mozilla/5.0 (Linux; U; Android");
        if (Build.VERSION.RELEASE != null) {
            stringBuffer.append(" ").append(Build.VERSION.RELEASE);
        }
        stringBuffer.append("; ").append(Locale.getDefault());
        if (Build.DEVICE != null) {
            stringBuffer.append("; ").append(Build.DEVICE);
            if (Build.DISPLAY != null) {
                stringBuffer.append(" Build/").append(Build.DISPLAY);
            }
        }
        stringBuffer.append(") AppleWebKit/533 Version/4.0 Safari/533");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String zzg(final Context context, String string) {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzCy != null) {
                return this.zzCy;
            }
            try {
                this.zzCy = zzu.zzcm().getDefaultUserAgent(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (TextUtils.isEmpty((CharSequence)this.zzCy)) {
                if (!zzm.zzdQ().zzjs()) {
                    this.zzCy = null;
                    zzQu.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = zzka.this.zzpp;
                            synchronized (object) {
                                zzka.this.zzCy = zzka.this.zzD(context);
                                zzka.this.zzpp.notifyAll();
                            }
                        }
                    });
                    while (this.zzCy == null) {
                        try {
                            this.zzpp.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this.zzCy = this.zziY();
                            String string2 = String.valueOf(this.zzCy);
                            zzjw.zzaW((String)(string2.length() != 0 ? "Interrupted, use default user agent: ".concat(string2) : new String("Interrupted, use default user agent: ")));
                        }
                    }
                } else {
                    try {
                        this.zzCy = this.zzD(context);
                    }
                    catch (Exception exception) {
                        this.zzCy = this.zziY();
                    }
                }
            }
            String string3 = String.valueOf(this.zzCy);
            this.zzCy = new StringBuilder(11 + String.valueOf(string3).length() + String.valueOf(string).length()).append(string3).append(" (Mobile; ").append(string).append(")").toString();
            return this.zzCy;
        }
    }

    protected String zzD(Context context) {
        return new WebView(context).getSettings().getUserAgentString();
    }

    public boolean zza(ClassLoader classLoader, Class<?> clazz, String string) {
        try {
            Class<?> clazz2 = Class.forName(string, false, classLoader);
            return clazz.isAssignableFrom(clazz2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String zzaN(String string) {
        return Uri.parse((String)string).buildUpon().query(null).build().toString();
    }

    public JSONObject zzM(Map<String, ?> map) throws JSONException {
        try {
            JSONObject jSONObject = new JSONObject();
            for (String string : map.keySet()) {
                this.zza(jSONObject, string, map.get(string));
            }
            return jSONObject;
        }
        catch (ClassCastException classCastException) {
            String string = String.valueOf(classCastException.getMessage());
            throw new JSONException(string.length() != 0 ? "Could not convert map to JSON: ".concat(string) : new String("Could not convert map to JSON: "));
        }
    }

    private JSONObject zzh(Bundle bundle) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        for (String string : bundle.keySet()) {
            this.zza(jSONObject, string, bundle.get(string));
        }
        return jSONObject;
    }

    private JSONArray zza(Collection<?> collection) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object obj : collection) {
            this.zza(jSONArray, obj);
        }
        return jSONArray;
    }

    JSONArray zza(Object[] objectArray) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (Object object : objectArray) {
            this.zza(jSONArray, object);
        }
        return jSONArray;
    }

    private void zza(JSONArray jSONArray, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONArray.put((Object)this.zzh((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONArray.put((Object)this.zzM(map));
        } else if (object instanceof Collection) {
            jSONArray.put((Object)this.zza((Collection)object));
        } else if (object instanceof Object[]) {
            jSONArray.put((Object)this.zza((Object[])object));
        } else {
            jSONArray.put(object);
        }
    }

    private void zza(JSONObject jSONObject, String string, Object object) throws JSONException {
        if (object instanceof Bundle) {
            jSONObject.put(string, (Object)this.zzh((Bundle)object));
        } else if (object instanceof Map) {
            Map map = (Map)object;
            jSONObject.put(string, (Object)this.zzM(map));
        } else if (object instanceof Collection) {
            jSONObject.put(string != null ? string : "null", (Object)this.zza((Collection)object));
        } else if (object instanceof Object[]) {
            jSONObject.put(string, (Object)this.zza(Arrays.asList((Object[])object)));
        } else {
            jSONObject.put(string, object);
        }
    }

    public Map<String, String> zzf(Uri uri) {
        if (uri == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Set<String> set = zzu.zzcm().zzg(uri);
        for (String string : set) {
            hashMap.put(string, uri.getQueryParameter(string));
        }
        return hashMap;
    }

    public String zziZ() {
        return UUID.randomUUID().toString();
    }

    public String zzja() {
        UUID uUID = UUID.randomUUID();
        byte[] byArray = BigInteger.valueOf(uUID.getLeastSignificantBits()).toByteArray();
        byte[] byArray2 = BigInteger.valueOf(uUID.getMostSignificantBits()).toByteArray();
        String string = new BigInteger(1, byArray).toString();
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(byArray);
                messageDigest.update(byArray2);
                byte[] byArray3 = new byte[8];
                System.arraycopy(messageDigest.digest(), 0, byArray3, 0, 8);
                string = new BigInteger(1, byArray3).toString();
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return string;
    }

    public int zzaO(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = String.valueOf(numberFormatException);
            zzjw.zzaW((String)new StringBuilder(22 + String.valueOf(string2).length()).append("Could not parse value:").append(string2).toString());
            return 0;
        }
    }

    public String zzjb() {
        String string = Build.MODEL;
        String string2 = Build.MANUFACTURER;
        return string.startsWith(string2) ? string : new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(" ").append(string).toString();
    }

    protected int[] zzjc() {
        return new int[]{0, 0};
    }

    public int[] zzh(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getWidth(), view.getHeight()};
        }
        return this.zzjc();
    }

    public int[] zzi(Activity activity) {
        int[] nArray = this.zzh(activity);
        return new int[]{zzm.zzdQ().zzb((Context)activity, nArray[0]), zzm.zzdQ().zzb((Context)activity, nArray[1])};
    }

    public int[] zzj(Activity activity) {
        View view;
        Window window = activity.getWindow();
        if (window != null && (view = window.findViewById(0x1020002)) != null) {
            return new int[]{view.getTop(), view.getBottom()};
        }
        return this.zzjc();
    }

    public int[] zzk(Activity activity) {
        int[] nArray = this.zzj(activity);
        return new int[]{zzm.zzdQ().zzb((Context)activity, nArray[0]), zzm.zzdQ().zzb((Context)activity, nArray[1])};
    }

    public boolean zzaP(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return string.matches("([^\\s]+(\\.(?i)(jpg|png|gif|bmp|webp))$)");
    }

    public void zza(Activity activity, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
        }
    }

    public void zza(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().addOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public void zzb(Activity activity, ViewTreeObserver.OnScrollChangedListener onScrollChangedListener) {
        Window window = activity.getWindow();
        if (window != null && window.getDecorView() != null && window.getDecorView().getViewTreeObserver() != null) {
            window.getDecorView().getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
        }
    }

    public DisplayMetrics zza(WindowManager windowManager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Display display = windowManager.getDefaultDisplay();
        display.getMetrics(displayMetrics);
        return displayMetrics;
    }

    public AlertDialog.Builder zzE(Context context) {
        return new AlertDialog.Builder(context);
    }

    public zzcm zzF(Context context) {
        return new zzcm(context);
    }

    public Bitmap zzl(View view) {
        view.setDrawingCacheEnabled(true);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
        view.setDrawingCacheEnabled(false);
        return bitmap;
    }

    public PopupWindow zza(View view, int n, int n2, boolean bl) {
        return new PopupWindow(view, n, n2, bl);
    }

    public String zzG(Context context) {
        try {
            ActivityManager.RunningTaskInfo runningTaskInfo;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return null;
            }
            List list = activityManager.getRunningTasks(1);
            if (list != null && !list.isEmpty() && (runningTaskInfo = (ActivityManager.RunningTaskInfo)list.get(0)) != null && runningTaskInfo.topActivity != null) {
                return runningTaskInfo.topActivity.getClassName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String zza(Context context, View view, AdSizeParcel adSizeParcel) {
        if (!zzcu.zzxY.get().booleanValue()) {
            return null;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("width", adSizeParcel.width);
            jSONObject2.put("height", adSizeParcel.height);
            jSONObject.put("size", (Object)jSONObject2);
            jSONObject.put("activity", (Object)this.zzG(context));
            if (!adSizeParcel.zzvt) {
                JSONArray jSONArray = new JSONArray();
                View view2 = view;
                while (view2 != null) {
                    ViewParent viewParent = view2.getParent();
                    if (viewParent != null) {
                        int n = -1;
                        if (viewParent instanceof ViewGroup) {
                            n = ((ViewGroup)viewParent).indexOfChild(view2);
                        }
                        JSONObject jSONObject3 = new JSONObject();
                        jSONObject3.put("type", (Object)viewParent.getClass().getName());
                        jSONObject3.put("index_of_child", n);
                        jSONArray.put((Object)jSONObject3);
                    }
                    if (viewParent != null && viewParent instanceof View) {
                        view2 = (View)viewParent;
                        continue;
                    }
                    view2 = null;
                }
                if (jSONArray.length() > 0) {
                    jSONObject.put("parents", (Object)jSONArray);
                }
            }
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzjw.zzd((String)"Fail to get view hierarchy json", (Throwable)jSONException);
            return null;
        }
    }

    public String zza(zzla zzla2, String string) {
        return this.zza(zzla2.getContext(), zzla2.zzjF(), string);
    }

    public String zza(Context context, zzaq zzaq2, String string) {
        if (zzaq2 == null) {
            return string;
        }
        try {
            Uri uri = Uri.parse((String)string);
            if (zzaq2.zzd(uri)) {
                uri = zzaq2.zzb(uri, context);
            }
            return uri.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public boolean zzH(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzj(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean zzj(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    public void zza(final Context context, final @Nullable String string, String string2, Bundle bundle, boolean bl) {
        if (bl) {
            bundle.putString("device", zzu.zzck().zzjb());
            bundle.putString("eids", TextUtils.join((CharSequence)",", zzcu.zzer()));
        }
        zzm.zzdQ().zza(context, string, string2, bundle, bl, new zza.zza(){

            public void zzaQ(String string2) {
                zzu.zzck().zzc(context, string, string2);
            }
        });
    }

    public void zzb(Context context, String string, String string2, Bundle bundle, boolean bl) {
        if (zzcu.zzyv.get().booleanValue()) {
            this.zza(context, string, string2, bundle, bl);
        }
    }

    public void runOnUiThread(Runnable runnable) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            runnable.run();
        } else {
            zzQu.post(runnable);
        }
    }

    private Bitmap zzm(@NonNull View view) {
        try {
            int n = view.getWidth();
            int n2 = view.getHeight();
            if (n == 0 || n2 == 0) {
                zzjw.zzaW((String)"Width or height of view is zero");
                return null;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
            Canvas canvas = new Canvas(bitmap);
            view.layout(0, 0, n, n2);
            view.draw(canvas);
            return bitmap;
        }
        catch (RuntimeException runtimeException) {
            zzjw.zzb((String)"Fail to capture the webview", (Throwable)runtimeException);
            return null;
        }
    }

    private Bitmap zzn(@NonNull View view) {
        Bitmap bitmap = null;
        try {
            boolean bl = view.isDrawingCacheEnabled();
            view.setDrawingCacheEnabled(true);
            Bitmap bitmap2 = view.getDrawingCache();
            if (bitmap2 != null) {
                bitmap = Bitmap.createBitmap((Bitmap)bitmap2);
            }
            view.setDrawingCacheEnabled(bl);
        }
        catch (RuntimeException runtimeException) {
            zzjw.zzb((String)"Fail to capture the web view", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public Bitmap zzI(Context context) {
        if (!(context instanceof Activity)) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            if (zzcu.zzza.get().booleanValue()) {
                Window window = ((Activity)context).getWindow();
                if (window != null) {
                    View view = window.getDecorView().getRootView();
                    bitmap = this.zzn(view);
                }
            } else {
                bitmap = this.zzm(((Activity)context).getWindow().getDecorView());
            }
        }
        catch (RuntimeException runtimeException) {
            zzjw.zzb((String)"Fail to capture screen shot", (Throwable)runtimeException);
        }
        return bitmap;
    }

    public void zzb(Context context, Intent intent) {
        try {
            context.startActivity(intent);
        }
        catch (Throwable throwable) {
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    public float zzbS() {
        zzo zzo2 = zzu.zzcA().zzbR();
        return zzo2 != null && zzo2.zzbT() ? zzo2.zzbS() : 1.0f;
    }

    public boolean zzbU() {
        zzo zzo2 = zzu.zzcA().zzbR();
        return zzo2 != null ? zzo2.zzbU() : false;
    }

    public AudioManager zzJ(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    public float zzK(Context context) {
        AudioManager audioManager = this.zzJ(context);
        if (audioManager == null) {
            return 0.0f;
        }
        int n = audioManager.getStreamMaxVolume(3);
        int n2 = audioManager.getStreamVolume(3);
        return n == 0 ? 0.0f : (float)n2 / (float)n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzfj zzc(Context context, VersionInfoParcel versionInfoParcel) {
        Object object = this.zzpp;
        synchronized (object) {
            if (this.zzMS == null) {
                this.zzMS = new zzfj(context.getApplicationContext() != null ? context.getApplicationContext() : context, versionInfoParcel, zzcu.zzwZ.get());
            }
            return this.zzMS;
        }
    }

    public int zzL(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        return applicationInfo == null ? 0 : applicationInfo.targetSdkVersion;
    }

    public boolean zza(View view, Context context) {
        PowerManager powerManager = null;
        Context context2 = context.getApplicationContext();
        if (context2 != null) {
            powerManager = (PowerManager)context2.getSystemService("power");
        }
        KeyguardManager keyguardManager = null;
        Object object = context.getSystemService("keyguard");
        if (object != null && object instanceof KeyguardManager) {
            keyguardManager = (KeyguardManager)object;
        }
        return this.zza(view, powerManager, keyguardManager);
    }

    public boolean zza(View view, PowerManager powerManager, KeyguardManager keyguardManager) {
        boolean bl = zzu.zzck().zziX() || !this.zza(keyguardManager);
        return view.getVisibility() == 0 && view.isShown() && this.zza(powerManager) && bl && (zzcu.zzyr.get() == false || view.getLocalVisibleRect(new Rect()) || view.getGlobalVisibleRect(new Rect()));
    }

    private boolean zza(PowerManager powerManager) {
        return powerManager == null || powerManager.isScreenOn();
    }

    private boolean zza(KeyguardManager keyguardManager) {
        if (keyguardManager == null) {
            return false;
        }
        return keyguardManager.inKeyguardRestrictedInputMode();
    }

    public int zzo(@Nullable View view) {
        ViewParent viewParent;
        if (view == null) {
            return -1;
        }
        for (viewParent = view.getParent(); viewParent != null && !(viewParent instanceof AdapterView); viewParent = viewParent.getParent()) {
        }
        if (viewParent == null) {
            return -1;
        }
        return ((AdapterView)viewParent).getPositionForView(view);
    }

    public boolean zzM(Context context) {
        try {
            context.getClassLoader().loadClass(ClientApi.class.getName());
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
    }

    public Bundle zzjd() {
        Bundle bundle = new Bundle();
        try {
            Debug.MemoryInfo memoryInfo = new Debug.MemoryInfo();
            Debug.getMemoryInfo((Debug.MemoryInfo)memoryInfo);
            bundle.putParcelable("debug_memory_info", (Parcelable)memoryInfo);
            Runtime runtime = Runtime.getRuntime();
            bundle.putLong("runtime_free_memory", runtime.freeMemory());
            bundle.putLong("runtime_max_memory", runtime.maxMemory());
            bundle.putLong("runtime_total_memory", runtime.totalMemory());
        }
        catch (Exception exception) {
            zzjw.zzd((String)"Unable to gather memory stats", (Throwable)exception);
        }
        return bundle;
    }

    private final class zza
    extends BroadcastReceiver {
        private zza() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.USER_PRESENT".equals(intent.getAction())) {
                zzka.this.zzQv = true;
            } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                zzka.this.zzQv = false;
            }
        }
    }
}

