/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.request.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.zzo;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzig
public final class LargeParcelTeleporter
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<LargeParcelTeleporter> CREATOR = new zzm();
    final int mVersionCode;
    ParcelFileDescriptor zzMq;
    private Parcelable zzMr;
    private boolean zzMs;

    LargeParcelTeleporter(int n, ParcelFileDescriptor parcelFileDescriptor) {
        this.mVersionCode = n;
        this.zzMq = parcelFileDescriptor;
        this.zzMr = null;
        this.zzMs = true;
    }

    public LargeParcelTeleporter(SafeParcelable safeParcelable) {
        this.mVersionCode = 1;
        this.zzMq = null;
        this.zzMr = safeParcelable;
        this.zzMs = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzMs) {
            byte[] byArray;
            if (this.zzMq == null) {
                zzjw.e((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzMq));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                zzo.zzb((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzMr = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzMs = false;
        }
        return (T)((SafeParcelable)this.zzMr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(Parcel parcel, int n) {
        if (this.zzMq == null) {
            byte[] byArray;
            Parcel parcel2 = Parcel.obtain();
            try {
                this.zzMr.writeToParcel(parcel2, 0);
                byArray = parcel2.marshall();
            }
            finally {
                parcel2.recycle();
            }
            this.zzMq = this.zzg(byArray);
        }
        zzm.zza(this, parcel, n);
    }

    protected <T> ParcelFileDescriptor zzg(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            Runnable runnable = new Runnable((OutputStream)autoCloseOutputStream2, byArray){
                final /* synthetic */ OutputStream zzMt;
                final /* synthetic */ byte[] zzMu;
                {
                    this.zzMt = outputStream;
                    this.zzMu = byArray;
                }

                @Override
                public void run() {
                    block7: {
                        DataOutputStream dataOutputStream = null;
                        try {
                            dataOutputStream = new DataOutputStream(this.zzMt);
                            dataOutputStream.writeInt(this.zzMu.length);
                            dataOutputStream.write(this.zzMu);
                        }
                        catch (IOException iOException) {
                            zzjw.zzb((String)"Error transporting the ad response", (Throwable)iOException);
                            zzu.zzcn().zzb(iOException, true);
                            break block7;
                        }
                        finally {
                            if (dataOutputStream == null) {
                                zzo.zzb((Closeable)this.zzMt);
                            } else {
                                zzo.zzb((Closeable)dataOutputStream);
                            }
                        }
                        zzo.zzb((Closeable)dataOutputStream);
                    }
                }
            };
            new Thread(runnable).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzjw.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzu.zzcn().zzb(iOException, true);
            zzo.zzb(autoCloseOutputStream);
            return null;
        }
    }
}

