/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.View;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.purchase.GInAppPurchaseManagerInfoParcel;
import com.google.android.gms.ads.internal.purchase.zzc;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzj;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.CapabilityParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzej;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzga;
import com.google.android.gms.internal.zzhe;
import com.google.android.gms.internal.zzhg;
import com.google.android.gms.internal.zzhh;
import com.google.android.gms.internal.zzhk;
import com.google.android.gms.internal.zzhl;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzjp;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzla;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Future;

@zzig
public abstract class zzb
extends zza
implements zzg,
zzj,
zzs,
zzej,
zzfs {
    protected final zzga zzqc;
    private final Messenger mMessenger;
    protected transient boolean zzqd;

    public zzb(Context context, AdSizeParcel adSizeParcel, String string, zzga zzga2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        this(new zzv(context, adSizeParcel, string, versionInfoParcel), zzga2, null, zzd2);
    }

    protected zzb(zzv zzv2, zzga zzga2, @Nullable zzr zzr2, zzd zzd2) {
        super(zzv2, zzr2, zzd2);
        this.zzqc = zzga2;
        this.mMessenger = new Messenger((Handler)new zzhe(this.zzpV.zzov));
        this.zzqd = false;
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel, zzdc zzdc2) {
        if (!this.zzbr()) {
            return false;
        }
        Bundle bundle = null;
        bundle = this.zza(zzu.zzcn().zzz(this.zzpV.zzov));
        this.zzpU.cancel();
        this.zzpV.zzsX = 0;
        zzjp zzjp2 = null;
        if (zzcu.zzzq.get().booleanValue()) {
            zzjp2 = zzu.zzcn().zziO();
            zzu.zzcC().zza(this.zzpV.zzov, this.zzpV.zzsx, false, zzjp2, zzjp2 == null ? null : zzjp2.zziC(), this.zzpV.zzsv);
        }
        AdRequestInfoParcel.zza zza2 = this.zza(adRequestParcel, bundle, zzjp2);
        zzdc2.zzf("seq_num", zza2.zzLl);
        zzdc2.zzf("request_id", zza2.zzLx);
        zzdc2.zzf("session_id", zza2.zzLm);
        if (zza2.zzLj != null) {
            zzdc2.zzf("app_version", String.valueOf(zza2.zzLj.versionCode));
        }
        this.zzpV.zzsz = zzu.zzcg().zza(this.zzpV.zzov, zza2, this.zzpV.zzsw, this);
        return true;
    }

    @Override
    public void zzb(zzjn zzjn2) {
        super.zzb(zzjn2);
        if (zzjn2.zzFg != null) {
            zzjw.zzaU((String)"Pinging network fill URLs.");
            zzu.zzcz().zza(this.zzpV.zzov, this.zzpV.zzsx.afmaVersion, zzjn2, this.zzpV.zzsv, false, zzjn2.zzFg.zzEu);
            if (zzjn2.zzOY.zzEI != null && zzjn2.zzOY.zzEI.size() > 0) {
                zzjw.zzaU((String)"Pinging urls remotely");
                zzu.zzck().zza(this.zzpV.zzov, zzjn2.zzOY.zzEI);
            }
        }
        if (zzjn2.errorCode == 3 && zzjn2.zzOY != null && zzjn2.zzOY.zzEH != null) {
            zzjw.zzaU((String)"Pinging no fill URLs.");
            zzu.zzcz().zza(this.zzpV.zzov, this.zzpV.zzsx.afmaVersion, zzjn2, this.zzpV.zzsv, false, zzjn2.zzOY.zzEH);
        }
    }

    @Override
    protected boolean zza(@Nullable zzjn zzjn2, zzjn zzjn3) {
        if (zzjn2 != null && zzjn2.zzFj != null) {
            zzjn2.zzFj.zza((zzfs)null);
        }
        if (zzjn3.zzFj != null) {
            zzjn3.zzFj.zza(this);
        }
        int n = 0;
        int n2 = 0;
        if (zzjn3.zzOY != null) {
            n = zzjn3.zzOY.zzER;
            n2 = zzjn3.zzOY.zzES;
        }
        this.zzpV.zzsV.zzh(n, n2);
        return true;
    }

    @Override
    public void onAdClicked() {
        if (this.zzpV.zzsC == null) {
            zzjw.zzaW((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        if (this.zzpV.zzsC.zzOY != null && this.zzpV.zzsC.zzOY.zzEF != null) {
            zzu.zzcz().zza(this.zzpV.zzov, this.zzpV.zzsx.afmaVersion, this.zzpV.zzsC, this.zzpV.zzsv, false, this.zzpV.zzsC.zzOY.zzEF);
        }
        if (this.zzpV.zzsC.zzFg != null && this.zzpV.zzsC.zzFg.zzEs != null) {
            zzu.zzcz().zza(this.zzpV.zzov, this.zzpV.zzsx.afmaVersion, this.zzpV.zzsC, this.zzpV.zzsv, false, this.zzpV.zzsC.zzFg.zzEs);
        }
        super.onAdClicked();
    }

    @Override
    boolean zza(zzjn zzjn2) {
        AdRequestParcel adRequestParcel;
        boolean bl = false;
        if (this.zzpW != null) {
            adRequestParcel = this.zzpW;
            this.zzpW = null;
        } else {
            adRequestParcel = zzjn2.zzLi;
            bl = adRequestParcel.extras != null ? adRequestParcel.extras.getBoolean("_noRefresh", false) : false;
        }
        return this.zza(adRequestParcel, zzjn2, bl);
    }

    protected boolean zza(AdRequestParcel adRequestParcel, zzjn zzjn2, boolean bl) {
        if (!bl && this.zzpV.zzcJ()) {
            if (zzjn2.zzEL > 0L) {
                this.zzpU.zza(adRequestParcel, zzjn2.zzEL);
            } else if (zzjn2.zzOY != null && zzjn2.zzOY.zzEL > 0L) {
                this.zzpU.zza(adRequestParcel, zzjn2.zzOY.zzEL);
            } else if (!zzjn2.zzLP && zzjn2.errorCode == 2) {
                this.zzpU.zzg(adRequestParcel);
            }
        }
        return this.zzpU.zzbW();
    }

    @Override
    public void pause() {
        zzaa.zzdc((String)"pause must be called on the main UI thread.");
        if (this.zzpV.zzsC != null && this.zzpV.zzsC.zzHF != null && this.zzpV.zzcJ()) {
            zzu.zzcm().zzi(this.zzpV.zzsC.zzHF);
        }
        if (this.zzpV.zzsC != null && this.zzpV.zzsC.zzFh != null) {
            try {
                this.zzpV.zzsC.zzFh.pause();
            }
            catch (RemoteException remoteException) {
                zzjw.zzaW((String)"Could not pause mediation adapter.");
            }
        }
        this.zzpX.zzk(this.zzpV.zzsC);
        this.zzpU.pause();
    }

    @Override
    public void resume() {
        zzaa.zzdc((String)"resume must be called on the main UI thread.");
        zzla zzla2 = null;
        if (this.zzpV.zzsC != null && this.zzpV.zzsC.zzHF != null) {
            zzla2 = this.zzpV.zzsC.zzHF;
        }
        if (zzla2 != null && this.zzpV.zzcJ()) {
            zzu.zzcm().zzj(this.zzpV.zzsC.zzHF);
        }
        if (this.zzpV.zzsC != null && this.zzpV.zzsC.zzFh != null) {
            try {
                this.zzpV.zzsC.zzFh.resume();
            }
            catch (RemoteException remoteException) {
                zzjw.zzaW((String)"Could not resume mediation adapter.");
            }
        }
        if (zzla2 == null || !zzla2.zzjJ()) {
            this.zzpU.resume();
        }
        this.zzpX.zzl(this.zzpV.zzsC);
    }

    @Override
    protected boolean zzc(AdRequestParcel adRequestParcel) {
        return super.zzc(adRequestParcel) && !this.zzqd;
    }

    protected boolean zzbr() {
        boolean bl = true;
        if (!zzu.zzck().zza(this.zzpV.zzov.getPackageManager(), this.zzpV.zzov.getPackageName(), "android.permission.INTERNET") || !zzu.zzck().zzB(this.zzpV.zzov)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void zzbs() {
        this.zzpX.zzi(this.zzpV.zzsC);
        this.zzqd = false;
        this.zzbm();
        this.zzpV.zzsE.zziv();
    }

    @Override
    public void zzbt() {
        this.zzqd = true;
        this.zzbo();
    }

    @Override
    public void onPause() {
        this.zzpX.zzk(this.zzpV.zzsC);
    }

    @Override
    public void onResume() {
        this.zzpX.zzl(this.zzpV.zzsC);
    }

    @Override
    public void zzbu() {
        this.onAdClicked();
    }

    @Override
    public void zzbv() {
        this.zzbs();
    }

    @Override
    public void zzbw() {
        this.zzbj();
    }

    @Override
    public void zzbx() {
        this.zzbt();
    }

    @Override
    public void zzby() {
        if (this.zzpV.zzsC != null) {
            String string = this.zzpV.zzsC.zzFi;
            zzjw.zzaW((String)new StringBuilder(74 + String.valueOf(string).length()).append("Mediation adapter ").append(string).append(" refreshed, but mediation adapters should never refresh.").toString());
        }
        this.zza(this.zzpV.zzsC, true);
        this.zzbp();
    }

    @Override
    public void zzbz() {
        this.recordImpression();
    }

    private AdRequestInfoParcel.zza zza(AdRequestParcel adRequestParcel, Bundle bundle, zzjp zzjp2) {
        String string;
        int n;
        Object object;
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.zzpV.zzov.getApplicationInfo();
        try {
            packageManager = this.zzpV.zzov.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = this.zzpV.zzov.getResources().getDisplayMetrics();
        Bundle bundle2 = null;
        if (this.zzpV.zzsy != null && this.zzpV.zzsy.getParent() != null) {
            object = new int[2];
            this.zzpV.zzsy.getLocationOnScreen((int[])object);
            Object object2 = object[0];
            Object object3 = object[1];
            int n2 = this.zzpV.zzsy.getWidth();
            int n3 = this.zzpV.zzsy.getHeight();
            int n4 = 0;
            if (this.zzpV.zzsy.isShown() && object2 + n2 > 0 && object3 + n3 > 0 && object2 <= packageManager.widthPixels && object3 <= packageManager.heightPixels) {
                n4 = 1;
            }
            bundle2 = new Bundle(5);
            bundle2.putInt("x", (int)object2);
            bundle2.putInt("y", (int)object3);
            bundle2.putInt("width", n2);
            bundle2.putInt("height", n3);
            bundle2.putInt("visible", n4);
        }
        object = zzu.zzcn().zziE();
        this.zzpV.zzsE = new zzjo((String)object, this.zzpV.zzsv);
        this.zzpV.zzsE.zzq(adRequestParcel);
        String string2 = zzu.zzck().zza(this.zzpV.zzov, (View)this.zzpV.zzsy, this.zzpV.zzsB);
        long l = 0L;
        if (this.zzpV.zzsI != null) {
            try {
                l = this.zzpV.zzsI.getValue();
            }
            catch (RemoteException remoteException) {
                zzjw.zzaW((String)"Cannot get correlation id, default to 0.");
            }
        }
        String string3 = UUID.randomUUID().toString();
        Bundle bundle3 = zzu.zzcn().zza(this.zzpV.zzov, this, (String)object);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.zzpV.zzsO.size(); n += 1) {
            arrayList.add((String)this.zzpV.zzsO.keyAt(n));
        }
        n = this.zzpV.zzsJ != null ? 1 : 0;
        boolean bl = this.zzpV.zzsK != null && zzu.zzcn().zziQ();
        boolean bl2 = this.zzpY.zzqo.zzgP();
        String string4 = "";
        if (zzcu.zzzK.get().booleanValue()) {
            zzjw.zzaU((String)"Getting webview cookie from CookieManager.");
            string = zzu.zzcm().zzN(this.zzpV.zzov);
            if (string != null) {
                string4 = string.getCookie("googleads.g.doubleclick.net");
            }
        }
        string = null;
        if (zzjp2 != null) {
            string = zzjp2.zziB();
        }
        return new AdRequestInfoParcel.zza(bundle2, adRequestParcel, this.zzpV.zzsB, this.zzpV.zzsv, applicationInfo, packageInfo, (String)object, zzu.zzcn().getSessionId(), this.zzpV.zzsx, bundle3, this.zzpV.zzsT, arrayList, bundle, zzu.zzcn().zziI(), this.mMessenger, packageManager.widthPixels, packageManager.heightPixels, packageManager.density, string2, l, string3, zzcu.zzer(), this.zzpV.zzsu, this.zzpV.zzsP, new CapabilityParcel(n != 0, bl, bl2), this.zzpV.zzcN(), zzu.zzck().zzbS(), zzu.zzck().zzbU(), zzu.zzck().zzL(this.zzpV.zzov), zzu.zzck().zzo((View)this.zzpV.zzsy), this.zzpV.zzov instanceof Activity, zzu.zzcn().zziM(), string4, string, zzu.zzcn().zziN(), zzu.zzcD().zzfe(), zzu.zzck().zzjd());
    }

    @Override
    public void zza(zzhh zzhh2) {
        zzaa.zzdc((String)"setInAppPurchaseListener must be called on the main UI thread.");
        this.zzpV.zzsJ = zzhh2;
    }

    @Override
    public void zza(zzhl zzhl2, @Nullable String string) {
        zzaa.zzdc((String)"setPlayStorePurchaseParams must be called on the main UI thread.");
        this.zzpV.zzsU = new zzk(string);
        this.zzpV.zzsK = zzhl2;
        if (!zzu.zzcn().zziH() && zzhl2 != null) {
            Future cfr_ignored_0 = (Future)new zzc(this.zzpV.zzov, this.zzpV.zzsK, this.zzpV.zzsU).zzhs();
        }
    }

    @Override
    public void zza(String string, ArrayList<String> arrayList) {
        com.google.android.gms.ads.internal.purchase.zzd zzd2 = new com.google.android.gms.ads.internal.purchase.zzd(string, arrayList, this.zzpV.zzov, this.zzpV.zzsx.afmaVersion);
        if (this.zzpV.zzsJ == null) {
            zzjw.zzaW((String)"InAppPurchaseListener is not set. Try to launch default purchase flow.");
            if (!zzm.zzdQ().zzQ(this.zzpV.zzov)) {
                zzjw.zzaW((String)"Google Play Service unavailable, cannot launch default purchase flow.");
                return;
            }
            if (this.zzpV.zzsK == null) {
                zzjw.zzaW((String)"PlayStorePurchaseListener is not set.");
                return;
            }
            if (this.zzpV.zzsU == null) {
                zzjw.zzaW((String)"PlayStorePurchaseVerifier is not initialized.");
                return;
            }
            if (this.zzpV.zzsY) {
                zzjw.zzaW((String)"An in-app purchase request is already in progress, abort");
                return;
            }
            this.zzpV.zzsY = true;
            try {
                if (!this.zzpV.zzsK.isValidPurchase(string)) {
                    this.zzpV.zzsY = false;
                    return;
                }
            }
            catch (RemoteException remoteException) {
                zzjw.zzaW((String)"Could not start In-App purchase.");
                this.zzpV.zzsY = false;
                return;
            }
            zzu.zzcu().zza(this.zzpV.zzov, this.zzpV.zzsx.zzRE, new GInAppPurchaseManagerInfoParcel(this.zzpV.zzov, this.zzpV.zzsU, (zzhg)zzd2, this));
        } else {
            try {
                this.zzpV.zzsJ.zza((zzhg)zzd2);
            }
            catch (RemoteException remoteException) {
                zzjw.zzaW((String)"Could not start In-App purchase.");
            }
        }
    }

    @Override
    public void zza(String string, boolean bl, int n, final Intent intent, zzf zzf2) {
        try {
            if (this.zzpV.zzsK != null) {
                this.zzpV.zzsK.zza((zzhk)new com.google.android.gms.ads.internal.purchase.zzg(this.zzpV.zzov, string, bl, n, intent, zzf2));
            }
        }
        catch (RemoteException remoteException) {
            zzjw.zzaW((String)"Fail to invoke PlayStorePurchaseListener.");
        }
        zzka.zzQu.postDelayed(new Runnable(){

            @Override
            public void run() {
                int n = zzu.zzcu().zzd(intent);
                zzu.zzcu();
                if (n == 0 && zzb.this.zzpV.zzsC != null && zzb.this.zzpV.zzsC.zzHF != null && zzb.this.zzpV.zzsC.zzHF.zzjB() != null) {
                    zzb.this.zzpV.zzsC.zzHF.zzjB().close();
                }
                zzb.this.zzpV.zzsY = false;
            }
        }, 500L);
    }

    public void recordImpression() {
        this.zza(this.zzpV.zzsC, false);
    }

    protected void zza(@Nullable zzjn zzjn2, boolean bl) {
        if (zzjn2 == null) {
            zzjw.zzaW((String)"Ad state was null when trying to ping impression URLs.");
            return;
        }
        super.zzc(zzjn2);
        if (zzjn2.zzOY != null && zzjn2.zzOY.zzEG != null) {
            zzu.zzcz().zza(this.zzpV.zzov, this.zzpV.zzsx.afmaVersion, zzjn2, this.zzpV.zzsv, bl, zzjn2.zzOY.zzEG);
        }
        if (zzjn2.zzFg != null && zzjn2.zzFg.zzEt != null) {
            zzu.zzcz().zza(this.zzpV.zzov, this.zzpV.zzsx.afmaVersion, zzjn2, this.zzpV.zzsv, bl, zzjn2.zzFg.zzEt);
        }
    }

    public String getMediationAdapterClassName() {
        if (this.zzpV.zzsC == null) {
            return null;
        }
        return this.zzpV.zzsC.zzFi;
    }

    public void showInterstitial() {
        throw new IllegalStateException("showInterstitial is not supported for current ad type");
    }

    @Override
    public void zzbA() {
        zzu.zzck().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                zzb.this.zzpU.pause();
            }
        });
    }

    @Override
    public void zzbB() {
        zzu.zzck().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                zzb.this.zzpU.resume();
            }
        });
    }
}

