/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.Window;
import com.google.android.gms.ads.internal.InterstitialAdParameterParcel;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzc;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzcu;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzfq;
import com.google.android.gms.internal.zzfr;
import com.google.android.gms.internal.zzga;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzij;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzjn;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlb;
import java.util.Collections;
import java.util.concurrent.Future;
import org.json.JSONException;
import org.json.JSONObject;

@zzig
public class zzl
extends zzc
implements zzel,
zzep.zza {
    protected transient boolean zzqX = false;
    private int zzqY = -1;
    private boolean zzqZ;
    private float zzra;

    public zzl(Context context, AdSizeParcel adSizeParcel, String string, zzga zzga2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        super(context, adSizeParcel, string, zzga2, versionInfoParcel, zzd2);
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel, zzdc zzdc2) {
        if (this.zzpV.zzsC != null) {
            zzjw.zzaW((String)"An interstitial is already loading. Aborting.");
            return false;
        }
        return super.zza(adRequestParcel, zzdc2);
    }

    @Override
    public void zza(zzjn.zza zza2, zzdc zzdc2) {
        boolean bl;
        if (!zzcu.zzyf.get().booleanValue()) {
            super.zza(zza2, zzdc2);
            return;
        }
        if (zza2.errorCode != -2) {
            super.zza(zza2, zzdc2);
            return;
        }
        Bundle bundle = zza2.zzPh.zzLi.zzuX;
        Bundle bundle2 = bundle.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        boolean bl2 = bundle2 == null || !bundle2.containsKey("gw");
        boolean bl3 = bl = !zza2.zzPi.zzLP;
        if (bl2 && bl) {
            this.zzpV.zzsD = this.zzc(zza2);
        }
        super.zza(this.zzpV.zzsD, zzdc2);
    }

    @Override
    protected zzla zza(zzjn.zza zza2, @Nullable zze zze2, @Nullable zzjh zzjh2) {
        zzla zzla2 = zzu.zzcl().zza(this.zzpV.zzov, this.zzpV.zzsB, false, false, this.zzpV.zzsw, this.zzpV.zzsx, this.zzpQ, this, this.zzpY);
        zzla2.zzjD().zza(this, null, this, this, zzcu.zzxU.get(), this, this, zze2, null, zzjh2);
        this.zza(zzla2);
        zzla2.zzaY(zza2.zzPh.zzLx);
        zzep.zza(zzla2, this);
        return zzla2;
    }

    @Override
    protected boolean zza(AdRequestParcel adRequestParcel, zzjn zzjn2, boolean bl) {
        if (this.zzpV.zzcJ() && zzjn2.zzHF != null) {
            zzu.zzcm().zzi(zzjn2.zzHF);
        }
        return this.zzpU.zzbW();
    }

    @Override
    public boolean zza(@Nullable zzjn zzjn2, zzjn zzjn3) {
        if (!super.zza(zzjn2, zzjn3)) {
            return false;
        }
        if (!this.zzpV.zzcJ() && this.zzpV.zzsW != null && zzjn3.zzOW != null) {
            this.zzpX.zza(this.zzpV.zzsB, zzjn3, this.zzpV.zzsW);
        }
        return true;
    }

    @Override
    public void zzbt() {
        zzlb zzlb2;
        this.recordImpression();
        super.zzbt();
        if (this.zzpV.zzsC != null && this.zzpV.zzsC.zzHF != null && (zzlb2 = this.zzpV.zzsC.zzHF.zzjD()) != null) {
            zzlb2.zzjU();
        }
    }

    @Override
    protected void zzbm() {
        this.zzbO();
        super.zzbm();
    }

    @Override
    public void zzf(boolean bl) {
        this.zzpV.zzrf = bl;
    }

    @Override
    public void zza(boolean bl, float f) {
        this.zzqZ = bl;
        this.zzra = f;
    }

    @Override
    public void showInterstitial() {
        Object object;
        String string;
        zzaa.zzdc((String)"showInterstitial must be called on the main UI thread.");
        if (this.zzpV.zzsC == null) {
            zzjw.zzaW((String)"The interstitial has not loaded.");
            return;
        }
        if (zzcu.zzyv.get().booleanValue()) {
            String string2 = string = this.zzpV.zzov.getApplicationContext() != null ? this.zzpV.zzov.getApplicationContext().getPackageName() : this.zzpV.zzov.getPackageName();
            if (!this.zzqX) {
                zzjw.zzaW((String)"It is not recommended to show an interstitial before onAdLoaded completes.");
                object = new Bundle();
                object.putString("appid", string);
                object.putString("action", "show_interstitial_before_load_finish");
                this.zzb((Bundle)object);
            }
            if (!zzu.zzck().zzH(this.zzpV.zzov)) {
                zzjw.zzaW((String)"It is not recommended to show an interstitial when app is not in foreground.");
                object = new Bundle();
                object.putString("appid", string);
                object.putString("action", "show_interstitial_app_not_in_foreground");
                this.zzb((Bundle)object);
            }
        }
        if (this.zzpV.zzcK()) {
            return;
        }
        if (this.zzpV.zzsC.zzLP && this.zzpV.zzsC.zzFh != null) {
            try {
                this.zzpV.zzsC.zzFh.showInterstitial();
            }
            catch (RemoteException remoteException) {
                zzjw.zzd((String)"Could not show interstitial.", (Throwable)remoteException);
                this.zzbO();
            }
        } else {
            if (this.zzpV.zzsC.zzHF == null) {
                zzjw.zzaW((String)"The interstitial failed to load.");
                return;
            }
            if (this.zzpV.zzsC.zzHF.zzjH()) {
                zzjw.zzaW((String)"The interstitial is already showing.");
                return;
            }
            this.zzpV.zzsC.zzHF.zzG(true);
            if (this.zzpV.zzsC.zzOW != null) {
                this.zzpX.zza(this.zzpV.zzsB, this.zzpV.zzsC);
            }
            string = this.zzpV.zzrf ? zzu.zzck().zzI(this.zzpV.zzov) : null;
            this.zzqY = zzu.zzcB().zzb((Bitmap)string);
            if (zzcu.zzyZ.get().booleanValue() && string != null) {
                Future cfr_ignored_0 = (Future)new zza(this.zzqY).zzhs();
            } else {
                object = new InterstitialAdParameterParcel(this.zzpV.zzrf, this.zzbN(), false, 0.0f, -1);
                int n = this.zzpV.zzsC.zzHF.getRequestedOrientation();
                if (n == -1) {
                    n = this.zzpV.zzsC.orientation;
                }
                AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(this, this, this, this.zzpV.zzsC.zzHF, n, this.zzpV.zzsx, this.zzpV.zzsC.zzLU, (InterstitialAdParameterParcel)((Object)object));
                zzu.zzci().zza(this.zzpV.zzov, adOverlayInfoParcel);
            }
        }
    }

    private void zzb(Bundle bundle) {
        zzu.zzck().zzb(this.zzpV.zzov, this.zzpV.zzsx.afmaVersion, "gmob-apps", bundle, false);
    }

    protected boolean zzbN() {
        if (!(this.zzpV.zzov instanceof Activity)) {
            return false;
        }
        Window window = ((Activity)this.zzpV.zzov).getWindow();
        if (window == null || window.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        window.getDecorView().getGlobalVisibleRect(rect, null);
        window.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    @Override
    protected void zzbp() {
        super.zzbp();
        this.zzqX = true;
    }

    public void zzbO() {
        zzu.zzcB().zzb(this.zzqY);
        if (this.zzpV.zzcJ()) {
            this.zzpV.zzcG();
            this.zzpV.zzsC = null;
            this.zzpV.zzrf = false;
            this.zzqX = false;
        }
    }

    @Override
    public void zzbP() {
        if (this.zzpV.zzsC != null && this.zzpV.zzsC.zzPb != null) {
            zzu.zzck().zza(this.zzpV.zzov, this.zzpV.zzsx.afmaVersion, this.zzpV.zzsC.zzPb);
        }
        this.zzbq();
    }

    @Override
    public void zzb(RewardItemParcel rewardItemParcel) {
        if (this.zzpV.zzsC != null) {
            if (this.zzpV.zzsC.zzMh != null) {
                zzu.zzck().zza(this.zzpV.zzov, this.zzpV.zzsx.afmaVersion, this.zzpV.zzsC.zzMh);
            }
            if (this.zzpV.zzsC.zzMf != null) {
                rewardItemParcel = this.zzpV.zzsC.zzMf;
            }
        }
        this.zza(rewardItemParcel);
    }

    private zzjn.zza zzc(zzjn.zza zza2) {
        String string;
        Object object;
        String string2;
        try {
            string2 = zzij.zzc(zza2.zzPi).toString();
            object = new JSONObject();
            object.put("pubid", (Object)zza2.zzPh.zzsv);
            string = object.toString();
        }
        catch (JSONException jSONException) {
            zzjw.zzb((String)"Unable to generate ad state for an interstitial ad with pooling.", (Throwable)jSONException);
            return zza2;
        }
        object = new zzfq(string2, null, Collections.singletonList("com.google.ads.mediation.admob.AdMobAdapter"), null, null, Collections.emptyList(), Collections.emptyList(), string, null, Collections.emptyList(), Collections.emptyList(), null, null, null, null, null, Collections.emptyList());
        zzfr zzfr2 = new zzfr(Collections.singletonList(object), -1L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, "", -1L, 0, 1, null, 0, -1, -1L, false);
        AdResponseParcel adResponseParcel = zza2.zzPi;
        AdResponseParcel adResponseParcel2 = new AdResponseParcel(zza2.zzPh, adResponseParcel.zzHH, adResponseParcel.body, adResponseParcel.zzEF, adResponseParcel.zzEG, adResponseParcel.zzLO, true, adResponseParcel.zzLQ, adResponseParcel.zzLR, adResponseParcel.zzEL, adResponseParcel.orientation, adResponseParcel.zzLS, adResponseParcel.zzLT, adResponseParcel.zzLU, adResponseParcel.zzLV, adResponseParcel.zzLW, adResponseParcel.zzLX, adResponseParcel.zzLY, adResponseParcel.zzvv, adResponseParcel.zzLq, adResponseParcel.zzLZ, adResponseParcel.zzMa, adResponseParcel.zzMb, adResponseParcel.zzMe, adResponseParcel.zzvw, adResponseParcel.zzvx, adResponseParcel.zzMf, adResponseParcel.zzMg, adResponseParcel.zzMh, adResponseParcel.zzMi, adResponseParcel.zzMj, adResponseParcel.zzLH, adResponseParcel.zzLI, adResponseParcel.zzEI, adResponseParcel.zzMk, adResponseParcel.zzEJ);
        return new zzjn.zza(zza2.zzPh, adResponseParcel2, zzfr2, zza2.zzsB, zza2.errorCode, zza2.zzPc, zza2.zzPd, zza2.zzOW);
    }

    @zzig
    private class zza
    extends zzjv {
        private final int zzrb;

        public zza(int n) {
            this.zzrb = n;
        }

        @Override
        public void zzbQ() {
            InterstitialAdParameterParcel interstitialAdParameterParcel = new InterstitialAdParameterParcel(zzl.this.zzpV.zzrf, zzl.this.zzbN(), zzl.this.zzqZ, zzl.this.zzra, zzl.this.zzpV.zzrf ? this.zzrb : -1);
            int n = zzl.this.zzpV.zzsC.zzHF.getRequestedOrientation();
            if (n == -1) {
                n = zzl.this.zzpV.zzsC.orientation;
            }
            final AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(zzl.this, zzl.this, zzl.this, zzl.this.zzpV.zzsC.zzHF, n, zzl.this.zzpV.zzsx, zzl.this.zzpV.zzsC.zzLU, interstitialAdParameterParcel);
            zzka.zzQu.post(new Runnable(){

                @Override
                public void run() {
                    zzu.zzci().zza(zzl.this.zzpV.zzov, adOverlayInfoParcel);
                }
            });
        }

        @Override
        public void onStop() {
        }
    }
}

