/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.ActivityManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdLauncherIntentInfoParcel;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzej;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzjw;
import com.google.android.gms.internal.zzla;
import com.google.android.gms.internal.zzlb;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@zzig
public final class zzeo
implements zzeh {
    private final zzej zzCq;
    private final zze zzCn;
    private final zzgr zzCo;

    public zzeo(zzej zzej2, zze zze2, zzgr zzgr2) {
        this.zzCq = zzej2;
        this.zzCn = zze2;
        this.zzCo = zzgr2;
    }

    @Override
    public void zza(zzla zzla2, Map<String, String> map) {
        String string2 = map.get("a");
        if (string2 == null) {
            zzjw.zzaW((String)"Action missing from an open GMSG.");
            return;
        }
        if (this.zzCn != null && !this.zzCn.zzbG()) {
            this.zzCn.zzt(map.get("u"));
            return;
        }
        zzlb zzlb2 = zzla2.zzjD();
        if ("expand".equalsIgnoreCase(string2)) {
            if (zzla2.zzjH()) {
                zzjw.zzaW((String)"Cannot expand WebView that is already expanded.");
                return;
            }
            this.zzq(false);
            zzlb2.zza(zzeo.zzc(map), zzeo.zzd(map));
        } else if ("webapp".equalsIgnoreCase(string2)) {
            String string3 = map.get("u");
            this.zzq(false);
            if (string3 != null) {
                zzlb2.zza(zzeo.zzc(map), zzeo.zzd(map), string3);
            } else {
                zzlb2.zza(zzeo.zzc(map), zzeo.zzd(map), map.get("html"), map.get("baseurl"));
            }
        } else if ("in_app_purchase".equalsIgnoreCase(string2)) {
            String string4 = map.get("product_id");
            String string5 = map.get("report_urls");
            if (this.zzCq == null) {
                return;
            }
            if (string5 != null && !string5.isEmpty()) {
                String[] stringArray = string5.split(" ");
                this.zzCq.zza(string4, new ArrayList<String>(Arrays.asList(stringArray)));
            } else {
                this.zzCq.zza(string4, new ArrayList<String>());
            }
        } else if ("app".equalsIgnoreCase(string2) && "true".equalsIgnoreCase(map.get("system_browser"))) {
            this.zzq(true);
            zzeo.zze(zzla2, map);
        } else {
            this.zzq(true);
            String string6 = map.get("u");
            if (!TextUtils.isEmpty((CharSequence)string6)) {
                string6 = zzu.zzck().zza(zzla2, string6);
            }
            zzlb2.zza(new AdLauncherIntentInfoParcel(map.get("i"), string6, map.get("m"), map.get("p"), map.get("c"), map.get("f"), map.get("e")));
        }
    }

    private static void zze(zzla zzla2, Map<String, String> map) {
        Context context = zzla2.getContext();
        String string2 = map.get("u");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            zzjw.zzaW((String)"Destination url cannot be empty.");
            return;
        }
        zzlb zzlb2 = zzla2.zzjD();
        zza zza2 = new zza(zzla2);
        Intent intent = zza2.zza(context, map);
        try {
            zzlb2.zza(new AdLauncherIntentInfoParcel(intent));
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzjw.zzaW((String)activityNotFoundException.getMessage());
        }
    }

    private static boolean zzc(Map<String, String> map) {
        return "1".equals(map.get("custom_close"));
    }

    private static int zzd(Map<String, String> map) {
        String string2 = map.get("o");
        if (string2 != null) {
            if ("p".equalsIgnoreCase(string2)) {
                return zzu.zzcm().zzjf();
            }
            if ("l".equalsIgnoreCase(string2)) {
                return zzu.zzcm().zzje();
            }
            if ("c".equalsIgnoreCase(string2)) {
                return zzu.zzcm().zzjg();
            }
        }
        return -1;
    }

    private void zzq(boolean bl) {
        if (this.zzCo != null) {
            this.zzCo.zzr(bl);
        }
    }

    public static class zza {
        private final zzla zzBb;

        public zza(zzla zzla2) {
            this.zzBb = zzla2;
        }

        public Intent zze(Uri uri) {
            if (uri == null) {
                return null;
            }
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.addFlags(0x10000000);
            intent.setData(uri);
            intent.setAction("android.intent.action.VIEW");
            return intent;
        }

        public ResolveInfo zza(Context context, Intent intent) {
            return this.zza(context, intent, new ArrayList<ResolveInfo>());
        }

        public ResolveInfo zza(Context context, Intent intent, ArrayList<ResolveInfo> arrayList) {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return null;
            }
            List list = packageManager.queryIntentActivities(intent, 65536);
            ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
            ResolveInfo resolveInfo2 = null;
            if (list != null && resolveInfo != null) {
                for (int i = 0; i < list.size(); ++i) {
                    ResolveInfo resolveInfo3 = (ResolveInfo)list.get(i);
                    if (resolveInfo == null || !resolveInfo.activityInfo.name.equals(resolveInfo3.activityInfo.name)) continue;
                    resolveInfo2 = resolveInfo;
                    break;
                }
            }
            arrayList.addAll(list);
            return resolveInfo2;
        }

        public Intent zza(Intent intent, ResolveInfo resolveInfo) {
            Intent intent2 = new Intent(intent);
            intent2.setClassName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name);
            return intent2;
        }

        public Intent zza(Context context, Map<String, String> map) {
            Object object;
            ResolveInfo resolveInfo3;
            Object object2;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            String string2 = map.get("u");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            if (this.zzBb != null) {
                string2 = zzu.zzck().zza(this.zzBb, string2);
            }
            Uri uri = Uri.parse((String)string2);
            boolean bl = Boolean.parseBoolean(map.get("use_first_package"));
            boolean bl2 = Boolean.parseBoolean(map.get("use_running_process"));
            Uri uri2 = null;
            if ("http".equalsIgnoreCase(uri.getScheme())) {
                uri2 = uri.buildUpon().scheme("https").build();
            } else if ("https".equalsIgnoreCase(uri.getScheme())) {
                uri2 = uri.buildUpon().scheme("http").build();
            }
            ArrayList<ResolveInfo> arrayList = new ArrayList<ResolveInfo>();
            Intent intent = this.zze(uri);
            Intent intent2 = this.zze(uri2);
            ResolveInfo resolveInfo2 = this.zza(context, intent, arrayList);
            if (resolveInfo2 != null) {
                return this.zza(intent, resolveInfo2);
            }
            if (intent2 != null && (object2 = this.zza(context, intent2)) != null && (resolveInfo3 = this.zza(context, (Intent)(object = this.zza(intent, (ResolveInfo)object2)))) != null) {
                return object;
            }
            if (arrayList.size() == 0) {
                return intent;
            }
            if (bl2 && activityManager != null && (object2 = activityManager.getRunningAppProcesses()) != null) {
                for (ResolveInfo resolveInfo3 : arrayList) {
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)iterator.next();
                        if (!runningAppProcessInfo.processName.equals(resolveInfo3.activityInfo.packageName)) continue;
                        return this.zza(intent, resolveInfo3);
                    }
                }
            }
            if (bl) {
                return this.zza(intent, arrayList.get(0));
            }
            return intent;
        }
    }
}

