/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcm;
import com.google.android.gms.internal.zzgw;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzla;
import java.util.Map;

@zzig
public class zzgq
extends zzgw {
    private final Map<String, String> zzAd;
    private final Context mContext;
    private String zzFR;
    private long zzFS;
    private long zzFT;
    private String zzFU;
    private String zzFV;

    public zzgq(zzla zzla2, Map<String, String> map) {
        super(zzla2, "createCalendarEvent");
        this.zzAd = map;
        this.mContext = zzla2.zzjy();
        this.zzfN();
    }

    private void zzfN() {
        this.zzFR = this.zzap("description");
        this.zzFU = this.zzap("summary");
        this.zzFS = this.zzaq("start_ticks");
        this.zzFT = this.zzaq("end_ticks");
        this.zzFV = this.zzap("location");
    }

    private String zzap(String string2) {
        return TextUtils.isEmpty((CharSequence)this.zzAd.get(string2)) ? "" : this.zzAd.get(string2);
    }

    private long zzaq(String string2) {
        String string3 = this.zzAd.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzas("Activity context is not available.");
            return;
        }
        zzcm zzcm2 = zzu.zzck().zzF(this.mContext);
        if (!zzcm2.zzeo()) {
            this.zzas("This feature is not available on the device.");
            return;
        }
        AlertDialog.Builder builder = zzu.zzck().zzE(this.mContext);
        Resources resources = zzu.zzcn().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.create_calendar_title) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.create_calendar_message) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.accept) : "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                Intent intent = zzgq.this.createIntent();
                zzu.zzck().zzb(zzgq.this.mContext, intent);
            }
        });
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.decline) : "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzgq.this.zzas("Operation denied by user.");
            }
        });
        builder.create().show();
    }

    @TargetApi(value=14)
    Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzFR);
        intent.putExtra("eventLocation", this.zzFV);
        intent.putExtra("description", this.zzFU);
        if (this.zzFS > -1L) {
            intent.putExtra("beginTime", this.zzFS);
        }
        if (this.zzFT > -1L) {
            intent.putExtra("endTime", this.zzFT);
        }
        intent.setFlags(0x10000000);
        return intent;
    }
}

