/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.graphics.Point;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.formats.zzg;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdw;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkl;
import com.google.android.gms.internal.zzll;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzir
public class zzk
extends zzdw.zza
implements View.OnClickListener,
View.OnTouchListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object zzail = new Object();
    private final FrameLayout zzbgx;
    private FrameLayout zzaiz;
    private Map<String, WeakReference<View>> zzbgy = new HashMap<String, WeakReference<View>>();
    private zzb zzbgz;
    private zzh zzbft;
    boolean zzbha = false;
    int zzbhb;
    int zzbhc;

    public zzk(FrameLayout frameLayout, FrameLayout frameLayout2) {
        this.zzbgx = frameLayout;
        this.zzaiz = frameLayout2;
        zzu.zzgk().zza((View)this.zzbgx, this);
        zzu.zzgk().zza((View)this.zzbgx, this);
        this.zzbgx.setOnTouchListener((View.OnTouchListener)this);
        this.zzbgx.setOnClickListener((View.OnClickListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzc(String string, zzd zzd2) {
        View view = (View)zze.zzad((zzd)zzd2);
        Object object = this.zzail;
        synchronized (object) {
            if (view == null) {
                this.zzbgy.remove(string);
            } else {
                this.zzbgy.put(string, new WeakReference<View>(view));
                view.setOnTouchListener((View.OnTouchListener)this);
                view.setClickable(true);
                view.setOnClickListener((View.OnClickListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzd zzap(String string) {
        Object object = this.zzail;
        synchronized (object) {
            WeakReference<View> weakReference = this.zzbgy.get(string);
            return zze.zzae(weakReference == null ? null : (View)weakReference.get());
        }
    }

    void zzh(View view) {
        zzh zzh2 = null;
        if (this.zzbft != null && (zzh2 = this.zzbft instanceof zzg ? ((zzg)this.zzbft).zzlc() : this.zzbft) != null) {
            zzh2.zzh(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zze(zzd zzd2) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzh(null);
            Object object2 = zze.zzad((zzd)zzd2);
            if (!(object2 instanceof zzi)) {
                zzkh.zzcy((String)"Not an instance of native engine. This is most likely a transient error");
                return;
            }
            if (this.zzaiz != null) {
                this.zzaiz.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
                this.zzbgx.requestLayout();
            }
            this.zzbha = true;
            final zzi zzi2 = (zzi)object2;
            if (this.zzbft != null && zzdc.zzbcf.get().booleanValue()) {
                this.zzbft.zzb((View)this.zzbgx, this.zzbgy);
            }
            if (this.zzbft instanceof zzg && ((zzg)this.zzbft).zzlb()) {
                ((zzg)this.zzbft).zzc(zzi2);
            } else {
                this.zzbft = zzi2;
                if (zzi2 instanceof zzg) {
                    ((zzg)zzi2).zzc(null);
                }
            }
            if (zzdc.zzbcf.get().booleanValue()) {
                this.zzaiz.setClickable(false);
            }
            this.zzaiz.removeAllViews();
            this.zzbgz = this.zzc(zzi2);
            if (this.zzbgz != null) {
                this.zzbgy.put("1007", new WeakReference<ViewGroup>(this.zzbgz.zzku()));
                this.zzaiz.addView((View)this.zzbgz);
            }
            zzkl.zzclg.post(new Runnable(){

                @Override
                public void run() {
                    zzll zzll2 = zzi2.zzld();
                    if (zzll2 != null && zzk.this.zzaiz != null) {
                        zzk.this.zzaiz.addView(zzll2.getView());
                    }
                }
            });
            zzi2.zza((View)this.zzbgx, this.zzbgy, this, this);
            this.zzh((View)this.zzbgx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClick(View view) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzbft == null) {
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (Map.Entry<String, WeakReference<View>> jSONObject3 : this.zzbgy.entrySet()) {
                View view2 = (View)jSONObject3.getValue().get();
                if (view2 == null) continue;
                Point point = this.zzi(view2);
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("width", this.zzx(view2.getWidth()));
                    jSONObject.put("height", this.zzx(view2.getHeight()));
                    jSONObject.put("x", this.zzx(point.x));
                    jSONObject.put("y", this.zzx(point.y));
                    jSONObject2.put(jSONObject3.getKey(), (Object)jSONObject);
                }
                catch (JSONException jSONException) {
                    String string = String.valueOf(jSONObject3.getKey());
                    zzkh.zzcy((String)(string.length() != 0 ? "Unable to get view rectangle for view ".concat(string) : new String("Unable to get view rectangle for view ")));
                }
            }
            JSONObject jSONObject5 = new JSONObject();
            try {
                jSONObject5.put("x", this.zzx(this.zzbhb));
                jSONObject5.put("y", this.zzx(this.zzbhc));
            }
            catch (JSONException jSONException) {
                zzkh.zzcy((String)"Unable to get click location");
            }
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("width", this.zzx(this.getMeasuredWidth()));
                jSONObject.put("height", this.zzx(this.getMeasuredHeight()));
            }
            catch (JSONException jSONException) {
                zzkh.zzcy((String)"Unable to get native ad view bounding box");
            }
            if (this.zzbgz != null && this.zzbgz.zzku().equals(view)) {
                this.zzbft.zza("1007", jSONObject2, jSONObject5, jSONObject);
            } else {
                this.zzbft.zza(view, this.zzbgy, jSONObject2, jSONObject5, jSONObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGlobalLayout() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzbha) {
                int n = this.getMeasuredWidth();
                int n2 = this.getMeasuredHeight();
                if (n != 0 && n2 != 0 && this.zzaiz != null) {
                    this.zzaiz.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
                    this.zzbha = false;
                }
            }
            if (this.zzbft != null) {
                this.zzbft.zzg((View)this.zzbgx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScrollChanged() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzbft != null) {
                this.zzbft.zzg((View)this.zzbgx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouch(View view, MotionEvent motionEvent) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzbft == null) {
                return false;
            }
            Point point = this.zzc(motionEvent);
            this.zzbhb = point.x;
            this.zzbhc = point.y;
            MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
            motionEvent2.setLocation((float)point.x, (float)point.y);
            this.zzbft.zzb(motionEvent2);
            motionEvent2.recycle();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzaiz != null) {
                this.zzaiz.removeAllViews();
            }
            this.zzaiz = null;
            this.zzbgy = null;
            this.zzbgz = null;
            this.zzbft = null;
        }
    }

    Point zzc(MotionEvent motionEvent) {
        int[] nArray = new int[2];
        this.zzbgx.getLocationOnScreen(nArray);
        float f = motionEvent.getRawX() - (float)nArray[0];
        float f2 = motionEvent.getRawY() - (float)nArray[1];
        return new Point((int)f, (int)f2);
    }

    zzb zzc(zzi zzi2) {
        return zzi2.zza(this);
    }

    int getMeasuredWidth() {
        return this.zzbgx.getMeasuredWidth();
    }

    int getMeasuredHeight() {
        return this.zzbgx.getMeasuredHeight();
    }

    int zzx(int n) {
        return zzm.zziw().zzb(this.zzbft.getContext(), n);
    }

    Point zzi(View view) {
        if (this.zzbgz != null && this.zzbgz.zzku().equals(view)) {
            Point point = new Point();
            this.zzbgx.getGlobalVisibleRect(new Rect(), point);
            Point point2 = new Point();
            view.getGlobalVisibleRect(new Rect(), point2);
            return new Point(point2.x - point.x, point2.y - point.y);
        }
        Point point = new Point();
        view.getGlobalVisibleRect(new Rect(), point);
        return point;
    }
}

