/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzs;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzhm;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkl;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzlm;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Future;

@zzir
public class zzd
extends zzhm.zza
implements com.google.android.gms.ads.internal.overlay.zzu {
    static final int zzbsr = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzbss;
    zzll zzbgj;
    zzc zzbst;
    zzo zzbsu;
    boolean zzbsv = false;
    FrameLayout zzbsw;
    WebChromeClient.CustomViewCallback zzbsx;
    boolean zzbsy = false;
    boolean zzbsz = false;
    zzb zzbta;
    boolean zzbtb = false;
    int zzbtc = 0;
    zzl zzbtd;
    private boolean zzbte;
    private boolean zzbtf = false;
    private boolean zzbtg = true;

    public zzd(Activity activity) {
        this.mActivity = activity;
        this.zzbtd = new zzs();
    }

    public void close() {
        this.zzbtc = 2;
        this.mActivity.finish();
    }

    public void zznw() {
        if (this.zzbss != null && this.zzbsv) {
            this.setRequestedOrientation(this.zzbss.orientation);
        }
        if (this.zzbsw != null) {
            this.mActivity.setContentView((View)this.zzbta);
            this.zzdc();
            this.zzbsw.removeAllViews();
            this.zzbsw = null;
        }
        if (this.zzbsx != null) {
            this.zzbsx.onCustomViewHidden();
            this.zzbsx = null;
        }
        this.zzbsv = false;
    }

    @Override
    public void zznx() {
        this.zzbtc = 1;
        this.mActivity.finish();
    }

    public void onBackPressed() {
        this.zzbtc = 0;
    }

    public boolean zzny() {
        boolean bl;
        this.zzbtc = 0;
        if (this.zzbgj == null) {
            return true;
        }
        boolean bl2 = bl = this.zzbgj.zzow() && this.zzbtd.zzow();
        if (!bl) {
            this.zzbgj.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzbsy = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzbss = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzbss == null) {
                throw new zza("Could not get info for ad overlay.");
            }
            if (this.zzbss.zzaou.zzcnp > 7500000) {
                this.zzbtc = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzbtg = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzbsz = this.zzbss.zzbtz != null ? this.zzbss.zzbtz.zzamc : false;
            if (zzdc.zzbby.get().booleanValue() && this.zzbsz && this.zzbss.zzbtz.zzamh != -1) {
                Future cfr_ignored_0 = (Future)new zzd().zzpz();
            }
            if (bundle == null) {
                if (this.zzbss.zzbtp != null && this.zzbtg) {
                    this.zzbss.zzbtp.zzdz();
                }
                if (this.zzbss.zzbtw != 1 && this.zzbss.zzbto != null) {
                    this.zzbss.zzbto.onAdClicked();
                }
            }
            this.zzbta = new zzb((Context)this.mActivity, this.zzbss.zzbty);
            this.zzbta.setId(1000);
            switch (this.zzbss.zzbtw) {
                case 1: {
                    this.zzaa(false);
                    break;
                }
                case 2: {
                    this.zzbst = new zzc(this.zzbss.zzbtq);
                    this.zzaa(false);
                    break;
                }
                case 3: {
                    this.zzaa(true);
                    break;
                }
                case 4: {
                    if (this.zzbsy) {
                        this.zzbtc = 3;
                        this.mActivity.finish();
                        break;
                    }
                    if (!zzu.zzfn().zza((Context)this.mActivity, this.zzbss.zzbtn, this.zzbss.zzbtv)) {
                        this.zzbtc = 3;
                        this.mActivity.finish();
                    }
                    break;
                }
                default: {
                    throw new zza("Could not determine ad overlay type.");
                }
            }
        }
        catch (zza zza2) {
            zzkh.zzcy((String)zza2.getMessage());
            this.zzbtc = 3;
            this.mActivity.finish();
        }
    }

    public void onRestart() {
    }

    public void onStart() {
    }

    public void onResume() {
        if (this.zzbss != null && this.zzbss.zzbtw == 4) {
            if (this.zzbsy) {
                this.zzbtc = 3;
                this.mActivity.finish();
            } else {
                this.zzbsy = true;
            }
        }
        if (this.zzbss.zzbtp != null) {
            this.zzbss.zzbtp.onResume();
        }
        if (this.zzbgj != null && !this.zzbgj.isDestroyed()) {
            zzu.zzfs().zzk(this.zzbgj);
        } else {
            zzkh.zzcy((String)"The webview does not exit. Ignoring action.");
        }
        this.zzbtd.resume();
    }

    public void onPause() {
        this.zzbtd.pause();
        this.zznw();
        if (this.zzbss.zzbtp != null) {
            this.zzbss.zzbtp.onPause();
        }
        if (!(this.zzbgj == null || this.mActivity.isFinishing() && this.zzbst != null)) {
            zzu.zzfs().zzj(this.zzbgj);
        }
        this.zzoa();
    }

    public void onActivityResult(int n, int n2, Intent intent) {
    }

    public void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzbsy);
    }

    public void onStop() {
        this.zzoa();
    }

    public void onDestroy() {
        if (this.zzbgj != null) {
            this.zzbta.removeView(this.zzbgj.getView());
        }
        this.zzoa();
    }

    public void zzz(boolean bl) {
        int n = bl ? 50 : 32;
        this.zzbsu = new zzo((Context)this.mActivity, n, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzbsu.zza(bl, this.zzbss.zzbtt);
        this.zzbta.addView((View)this.zzbsu, (ViewGroup.LayoutParams)layoutParams);
    }

    public void zzdc() {
        this.zzbte = true;
    }

    public void zza(boolean bl, boolean bl2) {
        if (this.zzbsu != null) {
            this.zzbsu.zza(bl, bl2);
        }
    }

    public void zznz() {
        this.zzbta.removeView((View)this.zzbsu);
        this.zzz(true);
    }

    public void setRequestedOrientation(int n) {
        this.mActivity.setRequestedOrientation(n);
    }

    public void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzbsw = new FrameLayout((Context)this.mActivity);
        this.zzbsw.setBackgroundColor(-16777216);
        this.zzbsw.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzbsw);
        this.zzdc();
        this.zzbsx = customViewCallback;
        this.zzbsv = true;
    }

    protected void zzaa(boolean bl) throws zza {
        com.google.android.gms.ads.internal.zzd zzd2;
        zzm zzm2;
        Window window;
        if (!this.zzbte) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zza("Invalid activity, no window available.");
        }
        if (!this.zzbsz || this.zzbss.zzbtz != null && this.zzbss.zzbtz.zzamd) {
            window.setFlags(1024, 1024);
        }
        boolean bl2 = this.zzbss.zzbtq.zzuk().zzho();
        this.zzbtb = false;
        if (bl2) {
            if (this.zzbss.orientation == zzu.zzfs().zztk()) {
                this.zzbtb = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzbss.orientation == zzu.zzfs().zztl()) {
                this.zzbtb = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl3 = this.zzbtb;
        zzkh.zzcw((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl3).toString());
        this.setRequestedOrientation(this.zzbss.orientation);
        if (zzu.zzfs().zza(window)) {
            zzkh.zzcw((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzbsz) {
            this.zzbta.setBackgroundColor(-16777216);
        } else {
            this.zzbta.setBackgroundColor(zzbsr);
        }
        this.mActivity.setContentView((View)this.zzbta);
        this.zzdc();
        if (bl) {
            this.zzbgj = zzu.zzfr().zza((Context)this.mActivity, this.zzbss.zzbtq.zzdo(), true, bl2, null, this.zzbss.zzaou, null, null, this.zzbss.zzbtq.zzuh());
            this.zzbgj.zzuk().zza(null, null, this.zzbss.zzbtr, this.zzbss.zzbtv, true, this.zzbss.zzbtx, null, this.zzbss.zzbtq.zzuk().zzuy(), null, null);
            this.zzbgj.zzuk().zza(new zzlm.zza(){

                @Override
                public void zza(zzll zzll2, boolean bl) {
                    zzll2.zzoc();
                }
            });
            if (this.zzbss.url != null) {
                this.zzbgj.loadUrl(this.zzbss.url);
            } else if (this.zzbss.zzbtu != null) {
                this.zzbgj.loadDataWithBaseURL(this.zzbss.zzbts, this.zzbss.zzbtu, "text/html", "UTF-8", null);
            } else {
                throw new zza("No URL or HTML to display in ad overlay.");
            }
            if (this.zzbss.zzbtq != null) {
                this.zzbss.zzbtq.zzc(this);
            }
        } else {
            this.zzbgj = this.zzbss.zzbtq;
            this.zzbgj.setContext((Context)this.mActivity);
        }
        this.zzbgj.zzb(this);
        ViewParent viewParent = this.zzbgj.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzbgj.getView());
        }
        if (this.zzbsz) {
            this.zzbgj.setBackgroundColor(zzbsr);
        }
        this.zzbta.addView(this.zzbgj.getView(), -1, -1);
        if (!bl && !this.zzbtb) {
            this.zzoc();
        }
        this.zzz(bl2);
        if (this.zzbgj.zzul()) {
            this.zza(bl2, true);
        }
        zzm zzm3 = zzm2 = (zzd2 = this.zzbgj.zzuh()) != null ? zzd2.zzakl : null;
        if (zzm2 != null) {
            this.zzbtd = zzm2.zza(this.mActivity, this.zzbgj, this.zzbta);
        } else {
            zzkh.zzcy((String)"Appstreaming controller is null.");
        }
    }

    protected void zzoa() {
        if (!this.mActivity.isFinishing() || this.zzbtf) {
            return;
        }
        this.zzbtf = true;
        if (this.zzbgj != null) {
            this.zzaf(this.zzbtc);
            this.zzbta.removeView(this.zzbgj.getView());
            if (this.zzbst != null) {
                this.zzbgj.setContext(this.zzbst.zzagf);
                this.zzbgj.zzah(false);
                this.zzbst.zzbtk.addView(this.zzbgj.getView(), this.zzbst.index, this.zzbst.zzbtj);
                this.zzbst = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzbgj.setContext(this.mActivity.getApplicationContext());
            }
            this.zzbgj = null;
        }
        if (this.zzbss != null && this.zzbss.zzbtp != null) {
            this.zzbss.zzbtp.zzdy();
        }
        this.zzbtd.destroy();
    }

    public void zzob() {
        if (this.zzbtb) {
            this.zzbtb = false;
            this.zzoc();
        }
    }

    protected void zzoc() {
        this.zzbgj.zzoc();
    }

    protected void zzaf(int n) {
        this.zzbgj.zzaf(n);
    }

    public void zzf(zzll zzll2, Map<String, String> map) {
        this.zzbtd.zzf(zzll2, map);
    }

    public void zzod() {
        this.zzbta.disable();
    }

    @zzir
    private class zzd
    extends zzkg {
        private zzd() {
        }

        @Override
        public void zzew() {
            Bitmap bitmap = zzu.zzgh().zza(zzd.this.zzbss.zzbtz.zzamh);
            if (bitmap != null) {
                final Drawable drawable = zzu.zzfs().zza((Context)zzd.this.mActivity, bitmap, zzd.this.zzbss.zzbtz.zzamf, zzd.this.zzbss.zzbtz.zzamg);
                zzkl.zzclg.post(new Runnable(){

                    @Override
                    public void run() {
                        zzd.this.mActivity.getWindow().setBackgroundDrawable(drawable);
                    }
                });
            }
        }

        @Override
        public void onStop() {
        }
    }

    @zzir
    static class zzb
    extends RelativeLayout {
        zzko zzaqd;
        boolean zzbti;

        public zzb(Context context, String string) {
            super(context);
            this.zzaqd = new zzko(context, string);
        }

        public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
            if (!this.zzbti) {
                this.zzaqd.zze(motionEvent);
            }
            return false;
        }

        void disable() {
            this.zzbti = true;
        }
    }

    @zzir
    public static class zzc {
        public final int index;
        public final ViewGroup.LayoutParams zzbtj;
        public final ViewGroup zzbtk;
        public final Context zzagf;

        public zzc(zzll zzll2) throws zza {
            this.zzbtj = zzll2.getLayoutParams();
            ViewParent viewParent = zzll2.getParent();
            this.zzagf = zzll2.zzug();
            if (viewParent == null || !(viewParent instanceof ViewGroup)) {
                throw new zza("Could not get the parent of the WebView for an overlay.");
            }
            this.zzbtk = (ViewGroup)viewParent;
            this.index = this.zzbtk.indexOfChild(zzll2.getView());
            this.zzbtk.removeView(zzll2.getView());
            zzll2.zzah(true);
        }
    }

    @zzir
    private static final class zza
    extends Exception {
        public zza(String string) {
            super(string);
        }
    }
}

