/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.ads.internal.overlay.zzv;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzir
@TargetApi(value=14)
public class zzw
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzv.zza {
    private static final float[] zzbuv = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzv zzbuw;
    private final float[] zzbur;
    private final float[] zzbux;
    private final float[] zzbuy;
    private final float[] zzbuz;
    private final float[] zzbva;
    private final float[] zzbvb;
    private final float[] zzbvc;
    private float zzbvd;
    private float zzbve;
    private float zzbvf;
    private int zzaif;
    private int zzaie;
    private SurfaceTexture zzbvg;
    private SurfaceTexture zzbvh;
    private int zzbvi;
    private int zzbvj;
    private int zzbvk;
    private FloatBuffer zzbvl = ByteBuffer.allocateDirect(zzbuv.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzbvm;
    private final Object zzbvn;
    private EGL10 zzbvo;
    private EGLDisplay zzbvp;
    private EGLContext zzbvq;
    private EGLSurface zzbvr;
    private volatile boolean zzbvs;
    private volatile boolean zzbvt;

    zzw(Context context) {
        super("SphericalVideoProcessor");
        this.zzbvl.put(zzbuv).position(0);
        this.zzbur = new float[9];
        this.zzbux = new float[9];
        this.zzbuy = new float[9];
        this.zzbuz = new float[9];
        this.zzbva = new float[9];
        this.zzbvb = new float[9];
        this.zzbvc = new float[9];
        this.zzbvd = Float.NaN;
        this.zzbuw = new zzv(context);
        this.zzbuw.zza(this);
        this.zzbvm = new CountDownLatch(1);
        this.zzbvn = new Object();
    }

    void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzaie = n;
        this.zzaif = n2;
        this.zzbvh = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzg(int n, int n2) {
        Object object = this.zzbvn;
        synchronized (object) {
            this.zzaie = n;
            this.zzaif = n2;
            this.zzbvs = true;
            this.zzbvn.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzoy() {
        Object object = this.zzbvn;
        synchronized (object) {
            this.zzbvt = true;
            this.zzbvh = null;
            this.zzbvn.notifyAll();
        }
    }

    public SurfaceTexture zzoz() {
        if (this.zzbvh == null) {
            return null;
        }
        try {
            this.zzbvm.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.zzbvg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzbvk;
        Object object = this.zzbvn;
        synchronized (object) {
            this.zzbvn.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzob() {
        Object object = this.zzbvn;
        synchronized (object) {
            this.zzbvn.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl;
        if (this.zzbvh == null) {
            zzkh.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzbvm.countDown();
            return;
        }
        boolean bl2 = this.zzpe();
        int n = this.zzpc();
        boolean bl3 = bl = this.zzbvi != 0;
        if (!bl2 || !bl) {
            String string = GLUtils.getEGLErrorString((int)this.zzbvo.eglGetError());
            String string2 = String.valueOf(string);
            String string3 = string2.length() != 0 ? "EGL initialization failed: ".concat(string2) : new String("EGL initialization failed: ");
            zzkh.e((String)string3);
            zzu.zzft().zzb(new Throwable(string3), true);
            this.zzpi();
            this.zzbvm.countDown();
            return;
        }
        this.zzbvg = new SurfaceTexture(n);
        this.zzbvg.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzbvm.countDown();
        this.zzbuw.start();
        try {
            this.zzbvs = true;
            while (!this.zzbvt) {
                this.zzpa();
                if (this.zzbvs) {
                    this.zzpb();
                    this.zzbvs = false;
                }
                try {
                    Object object = this.zzbvn;
                    synchronized (object) {
                        if (!this.zzbvt && !this.zzbvs && this.zzbvk == 0) {
                            this.zzbvn.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            zzkh.zzcy((String)"SphericalVideoProcessor halted unexpectedly.");
        }
        catch (Throwable throwable) {
            zzkh.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzu.zzft().zzb(throwable, true);
        }
        finally {
            this.zzbuw.stop();
            this.zzbvg.setOnFrameAvailableListener(null);
            this.zzbvg = null;
            this.zzpi();
        }
    }

    void zzpa() {
        while (this.zzbvk > 0) {
            this.zzbvg.updateTexImage();
            --this.zzbvk;
        }
        if (this.zzbuw.zzb(this.zzbur)) {
            if (Float.isNaN(this.zzbvd)) {
                this.zzbvd = -this.zzc(this.zzbur);
            }
            this.zzb(this.zzbvb, this.zzbvd + this.zzbve);
        } else {
            this.zza(this.zzbur, -1.5707964f);
            this.zzb(this.zzbvb, this.zzbve);
        }
        this.zza(this.zzbux, 1.5707964f);
        this.zza(this.zzbuy, this.zzbvb, this.zzbux);
        this.zza(this.zzbuz, this.zzbur, this.zzbuy);
        this.zza(this.zzbva, this.zzbvf);
        this.zza(this.zzbvc, this.zzbva, this.zzbuz);
        GLES20.glUniformMatrix3fv((int)this.zzbvj, (int)1, (boolean)false, (float[])this.zzbvc, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.zzby("drawArrays");
        GLES20.glFinish();
        this.zzbvo.eglSwapBuffers(this.zzbvp, this.zzbvr);
    }

    private float zzc(float[] fArray) {
        float[] fArray2 = this.zza(fArray, new float[]{0.0f, 1.0f, 0.0f});
        return (float)Math.atan2(fArray2[1], fArray2[0]) - 1.5707964f;
    }

    void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzaie > this.zzaif) {
            f4 = 1.7453293f * f / (float)this.zzaie;
            f3 = 1.7453293f * f2 / (float)this.zzaie;
        } else {
            f4 = 1.7453293f * f / (float)this.zzaif;
            f3 = 1.7453293f * f2 / (float)this.zzaif;
        }
        this.zzbve -= f4;
        this.zzbvf -= f3;
        if (this.zzbvf < -1.5707964f) {
            this.zzbvf = -1.5707964f;
        }
        if (this.zzbvf > 1.5707964f) {
            this.zzbvf = 1.5707964f;
        }
    }

    private void zzpb() {
        GLES20.glViewport((int)0, (int)0, (int)this.zzaie, (int)this.zzaif);
        this.zzby("viewport");
        int n = GLES20.glGetUniformLocation((int)this.zzbvi, (String)"uFOVx");
        int n2 = GLES20.glGetUniformLocation((int)this.zzbvi, (String)"uFOVy");
        if (this.zzaie > this.zzaif) {
            GLES20.glUniform1f((int)n, (float)0.87266463f);
            GLES20.glUniform1f((int)n2, (float)(0.87266463f * (float)this.zzaif / (float)this.zzaie));
        } else {
            GLES20.glUniform1f((int)n, (float)(0.87266463f * (float)this.zzaie / (float)this.zzaif));
            GLES20.glUniform1f((int)n2, (float)0.87266463f);
        }
    }

    private float[] zza(float[] fArray, float[] fArray2) {
        return new float[]{fArray[0] * fArray2[0] + fArray[1] * fArray2[1] + fArray[2] * fArray2[2], fArray[3] * fArray2[0] + fArray[4] * fArray2[1] + fArray[5] * fArray2[2], fArray[6] * fArray2[0] + fArray[7] * fArray2[1] + fArray[8] * fArray2[2]};
    }

    private void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    int zzpc() {
        this.zzbvi = this.zzpd();
        GLES20.glUseProgram((int)this.zzbvi);
        this.zzby("useProgram");
        int n = GLES20.glGetAttribLocation((int)this.zzbvi, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)this.zzbvl);
        this.zzby("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n);
        this.zzby("enableVertexAttribArray");
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        this.zzby("genTextures");
        int n2 = nArray[0];
        GLES20.glBindTexture((int)36197, (int)n2);
        this.zzby("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        this.zzby("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        this.zzby("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        this.zzby("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        this.zzby("texParameteri");
        this.zzbvj = GLES20.glGetUniformLocation((int)this.zzbvi, (String)"uVMat");
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)this.zzbvj, (int)1, (boolean)false, (float[])fArray, (int)0);
        return n2;
    }

    private int zzpd() {
        int n = this.zzc(35633, this.zzpg());
        if (n == 0) {
            return 0;
        }
        int n2 = this.zzc(35632, this.zzph());
        if (n2 == 0) {
            return 0;
        }
        int n3 = GLES20.glCreateProgram();
        this.zzby("createProgram");
        if (n3 != 0) {
            GLES20.glAttachShader((int)n3, (int)n);
            this.zzby("attachShader");
            GLES20.glAttachShader((int)n3, (int)n2);
            this.zzby("attachShader");
            GLES20.glLinkProgram((int)n3);
            this.zzby("linkProgram");
            int[] nArray = new int[1];
            GLES20.glGetProgramiv((int)n3, (int)35714, (int[])nArray, (int)0);
            this.zzby("getProgramiv");
            if (nArray[0] != 1) {
                Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n3));
                GLES20.glDeleteProgram((int)n3);
                this.zzby("deleteProgram");
                n3 = 0;
            } else {
                GLES20.glValidateProgram((int)n3);
                this.zzby("validateProgram");
            }
        }
        return n3;
    }

    private int zzc(int n, String string) {
        int n2 = GLES20.glCreateShader((int)n);
        this.zzby("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string);
            this.zzby("shaderSource");
            GLES20.glCompileShader((int)n2);
            this.zzby("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            this.zzby("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                this.zzby("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    boolean zzpe() {
        this.zzbvo = (EGL10)EGLContext.getEGL();
        this.zzbvp = this.zzbvo.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.zzbvp == EGL10.EGL_NO_DISPLAY) {
            return false;
        }
        int[] nArray = new int[2];
        if (!this.zzbvo.eglInitialize(this.zzbvp, nArray)) {
            return false;
        }
        EGLConfig eGLConfig = this.zzpf();
        if (eGLConfig == null) {
            return false;
        }
        int[] nArray2 = new int[]{12440, 2, 12344};
        this.zzbvq = this.zzbvo.eglCreateContext(this.zzbvp, eGLConfig, EGL10.EGL_NO_CONTEXT, nArray2);
        if (this.zzbvq == null || this.zzbvq == EGL10.EGL_NO_CONTEXT) {
            return false;
        }
        this.zzbvr = this.zzbvo.eglCreateWindowSurface(this.zzbvp, eGLConfig, (Object)this.zzbvh, null);
        if (this.zzbvr == null || this.zzbvr == EGL10.EGL_NO_SURFACE) {
            return false;
        }
        return this.zzbvo.eglMakeCurrent(this.zzbvp, this.zzbvr, this.zzbvr, this.zzbvq);
    }

    @Nullable
    private EGLConfig zzpf() {
        int[] nArray = new int[1];
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
        if (!this.zzbvo.eglChooseConfig(this.zzbvp, nArray2, eGLConfigArray, 1, nArray)) {
            return null;
        }
        if (nArray[0] > 0) {
            return eGLConfigArray[0];
        }
        return null;
    }

    private String zzpg() {
        zzcy<String> zzcy2 = zzdc.zzbak;
        if (!zzcy2.get().equals(zzcy2.zzjw())) {
            return zzcy2.get();
        }
        return "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
    }

    private String zzph() {
        zzcy<String> zzcy2 = zzdc.zzbal;
        if (!zzcy2.get().equals(zzcy2.zzjw())) {
            return zzcy2.get();
        }
        return "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
    }

    boolean zzpi() {
        boolean bl = false;
        if (this.zzbvr != null && this.zzbvr != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzbvo.eglMakeCurrent(this.zzbvp, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            bl |= this.zzbvo.eglDestroySurface(this.zzbvp, this.zzbvr);
            this.zzbvr = null;
        }
        if (this.zzbvq != null) {
            bl |= this.zzbvo.eglDestroyContext(this.zzbvp, this.zzbvq);
            this.zzbvq = null;
        }
        if (this.zzbvp != null) {
            bl |= this.zzbvo.eglTerminate(this.zzbvp);
            this.zzbvp = null;
        }
        return bl;
    }

    private void zzby(String string) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string).length()).append(string).append(": glError ").append(n).toString());
        }
    }
}

