/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.purchase;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import com.google.android.gms.ads.internal.purchase.zzb;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzg;
import com.google.android.gms.ads.internal.purchase.zzh;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzhv;
import com.google.android.gms.internal.zzhw;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@zzir
public class zzc
extends zzkg
implements ServiceConnection {
    private final Object zzail = new Object();
    private boolean zzbwv = false;
    private Context mContext;
    private zzhw zzblh;
    private zzb zzbww;
    private zzh zzbwx;
    private List<zzf> zzbwy = null;
    private zzk zzbwz;

    public zzc(Context context, zzhw zzhw2, zzk zzk2) {
        this(context, zzhw2, zzk2, new zzb(context), zzh.zzs(context.getApplicationContext()));
    }

    zzc(Context context, zzhw zzhw2, zzk zzk2, zzb zzb2, zzh zzh2) {
        this.mContext = context;
        this.zzblh = zzhw2;
        this.zzbwz = zzk2;
        this.zzbww = zzb2;
        this.zzbwx = zzh2;
        this.zzbwy = this.zzbwx.zzg(10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzew() {
        Object object = this.zzail;
        synchronized (object) {
            Intent intent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
            intent.setPackage("com.android.vending");
            com.google.android.gms.common.stats.zzb.zzaut().zza(this.mContext, intent, (ServiceConnection)this, 1);
            this.zze(SystemClock.elapsedRealtime());
            com.google.android.gms.common.stats.zzb.zzaut().zza(this.mContext, (ServiceConnection)this);
            this.zzbww.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzail;
        synchronized (object) {
            com.google.android.gms.common.stats.zzb.zzaut().zza(this.mContext, (ServiceConnection)this);
            this.zzbww.destroy();
        }
    }

    public void onServiceDisconnected(ComponentName componentName) {
        zzkh.zzcx((String)"In-app billing service disconnected.");
        this.zzbww.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzbww.zzas(iBinder);
            this.zzps();
            this.zzbwv = true;
            this.zzail.notify();
        }
    }

    protected void zzps() {
        int n;
        Bundle bundle;
        if (this.zzbwy.isEmpty()) {
            return;
        }
        HashMap<String, zzf> hashMap = new HashMap<String, zzf>();
        for (zzf object2 : this.zzbwy) {
            hashMap.put(object2.zzbxl, object2);
        }
        Object object3 = null;
        while ((bundle = this.zzbww.zzn(this.mContext.getPackageName(), (String)object3)) != null && (n = zzu.zzga().zze(bundle)) == 0) {
            ArrayList arrayList = bundle.getStringArrayList("INAPP_PURCHASE_ITEM_LIST");
            ArrayList arrayList2 = bundle.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
            ArrayList arrayList3 = bundle.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
            object3 = bundle.getString("INAPP_CONTINUATION_TOKEN");
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!hashMap.containsKey(arrayList.get(i))) continue;
                String string = (String)arrayList.get(i);
                String string2 = (String)arrayList2.get(i);
                String string3 = (String)arrayList3.get(i);
                zzf zzf2 = (zzf)hashMap.get(string);
                String string4 = zzu.zzga().zzbz(string2);
                if (!zzf2.zzbxk.equals(string4)) continue;
                this.zza(zzf2, string2, string3);
                hashMap.remove(string);
            }
            if (object3 != null && !hashMap.isEmpty()) continue;
        }
        for (String string : hashMap.keySet()) {
            this.zzbwx.zza((zzf)hashMap.get(string));
        }
    }

    protected void zza(final zzf zzf2, String string, String string2) {
        final Intent intent = new Intent();
        zzu.zzga();
        intent.putExtra("RESPONSE_CODE", 0);
        zzu.zzga();
        intent.putExtra("INAPP_PURCHASE_DATA", string);
        zzu.zzga();
        intent.putExtra("INAPP_DATA_SIGNATURE", string2);
        zzkl.zzclg.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (zzc.this.zzbwz.zza(zzf2.zzbxk, -1, intent)) {
                        zzc.this.zzblh.zza((zzhv)new zzg(zzc.this.mContext, zzf2.zzbxl, true, -1, intent, zzf2));
                    } else {
                        zzc.this.zzblh.zza((zzhv)new zzg(zzc.this.mContext, zzf2.zzbxl, false, -1, intent, zzf2));
                    }
                }
                catch (RemoteException remoteException) {
                    zzkh.zzcy((String)"Fail to verify and dispatch pending transaction");
                }
            }
        });
    }

    private void zze(long l) {
        do {
            if (this.zzf(l)) continue;
            zzkh.v("Timeout waiting for pending transaction to be processed.");
        } while (!this.zzbwv);
    }

    private boolean zzf(long l) {
        long l2 = 60000L - (SystemClock.elapsedRealtime() - l);
        if (l2 <= 0L) {
            return false;
        }
        try {
            this.zzail.wait(l2);
        }
        catch (InterruptedException interruptedException) {
            zzkh.zzcy((String)"waitWithTimeout_lock interrupted");
        }
        return true;
    }
}

