/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.request.zze;
import com.google.android.gms.ads.internal.request.zzg;
import com.google.android.gms.ads.internal.request.zzk;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zzit;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzle;

@zzir
public abstract class zzd
implements zzc.zza,
zzkn<Void> {
    private final zzle<AdRequestInfoParcel> zzcan;
    private final zzc.zza zzcao;
    private final Object zzail = new Object();

    public zzd(zzle<AdRequestInfoParcel> zzle2, zzc.zza zza2) {
        this.zzcan = zzle2;
        this.zzcao = zza2;
    }

    public abstract void zzqx();

    public abstract zzk zzqy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcao.zzb(adResponseParcel);
            this.zzqx();
        }
    }

    public Void zzpw() {
        final zzk zzk2 = this.zzqy();
        if (zzk2 == null) {
            this.zzcao.zzb(new AdResponseParcel(0));
            this.zzqx();
            return null;
        }
        this.zzcan.zza(new zzle.zzc<AdRequestInfoParcel>(){

            public void zzc(AdRequestInfoParcel adRequestInfoParcel) {
                if (!zzd.this.zza(zzk2, adRequestInfoParcel)) {
                    zzd.this.zzqx();
                }
            }

            @Override
            public /* synthetic */ void zzd(Object object) {
                this.zzc((AdRequestInfoParcel)((Object)object));
            }
        }, new zzle.zza(){

            @Override
            public void run() {
                zzd.this.zzqx();
            }
        });
        return null;
    }

    @Override
    public void cancel() {
        this.zzqx();
    }

    boolean zza(zzk zzk2, AdRequestInfoParcel adRequestInfoParcel) {
        try {
            zzk2.zza(adRequestInfoParcel, new zzg(this));
            return true;
        }
        catch (RemoteException remoteException) {
            zzkh.zzd((String)"Could not fetch ad response from ad request service.", (Throwable)remoteException);
            zzu.zzft().zzb(remoteException, true);
        }
        catch (NullPointerException nullPointerException) {
            zzkh.zzd((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)nullPointerException);
            zzu.zzft().zzb(nullPointerException, true);
        }
        catch (SecurityException securityException) {
            zzkh.zzd((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)securityException);
            zzu.zzft().zzb(securityException, true);
        }
        catch (Throwable throwable) {
            zzkh.zzd((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)throwable);
            zzu.zzft().zzb(throwable, true);
        }
        this.zzcao.zzb(new AdResponseParcel(0));
        return false;
    }

    @Override
    public /* synthetic */ Object zzpz() {
        return this.zzpw();
    }

    @zzir
    public static class zzb
    extends zzd
    implements zzd.zzb,
    zzd.zzc {
        private Context mContext;
        private VersionInfoParcel zzalm;
        private zzle<AdRequestInfoParcel> zzcan;
        private final zzc.zza zzcao;
        private final Object zzail = new Object();
        protected zze zzcar;
        private boolean zzcas;

        public zzb(Context context, VersionInfoParcel versionInfoParcel, zzle<AdRequestInfoParcel> zzle2, zzc.zza zza2) {
            super(zzle2, zza2);
            Looper looper;
            this.mContext = context;
            this.zzalm = versionInfoParcel;
            this.zzcan = zzle2;
            this.zzcao = zza2;
            if (zzdc.zzayw.get().booleanValue()) {
                this.zzcas = true;
                looper = zzu.zzgc().zztr();
            } else {
                looper = context.getMainLooper();
            }
            this.zzcar = new zze(context, looper, this, this, this.zzalm.zzcnp);
            this.connect();
        }

        protected void connect() {
            this.zzcar.zzart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public zzk zzqy() {
            Object object = this.zzail;
            synchronized (object) {
                try {
                    return this.zzcar.zzrc();
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzqx() {
            Object object = this.zzail;
            synchronized (object) {
                if (this.zzcar.isConnected() || this.zzcar.isConnecting()) {
                    this.zzcar.disconnect();
                }
                Binder.flushPendingCommands();
                if (this.zzcas) {
                    zzu.zzgc().zzts();
                    this.zzcas = false;
                }
            }
        }

        zzkn zzqz() {
            return new zza(this.mContext, this.zzcan, this.zzcao);
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzkh.zzcw((String)"Cannot connect to remote service, fallback to local instance.");
            zzkn zzkn2 = this.zzqz();
            zzkn2.zzpz();
            Bundle bundle = new Bundle();
            bundle.putString("action", "gms_connection_failed_fallback_to_local");
            zzu.zzfq().zzb(this.mContext, this.zzalm.zzcs, "gmob-apps", bundle, true);
        }

        public void onConnected(Bundle bundle) {
            Void cfr_ignored_0 = (Void)((zzd)this).zzpz();
        }

        public void onConnectionSuspended(int n) {
            zzkh.zzcw((String)"Disconnected from remote ad request service.");
        }

        @Override
        public /* synthetic */ Object zzpz() {
            return super.zzpw();
        }
    }

    @zzir
    public static final class zza
    extends zzd {
        private final Context mContext;

        public zza(Context context, zzle<AdRequestInfoParcel> zzle2, zzc.zza zza2) {
            super(zzle2, zza2);
            this.mContext = context;
        }

        @Override
        public zzk zzqy() {
            zzcv zzcv2 = new zzcv(zzdc.zzaxw.get());
            return zzit.zza(this.mContext, zzcv2, zzis.zzrg());
        }

        @Override
        public void zzqx() {
        }

        @Override
        public /* synthetic */ Object zzpz() {
            return super.zzpw();
        }
    }
}

