/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import com.google.android.gms.ads.internal.formats.zzd;
import com.google.android.gms.ads.internal.formats.zze;
import com.google.android.gms.ads.internal.zzf;
import com.google.android.gms.internal.zzdu;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzjy;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzlm;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzir
public class zzn {
    @Nullable
    public static View zzf(@Nullable zzjy zzjy2) {
        if (zzjy2 == null) {
            zzkh.e((String)"AdState is null");
            return null;
        }
        if (zzn.zzg(zzjy2) && zzjy2.zzbtq != null) {
            return zzjy2.zzbtq.getView();
        }
        try {
            com.google.android.gms.dynamic.zzd zzd2;
            com.google.android.gms.dynamic.zzd zzd3 = zzd2 = zzjy2.zzbos != null ? zzjy2.zzbos.getView() : null;
            if (zzd2 == null) {
                zzkh.zzcy((String)"View in mediation adapter is null.");
                return null;
            }
            return (View)com.google.android.gms.dynamic.zze.zzad((com.google.android.gms.dynamic.zzd)zzd2);
        }
        catch (RemoteException remoteException) {
            zzkh.zzd((String)"Could not get View from mediation adapter.", (Throwable)remoteException);
            return null;
        }
    }

    public static void zza(@Nullable zzjy zzjy2, zzf.zza zza2) {
        if (zzjy2 != null && zzn.zzg(zzjy2)) {
            View view;
            zzll zzll2 = zzjy2.zzbtq;
            View view2 = view = zzll2 != null ? zzll2.getView() : null;
            if (view == null) {
                zzkh.zzcy((String)"AdWebView is null");
                return;
            }
            try {
                zzgs zzgs2;
                List<String> list;
                List<String> list2 = list = zzjy2.zzbor != null ? zzjy2.zzbor.zzbnm : null;
                if (list == null || list.isEmpty()) {
                    zzkh.zzcy((String)"No template ids present in mediation response");
                    return;
                }
                zzgr zzgr2 = zzjy2.zzbos != null ? zzjy2.zzbos.zzmq() : null;
                zzgs zzgs3 = zzgs2 = zzjy2.zzbos != null ? zzjy2.zzbos.zzmr() : null;
                if (list.contains("2") && zzgr2 != null) {
                    zzgr2.zzl(com.google.android.gms.dynamic.zze.zzae((Object)view));
                    if (!zzgr2.getOverrideImpressionRecording()) {
                        zzgr2.recordImpression();
                    }
                    zzll2.zzuk().zza("/nativeExpressViewClicked", zzn.zza(zzgr2, null, zza2));
                } else if (list.contains("1") && zzgs2 != null) {
                    zzgs2.zzl(com.google.android.gms.dynamic.zze.zzae((Object)view));
                    if (!zzgs2.getOverrideImpressionRecording()) {
                        zzgs2.recordImpression();
                    }
                    zzll2.zzuk().zza("/nativeExpressViewClicked", zzn.zza(null, zzgs2, zza2));
                } else {
                    zzkh.zzcy((String)"No matching template id and mapper");
                }
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Error occurred while recording impression and registering for clicks", (Throwable)remoteException);
                return;
            }
        }
    }

    public static boolean zza(zzll zzll2, zzgi zzgi2, CountDownLatch countDownLatch) {
        boolean bl = false;
        try {
            bl = zzn.zzb(zzll2, zzgi2, countDownLatch);
        }
        catch (RemoteException remoteException) {
            zzkh.zzd((String)"Unable to invoke load assets", (Throwable)remoteException);
        }
        catch (RuntimeException runtimeException) {
            countDownLatch.countDown();
            throw runtimeException;
        }
        if (!bl) {
            countDownLatch.countDown();
        }
        return bl;
    }

    private static boolean zzb(zzll zzll2, zzgi zzgi2, CountDownLatch countDownLatch) throws RemoteException {
        Object object;
        View view = zzll2.getView();
        if (view == null) {
            zzkh.zzcy((String)"AdWebView is null");
            return false;
        }
        view.setVisibility(4);
        List<String> list = zzgi2.zzbor.zzbnm;
        if (list == null || list.isEmpty()) {
            zzkh.zzcy((String)"No template ids present in mediation response");
            return false;
        }
        zzn.zza(zzll2, countDownLatch);
        zzgr zzgr2 = zzgi2.zzbos.zzmq();
        zzgs zzgs2 = zzgi2.zzbos.zzmr();
        if (list.contains("2") && zzgr2 != null) {
            object = zzn.zza(zzgr2);
            zzn.zza(zzll2, object, zzgi2.zzbor.zzbnl);
        } else if (list.contains("1") && zzgs2 != null) {
            object = zzn.zza(zzgs2);
            zzn.zza(zzll2, (zze)object, zzgi2.zzbor.zzbnl);
        } else {
            zzkh.zzcy((String)"No matching template id and mapper");
            return false;
        }
        object = zzgi2.zzbor.zzbnj;
        String string = zzgi2.zzbor.zzbnk;
        if (string != null) {
            zzll2.loadDataWithBaseURL(string, (String)object, "text/html", "UTF-8", null);
        } else {
            zzll2.loadData((String)object, "text/html", "UTF-8");
        }
        return true;
    }

    public static boolean zzg(@Nullable zzjy zzjy2) {
        return zzjy2 != null && zzjy2.zzccc && zzjy2.zzbor != null && zzjy2.zzbor.zzbnj != null;
    }

    private static zzd zza(zzgr zzgr2) throws RemoteException {
        return new zzd(zzgr2.getHeadline(), zzgr2.getImages(), zzgr2.getBody(), zzgr2.zzkw(), zzgr2.getCallToAction(), zzgr2.getStarRating(), zzgr2.getStore(), zzgr2.getPrice(), null, zzgr2.getExtras());
    }

    private static zze zza(zzgs zzgs2) throws RemoteException {
        return new zze(zzgs2.getHeadline(), zzgs2.getImages(), zzgs2.getBody(), zzgs2.zzla(), zzgs2.getCallToAction(), zzgs2.getAdvertiser(), null, zzgs2.getExtras());
    }

    private static void zza(final zzll zzll2, final zzd zzd2, final String string) {
        zzll2.zzuk().zza(new zzlm.zza(){

            @Override
            public void zza(zzll zzll22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zzd2.getHeadline());
                    jSONObject.put("body", (Object)zzd2.getBody());
                    jSONObject.put("call_to_action", (Object)zzd2.getCallToAction());
                    jSONObject.put("price", (Object)zzd2.getPrice());
                    jSONObject.put("star_rating", (Object)String.valueOf(zzd2.getStarRating()));
                    jSONObject.put("store", (Object)zzd2.getStore());
                    jSONObject.put("icon", (Object)zzn.zza(zzd2.zzkw()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zzd2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzdu zzdu2 = zzn.zze(e);
                            jSONArray.put((Object)zzn.zza(zzdu2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzn.zza(zzd2.getExtras(), string));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"2");
                    zzll2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzkh.zzd((String)"Exception occurred when loading assets", (Throwable)jSONException);
                }
            }
        });
    }

    private static void zza(final zzll zzll2, final zze zze2, final String string) {
        zzll2.zzuk().zza(new zzlm.zza(){

            @Override
            public void zza(zzll zzll22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zze2.getHeadline());
                    jSONObject.put("body", (Object)zze2.getBody());
                    jSONObject.put("call_to_action", (Object)zze2.getCallToAction());
                    jSONObject.put("advertiser", (Object)zze2.getAdvertiser());
                    jSONObject.put("logo", (Object)zzn.zza(zze2.zzla()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zze2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzdu zzdu2 = zzn.zze(e);
                            jSONArray.put((Object)zzn.zza(zzdu2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzn.zza(zze2.getExtras(), string));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"1");
                    zzll2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzkh.zzd((String)"Exception occurred when loading assets", (Throwable)jSONException);
                }
            }
        });
    }

    private static void zza(zzll zzll2, CountDownLatch countDownLatch) {
        zzll2.zzuk().zza("/nativeExpressAssetsLoaded", zzn.zza(countDownLatch));
        zzll2.zzuk().zza("/nativeExpressAssetsLoadingFailed", zzn.zzb(countDownLatch));
    }

    static zzet zza(final CountDownLatch countDownLatch) {
        return new zzet(){

            @Override
            public void zza(zzll zzll2, Map<String, String> map) {
                countDownLatch.countDown();
                View view = zzll2.getView();
                if (view == null) {
                    return;
                }
                view.setVisibility(0);
            }
        };
    }

    static zzet zzb(final CountDownLatch countDownLatch) {
        return new zzet(){

            @Override
            public void zza(zzll zzll2, Map<String, String> map) {
                zzkh.zzcy((String)"Adapter returned an ad, but assets substitution failed");
                countDownLatch.countDown();
                zzll2.destroy();
            }
        };
    }

    static zzet zza(final @Nullable zzgr zzgr2, final @Nullable zzgs zzgs2, final zzf.zza zza2) {
        return new zzet(){

            @Override
            public void zza(zzll zzll2, Map<String, String> map) {
                View view = zzll2.getView();
                if (view == null) {
                    return;
                }
                try {
                    if (zzgr2 != null) {
                        if (!zzgr2.getOverrideClickHandling()) {
                            zzgr2.zzk(com.google.android.gms.dynamic.zze.zzae((Object)view));
                            zza2.onClick();
                        } else {
                            zzn.zza(zzll2);
                        }
                    } else if (zzgs2 != null) {
                        if (!zzgs2.getOverrideClickHandling()) {
                            zzgs2.zzk(com.google.android.gms.dynamic.zze.zzae((Object)view));
                            zza2.onClick();
                        } else {
                            zzn.zza(zzll2);
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    zzkh.zzd((String)"Unable to call handleClick on mapper", (Throwable)remoteException);
                }
            }
        };
    }

    private static void zza(zzll zzll2) {
        View.OnClickListener onClickListener = zzll2.zzux();
        if (onClickListener != null) {
            onClickListener.onClick(zzll2.getView());
        }
    }

    private static JSONObject zza(Bundle bundle, String string) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (bundle == null || TextUtils.isEmpty((CharSequence)string)) {
            return jSONObject;
        }
        JSONObject jSONObject2 = new JSONObject(string);
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            Object object;
            String string2 = (String)iterator.next();
            if (!bundle.containsKey(string2)) continue;
            String string3 = jSONObject2.getString(string2);
            if ("image".equals(string3)) {
                object = bundle.get(string2);
                if (object instanceof Bitmap) {
                    String string4 = zzn.zza((Bitmap)object);
                    jSONObject.put(string2, (Object)string4);
                    continue;
                }
                zzkh.zzcy((String)"Invalid type. An image type extra should return a bitmap");
                continue;
            }
            object = bundle.get(string2);
            if (object instanceof Bitmap) {
                zzkh.zzcy((String)"Invalid asset type. Bitmap should be returned only for image type");
                continue;
            }
            jSONObject.put(string2, (Object)String.valueOf(bundle.get(string2)));
        }
        return jSONObject;
    }

    static String zza(zzdu zzdu2) {
        if (zzdu2 == null) {
            zzkh.zzcy((String)"Image is null. Returning empty string");
            return "";
        }
        Uri uri = null;
        try {
            uri = zzdu2.getUri();
            if (uri != null) {
                return uri.toString();
            }
        }
        catch (RemoteException remoteException) {
            zzkh.zzcy((String)"Unable to get image uri. Trying data uri next");
        }
        return zzn.zzb(zzdu2);
    }

    private static String zzb(zzdu zzdu2) {
        com.google.android.gms.dynamic.zzd zzd2;
        Drawable drawable2 = null;
        try {
            zzd2 = zzdu2.zzkv();
            if (zzd2 == null) {
                zzkh.zzcy((String)"Drawable is null. Returning empty string");
                return "";
            }
            drawable2 = (Drawable)com.google.android.gms.dynamic.zze.zzad((com.google.android.gms.dynamic.zzd)zzd2);
        }
        catch (RemoteException remoteException) {
            zzkh.zzcy((String)"Unable to get drawable. Returning empty string");
            return "";
        }
        if (!(drawable2 instanceof BitmapDrawable)) {
            zzkh.zzcy((String)"Drawable is not an instance of BitmapDrawable. Returning empty string");
            return "";
        }
        zzd2 = (BitmapDrawable)drawable2;
        Bitmap bitmap = zzd2.getBitmap();
        return zzn.zza(bitmap);
    }

    private static String zza(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bitmap == null) {
            zzkh.zzcy((String)"Bitmap is null. Returning empty string");
            return "";
        }
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string = Base64.encodeToString((byte[])byArray, (int)0);
        String string2 = String.valueOf("data:image/png;base64,");
        String string3 = String.valueOf(string);
        return string3.length() != 0 ? string2.concat(string3) : new String(string2);
    }

    @Nullable
    private static zzdu zze(Object object) {
        if (object instanceof IBinder) {
            return zzdu.zza.zzy((IBinder)((IBinder)object));
        }
        return null;
    }
}

