/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.customtabs.CustomTabsIntent;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdLauncherIntentInfoParcel;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkl;

@zzir
public class zzhc
implements MediationInterstitialAdapter {
    private Activity zzbpy;
    private zzdq zzbpz;
    private MediationInterstitialListener zzbqa;
    private Uri mUri;

    public static boolean zzp(Context context) {
        return zzdq.zzo(context);
    }

    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzbqa = mediationInterstitialListener;
        if (this.zzbqa == null) {
            zzb.zzcy((String)"Listener not set for mediation. Returning.");
            return;
        }
        if (!(context instanceof Activity)) {
            zzb.zzcy((String)"AdMobCustomTabs can only work with Activity context. Bailing out.");
            this.zzbqa.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        if (!zzhc.zzp(context)) {
            zzb.zzcy((String)"Default browser does not support custom tabs. Bailing out.");
            this.zzbqa.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        String string = bundle.getString("tab_url");
        if (TextUtils.isEmpty((CharSequence)string)) {
            zzb.zzcy((String)"The tab_url retrieved from mediation metadata is empty. Bailing out.");
            this.zzbqa.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        this.zzbpy = (Activity)context;
        this.mUri = Uri.parse((String)string);
        this.zzbpz = new zzdq();
        zzdq.zza zza2 = new zzdq.zza(){

            @Override
            public void zzkn() {
                zzb.zzcw((String)"Hinting CustomTabsService for the load of the new url.");
            }

            @Override
            public void zzko() {
                zzb.zzcw((String)"Disconnecting from CustomTabs service.");
            }
        };
        this.zzbpz.zza(zza2);
        this.zzbpz.zze(this.zzbpy);
        this.zzbqa.onAdLoaded((MediationInterstitialAdapter)this);
    }

    public void showInterstitial() {
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder(this.zzbpz.zzkl()).build();
        customTabsIntent.intent.setData(this.mUri);
        AdLauncherIntentInfoParcel adLauncherIntentInfoParcel = new AdLauncherIntentInfoParcel(customTabsIntent.intent);
        final AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(adLauncherIntentInfoParcel, null, new zzg(){

            @Override
            public void zzdy() {
                zzb.zzcw((String)"AdMobCustomTabsAdapter overlay is closed.");
                zzhc.this.zzbqa.onAdClosed((MediationInterstitialAdapter)zzhc.this);
                zzhc.this.zzbpz.zzd(zzhc.this.zzbpy);
            }

            @Override
            public void onPause() {
                zzb.zzcw((String)"AdMobCustomTabsAdapter overlay is paused.");
            }

            @Override
            public void onResume() {
                zzb.zzcw((String)"AdMobCustomTabsAdapter overlay is resumed.");
            }

            @Override
            public void zzdz() {
                zzb.zzcw((String)"Opening AdMobCustomTabsAdapter overlay.");
                zzhc.this.zzbqa.onAdOpened((MediationInterstitialAdapter)zzhc.this);
            }
        }, null, new VersionInfoParcel(0, 0, false));
        zzkl.zzclg.post(new Runnable(){

            @Override
            public void run() {
                zzu.zzfo().zza((Context)zzhc.this.zzbpy, adOverlayInfoParcel);
            }
        });
        zzu.zzft().zzaf(false);
    }

    public void onDestroy() {
        zzb.zzcw((String)"Destroying AdMobCustomTabsAdapter adapter.");
        try {
            this.zzbpz.zzd(this.zzbpy);
        }
        catch (Exception exception) {
            zzb.zzb((String)"Exception while unbinding from CustomTabsService.", (Throwable)exception);
        }
    }

    public void onPause() {
        zzb.zzcw((String)"Pausing AdMobCustomTabsAdapter adapter.");
    }

    public void onResume() {
        zzb.zzcw((String)"Resuming AdMobCustomTabsAdapter adapter.");
    }
}

