/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.reward.client.RewardedVideoAdRequestParcel;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzge;
import com.google.android.gms.internal.zzgm;
import com.google.android.gms.internal.zzgn;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzjm;
import com.google.android.gms.internal.zzjq;
import com.google.android.gms.internal.zzjy;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkl;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzir
public class zzjj
extends zzb
implements zzjm {
    private static final zzgm zzchk = new zzgm();
    private final Map<String, zzjq> zzchl = new HashMap<String, zzjq>();
    private boolean zzchm;

    public zzjj(Context context, zzd zzd2, AdSizeParcel adSizeParcel, zzgn zzgn2, VersionInfoParcel versionInfoParcel) {
        super(context, adSizeParcel, null, zzgn2, versionInfoParcel, zzd2);
    }

    public void zza(RewardedVideoAdRequestParcel rewardedVideoAdRequestParcel) {
        zzab.zzhj((String)"loadAd must be called on the main UI thread.");
        if (TextUtils.isEmpty((CharSequence)rewardedVideoAdRequestParcel.zzaos)) {
            zzkh.zzcy((String)"Invalid ad unit id. Aborting.");
            return;
        }
        this.zzchm = false;
        this.zzajs.zzaos = rewardedVideoAdRequestParcel.zzaos;
        super.zzb(rewardedVideoAdRequestParcel.zzcav);
    }

    @Override
    public void zza(final zzjy.zza zza2, zzdk zzdk2) {
        if (zza2.errorCode != -2) {
            zzkl.zzclg.post(new Runnable(){

                @Override
                public void run() {
                    zzjj.this.zzb(new zzjy(zza2, null, null, null, null, null, null, null));
                }
            });
            return;
        }
        this.zzajs.zzapa = zza2;
        if (zza2.zzcik == null) {
            this.zzajs.zzapa = this.zze(zza2);
        }
        this.zzajs.zzapu = 0;
        this.zzajs.zzaox = zzu.zzfp().zza(this.zzajs.zzagf, this.zzajs.zzapa, this);
    }

    @Nullable
    public zzjq zzcg(String string) {
        zzjq zzjq2 = this.zzchl.get(string);
        if (zzjq2 == null) {
            try {
                zzgn zzgn2 = this.zzajz;
                if ("com.google.ads.mediation.admob.AdMobAdapter".equals(string)) {
                    zzgn2 = zzchk;
                }
                zzjq2 = new zzjq(zzgn2.zzbn(string), this);
                this.zzchl.put(string, zzjq2);
            }
            catch (Exception exception) {
                String string2 = String.valueOf(string);
                zzkh.zzd((String)(string2.length() != 0 ? "Fail to instantiate adapter ".concat(string2) : new String("Fail to instantiate adapter ")), (Throwable)exception);
            }
        }
        return zzjq2;
    }

    @Override
    public boolean zza(zzjy zzjy2, zzjy zzjy3) {
        return true;
    }

    @Override
    protected boolean zza(AdRequestParcel adRequestParcel, zzjy zzjy2, boolean bl) {
        return false;
    }

    @Override
    public void pause() {
        zzab.zzhj((String)"pause must be called on the main UI thread.");
        for (String string : this.zzchl.keySet()) {
            try {
                zzjq zzjq2 = this.zzchl.get(string);
                if (zzjq2 == null || zzjq2.zzrv() == null) continue;
                zzjq2.zzrv().pause();
            }
            catch (RemoteException remoteException) {
                String string2 = String.valueOf(string);
                zzkh.zzcy((String)(string2.length() != 0 ? "Fail to pause adapter: ".concat(string2) : new String("Fail to pause adapter: ")));
            }
        }
    }

    @Override
    public void resume() {
        zzab.zzhj((String)"resume must be called on the main UI thread.");
        for (String string : this.zzchl.keySet()) {
            try {
                zzjq zzjq2 = this.zzchl.get(string);
                if (zzjq2 == null || zzjq2.zzrv() == null) continue;
                zzjq2.zzrv().resume();
            }
            catch (RemoteException remoteException) {
                String string2 = String.valueOf(string);
                zzkh.zzcy((String)(string2.length() != 0 ? "Fail to resume adapter: ".concat(string2) : new String("Fail to resume adapter: ")));
            }
        }
    }

    @Override
    public void destroy() {
        zzab.zzhj((String)"destroy must be called on the main UI thread.");
        for (String string : this.zzchl.keySet()) {
            try {
                zzjq zzjq2 = this.zzchl.get(string);
                if (zzjq2 == null || zzjq2.zzrv() == null) continue;
                zzjq2.zzrv().destroy();
            }
            catch (RemoteException remoteException) {
                String string2 = String.valueOf(string);
                zzkh.zzcy((String)(string2.length() != 0 ? "Fail to destroy adapter: ".concat(string2) : new String("Fail to destroy adapter: ")));
            }
        }
    }

    public void zzrr() {
        zzab.zzhj((String)"showAd must be called on the main UI thread.");
        if (!this.isLoaded()) {
            zzkh.zzcy((String)"The reward video has not loaded.");
            return;
        }
        this.zzchm = true;
        zzjq zzjq2 = this.zzcg(this.zzajs.zzaoz.zzbot);
        if (zzjq2 != null && zzjq2.zzrv() != null) {
            try {
                zzjq2.zzrv().showVideo();
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Could not call showVideo.", (Throwable)remoteException);
            }
        }
    }

    public boolean isLoaded() {
        zzab.zzhj((String)"isLoaded must be called on the main UI thread.");
        return this.zzajs.zzaow == null && this.zzajs.zzaox == null && this.zzajs.zzaoz != null && !this.zzchm;
    }

    @Override
    public void onRewardedVideoAdOpened() {
        this.zza(this.zzajs.zzaoz, false);
        this.zzdu();
    }

    @Override
    public void onRewardedVideoStarted() {
        if (this.zzajs.zzaoz != null && this.zzajs.zzaoz.zzbor != null) {
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaou.zzcs, this.zzajs.zzaoz, this.zzajs.zzaos, false, this.zzajs.zzaoz.zzbor.zzbnh);
        }
        this.zzdw();
    }

    @Override
    public void onRewardedVideoAdClosed() {
        this.zzds();
    }

    @Override
    public void zzc(@Nullable RewardItemParcel rewardItemParcel) {
        if (this.zzajs.zzaoz != null && this.zzajs.zzaoz.zzbor != null) {
            zzu.zzgf().zza(this.zzajs.zzagf, this.zzajs.zzaou.zzcs, this.zzajs.zzaoz, this.zzajs.zzaos, false, this.zzajs.zzaoz.zzbor.zzbni);
        }
        if (this.zzajs.zzaoz != null && this.zzajs.zzaoz.zzcik != null && !TextUtils.isEmpty((CharSequence)this.zzajs.zzaoz.zzcik.zzbnx)) {
            rewardItemParcel = new RewardItemParcel(this.zzajs.zzaoz.zzcik.zzbnx, this.zzajs.zzaoz.zzcik.zzbny);
        }
        this.zza(rewardItemParcel);
    }

    @Override
    public void zzrs() {
        this.onAdClicked();
    }

    @Override
    public void onRewardedVideoAdLeftApplication() {
        this.zzdt();
    }

    public void onContextChanged(@NonNull Context context) {
        for (zzjq zzjq2 : this.zzchl.values()) {
            try {
                zzjq2.zzrv().zzj(zze.zzae((Object)context));
            }
            catch (RemoteException remoteException) {
                zzkh.zzb((String)"Unable to call Adapter.onContextChanged.", (Throwable)remoteException);
            }
        }
    }

    private zzjy.zza zze(zzjy.zza zza2) {
        Object object;
        zzkh.v("Creating mediation ad response for non-mediated rewarded ad.");
        String string = null;
        String string2 = null;
        try {
            string = zziu.zzc(zza2.zzciu).toString();
            object = new JSONObject();
            object.put("pubid", (Object)zza2.zzcit.zzaos);
            string2 = object.toString();
        }
        catch (JSONException jSONException) {
            zzkh.zzb((String)"Unable to generate ad state for non-mediated rewarded video.", (Throwable)jSONException);
            return this.zzf(zza2);
        }
        object = new zzgd(string, null, Arrays.asList("com.google.ads.mediation.admob.AdMobAdapter"), null, null, Collections.emptyList(), Collections.emptyList(), string2, null, Collections.emptyList(), Collections.emptyList(), null, null, null, null, null, Collections.emptyList());
        zzge zzge2 = new zzge(Arrays.asList(object), -1L, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, "", -1L, 0, 1, null, 0, -1, -1L, false);
        return new zzjy.zza(zza2.zzcit, zza2.zzciu, zzge2, zza2.zzaoy, zza2.errorCode, zza2.zzcio, zza2.zzcip, zza2.zzcii);
    }

    private zzjy.zza zzf(zzjy.zza zza2) {
        return new zzjy.zza(zza2.zzcit, zza2.zzciu, null, zza2.zzaoy, 0, zza2.zzcio, zza2.zzcip, zza2.zzcii);
    }
}

