/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import java.util.Map;

@zzir
public class zzko {
    private final Context mContext;
    private String zzclp;
    private final float zzbri;
    private float zzclq;
    private float zzclr;
    private float zzcls;
    private int mState = 0;

    public zzko(Context context) {
        this.mContext = context;
        this.zzbri = context.getResources().getDisplayMetrics().density;
    }

    public zzko(Context context, String string2) {
        this(context);
        this.zzclp = string2;
    }

    public void zze(MotionEvent motionEvent) {
        int n = motionEvent.getHistorySize();
        for (int i = 0; i < n; ++i) {
            this.zza(motionEvent.getActionMasked(), motionEvent.getHistoricalX(0, i), motionEvent.getHistoricalY(0, i));
        }
        this.zza(motionEvent.getActionMasked(), motionEvent.getX(), motionEvent.getY());
    }

    void zza(int n, float f, float f2) {
        if (n == 0) {
            this.mState = 0;
            this.zzclq = f;
            this.zzclr = f2;
            this.zzcls = f2;
        } else {
            if (this.mState == -1) {
                return;
            }
            if (n == 2) {
                if (f2 > this.zzclr) {
                    this.zzclr = f2;
                } else if (f2 < this.zzcls) {
                    this.zzcls = f2;
                }
                if (this.zzclr - this.zzcls > 30.0f * this.zzbri) {
                    this.mState = -1;
                    return;
                }
                if (this.mState == 0 || this.mState == 2) {
                    if (f - this.zzclq >= 50.0f * this.zzbri) {
                        this.zzclq = f;
                        ++this.mState;
                    }
                } else if ((this.mState == 1 || this.mState == 3) && f - this.zzclq <= -50.0f * this.zzbri) {
                    this.zzclq = f;
                    ++this.mState;
                }
                if (this.mState == 1 || this.mState == 3) {
                    if (f > this.zzclq) {
                        this.zzclq = f;
                    }
                } else if (this.mState == 2 && f < this.zzclq) {
                    this.zzclq = f;
                }
            } else if (n == 1 && this.mState == 4) {
                this.showDialog();
            }
        }
    }

    public void zzct(String string2) {
        this.zzclp = string2;
    }

    private void showDialog() {
        if (!(this.mContext instanceof Activity)) {
            zzkh.zzcx((String)"Can not create dialog without Activity Context");
            return;
        }
        final String string2 = zzko.zzcu(this.zzclp);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setMessage((CharSequence)string2);
        builder.setTitle((CharSequence)"Ad Information");
        builder.setPositiveButton((CharSequence)"Share", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzu.zzfq().zzb(zzko.this.mContext, Intent.createChooser((Intent)new Intent("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", string2), (CharSequence)"Share via"));
            }
        });
        builder.setNegativeButton((CharSequence)"Close", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    static String zzcu(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "No debug information";
        }
        string2 = string2.replaceAll("\\+", "%20");
        Uri uri = new Uri.Builder().encodedQuery(string2).build();
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> map = zzu.zzfq().zzf(uri);
        for (String string3 : map.keySet()) {
            stringBuilder.append(string3).append(" = ").append(map.get(string3)).append("\n\n");
        }
        String string4 = stringBuilder.toString().trim();
        return !TextUtils.isEmpty((CharSequence)string4) ? string4 : "No debug information";
    }
}

