/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.MutableContextWrapper;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzas;
import com.google.android.gms.internal.zzcd;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdj;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzhj;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkl;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzlk;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.internal.zzlq;
import com.google.android.gms.internal.zzlr;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzir
class zzlp
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzll {
    private final zza zzcpf;
    private final Object zzail = new Object();
    private final zzas zzbgh;
    private final VersionInfoParcel zzalm;
    private final com.google.android.gms.ads.internal.zzs zzcpg;
    private final zzd zzajv;
    private zzlm zzcph;
    private com.google.android.gms.ads.internal.overlay.zzd zzcpi;
    private AdSizeParcel zzang;
    private boolean zzcpj;
    private boolean zzcpk;
    private boolean zzcpl;
    private boolean zzcpm;
    private Boolean zzcka;
    private int zzcpn;
    private boolean zzcpo = true;
    boolean zzcpp = false;
    private String zzbvu = "";
    private zzlq zzcpq;
    private boolean zzcpr;
    private zzdi zzcps;
    private zzdi zzcpt;
    private zzdi zzcpu;
    private zzdj zzcpv;
    private WeakReference<View.OnClickListener> zzcpw;
    private com.google.android.gms.ads.internal.overlay.zzd zzcpx;
    private zzky zzaqe;
    private int zzbrk = -1;
    private int zzbrj = -1;
    private int zzbrm = -1;
    private int zzbrn = -1;
    private Map<String, zzfh> zzcpy;
    private final WindowManager zzaqk;

    static zzlp zzb(Context context, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzas zzas2, VersionInfoParcel versionInfoParcel, zzdk zzdk2, com.google.android.gms.ads.internal.zzs zzs2, zzd zzd2) {
        zza zza2 = new zza(context);
        return new zzlp(zza2, adSizeParcel, bl, bl2, zzas2, versionInfoParcel, zzdk2, zzs2, zzd2);
    }

    protected zzlp(zza zza2, AdSizeParcel adSizeParcel, boolean bl, boolean bl2, zzas zzas2, VersionInfoParcel versionInfoParcel, zzdk zzdk2, com.google.android.gms.ads.internal.zzs zzs2, zzd zzd2) {
        super((Context)zza2);
        this.zzcpf = zza2;
        this.zzang = adSizeParcel;
        this.zzcpl = bl;
        this.zzcpn = -1;
        this.zzbgh = zzas2;
        this.zzalm = versionInfoParcel;
        this.zzcpg = zzs2;
        this.zzajv = zzd2;
        this.zzaqk = (WindowManager)this.getContext().getSystemService("window");
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        zzu.zzfq().zza((Context)zza2, versionInfoParcel.zzcs, webSettings);
        zzu.zzfs().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zzvj();
        if (zzs.zzavo()) {
            this.addJavascriptInterface(new zzlr(this), "googleAdsJsInterface");
        }
        if (zzs.zzavj()) {
            this.removeJavascriptInterface("accessibility");
            this.removeJavascriptInterface("accessibilityTraversal");
        }
        this.zzaqe = new zzky(this.zzcpf.zzuf(), (View)this, this, null);
        this.zzd(zzdk2);
    }

    @Override
    public void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzlm) {
            this.zzcph = (zzlm)webViewClient;
        }
    }

    @Override
    public WebView getWebView() {
        return this;
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public zzd zzuh() {
        return this.zzajv;
    }

    public boolean zzvg() {
        int n;
        int n2;
        if (!this.zzuk().zzho()) {
            return false;
        }
        DisplayMetrics displayMetrics = zzu.zzfq().zza(this.zzaqk);
        int n3 = zzm.zziw().zzb(displayMetrics, displayMetrics.widthPixels);
        int n4 = zzm.zziw().zzb(displayMetrics, displayMetrics.heightPixels);
        Activity activity = this.zzuf();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            int[] nArray = zzu.zzfq().zzh(activity);
            n2 = zzm.zziw().zzb(displayMetrics, nArray[0]);
            n = zzm.zziw().zzb(displayMetrics, nArray[1]);
        }
        if (this.zzbrj == n3 && this.zzbrk == n4 && this.zzbrm == n2 && this.zzbrn == n) {
            return false;
        }
        boolean bl = this.zzbrj != n3 || this.zzbrk != n4;
        this.zzbrj = n3;
        this.zzbrk = n4;
        this.zzbrm = n2;
        this.zzbrn = n;
        new zzhj(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzaqk.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzu.zzfq().zzam(map);
        }
        catch (JSONException jSONException) {
            zzkh.zzcy((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzkh.zzcy((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(string2, valueCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzdc(String string2) {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzkh.zzcy((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadUrl(String string2) {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(string2);
                }
                catch (Throwable throwable) {
                    String string3 = String.valueOf(throwable);
                    zzkh.zzcy((String)new StringBuilder(24 + String.valueOf(string3).length()).append("Could not call loadUrl. ").append(string3).toString());
                }
            } else {
                zzkh.zzcy((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzcz(String string2) {
        Object object = this.zzail;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Throwable throwable) {
                String string3 = String.valueOf(throwable);
                zzkh.zzcy((String)new StringBuilder(24 + String.valueOf(string3).length()).append("Could not call loadUrl. ").append(string3).toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData(String string2, String string3, String string4) {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(string2, string3, string4);
            } else {
                zzkh.zzcy((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            } else {
                zzkh.zzcy((String)"The webview is destroyed. Ignoring action.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    protected void zza(String string2, ValueCallback<String> valueCallback) {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.evaluateJavascript(string2, valueCallback);
            } else {
                zzkh.zzcy((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
            }
        }
    }

    protected void zzdd(String string2) {
        if (zzs.zzavq()) {
            if (this.zzsr() == null) {
                this.zzvh();
            }
            if (this.zzsr().booleanValue()) {
                this.zza(string2, (ValueCallback<String>)null);
            } else {
                String string3 = String.valueOf(string2);
                this.zzdc(string3.length() != 0 ? "javascript:".concat(string3) : new String("javascript:"));
            }
        } else {
            String string4 = String.valueOf(string2);
            this.zzdc(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzvh() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcka = zzu.zzft().zzsr();
            if (this.zzcka == null) {
                try {
                    String string2 = "(function(){})()";
                    this.evaluateJavascript(string2, null);
                    this.zzb(true);
                }
                catch (IllegalStateException illegalStateException) {
                    this.zzb(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzb(Boolean bl) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcka = bl;
        }
        zzu.zzft().zzb(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Boolean zzsr() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcka;
        }
    }

    @Override
    public void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zzj(string2, string3);
    }

    @Override
    public void zzj(String string2, String string3) {
        String string4 = new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("(").append(string3).append(");").toString();
        this.zzdd(string4);
    }

    @Override
    public void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AFMA_ReceiveMessage('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzkh.v(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: "));
        this.zzdd(stringBuilder.toString());
    }

    @Override
    public void zzud() {
        this.zzvi();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzalm.zzcs);
        this.zza("onhide", hashMap);
    }

    @Override
    public void zzaf(int n) {
        this.zzvi();
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzalm.zzcs);
        this.zza("onhide", hashMap);
    }

    private void zzvi() {
        zzdg.zza(this.zzcpv.zzkf(), this.zzcpt, "aeh2");
    }

    @Override
    public void zzoc() {
        if (this.zzcps == null) {
            zzdg.zza(this.zzcpv.zzkf(), this.zzcpu, "aes");
            this.zzcps = zzdg.zzb(this.zzcpv.zzkf());
            this.zzcpv.zza("native:view_show", this.zzcps);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzalm.zzcs);
        this.zza("onshow", hashMap);
    }

    @Override
    public void zzue() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzu.zzfq().zzfa()));
        hashMap.put("app_volume", String.valueOf(zzu.zzfq().zzey()));
        hashMap.put("device_volume", String.valueOf(zzu.zzfq().zzal(this.getContext())));
        this.zza("volume", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzui() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.android.gms.ads.internal.overlay.zzd zzuj() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AdSizeParcel zzdo() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzang;
        }
    }

    @Override
    public zzlm zzuk() {
        return this.zzcph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzul() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpj;
        }
    }

    @Override
    public zzas zzum() {
        return this.zzbgh;
    }

    @Override
    public VersionInfoParcel zzun() {
        return this.zzalm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzuo() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpl;
        }
    }

    public void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzu.zzfq().zzb(this.getContext(), intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzkh.zzcw((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzbgh != null) {
            this.zzbgh.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int n, int n2) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzcpl || this.zzang.zzaus || this.zzang.zzaut) {
                super.onMeasure(n, n2);
                return;
            }
            if (this.zzang.zzauq) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzaqk.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n3 = View.MeasureSpec.getMode((int)n);
            int n4 = View.MeasureSpec.getSize((int)n);
            int n5 = View.MeasureSpec.getMode((int)n2);
            int n6 = View.MeasureSpec.getSize((int)n2);
            int n7 = Integer.MAX_VALUE;
            if (n3 == Integer.MIN_VALUE || n3 == 0x40000000) {
                n7 = n4;
            }
            int n8 = Integer.MAX_VALUE;
            if (n5 == Integer.MIN_VALUE || n5 == 0x40000000) {
                n8 = n6;
            }
            if (this.zzang.widthPixels > n7 || this.zzang.heightPixels > n8) {
                float f = this.zzcpf.getResources().getDisplayMetrics().density;
                int n9 = (int)((float)this.zzang.widthPixels / f);
                int n10 = (int)((float)this.zzang.heightPixels / f);
                int n11 = (int)((float)n4 / f);
                int n12 = (int)((float)n6 / f);
                zzkh.zzcy((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n9).append("x").append(n10).append(" dp, but only has ").append(n11).append("x").append(n12).append(" dp.").toString());
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzang.widthPixels, this.zzang.heightPixels);
            }
        }
    }

    public void onGlobalLayout() {
        boolean bl = this.zzvg();
        com.google.android.gms.ads.internal.overlay.zzd zzd2 = this.zzui();
        if (zzd2 != null && bl) {
            zzd2.zzob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(Context context, AdSizeParcel adSizeParcel, zzdk zzdk2) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzaqe.zztu();
            this.setContext(context);
            this.zzcpi = null;
            this.zzang = adSizeParcel;
            this.zzcpl = false;
            this.zzcpj = false;
            this.zzbvu = "";
            this.zzcpn = -1;
            zzu.zzfs().zzk(this);
            this.loadUrl("about:blank");
            this.zzcph.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.zzcpo = true;
            this.zzcpp = false;
            this.zzcpq = null;
            this.zzd(zzdk2);
            this.zzcpr = false;
            zzu.zzgj().zze(this);
            this.zzvm();
        }
    }

    private void zzd(zzdk zzdk2) {
        this.zzvn();
        this.zzcpv = new zzdj(new zzdk(true, "make_wv", this.zzang.zzaup));
        this.zzcpv.zzkf().zzc(zzdk2);
        this.zzcpt = zzdg.zzb(this.zzcpv.zzkf());
        this.zzcpv.zza("native:view_create", this.zzcpt);
        this.zzcpu = null;
        this.zzcps = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpi = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzc(com.google.android.gms.ads.internal.overlay.zzd zzd2) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpx = zzd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(AdSizeParcel adSizeParcel) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzang = adSizeParcel;
            this.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzah(boolean bl) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpl = bl;
            this.zzvj();
        }
    }

    @Override
    public void zzuv() {
        this.zzaqe.zztt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttachedToWindow() {
        Object object = this.zzail;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzaqe.onAttachedToWindow();
            }
            this.zzal(this.zzcpr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetachedFromWindow() {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzaqe.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
        }
        this.zzal(false);
    }

    @Override
    public void setContext(Context context) {
        this.zzcpf.setBaseContext(context);
        this.zzaqe.zzl(this.zzcpf.zzuf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzai(boolean bl) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzcpi != null) {
                this.zzcpi.zza(this.zzcph.zzho(), bl);
            } else {
                this.zzcpj = bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(int n) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpn = n;
            if (this.zzcpi != null) {
                this.zzcpi.setRequestedOrientation(this.zzcpn);
            }
        }
    }

    @Override
    public Activity zzuf() {
        return this.zzcpf.zzuf();
    }

    @Override
    public Context zzug() {
        return this.zzcpf.zzug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzvj() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzcpl || this.zzang.zzauq) {
                if (Build.VERSION.SDK_INT < 14) {
                    zzkh.zzcw((String)"Disabling hardware acceleration on an overlay.");
                    this.zzvk();
                } else {
                    zzkh.zzcw((String)"Enabling hardware acceleration on an overlay.");
                    this.zzvl();
                }
            } else if (Build.VERSION.SDK_INT < 18) {
                zzkh.zzcw((String)"Disabling hardware acceleration on an AdView.");
                this.zzvk();
            } else {
                zzkh.zzcw((String)"Enabling hardware acceleration on an AdView.");
                this.zzvl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzvk() {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.zzcpm) {
                zzu.zzfs().zzp((View)this);
            }
            this.zzcpm = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzvl() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzcpm) {
                zzu.zzfs().zzo((View)this);
            }
            this.zzcpm = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzvn();
            this.zzaqe.zztu();
            if (this.zzcpi != null) {
                this.zzcpi.close();
                this.zzcpi.onDestroy();
                this.zzcpi = null;
            }
            this.zzcph.reset();
            if (this.zzcpk) {
                return;
            }
            zzu.zzgj().zze(this);
            this.zzvm();
            this.zzcpk = true;
            zzkh.v("Initiating WebView self destruct sequence in 3...");
            this.zzcph.zzva();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        Object object = this.zzail;
        synchronized (object) {
            if (!this.zzcpk) {
                this.zzcph.reset();
                zzu.zzgj().zze(this);
                this.zzvm();
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzup() {
        Object object = this.zzail;
        synchronized (object) {
            zzkh.v("Destroying WebView!");
            zzkl.zzclg.post(new Runnable(){

                @Override
                public void run() {
                    zzlp.super.destroy();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpk;
        }
    }

    @TargetApi(value=21)
    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
    }

    @Override
    public void zzuw() {
        if (this.zzcpu == null) {
            this.zzcpu = zzdg.zzb(this.zzcpv.zzkf());
            this.zzcpv.zza("native:view_load", this.zzcpu);
        }
    }

    @Override
    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzs.zzavj()) {
                super.onPause();
            }
        }
        catch (Exception exception) {
            zzkh.zzb((String)"Could not pause webview.", (Throwable)exception);
        }
    }

    @Override
    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (zzs.zzavj()) {
                super.onResume();
            }
        }
        catch (Exception exception) {
            zzkh.zzb((String)"Could not resume webview.", (Throwable)exception);
        }
    }

    @Override
    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
        }
        catch (Exception exception) {
            zzkh.zzb((String)"Could not stop loading webview.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzaj(boolean bl) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpo = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzow() {
        Object object = this.zzail;
        synchronized (object) {
            zzdg.zza(this.zzcpv.zzkf(), this.zzcpt, "aebb2");
            return this.zzcpo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zzuq() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzeg() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpp = true;
            if (this.zzcpg != null) {
                this.zzcpg.zzeg();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzeh() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpp = false;
            if (this.zzcpg != null) {
                this.zzcpg.zzeh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzvm() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpy = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzda(String string2) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzbvu = string2 == null ? "" : string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRequestId() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzbvu;
        }
    }

    @Override
    public zzlk zzur() {
        return null;
    }

    @Override
    public zzdi zzus() {
        return this.zzcpu;
    }

    @Override
    public zzdj zzut() {
        return this.zzcpv;
    }

    @Override
    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzcpw = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public View.OnClickListener zzux() {
        return (View.OnClickListener)this.zzcpw.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzlq zzuu() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzcpq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzlq zzlq2) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzcpq != null) {
                zzkh.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
                return;
            }
            this.zzcpq = zzlq2;
        }
    }

    private void zzvn() {
        if (this.zzcpv == null) {
            return;
        }
        zzdk zzdk2 = this.zzcpv.zzkf();
        if (zzdk2 != null && zzu.zzft().zzsm() != null) {
            zzu.zzft().zzsm().zza(zzdk2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzcd zzcd2, boolean bl) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzcpr = bl;
        }
        this.zzal(bl);
    }

    private void zzal(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public void zza(String string2, zzet zzet2) {
        if (this.zzcph != null) {
            this.zzcph.zza(string2, zzet2);
        }
    }

    @Override
    public void zzb(String string2, zzet zzet2) {
        if (this.zzcph != null) {
            this.zzcph.zzb(string2, zzet2);
        }
    }

    @zzir
    public static class zza
    extends MutableContextWrapper {
        private Activity zzcmz;
        private Context zzaqj;
        private Context zzcqa;

        public zza(Context context) {
            super(context);
            this.setBaseContext(context);
        }

        public void setBaseContext(Context context) {
            this.zzaqj = context.getApplicationContext();
            this.zzcmz = context instanceof Activity ? (Activity)context : null;
            this.zzcqa = context;
            super.setBaseContext(this.zzaqj);
        }

        public void startActivity(Intent intent) {
            if (this.zzcmz != null) {
                this.zzcmz.startActivity(intent);
            } else {
                intent.setFlags(0x10000000);
                this.zzaqj.startActivity(intent);
            }
        }

        public Activity zzuf() {
            return this.zzcmz;
        }

        public Object getSystemService(String string2) {
            return this.zzcqa.getSystemService(string2);
        }

        public Context zzug() {
            return this.zzcqa;
        }
    }
}

