/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;

@zzir
class zzv
implements SensorEventListener {
    private final SensorManager zzbum;
    private final Object zzbun;
    private final Display zzbuo;
    private final float[] zzbup;
    private final float[] zzbuq;
    private float[] zzbur;
    private Handler zzbus;
    private zza zzbut;

    zzv(Context context) {
        this.zzbum = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzbuo = windowManager.getDefaultDisplay();
        this.zzbup = new float[9];
        this.zzbuq = new float[9];
        this.zzbun = new Object();
    }

    int getRotation() {
        return this.zzbuo.getRotation();
    }

    void start() {
        if (this.zzbus != null) {
            return;
        }
        Sensor sensor = this.zzbum.getDefaultSensor(11);
        if (sensor == null) {
            zzkh.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzbus = new Handler(handlerThread.getLooper());
        boolean bl = this.zzbum.registerListener((SensorEventListener)this, sensor, 0, this.zzbus);
        if (!bl) {
            zzkh.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    void stop() {
        if (this.zzbus == null) {
            return;
        }
        this.zzbum.unregisterListener((SensorEventListener)this);
        this.zzbus.post(new Runnable(){

            @Override
            public void run() {
                Looper.myLooper().quit();
            }
        });
        this.zzbus = null;
    }

    void zza(zza zza2) {
        this.zzbut = zza2;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        this.zza(sensorEvent.values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zza(float[] fArray) {
        if (fArray[0] == 0.0f && fArray[1] == 0.0f && fArray[2] == 0.0f) {
            return;
        }
        Object object = this.zzbun;
        synchronized (object) {
            if (this.zzbur == null) {
                this.zzbur = new float[9];
            }
        }
        SensorManager.getRotationMatrixFromVector((float[])this.zzbup, (float[])fArray);
        int n = this.getRotation();
        switch (n) {
            case 1: {
                SensorManager.remapCoordinateSystem((float[])this.zzbup, (int)2, (int)129, (float[])this.zzbuq);
                break;
            }
            case 2: {
                SensorManager.remapCoordinateSystem((float[])this.zzbup, (int)129, (int)130, (float[])this.zzbuq);
                break;
            }
            case 3: {
                SensorManager.remapCoordinateSystem((float[])this.zzbup, (int)130, (int)1, (float[])this.zzbuq);
                break;
            }
            default: {
                System.arraycopy(this.zzbup, 0, this.zzbuq, 0, 9);
            }
        }
        this.zzf(1, 3);
        this.zzf(2, 6);
        this.zzf(5, 7);
        Object object2 = this.zzbun;
        synchronized (object2) {
            System.arraycopy(this.zzbuq, 0, this.zzbur, 0, 9);
        }
        if (this.zzbut != null) {
            this.zzbut.zzob();
        }
    }

    public void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzb(float[] fArray) {
        Object object = this.zzbun;
        synchronized (object) {
            if (this.zzbur == null) {
                return false;
            }
            System.arraycopy(this.zzbur, 0, fArray, 0, this.zzbur.length);
            return true;
        }
    }

    private void zzf(int n, int n2) {
        float f = this.zzbuq[n];
        this.zzbuq[n] = this.zzbuq[n2];
        this.zzbuq[n2] = f;
    }

    static interface zza {
        public void zzob();
    }
}

