/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzeu;
import com.google.android.gms.internal.zzey;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzfw;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzjy;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkp;
import com.google.android.gms.internal.zzle;
import com.google.android.gms.internal.zzll;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzir
public class zzn
extends zzkg {
    static final long zzcdj = TimeUnit.SECONDS.toMillis(10L);
    private static final Object zzamp = new Object();
    static boolean zzcdk = false;
    private static zzfw zzbyz = null;
    private static zzeu zzcdl = null;
    private static zzey zzcdm = null;
    private static zzet zzcdn = null;
    private final zza.zza zzcai;
    private final AdRequestInfoParcel.zza zzcaj;
    private final Object zzbxy = new Object();
    private final Context mContext;
    private zzfw.zzc zzcdo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzn(Context context, AdRequestInfoParcel.zza zza2, zza.zza zza3) {
        super(true);
        this.zzcai = zza3;
        this.mContext = context;
        this.zzcaj = zza2;
        Object object = zzamp;
        synchronized (object) {
            if (!zzcdk) {
                zzcdm = new zzey();
                zzcdl = new zzeu(context.getApplicationContext(), zza2.zzaou);
                zzcdn = new zzc();
                zzbyz = new zzfw(this.mContext.getApplicationContext(), this.zzcaj.zzaou, zzdc.zzaxw.get(), new zzb(), new zza());
                zzcdk = true;
            }
        }
    }

    protected static void zzb(zzft zzft2) {
        zzft2.zza("/loadAd", zzcdm);
        zzft2.zza("/fetchHttpRequest", zzcdl);
        zzft2.zza("/invalidRequest", zzcdn);
    }

    protected static void zzc(zzft zzft2) {
        zzft2.zzb("/loadAd", zzcdm);
        zzft2.zzb("/fetchHttpRequest", zzcdl);
        zzft2.zzb("/invalidRequest", zzcdn);
    }

    @Override
    public void zzew() {
        zzkh.zzcw((String)"SdkLessAdLoaderBackgroundTask started.");
        AdRequestInfoParcel adRequestInfoParcel = new AdRequestInfoParcel(this.zzcaj, null, -1L);
        AdResponseParcel adResponseParcel = this.zze(adRequestInfoParcel);
        long l = zzu.zzfu().elapsedRealtime();
        final zzjy.zza zza2 = new zzjy.zza(adRequestInfoParcel, adResponseParcel, null, null, adResponseParcel.errorCode, l, adResponseParcel.zzccg, null);
        com.google.android.gms.ads.internal.util.client.zza.zzcnf.post(new Runnable(){

            @Override
            public void run() {
                zzn.this.zzcai.zza(zza2);
                if (zzn.this.zzcdo != null) {
                    zzn.this.zzcdo.release();
                    zzn.this.zzcdo = null;
                }
            }
        });
    }

    private AdResponseParcel zze(AdRequestInfoParcel adRequestInfoParcel) {
        JSONObject jSONObject;
        final String string = zzu.zzfq().zztf();
        final JSONObject jSONObject2 = this.zza(adRequestInfoParcel, string);
        if (jSONObject2 == null) {
            return new AdResponseParcel(0);
        }
        long l = zzu.zzfu().elapsedRealtime();
        Future<JSONObject> future = zzcdm.zzax(string);
        com.google.android.gms.ads.internal.util.client.zza.zzcnf.post(new Runnable(){

            @Override
            public void run() {
                zzn.this.zzcdo = zzbyz.zzmc();
                zzn.this.zzcdo.zza(new zzle.zzc<zzfx>(){

                    public void zzb(zzfx zzfx2) {
                        try {
                            zzfx2.zza("AFMA_getAdapterLessMediationAd", jSONObject2);
                        }
                        catch (Exception exception) {
                            zzkh.zzb((String)"Error requesting an ad url", (Throwable)exception);
                            zzcdm.zzay(string);
                        }
                    }

                    @Override
                    public /* synthetic */ void zzd(Object object) {
                        this.zzb((zzfx)object);
                    }
                }, new zzle.zza(){

                    @Override
                    public void run() {
                        zzcdm.zzay(string);
                    }
                });
            }
        });
        long l2 = zzcdj - (zzu.zzfu().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new AdResponseParcel(-1);
        }
        catch (TimeoutException timeoutException) {
            return new AdResponseParcel(2);
        }
        catch (ExecutionException executionException) {
            return new AdResponseParcel(0);
        }
        if (jSONObject == null) {
            return new AdResponseParcel(-1);
        }
        AdResponseParcel adResponseParcel = zziu.zza(this.mContext, adRequestInfoParcel, jSONObject.toString());
        if (adResponseParcel.errorCode != -3 && TextUtils.isEmpty((CharSequence)adResponseParcel.body)) {
            return new AdResponseParcel(3);
        }
        return adResponseParcel;
    }

    private JSONObject zza(AdRequestInfoParcel adRequestInfoParcel, String string) {
        Bundle bundle = adRequestInfoParcel.zzcav.extras.getBundle("sdk_less_server_data");
        String string2 = adRequestInfoParcel.zzcav.extras.getString("sdk_less_network_id");
        if (bundle == null) {
            return null;
        }
        JSONObject jSONObject = zziu.zza(this.mContext, adRequestInfoParcel, zzu.zzfw().zzy(this.mContext), null, null, new zzcv(zzdc.zzaxw.get()), null, new ArrayList<String>(), null, null);
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            zzkh.zzd((String)"Cannot get advertising id info", (Throwable)throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string);
        hashMap.put("network_id", string2);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzu.zzfq().zzam(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzbxy;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zza.zzcnf.post(new Runnable(){

                @Override
                public void run() {
                    if (zzn.this.zzcdo != null) {
                        zzn.this.zzcdo.release();
                        zzn.this.zzcdo = null;
                    }
                }
            });
        }
    }

    public static class zza
    implements zzkp<zzft> {
        public void zza(zzft zzft2) {
            zzn.zzc(zzft2);
        }

        @Override
        public /* synthetic */ void zzd(Object object) {
            this.zza((zzft)object);
        }
    }

    public static class zzb
    implements zzkp<zzft> {
        public void zza(zzft zzft2) {
            zzn.zzb(zzft2);
        }

        @Override
        public /* synthetic */ void zzd(Object object) {
            this.zza((zzft)object);
        }
    }

    public static class zzc
    implements zzet {
        @Override
        public void zza(zzll zzll2, Map<String, String> map) {
            String string = map.get("request_id");
            String string2 = map.get("errors");
            String string3 = String.valueOf(string2);
            zzkh.zzcy((String)(string3.length() != 0 ? "Invalid request: ".concat(string3) : new String("Invalid request: ")));
            zzcdm.zzay(string);
        }
    }
}

