/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.clearcut.zzb;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.zzc;
import com.google.android.gms.gass.internal.zza;
import com.google.android.gms.internal.zzae;
import com.google.android.gms.internal.zzak;
import com.google.android.gms.internal.zzam;
import com.google.android.gms.internal.zzapc;
import com.google.android.gms.internal.zzau;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzbo;
import com.google.android.gms.internal.zzdc;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzax {
    private static final String TAG = zzax.class.getSimpleName();
    protected Context zzagf;
    private ExecutorService zzagg;
    private DexClassLoader zzagh;
    private zzau zzagi;
    private byte[] zzagj;
    private volatile AdvertisingIdClient zzagk = null;
    private volatile boolean zzafn = false;
    private Future zzagl = null;
    private volatile zzae.zza zzagm = null;
    private Future zzagn = null;
    private zzam zzago;
    private GoogleApiClient zzagp = null;
    protected boolean zzagq = false;
    protected static final Object zzagr = new Object();
    protected boolean zzags = false;
    private static zzc zzagt = null;
    protected boolean zzagu = false;
    private Map<Pair<String, String>, zzbo> zzagv;

    public static zzax zza(Context context, String string2, String string3, boolean bl) {
        zzax zzax2 = new zzax(context);
        try {
            if (zzax2.zzc(string2, string3, bl)) {
                return zzax2;
            }
        }
        catch (zzaw zzaw2) {
            // empty catch block
        }
        return null;
    }

    public Context getContext() {
        return this.zzagf;
    }

    public ExecutorService zzce() {
        return this.zzagg;
    }

    public DexClassLoader zzcf() {
        return this.zzagh;
    }

    public zzau zzcg() {
        return this.zzagi;
    }

    public byte[] zzch() {
        return this.zzagj;
    }

    public GoogleApiClient zzci() {
        return this.zzagp;
    }

    public boolean zzcj() {
        return this.zzagq;
    }

    public boolean zzck() {
        return this.zzagu;
    }

    public zzam zzcl() {
        return this.zzago;
    }

    public zzae.zza zzcm() {
        return this.zzagm;
    }

    public Future zzcn() {
        return this.zzagn;
    }

    private zzax(Context context) {
        this.zzagf = context;
        this.zzagv = new HashMap<Pair<String, String>, zzbo>();
    }

    private boolean zzc(String string2, String string3, boolean bl) throws zzaw {
        boolean bl2 = false;
        this.zzagg = Executors.newCachedThreadPool();
        this.zzc(bl);
        this.zzcr();
        this.zzcp();
        this.zzagi = new zzau(null);
        try {
            this.zzagj = this.zzagi.zzl(string2);
        }
        catch (zzau.zza zza2) {
            throw new zzaw(zza2);
        }
        bl2 = this.zzm(string3);
        this.zzago = new zzam(this);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zzm(String string2) throws zzaw {
        try {
            File file = this.zzagf.getCacheDir();
            if (file == null && (file = this.zzagf.getDir("dex", 0)) == null) {
                throw new zzaw();
            }
            String string3 = zzav.zzay();
            File file2 = this.zza(string2, file, string3);
            this.zzb(file, string3);
            try {
                this.zzagh = new DexClassLoader(file2.getAbsolutePath(), file.getAbsolutePath(), null, this.zzagf.getClassLoader());
                boolean bl = true;
                this.zza(file2);
                this.zza(file, string3);
            }
            catch (Throwable throwable) {
                this.zza(file2);
                this.zza(file, string3);
                this.zzn(String.format("%s/%s.dex", file, string3));
                throw throwable;
            }
            this.zzn(String.format("%s/%s.dex", file, string3));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new zzaw(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new zzaw(iOException);
        }
        catch (zzau.zza zza2) {
            throw new zzaw(zza2);
        }
        catch (NullPointerException nullPointerException) {
            throw new zzaw(nullPointerException);
        }
        return true;
    }

    @NonNull
    private File zza(String string2, File file, String string3) throws zzau.zza, IOException {
        File file2 = new File(String.format("%s/%s.jar", file, string3));
        if (!file2.exists()) {
            byte[] byArray = this.zzagi.zzc(this.zzagj, string2);
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            fileOutputStream.close();
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zza(File file, String string2) {
        File file2 = new File(String.format("%s/%s.tmp", file, string2));
        if (file2.exists()) {
            return;
        }
        File file3 = new File(String.format("%s/%s.dex", file, string2));
        if (!file3.exists()) {
            return;
        }
        FileInputStream fileInputStream = null;
        long l = file3.length();
        if (l <= 0L) {
            return;
        }
        byte[] byArray = new byte[(int)l];
        try {
            fileInputStream = new FileInputStream(file3);
            int n = fileInputStream.read(byArray);
            if (n <= 0) {
                return;
            }
            zzae.zzd zzd2 = new zzae.zzd();
            zzd2.zzev = Build.VERSION.SDK.getBytes();
            zzd2.zzeu = string2.getBytes();
            byte[] byArray2 = this.zzagi.zzd(this.zzagj, byArray).getBytes();
            zzd2.data = byArray2;
            zzd2.zzet = zzak.zzg(byArray2);
            byArray = null;
            file2.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray3 = zzapc.zzf((zzapc)zzd2);
            zzd2 = null;
            fileOutputStream.write(byArray3, 0, byArray3.length);
            fileOutputStream.close();
        }
        catch (zzau.zza | IOException | NoSuchAlgorithmException exception) {
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            this.zza(file3);
        }
    }

    private void zzn(String string2) {
        File file = new File(string2);
        this.zza(file);
    }

    private void zza(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    private boolean zzb(File file, String string2) {
        File file2 = new File(String.format("%s/%s.tmp", file, string2));
        if (!file2.exists()) {
            return false;
        }
        File file3 = new File(String.format("%s/%s.dex", file, string2));
        if (file3.exists()) {
            return false;
        }
        try {
            long l = file2.length();
            if (l <= 0L) {
                this.zza(file2);
                return false;
            }
            FileInputStream fileInputStream = new FileInputStream(file2);
            byte[] byArray = new byte[(int)l];
            int n = fileInputStream.read(byArray);
            if (n <= 0) {
                Log.d((String)TAG, (String)"Cannot read the cache data.");
                this.zza(file2);
                return false;
            }
            zzae.zzd zzd2 = zzae.zzd.zzd((byte[])byArray);
            byArray = null;
            if (!(string2.equals(new String(zzd2.zzeu)) && Arrays.equals(zzd2.zzet, zzak.zzg(zzd2.data)) && Arrays.equals(zzd2.zzev, Build.VERSION.SDK.getBytes()))) {
                this.zza(file2);
                return false;
            }
            byte[] byArray2 = this.zzagi.zzc(this.zzagj, new String(zzd2.data));
            file3.createNewFile();
            FileOutputStream fileOutputStream = new FileOutputStream(file3);
            fileOutputStream.write(byArray2, 0, byArray2.length);
            fileOutputStream.close();
        }
        catch (zzau.zza | IOException | NoSuchAlgorithmException exception) {
            return false;
        }
        return true;
    }

    public boolean zza(String string2, String string3, List<Class> list) {
        if (!this.zzagv.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzagv.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzbo(this, string2, string3, list));
            return true;
        }
        return false;
    }

    public Method zzc(String string2, String string3) {
        zzbo zzbo2 = this.zzagv.get(new Pair((Object)string2, (Object)string3));
        if (zzbo2 == null) {
            return null;
        }
        return zzbo2.zzda();
    }

    private void zzc(boolean bl) {
        this.zzafn = bl;
        if (!bl) {
            return;
        }
        this.zzagl = this.zzagg.submit(new Runnable(){

            @Override
            public void run() {
                zzax.this.zzco();
            }
        });
    }

    private void zzco() {
        try {
            if (this.zzagk == null) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzagf);
                advertisingIdClient.start();
                this.zzagk = advertisingIdClient;
            }
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzagk = null;
        }
    }

    void zzcp() {
        if (!zzdc.zzbbs.get().booleanValue()) {
            return;
        }
        this.zzagn = this.zzagg.submit(new Runnable(){

            @Override
            public void run() {
                zzax.this.zzcq();
            }
        });
    }

    private void zzcq() {
        if (this.zzags) {
            try {
                PackageInfo packageInfo = this.zzagf.getPackageManager().getPackageInfo(this.zzagf.getPackageName(), 0);
                this.zzagm = zza.zzf((Context)this.zzagf, (String)this.zzagf.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
    }

    private void zzcr() {
        zzagt = zzc.zzand();
        this.zzagq = zzagt.zzbn(this.zzagf) > 0;
        boolean bl = this.zzags = zzagt.isGooglePlayServicesAvailable(this.zzagf) == 0;
        if (this.zzagf.getApplicationContext() != null) {
            this.zzagp = new GoogleApiClient.Builder(this.zzagf).addApi(zzb.API).build();
        }
        zzdc.initialize(this.zzagf);
    }

    public AdvertisingIdClient zzcs() {
        if (!this.zzafn) {
            return null;
        }
        if (this.zzagk != null) {
            return this.zzagk;
        }
        if (this.zzagl != null) {
            try {
                this.zzagl.get(2000L, TimeUnit.MILLISECONDS);
                this.zzagl = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzagl.cancel(true);
            }
        }
        return this.zzagk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzct() {
        Object object = zzagr;
        synchronized (object) {
            if (this.zzagu) {
                return;
            }
            if (this.zzags && this.zzagp != null) {
                this.zzagp.connect();
                this.zzagu = true;
            } else {
                this.zzagu = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzcu() {
        Object object = zzagr;
        synchronized (object) {
            if (this.zzagu && this.zzagp != null) {
                this.zzagp.disconnect();
                this.zzagu = false;
            }
        }
    }

    public int zzau() {
        int n = Integer.MIN_VALUE;
        zzam zzam2 = this.zzcl();
        if (zzam2 != null) {
            n = zzam2.zzau();
        }
        return n;
    }
}

