/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzlk;
import com.google.android.gms.internal.zzll;
import java.util.Map;
import java.util.WeakHashMap;
import org.json.JSONObject;

@zzir
public final class zzfd
implements zzet {
    private final Map<zzll, Integer> zzbjd = new WeakHashMap<zzll, Integer>();
    private boolean zzbje;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                n2 = zzm.zziw().zza(context, Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzkh.zzcy((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    @Override
    public void zza(zzll zzll2, Map<String, String> map) {
        Object object;
        String string2 = map.get("action");
        if (string2 == null) {
            zzkh.zzcy((String)"Action missing from video GMSG.");
            return;
        }
        if (zzkh.zzaz((int)3)) {
            object = new JSONObject(map);
            object.remove("google.afma.Notify_dt");
            String string3 = String.valueOf(object.toString());
            zzkh.zzcw((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Video GMSG: ").append(string2).append(" ").append(string3).toString());
        }
        if ("background".equals(string2)) {
            object = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object)) {
                zzkh.zzcy((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                zzk zzk2;
                int n = Color.parseColor((String)object);
                zzlk zzlk2 = zzll2.zzur();
                if (zzlk2 != null && (zzk2 = zzlk2.zzuc()) != null) {
                    zzk2.setBackgroundColor(n);
                    return;
                }
                this.zzbjd.put(zzll2, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzkh.zzcy((String)"Invalid color parameter in video GMSG.");
            }
            return;
        }
        object = zzll2.zzur();
        if (object == null) {
            zzkh.zzcy((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzll2.getContext();
            int n2 = zzfd.zza(context, map, "x", 0);
            int n3 = zzfd.zza(context, map, "y", 0);
            int n4 = zzfd.zza(context, map, "w", -1);
            int n5 = zzfd.zza(context, map, "h", -1);
            try {
                n = Integer.parseInt(map.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean(map.get("spherical"));
            if (bl && ((zzlk)object).zzuc() == null) {
                ((zzlk)object).zza(n2, n3, n4, n5, n, bl3);
                if (this.zzbjd.containsKey(zzll2)) {
                    int n6 = this.zzbjd.get(zzll2);
                    zzk zzk3 = ((zzlk)object).zzuc();
                    zzk3.setBackgroundColor(n6);
                }
            } else {
                ((zzlk)object).zze(n2, n3, n4, n5);
            }
        } else {
            zzk zzk4 = ((zzlk)object).zzuc();
            if (zzk4 == null) {
                zzk.zzi(zzll2);
                return;
            }
            if ("click".equals(string2)) {
                Context context = zzll2.getContext();
                int n = zzfd.zza(context, map, "x", 0);
                int n7 = zzfd.zza(context, map, "y", 0);
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n7, (int)0);
                zzk4.zzd(motionEvent);
                motionEvent.recycle();
            } else if ("currentTime".equals(string2)) {
                String string4 = map.get("time");
                if (string4 == null) {
                    zzkh.zzcy((String)"Time parameter missing from currentTime video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    int n = (int)(f * 1000.0f);
                    zzk4.seekTo(n);
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = String.valueOf(string4);
                    zzkh.zzcy((String)(string5.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string5) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                }
            } else if ("hide".equals(string2)) {
                zzk4.setVisibility(4);
            } else if ("load".equals(string2)) {
                zzk4.zzlx();
            } else if ("mimetype".equals(string2)) {
                zzk4.setMimeType(map.get("mimetype"));
            } else if ("muted".equals(string2)) {
                boolean bl4 = Boolean.parseBoolean(map.get("muted"));
                if (bl4) {
                    zzk4.zznq();
                } else {
                    zzk4.zznr();
                }
            } else if ("pause".equals(string2)) {
                zzk4.pause();
            } else if ("play".equals(string2)) {
                zzk4.play();
            } else if ("show".equals(string2)) {
                zzk4.setVisibility(0);
            } else if ("src".equals(string2)) {
                zzk4.zzbx(map.get("src"));
            } else if ("touchMove".equals(string2)) {
                Context context = zzll2.getContext();
                int n = zzfd.zza(context, map, "dx", 0);
                int n8 = zzfd.zza(context, map, "dy", 0);
                zzk4.zza(n, n8);
                if (!this.zzbje) {
                    zzd zzd2 = zzll2.zzui();
                    zzd2.zzod();
                    this.zzbje = true;
                }
            } else if ("volume".equals(string2)) {
                String string6 = map.get("volume");
                if (string6 == null) {
                    zzkh.zzcy((String)"Level parameter missing from volume video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string6);
                    zzk4.zza(f);
                }
                catch (NumberFormatException numberFormatException) {
                    String string7 = String.valueOf(string6);
                    zzkh.zzcy((String)(string7.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string7) : new String("Could not parse volume parameter from volume video GMSG: ")));
                }
            } else if ("watermark".equals(string2)) {
                zzk4.zzop();
            } else {
                String string8 = String.valueOf(string2);
                zzkh.zzcy((String)(string8.length() != 0 ? "Unknown video action: ".concat(string8) : new String("Unknown video action: ")));
            }
        }
    }
}

