/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzfl;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzfq;
import com.google.android.gms.internal.zzfs;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzkh;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;

@zzir
public class zzfo {
    private final Map<zzfp, zzfq> zzbks = new HashMap<zzfp, zzfq>();
    private final LinkedList<zzfp> zzbkt = new LinkedList();
    private zzfl zzbku;

    void zza(zzfl zzfl2) {
        if (this.zzbku == null) {
            this.zzbku = zzfl2.zzlp();
            this.restore();
        }
    }

    zzfq.zza zza(AdRequestParcel adRequestParcel, String string2) {
        Object object;
        if (this.zzbg(string2)) {
            return null;
        }
        Context context = this.zzbku.getApplicationContext();
        zziz zziz2 = new zziz.zza(context).zzro();
        int n = zziz2.zzcgt;
        AdRequestParcel adRequestParcel2 = zzfo.zzl(adRequestParcel);
        zzfp zzfp2 = new zzfp(adRequestParcel2, string2, n);
        zzfq zzfq2 = this.zzbks.get(zzfp2);
        if (zzfq2 == null) {
            zzfo.zza("Interstitial pool created at %s.", zzfp2);
            zzfq2 = new zzfq(adRequestParcel2, string2, n);
            this.zzbks.put(zzfp2, zzfq2);
        }
        this.zzbkt.remove(zzfp2);
        this.zzbkt.add(zzfp2);
        zzfq2.zzlv();
        while (this.zzbkt.size() > zzdc.zzbag.get()) {
            object = this.zzbkt.remove();
            zzfq zzfq3 = this.zzbks.get(object);
            zzfo.zza("Evicting interstitial queue for %s.", (zzfp)object);
            while (zzfq3.size() > 0) {
                zzfq.zza zza2 = zzfq3.zzm(null);
                zza2.zzbkz.zzeu();
            }
            this.zzbks.remove(object);
        }
        while (zzfq2.size() > 0) {
            long l;
            object = zzfq2.zzm(adRequestParcel2);
            if (((zzfq.zza)object).zzbld && (l = zzu.zzfu().currentTimeMillis() - ((zzfq.zza)object).zzblc) > 1000L * (long)zzdc.zzbai.get().intValue()) {
                zzfo.zza("Expired interstitial at %s.", zzfp2);
                continue;
            }
            String string3 = ((zzfq.zza)object).zzbla != null ? " (inline) " : " ";
            zzfo.zza(new StringBuilder(34 + String.valueOf(string3).length()).append("Pooled interstitial").append(string3).append("returned at %s.").toString(), zzfp2);
            return object;
        }
        return null;
    }

    void zzb(AdRequestParcel adRequestParcel, String string2) {
        if (this.zzbku == null) {
            return;
        }
        Context context = this.zzbku.getApplicationContext();
        zziz zziz2 = new zziz.zza(context).zzro();
        int n = zziz2.zzcgt;
        AdRequestParcel adRequestParcel2 = zzfo.zzl(adRequestParcel);
        zzfp zzfp2 = new zzfp(adRequestParcel2, string2, n);
        zzfq zzfq2 = this.zzbks.get(zzfp2);
        if (zzfq2 == null) {
            zzfo.zza("Interstitial pool created at %s.", zzfp2);
            zzfq2 = new zzfq(adRequestParcel2, string2, n);
            this.zzbks.put(zzfp2, zzfq2);
        }
        zzfq2.zza(this.zzbku, adRequestParcel);
        zzfq2.zzlv();
        zzfo.zza("Inline entry added to the queue at %s.", zzfp2);
    }

    void zzlq() {
        if (this.zzbku == null) {
            return;
        }
        for (Map.Entry<zzfp, zzfq> entry : this.zzbks.entrySet()) {
            zzfp zzfp2 = entry.getKey();
            zzfq zzfq2 = entry.getValue();
            if (zzkh.zzaz((int)2)) {
                int n = zzfq2.size();
                int n2 = zzfq2.zzlt();
                if (n2 < n) {
                    zzkh.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zzfp2));
                }
            }
            zzfq2.zzlu();
            while (zzfq2.size() < zzdc.zzbah.get()) {
                zzfo.zza("Pooling and loading one new interstitial for %s.", zzfp2);
                zzfq2.zzb(this.zzbku);
            }
        }
        this.save();
    }

    void save() {
        if (this.zzbku == null) {
            return;
        }
        Context context = this.zzbku.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        for (Map.Entry<zzfp, zzfq> entry : this.zzbks.entrySet()) {
            zzfp zzfp2 = entry.getKey();
            zzfq zzfq2 = entry.getValue();
            if (!zzfq2.zzlw()) continue;
            zzfs zzfs2 = new zzfs(zzfq2);
            String string2 = zzfs2.zzlz();
            String string3 = zzfp2.toString();
            editor.putString(string3, string2);
            zzfo.zza("Saved interstitial queue for %s.", zzfp2);
        }
        editor.putString("PoolKeys", this.zzlr());
        editor.apply();
    }

    void restore() {
        zzfp zzfp2;
        if (this.zzbku == null) {
            return;
        }
        Context context = this.zzbku.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        this.flush();
        HashMap<String, zzfp> hashMap = new HashMap<String, zzfp>();
        String[] stringArray = sharedPreferences.getAll().entrySet().iterator();
        while (stringArray.hasNext()) {
            String[] stringArray2 = stringArray.next();
            try {
                String string2 = (String)stringArray2.getKey();
                if (string2.equals("PoolKeys")) continue;
                String string3 = (String)stringArray2.getValue();
                zzfs object = new zzfs(string3);
                zzfp2 = new zzfp(object.zzana, object.zzall, object.zzbkx);
                if (this.zzbks.containsKey(zzfp2)) continue;
                zzfq zzfq2 = new zzfq(object.zzana, object.zzall, object.zzbkx);
                this.zzbks.put(zzfp2, zzfq2);
                hashMap.put(zzfp2.toString(), zzfp2);
                zzfo.zza("Restored interstitial queue for %s.", zzfp2);
            }
            catch (IOException | ClassCastException exception) {
                zzkh.zzd((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)exception);
            }
        }
        for (String string2 : stringArray = this.zzbf(sharedPreferences.getString("PoolKeys", ""))) {
            zzfp2 = (zzfp)hashMap.get(string2);
            if (!this.zzbks.containsKey(zzfp2)) continue;
            this.zzbkt.add(zzfp2);
        }
    }

    void flush() {
        while (this.zzbkt.size() > 0) {
            zzfp zzfp2 = this.zzbkt.remove();
            zzfq zzfq2 = this.zzbks.get(zzfp2);
            zzfo.zza("Flushing interstitial queue for %s.", zzfp2);
            while (zzfq2.size() > 0) {
                zzfq.zza zza2 = zzfq2.zzm(null);
                zza2.zzbkz.zzeu();
            }
            this.zzbks.remove(zzfp2);
        }
    }

    private String zzlr() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzbkt.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zzfp)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private String[] zzbf(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private boolean zzbg(String string2) {
        try {
            return Pattern.matches(zzdc.zzbaj.get(), string2);
        }
        catch (RuntimeException runtimeException) {
            zzu.zzft().zzb(runtimeException, true);
            return false;
        }
    }

    @Nullable
    static Bundle zzi(AdRequestParcel adRequestParcel) {
        Bundle bundle = adRequestParcel.zzatu;
        if (bundle == null) {
            return null;
        }
        return bundle.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
    }

    static AdRequestParcel zzj(AdRequestParcel adRequestParcel) {
        Parcel parcel = Parcel.obtain();
        adRequestParcel.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        AdRequestParcel adRequestParcel2 = (AdRequestParcel)AdRequestParcel.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        Bundle bundle = zzfo.zzi(adRequestParcel2);
        if (bundle == null) {
            bundle = new Bundle();
            adRequestParcel2.zzatu.putBundle("com.google.ads.mediation.admob.AdMobAdapter", bundle);
        }
        bundle.putBoolean("_skipMediation", true);
        return adRequestParcel2;
    }

    static boolean zzk(AdRequestParcel adRequestParcel) {
        Bundle bundle = adRequestParcel.zzatu;
        if (bundle == null) {
            return false;
        }
        Bundle bundle2 = bundle.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        return bundle2 != null && bundle2.containsKey("_skipMediation");
    }

    private static AdRequestParcel zzl(AdRequestParcel adRequestParcel) {
        String[] stringArray;
        Parcel parcel = Parcel.obtain();
        adRequestParcel.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        AdRequestParcel adRequestParcel2 = (AdRequestParcel)AdRequestParcel.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        String string2 = zzdc.zzbaf.get();
        for (String string3 : stringArray = string2.split(",")) {
            zzfo.zzc(adRequestParcel2.zzatu, string3);
        }
        return adRequestParcel2;
    }

    private static void zzc(Bundle bundle, String string2) {
        String[] stringArray = string2.split("/", 2);
        if (stringArray.length == 0) {
            return;
        }
        String string3 = stringArray[0];
        if (stringArray.length == 1) {
            bundle.remove(string3);
            return;
        }
        Bundle bundle2 = bundle.getBundle(string3);
        if (bundle2 == null) {
            return;
        }
        zzfo.zzc(bundle2, stringArray[1]);
    }

    private static void zza(String string2, zzfp zzfp2) {
        if (zzkh.zzaz((int)2)) {
            zzkh.v(String.format(string2, zzfp2));
        }
    }
}

