/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzf;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzge;
import com.google.android.gms.internal.zzgg;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzgn;
import com.google.android.gms.internal.zzgo;
import com.google.android.gms.internal.zzgp;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzhc;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkl;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzir
public class zzgh
implements zzgi.zza {
    private final String zzbog;
    private final zzgn zzajz;
    private final long zzboh;
    private final zzge zzboi;
    private final zzgd zzboj;
    private AdRequestParcel zzana;
    private final AdSizeParcel zzang;
    private final Context mContext;
    private final Object zzail = new Object();
    private final VersionInfoParcel zzalm;
    private final boolean zzarj;
    private final NativeAdOptionsParcel zzali;
    private final List<String> zzalj;
    private final boolean zzawl;
    private zzgo zzbok;
    private int zzbol = -2;
    private zzgq zzbom;

    public zzgh(Context context, String string, zzgn zzgn2, zzge zzge2, zzgd zzgd2, AdRequestParcel adRequestParcel, AdSizeParcel adSizeParcel, VersionInfoParcel versionInfoParcel, boolean bl, boolean bl2, NativeAdOptionsParcel nativeAdOptionsParcel, List<String> list) {
        this.mContext = context;
        this.zzajz = zzgn2;
        this.zzboj = zzgd2;
        this.zzbog = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string) ? this.zzmj() : string;
        this.zzboi = zzge2;
        this.zzboh = zzge2.zzbnp != -1L ? zzge2.zzbnp : 10000L;
        this.zzana = adRequestParcel;
        this.zzang = adSizeParcel;
        this.zzalm = versionInfoParcel;
        this.zzarj = bl;
        this.zzawl = bl2;
        this.zzali = nativeAdOptionsParcel;
        this.zzalj = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.zzail;
        synchronized (object) {
            try {
                if (this.zzbok != null) {
                    this.zzbok.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzkh.zzd((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzbol = -1;
            this.zzail.notify();
        }
    }

    private String zzmj() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzboj.zzbnc)) {
                return this.zzajz.zzbo(this.zzboj.zzbnc) ? "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter" : "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzkh.zzcy((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzy(int n) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzbol = n;
            this.zzail.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(int n, zzgq zzgq2) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzbol = n;
            this.zzbom = zzgq2;
            this.zzail.notify();
        }
    }

    protected zzgo zza(MediationAdapter mediationAdapter) {
        return new zzgu(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzgi zza(long l, long l2) {
        Object object = this.zzail;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            final zzgg zzgg2 = new zzgg();
            zzkl.zzclg.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = zzgh.this.zzail;
                    synchronized (object) {
                        if (zzgh.this.zzbol != -2) {
                            return;
                        }
                        zzgh.this.zzbok = zzgh.this.zzml();
                        if (zzgh.this.zzbok == null) {
                            zzgh.this.zzy(4);
                            return;
                        }
                        if (zzgh.this.zzmm() && !zzgh.this.zzz(1)) {
                            String string = zzgh.this.zzbog;
                            zzkh.zzcy((String)new StringBuilder(56 + String.valueOf(string).length()).append("Ignoring adapter ").append(string).append(" as delayed impression is not supported").toString());
                            zzgh.this.zzy(2);
                            return;
                        }
                        zzgg2.zza(zzgh.this);
                        zzgh.this.zza(zzgg2);
                    }
                }
            });
            long l4 = this.zza(l3, this.zzboh, l, l2);
            return new zzgi(this.zzboj, this.zzbok, this.zzbog, zzgg2, this.zzbol, this.zzmk(), l4);
        }
    }

    private zzgq zzmk() {
        if (this.zzbol != 0 || !this.zzmm()) {
            return null;
        }
        try {
            if (this.zzz(4) && this.zzbom != null && this.zzbom.zzmo() != 0) {
                return this.zzbom;
            }
        }
        catch (RemoteException remoteException) {
            zzkh.zzcy((String)"Could not get cpm value from MediationResponseMetadata");
        }
        return zzgh.zzaa(this.zzmn());
    }

    private zzgo zzml() {
        String string = String.valueOf(this.zzbog);
        zzkh.zzcx((String)(string.length() != 0 ? "Instantiating mediation adapter: ".concat(string) : new String("Instantiating mediation adapter: ")));
        if (!this.zzarj) {
            if (zzdc.zzbbc.get().booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzbog)) {
                return this.zza((MediationAdapter)new AdMobAdapter());
            }
            if (zzdc.zzbbd.get().booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzbog)) {
                return this.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzbog)) {
                return new zzgu((MediationAdapter)new zzhc());
            }
        }
        try {
            return this.zzajz.zzbn(this.zzbog);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(this.zzbog);
            zzkh.zza((String)(string2.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string2) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private void zza(zzgg zzgg2) {
        String string;
        if ("com.google.ads.mediation.AdUrlAdapter".equals(this.zzbog)) {
            if (this.zzana.zzatu == null) {
                this.zzana = new zzf(this.zzana).zzc(new Bundle()).zzig();
            }
            if ((string = this.zzana.zzatu.getBundle(this.zzbog)) == null) {
                string = new Bundle();
            }
            string.putString("sdk_less_network_id", this.zzboj.zzbmz);
            this.zzana.zzatu.putBundle(this.zzbog, (Bundle)string);
        }
        string = this.zzbk(this.zzboj.zzbng);
        try {
            if (this.zzalm.zzcnp < 4100000) {
                if (this.zzang.zzauq) {
                    this.zzbok.zza(zze.zzae((Object)this.mContext), this.zzana, string, (zzgp)zzgg2);
                } else {
                    this.zzbok.zza(zze.zzae((Object)this.mContext), this.zzang, this.zzana, string, (zzgp)zzgg2);
                }
            } else if (this.zzarj) {
                this.zzbok.zza(zze.zzae((Object)this.mContext), this.zzana, string, this.zzboj.zzbmy, (zzgp)zzgg2, this.zzali, this.zzalj);
            } else if (this.zzang.zzauq) {
                this.zzbok.zza(zze.zzae((Object)this.mContext), this.zzana, string, this.zzboj.zzbmy, (zzgp)zzgg2);
            } else if (this.zzawl) {
                if (this.zzboj.zzbnj != null) {
                    this.zzbok.zza(zze.zzae((Object)this.mContext), this.zzana, string, this.zzboj.zzbmy, (zzgp)zzgg2, new NativeAdOptionsParcel(zzgh.zzbl(this.zzboj.zzbnn)), this.zzboj.zzbnm);
                } else {
                    this.zzbok.zza(zze.zzae((Object)this.mContext), this.zzang, this.zzana, string, this.zzboj.zzbmy, (zzgp)zzgg2);
                }
            } else {
                this.zzbok.zza(zze.zzae((Object)this.mContext), this.zzang, this.zzana, string, this.zzboj.zzbmy, (zzgp)zzgg2);
            }
        }
        catch (RemoteException remoteException) {
            zzkh.zzd((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzy(5);
        }
    }

    private long zza(long l, long l2, long l3, long l4) {
        while (this.zzbol == -2) {
            this.zzb(l, l2, l3, l4);
        }
        return zzu.zzfu().elapsedRealtime() - l;
    }

    private void zzb(long l, long l2, long l3, long l4) {
        long l5 = SystemClock.elapsedRealtime();
        long l6 = l2 - (l5 - l);
        long l7 = l4 - (l5 - l3);
        if (l6 <= 0L || l7 <= 0L) {
            zzkh.zzcx((String)"Timed out waiting for adapter.");
            this.zzbol = 3;
            return;
        }
        try {
            this.zzail.wait(Math.min(l6, l7));
        }
        catch (InterruptedException interruptedException) {
            this.zzbol = -1;
        }
    }

    private boolean zzz(int n) {
        Bundle bundle = null;
        try {
            bundle = this.zzarj ? this.zzbok.zzmt() : (this.zzang.zzauq ? this.zzbok.getInterstitialAdapterInfo() : this.zzbok.zzms());
        }
        catch (RemoteException remoteException) {
            zzkh.zzcy((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private boolean zzmm() {
        return this.zzboi.zzbnz != -1;
    }

    private String zzbk(String string) {
        if (string == null || !this.zzmm() || this.zzz(2)) {
            return string;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzkh.zzcy((String)"Could not remove field. Returning the original value");
            return string;
        }
    }

    private int zzmn() {
        JSONObject jSONObject;
        if (this.zzboj.zzbng == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzboj.zzbng);
        }
        catch (JSONException jSONException) {
            zzkh.zzcy((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzbog)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzz(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static zzgq zzaa(final int n) {
        return new zzgq.zza(){

            public int zzmo() throws RemoteException {
                return n;
            }
        };
    }

    private static NativeAdOptions zzbl(String string) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string == null) {
            return builder.build();
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string2 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation(zzgh.zzbm(string2));
        }
        catch (JSONException jSONException) {
            zzkh.zzd((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    private static int zzbm(String string) {
        if ("landscape".equals(string)) {
            return 2;
        }
        if ("portrait".equals(string)) {
            return 1;
        }
        return 0;
    }
}

