/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzhj;
import com.google.android.gms.internal.zzhk;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzll;
import java.util.Map;
import java.util.Set;

@zzir
public class zzhe
extends zzhj {
    static final Set<String> zzbqi = zzf.zzc((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzbqj = "top-right";
    private boolean zzbqk = true;
    private int zzbql = 0;
    private int zzbqm = 0;
    private int zzaif = -1;
    private int zzbqn = 0;
    private int zzbqo = 0;
    private int zzaie = -1;
    private final Object zzail = new Object();
    private final zzll zzbgj;
    private final Activity zzbpy;
    private AdSizeParcel zzang;
    private ImageView zzbqp;
    private LinearLayout zzbqq;
    private zzhk zzbqr;
    private PopupWindow zzbqs;
    private RelativeLayout zzbqt;
    private ViewGroup zzbqu;

    public zzhe(zzll zzll2, zzhk zzhk2) {
        super(zzll2, "resize");
        this.zzbgj = zzll2;
        this.zzbpy = zzll2.zzuf();
        this.zzbqr = zzhk2;
    }

    private void zzi(Map<String, String> map) {
        String string2;
        if (!TextUtils.isEmpty((CharSequence)map.get("width"))) {
            this.zzaie = zzu.zzfq().zzcq(map.get("width"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("height"))) {
            this.zzaif = zzu.zzfq().zzcq(map.get("height"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetX"))) {
            this.zzbqn = zzu.zzfq().zzcq(map.get("offsetX"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("offsetY"))) {
            this.zzbqo = zzu.zzfq().zzcq(map.get("offsetY"));
        }
        if (!TextUtils.isEmpty((CharSequence)map.get("allowOffscreen"))) {
            this.zzbqk = Boolean.parseBoolean(map.get("allowOffscreen"));
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = map.get("customClosePosition")))) {
            this.zzbqj = string2;
        }
    }

    boolean zzmw() {
        return this.zzaie > -1 && this.zzaif > -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Map<String, String> map) {
        Object object = this.zzail;
        synchronized (object) {
            Bitmap bitmap;
            if (this.zzbpy == null) {
                this.zzbu("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzbgj.zzdo() == null) {
                this.zzbu("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzbgj.zzdo().zzauq) {
                this.zzbu("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzbgj.zzuo()) {
                this.zzbu("Cannot resize an expanded banner.");
                return;
            }
            this.zzi(map);
            if (!this.zzmw()) {
                this.zzbu("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzbpy.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzbu("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzmx();
            if (nArray == null) {
                this.zzbu("Resize location out of screen or close button is not visible.");
                return;
            }
            int n = zzm.zziw().zza((Context)this.zzbpy, this.zzaie);
            int n2 = zzm.zziw().zza((Context)this.zzbpy, this.zzaif);
            ViewParent viewParent = this.zzbgj.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzbgj.getView());
                if (this.zzbqs == null) {
                    this.zzbqu = (ViewGroup)viewParent;
                    bitmap = zzu.zzfq().zzk(this.zzbgj.getView());
                    this.zzbqp = new ImageView((Context)this.zzbpy);
                    this.zzbqp.setImageBitmap(bitmap);
                    this.zzang = this.zzbgj.zzdo();
                    this.zzbqu.addView((View)this.zzbqp);
                } else {
                    this.zzbqs.dismiss();
                }
            } else {
                this.zzbu("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzbqt = new RelativeLayout((Context)this.zzbpy);
            this.zzbqt.setBackgroundColor(0);
            this.zzbqt.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            this.zzbqs = zzu.zzfq().zza((View)this.zzbqt, n, n2, false);
            this.zzbqs.setOutsideTouchable(true);
            this.zzbqs.setTouchable(true);
            this.zzbqs.setClippingEnabled(!this.zzbqk);
            this.zzbqt.addView(this.zzbgj.getView(), -1, -1);
            this.zzbqq = new LinearLayout((Context)this.zzbpy);
            bitmap = new RelativeLayout.LayoutParams(zzm.zziw().zza((Context)this.zzbpy, 50), zzm.zziw().zza((Context)this.zzbpy, 50));
            switch (this.zzbqj) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzbqq.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    zzhe.this.zzs(true);
                }
            });
            this.zzbqq.setContentDescription((CharSequence)"Close button");
            this.zzbqt.addView((View)this.zzbqq, (ViewGroup.LayoutParams)bitmap);
            try {
                this.zzbqs.showAtLocation(window.getDecorView(), 0, zzm.zziw().zza((Context)this.zzbpy, nArray[0]), zzm.zziw().zza((Context)this.zzbpy, nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(runtimeException.getMessage());
                this.zzbu(string2.length() != 0 ? "Cannot show popup window: ".concat(string2) : new String("Cannot show popup window: "));
                this.zzbqt.removeView(this.zzbgj.getView());
                if (this.zzbqu != null) {
                    this.zzbqu.removeView((View)this.zzbqp);
                    this.zzbqu.addView(this.zzbgj.getView());
                    this.zzbgj.zza(this.zzang);
                }
                return;
            }
            this.zzb(nArray[0], nArray[1]);
            this.zzbgj.zza(new AdSizeParcel((Context)this.zzbpy, new AdSize(this.zzaie, this.zzaif)));
            this.zzc(nArray[0], nArray[1]);
            this.zzbw("resized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzs(boolean bl) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzbqs != null) {
                this.zzbqs.dismiss();
                this.zzbqt.removeView(this.zzbgj.getView());
                if (this.zzbqu != null) {
                    this.zzbqu.removeView((View)this.zzbqp);
                    this.zzbqu.addView(this.zzbgj.getView());
                    this.zzbgj.zza(this.zzang);
                }
                if (bl) {
                    this.zzbw("default");
                    if (this.zzbqr != null) {
                        this.zzbqr.zzek();
                    }
                }
                this.zzbqs = null;
                this.zzbqt = null;
                this.zzbqu = null;
                this.zzbqq = null;
            }
        }
    }

    private int[] zzmx() {
        if (!this.zzmz()) {
            return null;
        }
        if (this.zzbqk) {
            return new int[]{this.zzbql + this.zzbqn, this.zzbqm + this.zzbqo};
        }
        int[] nArray = zzu.zzfq().zzi(this.zzbpy);
        int[] nArray2 = zzu.zzfq().zzk(this.zzbpy);
        int n = nArray[0];
        int n2 = this.zzbql + this.zzbqn;
        int n3 = this.zzbqm + this.zzbqo;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 + this.zzaie > n) {
            n2 = n - this.zzaie;
        }
        if (n3 < nArray2[0]) {
            n3 = nArray2[0];
        } else if (n3 + this.zzaif > nArray2[1]) {
            n3 = nArray2[1] - this.zzaif;
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(int n, int n2, boolean bl) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzbql = n;
            this.zzbqm = n2;
            if (this.zzbqs != null && bl) {
                int[] nArray = this.zzmx();
                if (nArray != null) {
                    this.zzbqs.update(zzm.zziw().zza((Context)this.zzbpy, nArray[0]), zzm.zziw().zza((Context)this.zzbpy, nArray[1]), this.zzbqs.getWidth(), this.zzbqs.getHeight());
                    this.zzc(nArray[0], nArray[1]);
                } else {
                    this.zzs(true);
                }
            }
        }
    }

    void zzb(int n, int n2) {
        if (this.zzbqr != null) {
            this.zzbqr.zza(n, n2, this.zzaie, this.zzaif);
        }
    }

    void zzc(int n, int n2) {
        int n3 = zzu.zzfq().zzk(this.zzbpy)[0];
        this.zzb(n, n2 - n3, this.zzaie, this.zzaif);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzmy() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzbqs != null;
        }
    }

    public void zzd(int n, int n2) {
        this.zzbql = n;
        this.zzbqm = n2;
    }

    boolean zzmz() {
        int[] nArray = zzu.zzfq().zzi(this.zzbpy);
        int[] nArray2 = zzu.zzfq().zzk(this.zzbpy);
        int n = nArray[0];
        int n2 = nArray[1];
        if (this.zzaie < 50 || this.zzaie > n) {
            zzkh.zzcy((String)"Width is too small or too large.");
            return false;
        }
        if (this.zzaif < 50 || this.zzaif > n2) {
            zzkh.zzcy((String)"Height is too small or too large.");
            return false;
        }
        if (this.zzaif == n2 && this.zzaie == n) {
            zzkh.zzcy((String)"Cannot resize to a full-screen ad.");
            return false;
        }
        if (this.zzbqk) {
            int n3 = -1;
            int n4 = -2;
            switch (this.zzbqj) {
                case "top-left": {
                    n3 = this.zzbql + this.zzbqn;
                    n4 = this.zzbqm + this.zzbqo;
                    break;
                }
                case "top-center": {
                    n3 = this.zzbql + this.zzbqn + this.zzaie / 2 - 25;
                    n4 = this.zzbqm + this.zzbqo;
                    break;
                }
                case "center": {
                    n3 = this.zzbql + this.zzbqn + this.zzaie / 2 - 25;
                    n4 = this.zzbqm + this.zzbqo + this.zzaif / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n3 = this.zzbql + this.zzbqn;
                    n4 = this.zzbqm + this.zzbqo + this.zzaif - 50;
                    break;
                }
                case "bottom-center": {
                    n3 = this.zzbql + this.zzbqn + this.zzaie / 2 - 25;
                    n4 = this.zzbqm + this.zzbqo + this.zzaif - 50;
                    break;
                }
                case "bottom-right": {
                    n3 = this.zzbql + this.zzbqn + this.zzaie - 50;
                    n4 = this.zzbqm + this.zzbqo + this.zzaif - 50;
                    break;
                }
                default: {
                    n3 = this.zzbql + this.zzbqn + this.zzaie - 50;
                    n4 = this.zzbqm + this.zzbqo;
                }
            }
            if (n3 < 0 || n3 + 50 > n || n4 < nArray2[0] || n4 + 50 > nArray2[1]) {
                return false;
            }
        }
        return true;
    }
}

