/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.view.View;
import android.view.WindowManager;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzll;

@zzir
@TargetApi(value=11)
public class zzls
extends WebChromeClient {
    private final zzll zzbgj;

    protected boolean zza(Context context, String string2, String string3, String string4, JsResult jsResult, JsPromptResult jsPromptResult, boolean bl) {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setTitle((CharSequence)string2);
            if (bl) {
                zzls.zza(context, builder, string3, string4, jsPromptResult);
            } else {
                zzls.zza(builder, string3, jsResult);
            }
        }
        catch (WindowManager.BadTokenException badTokenException) {
            zzkh.zzd((String)"Fail to display Dialog.", (Throwable)badTokenException);
        }
        return true;
    }

    private static void zza(AlertDialog.Builder builder, String string2, final JsResult jsResult) {
        builder.setMessage((CharSequence)string2).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                jsResult.confirm();
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                jsResult.cancel();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                jsResult.cancel();
            }
        }).create().show();
    }

    private static void zza(Context context, AlertDialog.Builder builder, String string2, String string3, final JsPromptResult jsPromptResult) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        TextView textView = new TextView(context);
        textView.setText((CharSequence)string2);
        final EditText editText = new EditText(context);
        editText.setText((CharSequence)string3);
        linearLayout.addView((View)textView);
        linearLayout.addView((View)editText);
        builder.setView((View)linearLayout).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                jsPromptResult.confirm(editText.getText().toString());
            }
        }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                jsPromptResult.cancel();
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                jsPromptResult.cancel();
            }
        }).create().show();
    }

    public zzls(zzll zzll2) {
        this.zzbgj = zzll2;
    }

    public final boolean onCreateWindow(WebView webView, boolean bl, boolean bl2, Message message) {
        WebView.WebViewTransport webViewTransport = (WebView.WebViewTransport)message.obj;
        WebView webView2 = new WebView(webView.getContext());
        webView2.setWebViewClient((WebViewClient)this.zzbgj.zzuk());
        webViewTransport.setWebView(webView2);
        message.sendToTarget();
        return true;
    }

    public final void onCloseWindow(WebView webView) {
        if (!(webView instanceof zzll)) {
            zzkh.zzcy((String)"Tried to close a WebView that wasn't an AdWebView.");
            return;
        }
        zzd zzd2 = ((zzll)webView).zzui();
        if (zzd2 == null) {
            zzkh.zzcy((String)"Tried to close an AdWebView not associated with an overlay.");
            return;
        }
        zzd2.close();
    }

    public final boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        String string2 = String.valueOf(consoleMessage.message());
        String string3 = String.valueOf(consoleMessage.sourceId());
        int n = consoleMessage.lineNumber();
        String string4 = new StringBuilder(19 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("JS: ").append(string2).append(" (").append(string3).append(":").append(n).append(")").toString();
        if (string4.contains("Application Cache")) {
            return super.onConsoleMessage(consoleMessage);
        }
        switch (consoleMessage.messageLevel()) {
            case ERROR: {
                zzkh.e((String)string4);
                break;
            }
            case WARNING: {
                zzkh.zzcy((String)string4);
                break;
            }
            case LOG: 
            case TIP: {
                zzkh.zzcx((String)string4);
                break;
            }
            case DEBUG: {
                zzkh.zzcw((String)string4);
                break;
            }
            default: {
                zzkh.zzcx((String)string4);
            }
        }
        return super.onConsoleMessage(consoleMessage);
    }

    public final void onExceededDatabaseQuota(String string2, String string3, long l, long l2, long l3, WebStorage.QuotaUpdater quotaUpdater) {
        long l4;
        long l5 = 0x500000L - l3;
        if (l5 <= 0L) {
            quotaUpdater.updateQuota(l);
            return;
        }
        if (l == 0L) {
            l4 = l2 <= l5 && l2 <= 0x100000L ? l2 : 0L;
        } else if (l2 == 0L) {
            long l6 = Math.min(131072L, l5);
            l4 = Math.min(l + l6, 0x100000L);
        } else {
            long l7 = Math.min(0x100000L - l, l5);
            l4 = l2 <= l7 ? l + l2 : l;
        }
        quotaUpdater.updateQuota(l4);
    }

    public final void onHideCustomView() {
        zzd zzd2 = this.zzbgj.zzui();
        if (zzd2 == null) {
            zzkh.zzcy((String)"Could not get ad overlay when hiding custom view.");
            return;
        }
        zzd2.zznw();
    }

    private final Context zza(WebView webView) {
        if (!(webView instanceof zzll)) {
            return webView.getContext();
        }
        zzll zzll2 = (zzll)webView;
        Activity activity = zzll2.zzuf();
        return activity != null ? activity : zzll2.getContext();
    }

    public final boolean onJsAlert(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(this.zza(webView), string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsBeforeUnload(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(this.zza(webView), string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsConfirm(WebView webView, String string2, String string3, JsResult jsResult) {
        return this.zza(this.zza(webView), string2, string3, null, jsResult, null, false);
    }

    public final boolean onJsPrompt(WebView webView, String string2, String string3, String string4, JsPromptResult jsPromptResult) {
        return this.zza(this.zza(webView), string2, string3, string4, null, jsPromptResult, true);
    }

    public final void onReachedMaxAppCacheSize(long l, long l2, WebStorage.QuotaUpdater quotaUpdater) {
        long l3 = 0x500000L - l2;
        long l4 = l + 131072L;
        if (l3 < l4) {
            quotaUpdater.updateQuota(0L);
        } else {
            quotaUpdater.updateQuota(l4);
        }
    }

    public final void onShowCustomView(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zza(view, -1, customViewCallback);
    }

    public final void onGeolocationPermissionsShowPrompt(String string2, GeolocationPermissions.Callback callback) {
        if (callback != null) {
            callback.invoke(string2, this.zzvo(), true);
        }
    }

    private final boolean zzvo() {
        return zzu.zzfq().zza(this.zzbgj.getContext().getPackageManager(), this.zzbgj.getContext().getPackageName(), "android.permission.ACCESS_FINE_LOCATION") || zzu.zzfq().zza(this.zzbgj.getContext().getPackageManager(), this.zzbgj.getContext().getPackageName(), "android.permission.ACCESS_COARSE_LOCATION");
    }

    protected final void zza(View view, int n, WebChromeClient.CustomViewCallback customViewCallback) {
        zzd zzd2 = this.zzbgj.zzui();
        if (zzd2 == null) {
            zzkh.zzcy((String)"Could not get ad overlay when showing custom view.");
            customViewCallback.onCustomViewHidden();
            return;
        }
        zzd2.zza(view, customViewCallback);
        zzd2.setRequestedOrientation(n);
    }
}

