/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.graphics.Point;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.formats.zzg;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdt;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzlh;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzin
public class zzk
extends zzdt.zza
implements View.OnClickListener,
View.OnTouchListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object zzail = new Object();
    private final FrameLayout zzbgt;
    @Nullable
    private FrameLayout zzaiz;
    private Map<String, WeakReference<View>> zzbgu = new HashMap<String, WeakReference<View>>();
    @Nullable
    private zzb zzbgv;
    @Nullable
    private zzh zzbfp;
    boolean zzbgw = false;
    int zzbgx;
    int zzbgy;

    public zzk(FrameLayout frameLayout, FrameLayout frameLayout2) {
        this.zzbgt = frameLayout;
        this.zzaiz = frameLayout2;
        zzu.zzgk().zza((View)this.zzbgt, this);
        zzu.zzgk().zza((View)this.zzbgt, this);
        this.zzbgt.setOnTouchListener((View.OnTouchListener)this);
        this.zzbgt.setOnClickListener((View.OnClickListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzc(String string, zzd zzd2) {
        View view = (View)zze.zzad((zzd)zzd2);
        Object object = this.zzail;
        synchronized (object) {
            if (view == null) {
                this.zzbgu.remove(string);
            } else {
                this.zzbgu.put(string, new WeakReference<View>(view));
                view.setOnTouchListener((View.OnTouchListener)this);
                view.setClickable(true);
                view.setOnClickListener((View.OnClickListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzd zzap(String string) {
        Object object = this.zzail;
        synchronized (object) {
            WeakReference<View> weakReference = this.zzbgu.get(string);
            return zze.zzac(weakReference == null ? null : (View)weakReference.get());
        }
    }

    void zzh(@Nullable View view) {
        zzh zzh2 = null;
        if (this.zzbfp != null && (zzh2 = this.zzbfp instanceof zzg ? ((zzg)this.zzbfp).zzla() : this.zzbfp) != null) {
            zzh2.zzh(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zze(zzd zzd2) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzh(null);
            Object object2 = zze.zzad((zzd)zzd2);
            if (!(object2 instanceof zzi)) {
                zzkd.zzcx((String)"Not an instance of native engine. This is most likely a transient error");
                return;
            }
            if (this.zzaiz != null) {
                this.zzaiz.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
                this.zzbgt.requestLayout();
            }
            this.zzbgw = true;
            final zzi zzi2 = (zzi)object2;
            if (this.zzbfp != null && zzdc.zzbch.get().booleanValue()) {
                this.zzbfp.zzb((View)this.zzbgt, this.zzbgu);
            }
            if (this.zzbfp instanceof zzg && ((zzg)this.zzbfp).zzkz()) {
                ((zzg)this.zzbfp).zzc(zzi2);
            } else {
                this.zzbfp = zzi2;
                if (zzi2 instanceof zzg) {
                    ((zzg)zzi2).zzc(null);
                }
            }
            if (zzdc.zzbch.get().booleanValue()) {
                this.zzaiz.setClickable(false);
            }
            this.zzaiz.removeAllViews();
            this.zzbgv = this.zzc(zzi2);
            if (this.zzbgv != null) {
                this.zzbgu.put("1007", new WeakReference<ViewGroup>(this.zzbgv.zzks()));
                this.zzaiz.addView((View)this.zzbgv);
            }
            zzkh.zzclc.post(new Runnable(){

                @Override
                public void run() {
                    zzlh zzlh2 = zzi2.zzlb();
                    if (zzlh2 != null && zzk.this.zzaiz != null) {
                        zzk.this.zzaiz.addView(zzlh2.getView());
                    }
                }
            });
            zzi2.zza((View)this.zzbgt, this.zzbgu, this, this);
            this.zzh((View)this.zzbgt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClick(View view) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzbfp == null) {
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (Map.Entry<String, WeakReference<View>> jSONObject3 : this.zzbgu.entrySet()) {
                View view2 = (View)jSONObject3.getValue().get();
                if (view2 == null) continue;
                Point point = this.zzi(view2);
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("width", this.zzx(view2.getWidth()));
                    jSONObject.put("height", this.zzx(view2.getHeight()));
                    jSONObject.put("x", this.zzx(point.x));
                    jSONObject.put("y", this.zzx(point.y));
                    jSONObject2.put(jSONObject3.getKey(), (Object)jSONObject);
                }
                catch (JSONException jSONException) {
                    String string = String.valueOf(jSONObject3.getKey());
                    zzkd.zzcx((String)(string.length() != 0 ? "Unable to get view rectangle for view ".concat(string) : new String("Unable to get view rectangle for view ")));
                }
            }
            JSONObject jSONObject5 = new JSONObject();
            try {
                jSONObject5.put("x", this.zzx(this.zzbgx));
                jSONObject5.put("y", this.zzx(this.zzbgy));
            }
            catch (JSONException jSONException) {
                zzkd.zzcx((String)"Unable to get click location");
            }
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("width", this.zzx(this.getMeasuredWidth()));
                jSONObject.put("height", this.zzx(this.getMeasuredHeight()));
            }
            catch (JSONException jSONException) {
                zzkd.zzcx((String)"Unable to get native ad view bounding box");
            }
            if (this.zzbgv != null && this.zzbgv.zzks().equals(view)) {
                if (this.zzbfp instanceof zzg && ((zzg)this.zzbfp).zzla() != null) {
                    ((zzg)this.zzbfp).zzla().zza("1007", jSONObject2, jSONObject5, jSONObject);
                } else {
                    this.zzbfp.zza("1007", jSONObject2, jSONObject5, jSONObject);
                }
            } else {
                this.zzbfp.zza(view, this.zzbgu, jSONObject2, jSONObject5, jSONObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGlobalLayout() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzbgw) {
                int n = this.getMeasuredWidth();
                int n2 = this.getMeasuredHeight();
                if (n != 0 && n2 != 0 && this.zzaiz != null) {
                    this.zzaiz.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
                    this.zzbgw = false;
                }
            }
            if (this.zzbfp != null) {
                this.zzbfp.zzg((View)this.zzbgt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScrollChanged() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzbfp != null) {
                this.zzbfp.zzg((View)this.zzbgt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouch(View view, MotionEvent motionEvent) {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzbfp == null) {
                return false;
            }
            Point point = this.zzc(motionEvent);
            this.zzbgx = point.x;
            this.zzbgy = point.y;
            MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
            motionEvent2.setLocation((float)point.x, (float)point.y);
            this.zzbfp.zzb(motionEvent2);
            motionEvent2.recycle();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzaiz != null) {
                this.zzaiz.removeAllViews();
            }
            this.zzaiz = null;
            this.zzbgu = null;
            this.zzbgv = null;
            this.zzbfp = null;
        }
    }

    Point zzc(MotionEvent motionEvent) {
        int[] nArray = new int[2];
        this.zzbgt.getLocationOnScreen(nArray);
        float f = motionEvent.getRawX() - (float)nArray[0];
        float f2 = motionEvent.getRawY() - (float)nArray[1];
        return new Point((int)f, (int)f2);
    }

    @Nullable
    zzb zzc(zzi zzi2) {
        return zzi2.zza(this);
    }

    int getMeasuredWidth() {
        return this.zzbgt.getMeasuredWidth();
    }

    int getMeasuredHeight() {
        return this.zzbgt.getMeasuredHeight();
    }

    int zzx(int n) {
        return zzm.zziw().zzb(this.zzbfp.getContext(), n);
    }

    Point zzi(View view) {
        if (this.zzbgv != null && this.zzbgv.zzks().equals(view)) {
            Point point = new Point();
            this.zzbgt.getGlobalVisibleRect(new Rect(), point);
            Point point2 = new Point();
            view.getGlobalVisibleRect(new Rect(), point2);
            return new Point(point2.x - point.x, point2.y - point.y);
        }
        Point point = new Point();
        view.getGlobalVisibleRect(new Rect(), point);
        return point;
    }
}

