/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdLauncherIntentInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;

@zzin
public class zza {
    public boolean zza(Context context, AdLauncherIntentInfoParcel adLauncherIntentInfoParcel, zzp zzp2) {
        String[] stringArray;
        if (adLauncherIntentInfoParcel == null) {
            zzkd.zzcx((String)"No intent data for launcher overlay.");
            return false;
        }
        if (adLauncherIntentInfoParcel.intent != null) {
            return this.zza(context, adLauncherIntentInfoParcel.intent, zzp2);
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.url)) {
            zzkd.zzcx((String)"Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.mimeType)) {
            intent.setDataAndType(Uri.parse((String)adLauncherIntentInfoParcel.url), adLauncherIntentInfoParcel.mimeType);
        } else {
            intent.setData(Uri.parse((String)adLauncherIntentInfoParcel.url));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.packageName)) {
            intent.setPackage(adLauncherIntentInfoParcel.packageName);
        }
        if (!TextUtils.isEmpty((CharSequence)adLauncherIntentInfoParcel.zzbro)) {
            stringArray = adLauncherIntentInfoParcel.zzbro.split("/", 2);
            if (stringArray.length < 2) {
                String string = String.valueOf(adLauncherIntentInfoParcel.zzbro);
                zzkd.zzcx((String)(string.length() != 0 ? "Could not parse component name from open GMSG: ".concat(string) : new String("Could not parse component name from open GMSG: ")));
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = adLauncherIntentInfoParcel.zzbrp))) {
            int n = 0;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zzkd.zzcx((String)"Could not parse intent flags.");
            }
            intent.addFlags(n);
        }
        return this.zza(context, intent, zzp2);
    }

    public boolean zza(Context context, Intent intent, zzp zzp2) {
        try {
            String string = String.valueOf(intent.toURI());
            zzkd.v(string.length() != 0 ? "Launching an intent: ".concat(string) : new String("Launching an intent: "));
            zzu.zzfq().zzb(context, intent);
            if (zzp2 != null) {
                zzp2.zzdo();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzkd.zzcx((String)activityNotFoundException.getMessage());
            return false;
        }
        return true;
    }
}

