/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.ads.internal.overlay.zzv;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzin
@TargetApi(value=14)
public class zzw
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzv.zza {
    private static final float[] zzbur = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzv zzbus;
    private final float[] zzbun;
    private final float[] zzbut;
    private final float[] zzbuu;
    private final float[] zzbuv;
    private final float[] zzbuw;
    private final float[] zzbux;
    private final float[] zzbuy;
    private float zzbuz;
    private float zzbva;
    private float zzbvb;
    private int zzaif;
    private int zzaie;
    private SurfaceTexture zzbvc;
    private SurfaceTexture zzbvd;
    private int zzbve;
    private int zzbvf;
    private int zzbvg;
    private FloatBuffer zzbvh = ByteBuffer.allocateDirect(zzbur.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzbvi;
    private final Object zzbvj;
    private EGL10 zzbvk;
    private EGLDisplay zzbvl;
    private EGLContext zzbvm;
    private EGLSurface zzbvn;
    private volatile boolean zzbvo;
    private volatile boolean zzbvp;

    zzw(Context context) {
        super("SphericalVideoProcessor");
        this.zzbvh.put(zzbur).position(0);
        this.zzbun = new float[9];
        this.zzbut = new float[9];
        this.zzbuu = new float[9];
        this.zzbuv = new float[9];
        this.zzbuw = new float[9];
        this.zzbux = new float[9];
        this.zzbuy = new float[9];
        this.zzbuz = Float.NaN;
        this.zzbus = new zzv(context);
        this.zzbus.zza(this);
        this.zzbvi = new CountDownLatch(1);
        this.zzbvj = new Object();
    }

    void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzaie = n;
        this.zzaif = n2;
        this.zzbvd = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzg(int n, int n2) {
        Object object = this.zzbvj;
        synchronized (object) {
            this.zzaie = n;
            this.zzaif = n2;
            this.zzbvo = true;
            this.zzbvj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzow() {
        Object object = this.zzbvj;
        synchronized (object) {
            this.zzbvp = true;
            this.zzbvd = null;
            this.zzbvj.notifyAll();
        }
    }

    public SurfaceTexture zzox() {
        if (this.zzbvd == null) {
            return null;
        }
        try {
            this.zzbvi.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.zzbvc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzbvg;
        Object object = this.zzbvj;
        synchronized (object) {
            this.zzbvj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zznz() {
        Object object = this.zzbvj;
        synchronized (object) {
            this.zzbvj.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl;
        if (this.zzbvd == null) {
            zzkd.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzbvi.countDown();
            return;
        }
        boolean bl2 = this.zzpc();
        int n = this.zzpa();
        boolean bl3 = bl = this.zzbve != 0;
        if (!bl2 || !bl) {
            String string = GLUtils.getEGLErrorString((int)this.zzbvk.eglGetError());
            String string2 = String.valueOf(string);
            String string3 = string2.length() != 0 ? "EGL initialization failed: ".concat(string2) : new String("EGL initialization failed: ");
            zzkd.e((String)string3);
            zzu.zzft().zzb(new Throwable(string3), true);
            this.zzpg();
            this.zzbvi.countDown();
            return;
        }
        this.zzbvc = new SurfaceTexture(n);
        this.zzbvc.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzbvi.countDown();
        this.zzbus.start();
        try {
            this.zzbvo = true;
            while (!this.zzbvp) {
                this.zzoy();
                if (this.zzbvo) {
                    this.zzoz();
                    this.zzbvo = false;
                }
                try {
                    Object object = this.zzbvj;
                    synchronized (object) {
                        if (!this.zzbvp && !this.zzbvo && this.zzbvg == 0) {
                            this.zzbvj.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            zzkd.zzcx((String)"SphericalVideoProcessor halted unexpectedly.");
        }
        catch (Throwable throwable) {
            zzkd.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzu.zzft().zzb(throwable, true);
        }
        finally {
            this.zzbus.stop();
            this.zzbvc.setOnFrameAvailableListener(null);
            this.zzbvc = null;
            this.zzpg();
        }
    }

    void zzoy() {
        while (this.zzbvg > 0) {
            this.zzbvc.updateTexImage();
            --this.zzbvg;
        }
        if (this.zzbus.zzb(this.zzbun)) {
            if (Float.isNaN(this.zzbuz)) {
                this.zzbuz = -this.zzc(this.zzbun);
            }
            this.zzb(this.zzbux, this.zzbuz + this.zzbva);
        } else {
            this.zza(this.zzbun, -1.5707964f);
            this.zzb(this.zzbux, this.zzbva);
        }
        this.zza(this.zzbut, 1.5707964f);
        this.zza(this.zzbuu, this.zzbux, this.zzbut);
        this.zza(this.zzbuv, this.zzbun, this.zzbuu);
        this.zza(this.zzbuw, this.zzbvb);
        this.zza(this.zzbuy, this.zzbuw, this.zzbuv);
        GLES20.glUniformMatrix3fv((int)this.zzbvf, (int)1, (boolean)false, (float[])this.zzbuy, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.zzbx("drawArrays");
        GLES20.glFinish();
        this.zzbvk.eglSwapBuffers(this.zzbvl, this.zzbvn);
    }

    private float zzc(float[] fArray) {
        float[] fArray2 = this.zza(fArray, new float[]{0.0f, 1.0f, 0.0f});
        return (float)Math.atan2(fArray2[1], fArray2[0]) - 1.5707964f;
    }

    void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzaie > this.zzaif) {
            f4 = 1.7453293f * f / (float)this.zzaie;
            f3 = 1.7453293f * f2 / (float)this.zzaie;
        } else {
            f4 = 1.7453293f * f / (float)this.zzaif;
            f3 = 1.7453293f * f2 / (float)this.zzaif;
        }
        this.zzbva -= f4;
        this.zzbvb -= f3;
        if (this.zzbvb < -1.5707964f) {
            this.zzbvb = -1.5707964f;
        }
        if (this.zzbvb > 1.5707964f) {
            this.zzbvb = 1.5707964f;
        }
    }

    private void zzoz() {
        GLES20.glViewport((int)0, (int)0, (int)this.zzaie, (int)this.zzaif);
        this.zzbx("viewport");
        int n = GLES20.glGetUniformLocation((int)this.zzbve, (String)"uFOVx");
        int n2 = GLES20.glGetUniformLocation((int)this.zzbve, (String)"uFOVy");
        if (this.zzaie > this.zzaif) {
            GLES20.glUniform1f((int)n, (float)0.87266463f);
            GLES20.glUniform1f((int)n2, (float)(0.87266463f * (float)this.zzaif / (float)this.zzaie));
        } else {
            GLES20.glUniform1f((int)n, (float)(0.87266463f * (float)this.zzaie / (float)this.zzaif));
            GLES20.glUniform1f((int)n2, (float)0.87266463f);
        }
    }

    private float[] zza(float[] fArray, float[] fArray2) {
        return new float[]{fArray[0] * fArray2[0] + fArray[1] * fArray2[1] + fArray[2] * fArray2[2], fArray[3] * fArray2[0] + fArray[4] * fArray2[1] + fArray[5] * fArray2[2], fArray[6] * fArray2[0] + fArray[7] * fArray2[1] + fArray[8] * fArray2[2]};
    }

    private void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    int zzpa() {
        this.zzbve = this.zzpb();
        GLES20.glUseProgram((int)this.zzbve);
        this.zzbx("useProgram");
        int n = GLES20.glGetAttribLocation((int)this.zzbve, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)this.zzbvh);
        this.zzbx("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n);
        this.zzbx("enableVertexAttribArray");
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        this.zzbx("genTextures");
        int n2 = nArray[0];
        GLES20.glBindTexture((int)36197, (int)n2);
        this.zzbx("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        this.zzbx("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        this.zzbx("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        this.zzbx("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        this.zzbx("texParameteri");
        this.zzbvf = GLES20.glGetUniformLocation((int)this.zzbve, (String)"uVMat");
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)this.zzbvf, (int)1, (boolean)false, (float[])fArray, (int)0);
        return n2;
    }

    private int zzpb() {
        int n = this.zzc(35633, this.zzpe());
        if (n == 0) {
            return 0;
        }
        int n2 = this.zzc(35632, this.zzpf());
        if (n2 == 0) {
            return 0;
        }
        int n3 = GLES20.glCreateProgram();
        this.zzbx("createProgram");
        if (n3 != 0) {
            GLES20.glAttachShader((int)n3, (int)n);
            this.zzbx("attachShader");
            GLES20.glAttachShader((int)n3, (int)n2);
            this.zzbx("attachShader");
            GLES20.glLinkProgram((int)n3);
            this.zzbx("linkProgram");
            int[] nArray = new int[1];
            GLES20.glGetProgramiv((int)n3, (int)35714, (int[])nArray, (int)0);
            this.zzbx("getProgramiv");
            if (nArray[0] != 1) {
                Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n3));
                GLES20.glDeleteProgram((int)n3);
                this.zzbx("deleteProgram");
                n3 = 0;
            } else {
                GLES20.glValidateProgram((int)n3);
                this.zzbx("validateProgram");
            }
        }
        return n3;
    }

    private int zzc(int n, String string) {
        int n2 = GLES20.glCreateShader((int)n);
        this.zzbx("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string);
            this.zzbx("shaderSource");
            GLES20.glCompileShader((int)n2);
            this.zzbx("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            this.zzbx("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                this.zzbx("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    boolean zzpc() {
        this.zzbvk = (EGL10)EGLContext.getEGL();
        this.zzbvl = this.zzbvk.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.zzbvl == EGL10.EGL_NO_DISPLAY) {
            return false;
        }
        int[] nArray = new int[2];
        if (!this.zzbvk.eglInitialize(this.zzbvl, nArray)) {
            return false;
        }
        EGLConfig eGLConfig = this.zzpd();
        if (eGLConfig == null) {
            return false;
        }
        int[] nArray2 = new int[]{12440, 2, 12344};
        this.zzbvm = this.zzbvk.eglCreateContext(this.zzbvl, eGLConfig, EGL10.EGL_NO_CONTEXT, nArray2);
        if (this.zzbvm == null || this.zzbvm == EGL10.EGL_NO_CONTEXT) {
            return false;
        }
        this.zzbvn = this.zzbvk.eglCreateWindowSurface(this.zzbvl, eGLConfig, (Object)this.zzbvd, null);
        if (this.zzbvn == null || this.zzbvn == EGL10.EGL_NO_SURFACE) {
            return false;
        }
        return this.zzbvk.eglMakeCurrent(this.zzbvl, this.zzbvn, this.zzbvn, this.zzbvm);
    }

    @Nullable
    private EGLConfig zzpd() {
        int[] nArray = new int[1];
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
        if (!this.zzbvk.eglChooseConfig(this.zzbvl, nArray2, eGLConfigArray, 1, nArray)) {
            return null;
        }
        if (nArray[0] > 0) {
            return eGLConfigArray[0];
        }
        return null;
    }

    private String zzpe() {
        zzcy<String> zzcy2 = zzdc.zzbam;
        if (!zzcy2.get().equals(zzcy2.zzjw())) {
            return zzcy2.get();
        }
        return "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
    }

    private String zzpf() {
        zzcy<String> zzcy2 = zzdc.zzban;
        if (!zzcy2.get().equals(zzcy2.zzjw())) {
            return zzcy2.get();
        }
        return "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
    }

    boolean zzpg() {
        boolean bl = false;
        if (this.zzbvn != null && this.zzbvn != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzbvk.eglMakeCurrent(this.zzbvl, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            bl |= this.zzbvk.eglDestroySurface(this.zzbvl, this.zzbvn);
            this.zzbvn = null;
        }
        if (this.zzbvm != null) {
            bl |= this.zzbvk.eglDestroyContext(this.zzbvl, this.zzbvm);
            this.zzbvm = null;
        }
        if (this.zzbvl != null) {
            bl |= this.zzbvk.eglTerminate(this.zzbvl);
            this.zzbvl = null;
        }
        return bl;
    }

    private void zzbx(String string) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string).length()).append(string).append(": glError ").append(n).toString());
        }
    }
}

