/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import com.google.android.gms.ads.internal.formats.zzd;
import com.google.android.gms.ads.internal.formats.zze;
import com.google.android.gms.ads.internal.zzf;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzge;
import com.google.android.gms.internal.zzgn;
import com.google.android.gms.internal.zzgo;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzlh;
import com.google.android.gms.internal.zzli;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzin
public class zzn {
    @Nullable
    public static View zzf(@Nullable zzju zzju2) {
        if (zzju2 == null) {
            zzkd.e((String)"AdState is null");
            return null;
        }
        if (zzn.zzg(zzju2) && zzju2.zzbtm != null) {
            return zzju2.zzbtm.getView();
        }
        try {
            com.google.android.gms.dynamic.zzd zzd2;
            com.google.android.gms.dynamic.zzd zzd3 = zzd2 = zzju2.zzboo != null ? zzju2.zzboo.getView() : null;
            if (zzd2 == null) {
                zzkd.zzcx((String)"View in mediation adapter is null.");
                return null;
            }
            return (View)com.google.android.gms.dynamic.zze.zzad((com.google.android.gms.dynamic.zzd)zzd2);
        }
        catch (RemoteException remoteException) {
            zzkd.zzd((String)"Could not get View from mediation adapter.", (Throwable)remoteException);
            return null;
        }
    }

    public static void zza(@Nullable zzju zzju2, zzf.zza zza2) {
        if (zzju2 != null && zzn.zzg(zzju2)) {
            View view;
            zzlh zzlh2 = zzju2.zzbtm;
            View view2 = view = zzlh2 != null ? zzlh2.getView() : null;
            if (view == null) {
                zzkd.zzcx((String)"AdWebView is null");
                return;
            }
            try {
                zzgo zzgo2;
                List<String> list;
                List<String> list2 = list = zzju2.zzbon != null ? zzju2.zzbon.zzbni : null;
                if (list == null || list.isEmpty()) {
                    zzkd.zzcx((String)"No template ids present in mediation response");
                    return;
                }
                zzgn zzgn2 = zzju2.zzboo != null ? zzju2.zzboo.zzmo() : null;
                zzgo zzgo3 = zzgo2 = zzju2.zzboo != null ? zzju2.zzboo.zzmp() : null;
                if (list.contains("2") && zzgn2 != null) {
                    zzgn2.zzl(com.google.android.gms.dynamic.zze.zzac((Object)view));
                    if (!zzgn2.getOverrideImpressionRecording()) {
                        zzgn2.recordImpression();
                    }
                    zzlh2.zzuj().zza("/nativeExpressViewClicked", zzn.zza(zzgn2, null, zza2));
                } else if (list.contains("1") && zzgo2 != null) {
                    zzgo2.zzl(com.google.android.gms.dynamic.zze.zzac((Object)view));
                    if (!zzgo2.getOverrideImpressionRecording()) {
                        zzgo2.recordImpression();
                    }
                    zzlh2.zzuj().zza("/nativeExpressViewClicked", zzn.zza(null, zzgo2, zza2));
                } else {
                    zzkd.zzcx((String)"No matching template id and mapper");
                }
            }
            catch (RemoteException remoteException) {
                zzkd.zzd((String)"Error occurred while recording impression and registering for clicks", (Throwable)remoteException);
                return;
            }
        }
    }

    public static boolean zza(zzlh zzlh2, zzge zzge2, CountDownLatch countDownLatch) {
        boolean bl = false;
        try {
            bl = zzn.zzb(zzlh2, zzge2, countDownLatch);
        }
        catch (RemoteException remoteException) {
            zzkd.zzd((String)"Unable to invoke load assets", (Throwable)remoteException);
        }
        catch (RuntimeException runtimeException) {
            countDownLatch.countDown();
            throw runtimeException;
        }
        if (!bl) {
            countDownLatch.countDown();
        }
        return bl;
    }

    private static boolean zzb(zzlh zzlh2, zzge zzge2, CountDownLatch countDownLatch) throws RemoteException {
        Object object;
        View view = zzlh2.getView();
        if (view == null) {
            zzkd.zzcx((String)"AdWebView is null");
            return false;
        }
        view.setVisibility(4);
        List<String> list = zzge2.zzbon.zzbni;
        if (list == null || list.isEmpty()) {
            zzkd.zzcx((String)"No template ids present in mediation response");
            return false;
        }
        zzn.zza(zzlh2, countDownLatch);
        zzgn zzgn2 = zzge2.zzboo.zzmo();
        zzgo zzgo2 = zzge2.zzboo.zzmp();
        if (list.contains("2") && zzgn2 != null) {
            object = zzn.zza(zzgn2);
            zzn.zza(zzlh2, object, zzge2.zzbon.zzbnh);
        } else if (list.contains("1") && zzgo2 != null) {
            object = zzn.zza(zzgo2);
            zzn.zza(zzlh2, (zze)object, zzge2.zzbon.zzbnh);
        } else {
            zzkd.zzcx((String)"No matching template id and mapper");
            return false;
        }
        object = zzge2.zzbon.zzbnf;
        String string = zzge2.zzbon.zzbng;
        if (string != null) {
            zzlh2.loadDataWithBaseURL(string, (String)object, "text/html", "UTF-8", null);
        } else {
            zzlh2.loadData((String)object, "text/html", "UTF-8");
        }
        return true;
    }

    public static boolean zzg(@Nullable zzju zzju2) {
        return zzju2 != null && zzju2.zzcby && zzju2.zzbon != null && zzju2.zzbon.zzbnf != null;
    }

    private static zzd zza(zzgn zzgn2) throws RemoteException {
        return new zzd(zzgn2.getHeadline(), zzgn2.getImages(), zzgn2.getBody(), zzgn2.zzku(), zzgn2.getCallToAction(), zzgn2.getStarRating(), zzgn2.getStore(), zzgn2.getPrice(), null, zzgn2.getExtras());
    }

    private static zze zza(zzgo zzgo2) throws RemoteException {
        return new zze(zzgo2.getHeadline(), zzgo2.getImages(), zzgo2.getBody(), zzgo2.zzky(), zzgo2.getCallToAction(), zzgo2.getAdvertiser(), null, zzgo2.getExtras());
    }

    private static void zza(final zzlh zzlh2, final zzd zzd2, final String string) {
        zzlh2.zzuj().zza(new zzli.zza(){

            @Override
            public void zza(zzlh zzlh22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zzd2.getHeadline());
                    jSONObject.put("body", (Object)zzd2.getBody());
                    jSONObject.put("call_to_action", (Object)zzd2.getCallToAction());
                    jSONObject.put("price", (Object)zzd2.getPrice());
                    jSONObject.put("star_rating", (Object)String.valueOf(zzd2.getStarRating()));
                    jSONObject.put("store", (Object)zzd2.getStore());
                    jSONObject.put("icon", (Object)zzn.zza(zzd2.zzku()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zzd2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzdr zzdr2 = zzn.zze(e);
                            jSONArray.put((Object)zzn.zza(zzdr2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzn.zza(zzd2.getExtras(), string));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"2");
                    zzlh2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzkd.zzd((String)"Exception occurred when loading assets", (Throwable)jSONException);
                }
            }
        });
    }

    private static void zza(final zzlh zzlh2, final zze zze2, final String string) {
        zzlh2.zzuj().zza(new zzli.zza(){

            @Override
            public void zza(zzlh zzlh22, boolean bl) {
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("headline", (Object)zze2.getHeadline());
                    jSONObject.put("body", (Object)zze2.getBody());
                    jSONObject.put("call_to_action", (Object)zze2.getCallToAction());
                    jSONObject.put("advertiser", (Object)zze2.getAdvertiser());
                    jSONObject.put("logo", (Object)zzn.zza(zze2.zzky()));
                    JSONArray jSONArray = new JSONArray();
                    List list = zze2.getImages();
                    if (list != null) {
                        for (Object e : list) {
                            zzdr zzdr2 = zzn.zze(e);
                            jSONArray.put((Object)zzn.zza(zzdr2));
                        }
                    }
                    jSONObject.put("images", (Object)jSONArray);
                    jSONObject.put("extras", (Object)zzn.zza(zze2.getExtras(), string));
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("assets", (Object)jSONObject);
                    jSONObject2.put("template_id", (Object)"1");
                    zzlh2.zza("google.afma.nativeExpressAds.loadAssets", jSONObject2);
                }
                catch (JSONException jSONException) {
                    zzkd.zzd((String)"Exception occurred when loading assets", (Throwable)jSONException);
                }
            }
        });
    }

    private static void zza(zzlh zzlh2, CountDownLatch countDownLatch) {
        zzlh2.zzuj().zza("/nativeExpressAssetsLoaded", zzn.zza(countDownLatch));
        zzlh2.zzuj().zza("/nativeExpressAssetsLoadingFailed", zzn.zzb(countDownLatch));
    }

    static zzep zza(final CountDownLatch countDownLatch) {
        return new zzep(){

            @Override
            public void zza(zzlh zzlh2, Map<String, String> map) {
                countDownLatch.countDown();
                zzlh2.getView().setVisibility(0);
            }
        };
    }

    static zzep zzb(final CountDownLatch countDownLatch) {
        return new zzep(){

            @Override
            public void zza(zzlh zzlh2, Map<String, String> map) {
                zzkd.zzcx((String)"Adapter returned an ad, but assets substitution failed");
                countDownLatch.countDown();
                zzlh2.destroy();
            }
        };
    }

    static zzep zza(final @Nullable zzgn zzgn2, final @Nullable zzgo zzgo2, final zzf.zza zza2) {
        return new zzep(){

            @Override
            public void zza(zzlh zzlh2, Map<String, String> map) {
                View view = zzlh2.getView();
                if (view == null) {
                    return;
                }
                try {
                    if (zzgn2 != null) {
                        if (!zzgn2.getOverrideClickHandling()) {
                            zzgn2.zzk(com.google.android.gms.dynamic.zze.zzac((Object)view));
                            zza2.onClick();
                        } else {
                            zzn.zza(zzlh2);
                        }
                    } else if (zzgo2 != null) {
                        if (!zzgo2.getOverrideClickHandling()) {
                            zzgo2.zzk(com.google.android.gms.dynamic.zze.zzac((Object)view));
                            zza2.onClick();
                        } else {
                            zzn.zza(zzlh2);
                        }
                    }
                }
                catch (RemoteException remoteException) {
                    zzkd.zzd((String)"Unable to call handleClick on mapper", (Throwable)remoteException);
                }
            }
        };
    }

    private static void zza(zzlh zzlh2) {
        View.OnClickListener onClickListener = zzlh2.zzuw();
        if (onClickListener != null) {
            onClickListener.onClick(zzlh2.getView());
        }
    }

    private static JSONObject zza(@Nullable Bundle bundle, String string) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (bundle == null || TextUtils.isEmpty((CharSequence)string)) {
            return jSONObject;
        }
        JSONObject jSONObject2 = new JSONObject(string);
        Iterator iterator = jSONObject2.keys();
        while (iterator.hasNext()) {
            Object object;
            String string2 = (String)iterator.next();
            if (!bundle.containsKey(string2)) continue;
            String string3 = jSONObject2.getString(string2);
            if ("image".equals(string3)) {
                object = bundle.get(string2);
                if (object instanceof Bitmap) {
                    String string4 = zzn.zza((Bitmap)object);
                    jSONObject.put(string2, (Object)string4);
                    continue;
                }
                zzkd.zzcx((String)"Invalid type. An image type extra should return a bitmap");
                continue;
            }
            object = bundle.get(string2);
            if (object instanceof Bitmap) {
                zzkd.zzcx((String)"Invalid asset type. Bitmap should be returned only for image type");
                continue;
            }
            jSONObject.put(string2, (Object)String.valueOf(bundle.get(string2)));
        }
        return jSONObject;
    }

    static String zza(@Nullable zzdr zzdr2) {
        if (zzdr2 == null) {
            zzkd.zzcx((String)"Image is null. Returning empty string");
            return "";
        }
        Uri uri = null;
        try {
            uri = zzdr2.getUri();
            if (uri != null) {
                return uri.toString();
            }
        }
        catch (RemoteException remoteException) {
            zzkd.zzcx((String)"Unable to get image uri. Trying data uri next");
        }
        return zzn.zzb(zzdr2);
    }

    private static String zzb(zzdr zzdr2) {
        com.google.android.gms.dynamic.zzd zzd2;
        Drawable drawable2 = null;
        try {
            zzd2 = zzdr2.zzkt();
            if (zzd2 == null) {
                zzkd.zzcx((String)"Drawable is null. Returning empty string");
                return "";
            }
            drawable2 = (Drawable)com.google.android.gms.dynamic.zze.zzad((com.google.android.gms.dynamic.zzd)zzd2);
        }
        catch (RemoteException remoteException) {
            zzkd.zzcx((String)"Unable to get drawable. Returning empty string");
            return "";
        }
        if (!(drawable2 instanceof BitmapDrawable)) {
            zzkd.zzcx((String)"Drawable is not an instance of BitmapDrawable. Returning empty string");
            return "";
        }
        zzd2 = (BitmapDrawable)drawable2;
        Bitmap bitmap = zzd2.getBitmap();
        return zzn.zza(bitmap);
    }

    private static String zza(@Nullable Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bitmap == null) {
            zzkd.zzcx((String)"Bitmap is null. Returning empty string");
            return "";
        }
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        String string = Base64.encodeToString((byte[])byArray, (int)0);
        String string2 = String.valueOf("data:image/png;base64,");
        String string3 = String.valueOf(string);
        return string3.length() != 0 ? string2.concat(string3) : new String(string2);
    }

    @Nullable
    private static zzdr zze(Object object) {
        if (object instanceof IBinder) {
            return zzdr.zza.zzy((IBinder)((IBinder)object));
        }
        return null;
    }
}

