/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.VideoOptionsParcel;
import com.google.android.gms.ads.internal.client.zzab;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzp;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.client.zzw;
import com.google.android.gms.ads.internal.client.zzy;
import com.google.android.gms.ads.internal.reward.client.zzd;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzbw;
import com.google.android.gms.internal.zzbx;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdo;
import com.google.android.gms.internal.zzho;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkg;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzin
public class zzt
extends zzu.zza {
    private final VersionInfoParcel zzalo;
    private final AdSizeParcel zzani;
    private final Future<zzbw> zzanj;
    private final Context mContext;
    private final zzb zzank;
    @Nullable
    private WebView zzanl;
    @Nullable
    private zzq zzalf;
    @Nullable
    private zzbw zzanm;
    private AsyncTask<Void, Void, Void> zzann;

    public zzt(Context context, AdSizeParcel adSizeParcel, String string, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzalo = versionInfoParcel;
        this.zzani = adSizeParcel;
        this.zzanl = new WebView(this.mContext);
        this.zzanj = this.zzfg();
        this.zzank = new zzb(string);
        this.zzfd();
    }

    public com.google.android.gms.dynamic.zzd zzdm() throws RemoteException {
        com.google.android.gms.common.internal.zzab.zzhi((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzac((Object)this.zzanl);
    }

    public void destroy() throws RemoteException {
        com.google.android.gms.common.internal.zzab.zzhi((String)"destroy must be called on the main UI thread.");
        this.zzann.cancel(true);
        this.zzanj.cancel(true);
        this.zzanl.destroy();
        this.zzanl = null;
    }

    public boolean isReady() throws RemoteException {
        return false;
    }

    public boolean zzb(AdRequestParcel adRequestParcel) throws RemoteException {
        com.google.android.gms.common.internal.zzab.zzb((Object)this.zzanl, (Object)"This Search Ad has already been torn down");
        this.zzank.zzh(adRequestParcel);
        this.zzann = new zza().execute(new Void[0]);
        return true;
    }

    public void pause() throws RemoteException {
        com.google.android.gms.common.internal.zzab.zzhi((String)"pause must be called on the main UI thread.");
    }

    public void resume() throws RemoteException {
        com.google.android.gms.common.internal.zzab.zzhi((String)"resume must be called on the main UI thread.");
    }

    public void zza(zzq zzq2) throws RemoteException {
        this.zzalf = zzq2;
    }

    public void zza(zzw zzw2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void showInterstitial() throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void stopLoading() throws RemoteException {
    }

    public void zzdp() throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public AdSizeParcel zzdn() throws RemoteException {
        return this.zzani;
    }

    public void zza(AdSizeParcel adSizeParcel) throws RemoteException {
        throw new IllegalStateException("AdSize must be set before initialization");
    }

    public void zza(zzho zzho2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void zza(zzhs zzhs2, String string) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    @Nullable
    public String getMediationAdapterClassName() throws RemoteException {
        return null;
    }

    public void zza(zzdo zzdo2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void zza(zzp zzp2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void zza(zzy zzy2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void setManualImpressionsEnabled(boolean bl) throws RemoteException {
    }

    public boolean isLoading() throws RemoteException {
        return false;
    }

    public void zza(zzd zzd2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void setUserId(String string) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    @Nullable
    public zzab zzdq() {
        return null;
    }

    public void zza(VideoOptionsParcel videoOptionsParcel) {
        throw new IllegalStateException("Unused method");
    }

    private void zzfd() {
        this.zzj(0);
        this.zzanl.setVerticalScrollBarEnabled(false);
        this.zzanl.getSettings().setJavaScriptEnabled(true);
        this.zzanl.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView webView, String string) {
                if (string.startsWith(zzt.this.zzff())) {
                    return false;
                }
                if (string.startsWith(zzdc.zzbcy.get())) {
                    if (zzt.this.zzalf != null) {
                        try {
                            zzt.this.zzalf.onAdFailedToLoad(3);
                        }
                        catch (RemoteException remoteException) {
                            zzkd.zzd((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
                        }
                    }
                    zzt.this.zzj(0);
                    return true;
                }
                if (string.startsWith(zzdc.zzbcz.get())) {
                    if (zzt.this.zzalf != null) {
                        try {
                            zzt.this.zzalf.onAdFailedToLoad(0);
                        }
                        catch (RemoteException remoteException) {
                            zzkd.zzd((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
                        }
                    }
                    zzt.this.zzj(0);
                    return true;
                }
                if (string.startsWith(zzdc.zzbda.get())) {
                    if (zzt.this.zzalf != null) {
                        try {
                            zzt.this.zzalf.onAdLoaded();
                        }
                        catch (RemoteException remoteException) {
                            zzkd.zzd((String)"Could not call AdListener.onAdLoaded().", (Throwable)remoteException);
                        }
                    }
                    int n = zzt.this.zzw(string);
                    zzt.this.zzj(n);
                    return true;
                }
                if (string.startsWith("gmsg://")) {
                    return true;
                }
                if (zzt.this.zzalf != null) {
                    try {
                        zzt.this.zzalf.onAdLeftApplication();
                    }
                    catch (RemoteException remoteException) {
                        zzkd.zzd((String)"Could not call AdListener.onAdLeftApplication().", (Throwable)remoteException);
                    }
                }
                String string2 = zzt.this.zzx(string);
                zzt.this.zzy(string2);
                return true;
            }

            public void onReceivedError(WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
                if (zzt.this.zzalf != null) {
                    try {
                        zzt.this.zzalf.onAdFailedToLoad(0);
                    }
                    catch (RemoteException remoteException) {
                        zzkd.zzd((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
                    }
                }
            }
        });
        this.zzanl.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (zzt.this.zzanm != null) {
                    try {
                        zzt.this.zzanm.zza(motionEvent);
                    }
                    catch (RemoteException remoteException) {
                        zzkd.zzd((String)"Unable to process ad data", (Throwable)remoteException);
                    }
                }
                return false;
            }
        });
    }

    int zzw(String string) {
        String string2 = Uri.parse((String)string).getQueryParameter("height");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return 0;
        }
        try {
            return zzm.zziw().zza(this.mContext, Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    void zzj(int n) {
        if (this.zzanl == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, n);
        this.zzanl.setLayoutParams(layoutParams);
    }

    String zzfe() {
        String string2;
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https://").appendEncodedPath(zzdc.zzbdb.get());
        builder.appendQueryParameter("query", this.zzank.getQuery());
        builder.appendQueryParameter("pubId", this.zzank.zzfj());
        Map<String, String> map = this.zzank.zzfk();
        for (String string2 : map.keySet()) {
            builder.appendQueryParameter(string2, map.get(string2));
        }
        Uri uri = builder.build();
        if (this.zzanm != null) {
            try {
                uri = this.zzanm.zzc(uri, this.mContext);
            }
            catch (RemoteException | zzbx throwable) {
                zzkd.zzd((String)"Unable to process ad data", (Throwable)throwable);
            }
        }
        string2 = String.valueOf(this.zzff());
        String string3 = String.valueOf(uri.getEncodedQuery());
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("#").append(string3).toString();
    }

    String zzff() {
        String string = this.zzank.zzfi();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = "www.google.com";
        }
        String string2 = String.valueOf("https://");
        String string3 = string;
        String string4 = zzdc.zzbdb.get();
        return new StringBuilder(0 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append(string3).append(string4).toString();
    }

    private String zzx(String string) {
        if (this.zzanm == null) {
            return string;
        }
        Uri uri = Uri.parse((String)string);
        try {
            uri = this.zzanm.zzd(uri, this.mContext);
        }
        catch (RemoteException remoteException) {
            zzkd.zzd((String)"Unable to process ad data", (Throwable)remoteException);
        }
        catch (zzbx zzbx2) {
            zzkd.zzd((String)"Unable to parse ad click url", (Throwable)zzbx2);
        }
        return uri.toString();
    }

    private void zzy(String string) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)string));
        this.mContext.startActivity(intent);
    }

    private Future<zzbw> zzfg() {
        return zzkg.zza(new Callable<zzbw>(){

            public zzbw zzfh() throws Exception {
                return new zzbw(((zzt)zzt.this).zzalo.zzcs, zzt.this.mContext, false);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzfh();
            }
        });
    }

    private static class zzb {
        private final String zzanp;
        private final Map<String, String> zzanq;
        private String zzanr;
        private String zzans;

        public zzb(String string) {
            this.zzanp = string;
            this.zzanq = new TreeMap<String, String>();
        }

        public String zzfi() {
            return this.zzans;
        }

        public String getQuery() {
            return this.zzanr;
        }

        public String zzfj() {
            return this.zzanp;
        }

        public Map<String, String> zzfk() {
            return this.zzanq;
        }

        public void zzh(AdRequestParcel adRequestParcel) {
            this.zzanr = adRequestParcel.zzatt.zzaxl;
            Bundle bundle = null;
            if (adRequestParcel.zzatw != null) {
                bundle = adRequestParcel.zzatw.getBundle(AdMobAdapter.class.getName());
            }
            if (bundle == null) {
                return;
            }
            String string = zzdc.zzbdc.get();
            for (String string2 : bundle.keySet()) {
                if (string.equals(string2)) {
                    this.zzans = bundle.getString(string2);
                    continue;
                }
                if (!string2.startsWith("csa_")) continue;
                this.zzanq.put(string2.substring("csa_".length()), bundle.getString(string2));
            }
        }
    }

    private class zza
    extends AsyncTask<Void, Void, Void> {
        private zza() {
        }

        protected Void doInBackground(Void ... voidArray) {
            try {
                zzt.this.zzanm = (zzbw)zzt.this.zzanj.get(zzdc.zzbdd.get(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException exception) {
                zzkd.zzd((String)"Failed to load ad data", (Throwable)exception);
            }
            catch (TimeoutException timeoutException) {
                zzkd.zzcx((String)"Timed out waiting for ad data");
            }
            return null;
        }

        protected void onPostExecute(Void void_) {
            String string = zzt.this.zzfe();
            if (zzt.this.zzanl != null) {
                zzt.this.zzanl.loadUrl(string);
            }
        }
    }
}

