/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzce;
import com.google.android.gms.internal.zzcf;
import com.google.android.gms.internal.zzch;
import com.google.android.gms.internal.zzck;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzju;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzlh;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzin
public abstract class zzcd
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    protected final Object zzail = new Object();
    private final WeakReference<zzju> zzaqh;
    private WeakReference<ViewTreeObserver> zzaqi;
    private final zzck zzaqj;
    protected final zzcf zzaqk;
    private final Context zzaql;
    private final WindowManager zzaqm;
    private final PowerManager zzaqn;
    private final KeyguardManager zzaqo;
    @Nullable
    private zzch zzaqp;
    private boolean zzaqq;
    private boolean zzane = false;
    private boolean zzaqr = false;
    private boolean zzaqs;
    private boolean zzaqt;
    private boolean zzaqu;
    @Nullable
    BroadcastReceiver zzaqv;
    private final HashSet<zzce> zzaqw = new HashSet();
    private zzkr zzaqb;
    private final zzep zzaqx = new zzep(){

        @Override
        public void zza(zzlh zzlh2, Map<String, String> map) {
            if (!zzcd.this.zzb(map)) {
                return;
            }
            zzcd.this.zza(zzlh2.getView(), map);
        }
    };
    private final zzep zzaqy = new zzep(){

        @Override
        public void zza(zzlh zzlh2, Map<String, String> map) {
            if (!zzcd.this.zzb(map)) {
                return;
            }
            String string2 = String.valueOf(zzcd.this.zzaqk.zzhn());
            zzkd.zzcv((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
            zzcd.this.destroy();
        }
    };
    private final zzep zzaqz = new zzep(){

        @Override
        public void zza(zzlh zzlh2, Map<String, String> map) {
            if (!zzcd.this.zzb(map)) {
                return;
            }
            if (!map.containsKey("isVisible")) {
                return;
            }
            Boolean bl = "1".equals(map.get("isVisible")) || "true".equals(map.get("isVisible"));
            zzcd.this.zzj(bl);
        }
    };

    public zzcd(Context context, AdSizeParcel adSizeParcel, zzju zzju2, VersionInfoParcel versionInfoParcel, zzck zzck2) {
        this.zzaqh = new WeakReference<zzju>(zzju2);
        this.zzaqj = zzck2;
        this.zzaqi = new WeakReference<Object>(null);
        this.zzaqs = true;
        this.zzaqu = false;
        this.zzaqb = new zzkr(200L);
        this.zzaqk = new zzcf(UUID.randomUUID().toString(), versionInfoParcel, adSizeParcel.zzaur, zzju2.zzcie, zzju2.zzho(), adSizeParcel.zzauu);
        this.zzaqm = (WindowManager)context.getSystemService("window");
        this.zzaqn = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzaqo = (KeyguardManager)context.getSystemService("keyguard");
        this.zzaql = context;
    }

    public void zza(zzce zzce2) {
        this.zzaqw.add(zzce2);
    }

    protected void zzj(boolean bl) {
        for (zzce zzce2 : this.zzaqw) {
            zzce2.zza(this, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzgw() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzaqv != null) {
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            this.zzaqv = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    zzcd.this.zzk(3);
                }
            };
            this.zzaql.registerReceiver(this.zzaqv, intentFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzgx() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzaqv != null) {
                try {
                    this.zzaql.unregisterReceiver(this.zzaqv);
                }
                catch (IllegalStateException illegalStateException) {
                    zzkd.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                }
                catch (Exception exception) {
                    zzu.zzft().zzb(exception, true);
                }
                this.zzaqv = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzhc();
            this.zzgx();
            this.zzaqs = false;
            this.zzgz();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzgy() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.zzaqs) {
                this.zzaqt = true;
                try {
                    JSONObject jSONObject = this.zzhg();
                    this.zza(jSONObject);
                }
                catch (JSONException jSONException) {
                    zzkd.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzkd.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzaqk.zzhn());
                zzkd.zzcv((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
        }
    }

    protected void zza(View view, Map<String, String> map) {
        this.zzk(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zzk(int n) {
        Object object = this.zzail;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            if (!this.zzhe() || !this.zzaqs) {
                return;
            }
            View view = this.zzaqj.zzhh();
            this.zzaqu = bl2 = view != null && zzu.zzfq().zza(view, this.zzaqn, this.zzaqo) && view.getGlobalVisibleRect(new Rect(), null);
            boolean bl3 = this.zzaqj.zzhi();
            if (bl3) {
                this.zzgy();
                return;
            }
            boolean bl4 = bl = n == 1;
            if (bl && !this.zzaqb.tryAcquire() && bl2 == this.zzaqu) {
                return;
            }
            if (!bl2 && !this.zzaqu && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zzd(view);
                this.zza(jSONObject);
            }
            catch (RuntimeException | JSONException throwable) {
                zzkd.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            this.zzhb();
            this.zzgz();
        }
    }

    protected void zzgz() {
        if (this.zzaqp != null) {
            this.zzaqp.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzha() {
        Object object = this.zzail;
        synchronized (object) {
            return this.zzaqs;
        }
    }

    protected int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    protected void zzhb() {
        zzck zzck2 = this.zzaqj.zzhj();
        View view = zzck2.zzhh();
        if (view == null) {
            return;
        }
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzaqi.get();
        ViewTreeObserver viewTreeObserver2 = view.getViewTreeObserver();
        if (viewTreeObserver2 == viewTreeObserver) {
            return;
        }
        this.zzhc();
        if (!this.zzaqq || viewTreeObserver != null && viewTreeObserver.isAlive()) {
            this.zzaqq = true;
            viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzaqi = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
    }

    protected boolean zzb(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzaqk.zzhn());
    }

    protected void zzc(zzft zzft2) {
        zzft2.zza("/updateActiveView", this.zzaqx);
        zzft2.zza("/untrackActiveViewUnit", this.zzaqy);
        zzft2.zza("/visibilityChanged", this.zzaqz);
    }

    protected void zzd(zzft zzft2) {
        zzft2.zzb("/visibilityChanged", this.zzaqz);
        zzft2.zzb("/untrackActiveViewUnit", this.zzaqy);
        zzft2.zzb("/updateActiveView", this.zzaqx);
    }

    protected void zzhc() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzaqi.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected JSONObject zzhd() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("afmaVersion", (Object)this.zzaqk.zzhl()).put("activeViewJSON", (Object)this.zzaqk.zzhm()).put("timestamp", zzu.zzfu().elapsedRealtime()).put("adFormat", (Object)this.zzaqk.zzhk()).put("hashCode", (Object)this.zzaqk.zzhn()).put("isMraid", this.zzaqk.zzho()).put("isStopped", this.zzaqr).put("isPaused", this.zzane).put("isScreenOn", this.isScreenOn()).put("isNative", this.zzaqk.zzhp());
        return jSONObject;
    }

    protected void zza(JSONObject jSONObject) {
        try {
            JSONArray jSONArray = new JSONArray();
            JSONObject jSONObject2 = new JSONObject();
            jSONArray.put((Object)jSONObject);
            jSONObject2.put("units", (Object)jSONArray);
            this.zzb(jSONObject2);
        }
        catch (Throwable throwable) {
            zzkd.zzb((String)"Skipping active view message.", (Throwable)throwable);
        }
    }

    protected abstract void zzb(JSONObject var1);

    protected abstract boolean zzhe();

    protected JSONObject zzhf() throws JSONException {
        return this.zzhd().put("isAttachedToWindow", false).put("isScreenOn", this.isScreenOn()).put("isVisible", false);
    }

    protected JSONObject zzd(@Nullable View view) throws JSONException {
        if (view == null) {
            return this.zzhf();
        }
        boolean bl = zzu.zzfs().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzkd.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        Rect rect = new Rect();
        rect.left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        rect2.right = this.zzaqm.getDefaultDisplay().getWidth();
        rect2.bottom = this.zzaqm.getDefaultDisplay().getHeight();
        Rect rect3 = new Rect();
        boolean bl2 = view.getGlobalVisibleRect(rect3, null);
        Rect rect4 = new Rect();
        boolean bl3 = view.getLocalVisibleRect(rect4);
        Rect rect5 = new Rect();
        view.getHitRect(rect5);
        JSONObject jSONObject = this.zzhd();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl).put("viewBox", (Object)new JSONObject().put("top", this.zza(rect2.top, displayMetrics)).put("bottom", this.zza(rect2.bottom, displayMetrics)).put("left", this.zza(rect2.left, displayMetrics)).put("right", this.zza(rect2.right, displayMetrics))).put("adBox", (Object)new JSONObject().put("top", this.zza(rect.top, displayMetrics)).put("bottom", this.zza(rect.bottom, displayMetrics)).put("left", this.zza(rect.left, displayMetrics)).put("right", this.zza(rect.right, displayMetrics))).put("globalVisibleBox", (Object)new JSONObject().put("top", this.zza(rect3.top, displayMetrics)).put("bottom", this.zza(rect3.bottom, displayMetrics)).put("left", this.zza(rect3.left, displayMetrics)).put("right", this.zza(rect3.right, displayMetrics))).put("globalVisibleBoxVisible", bl2).put("localVisibleBox", (Object)new JSONObject().put("top", this.zza(rect4.top, displayMetrics)).put("bottom", this.zza(rect4.bottom, displayMetrics)).put("left", this.zza(rect4.left, displayMetrics)).put("right", this.zza(rect4.right, displayMetrics))).put("localVisibleBoxVisible", bl3).put("hitBox", (Object)new JSONObject().put("top", this.zza(rect5.top, displayMetrics)).put("bottom", this.zza(rect5.bottom, displayMetrics)).put("left", this.zza(rect5.left, displayMetrics)).put("right", this.zza(rect5.right, displayMetrics))).put("screenDensity", (double)displayMetrics.density).put("isVisible", zzu.zzfq().zza(view, this.zzaqn, this.zzaqo));
        return jSONObject;
    }

    boolean isScreenOn() {
        return this.zzaqn.isScreenOn();
    }

    protected JSONObject zzhg() throws JSONException {
        JSONObject jSONObject = this.zzhd();
        jSONObject.put("doneReasonCode", (Object)"u");
        return jSONObject;
    }

    public void onScrollChanged() {
        this.zzk(1);
    }

    public void onGlobalLayout() {
        this.zzk(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(zzch zzch2) {
        Object object = this.zzail;
        synchronized (object) {
            this.zzaqp = zzch2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzaqr = true;
            this.zzk(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzane = true;
            this.zzk(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzane = false;
            this.zzk(3);
        }
    }

    public static class zzb
    implements zzck {
        private zzh zzarc;

        public zzb(zzh zzh2) {
            this.zzarc = zzh2;
        }

        @Override
        public View zzhh() {
            return this.zzarc.zzlc();
        }

        @Override
        public boolean zzhi() {
            return this.zzarc == null;
        }

        @Override
        public zzck zzhj() {
            return this;
        }
    }

    public static class zza
    implements zzck {
        private WeakReference<zzh> zzarb;

        public zza(zzh zzh2) {
            this.zzarb = new WeakReference<zzh>(zzh2);
        }

        @Override
        @Nullable
        public View zzhh() {
            zzh zzh2 = (zzh)this.zzarb.get();
            return zzh2 != null ? zzh2.zzlc() : null;
        }

        @Override
        public boolean zzhi() {
            return this.zzarb.get() == null;
        }

        @Override
        public zzck zzhj() {
            return new zzb((zzh)this.zzarb.get());
        }
    }

    public static class zzc
    implements zzck {
        @Nullable
        private final View mView;
        @Nullable
        private final zzju zzard;

        public zzc(View view, zzju zzju2) {
            this.mView = view;
            this.zzard = zzju2;
        }

        @Override
        public View zzhh() {
            return this.mView;
        }

        @Override
        public boolean zzhi() {
            return this.zzard == null || this.mView == null;
        }

        @Override
        public zzck zzhj() {
            return this;
        }
    }

    public static class zzd
    implements zzck {
        private final WeakReference<View> zzare;
        private final WeakReference<zzju> zzarf;

        public zzd(View view, zzju zzju2) {
            this.zzare = new WeakReference<View>(view);
            this.zzarf = new WeakReference<zzju>(zzju2);
        }

        @Override
        public View zzhh() {
            return (View)this.zzare.get();
        }

        @Override
        public boolean zzhi() {
            return this.zzare.get() == null || this.zzarf.get() == null;
        }

        @Override
        public zzck zzhj() {
            return new zzc((View)this.zzare.get(), (zzju)this.zzarf.get());
        }
    }
}

