/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzcl;
import com.google.android.gms.internal.zzcm;
import com.google.android.gms.internal.zzcn;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzlh;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzin
@TargetApi(value=14)
public class zzco
extends Thread {
    private boolean mStarted = false;
    private boolean zzasj = false;
    private boolean zzbl = false;
    private final Object zzail;
    private final zzcn zzask;
    private final zzcm zzasl;
    private final zzim zzasm;
    private final int zzasn;
    private final int zzarv;
    private final int zzaso;
    private final int zzarx;
    private final int zzasp;

    public zzco(zzcn zzcn2, zzcm zzcm2, zzim zzim2) {
        this.zzask = zzcn2;
        this.zzasl = zzcm2;
        this.zzasm = zzim2;
        this.zzail = new Object();
        this.zzarv = zzdc.zzazi.get();
        this.zzaso = zzdc.zzazj.get();
        this.zzarx = zzdc.zzazk.get();
        this.zzasp = zzdc.zzazl.get();
        this.zzasn = zzdc.zzazm.get();
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzhz() {
        Object object = this.zzail;
        synchronized (object) {
            if (this.mStarted) {
                zzkd.zzcv((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object;
            if (false) break;
            try {
                if (this.zzia()) {
                    object = this.zzask.getActivity();
                    if (object == null) {
                        zzkd.zzcv((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzic();
                    } else {
                        this.zza((Activity)object);
                    }
                } else {
                    zzkd.zzcv((String)"ContentFetchTask: sleeping");
                    this.zzic();
                }
                Thread.sleep(this.zzasn * 1000);
            }
            catch (Throwable throwable) {
                zzkd.zzb((String)"Error in ContentFetchTask", (Throwable)throwable);
                this.zzasm.zza(throwable, true);
            }
            object = this.zzail;
            synchronized (object) {
                while (this.zzasj) {
                    try {
                        zzkd.zzcv((String)"ContentFetchTask: waiting");
                        this.zzail.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    boolean zze(final @Nullable View view) {
        if (view == null) {
            return false;
        }
        view.post(new Runnable(){

            @Override
            public void run() {
                zzco.this.zzf(view);
            }
        });
        return true;
    }

    void zzf(View view) {
        try {
            zzcl zzcl2 = new zzcl(this.zzarv, this.zzaso, this.zzarx, this.zzasp);
            zza zza2 = this.zza(view, zzcl2);
            zzcl2.zzhw();
            if (zza2.zzasx == 0 && zza2.zzasy == 0) {
                return;
            }
            if (zza2.zzasy == 0 && zzcl2.zzhx() == 0) {
                return;
            }
            if (zza2.zzasy == 0 && this.zzasl.zza(zzcl2)) {
                return;
            }
            this.zzasl.zzc(zzcl2);
        }
        catch (Exception exception) {
            zzkd.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzasm.zza(exception, true);
        }
    }

    boolean zzj(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    boolean zzia() {
        try {
            Context context = this.zzask.getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (!this.zza(runningAppProcessInfo) || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzj(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    boolean zza(ActivityManager.RunningAppProcessInfo runningAppProcessInfo) {
        return runningAppProcessInfo.importance == 100;
    }

    void zza(@Nullable Activity activity) {
        if (activity == null) {
            return;
        }
        View view = null;
        try {
            if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                view = activity.getWindow().getDecorView().findViewById(0x1020002);
            }
        }
        catch (Throwable throwable) {
            zzkd.zzcv((String)"Failed getting root view of activity. Content not extracted.");
        }
        if (view == null) {
            return;
        }
        this.zze(view);
    }

    zza zza(@Nullable View view, zzcl zzcl2) {
        if (view == null) {
            return new zza(0, 0);
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            TextView textView = (TextView)view;
            CharSequence charSequence = textView.getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzcl2.zze(string2, bl);
                return new zza(1, 0);
            }
            return new zza(0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzlh)) {
            zzcl2.zzhv();
            if (this.zza((WebView)view, zzcl2, bl)) {
                return new zza(0, 1);
            }
            return new zza(0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zza zza2 = this.zza(viewGroup.getChildAt(i), zzcl2);
                n += zza2.zzasx;
                n2 += zza2.zzasy;
            }
            return new zza(n, n2);
        }
        return new zza(0, 0);
    }

    @TargetApi(value=19)
    boolean zza(final WebView webView, final zzcl zzcl2, final boolean bl) {
        if (!zzs.zzavu()) {
            return false;
        }
        zzcl2.zzhv();
        webView.post(new Runnable(){
            ValueCallback<String> zzass = new ValueCallback<String>(){

                public void zzz(String string2) {
                    zzco.this.zza(zzcl2, webView, string2, bl);
                }

                public /* synthetic */ void onReceiveValue(Object object) {
                    this.zzz((String)object);
                }
            };

            @Override
            public void run() {
                if (webView.getSettings().getJavaScriptEnabled()) {
                    try {
                        webView.evaluateJavascript("(function() { return  {text:document.body.innerText}})();", this.zzass);
                    }
                    catch (Throwable throwable) {
                        this.zzass.onReceiveValue((Object)"");
                    }
                }
            }
        });
        return true;
    }

    void zza(zzcl zzcl2, WebView webView, String string2, boolean bl) {
        zzcl2.zzhu();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.optString("text");
                if (!TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = String.valueOf(webView.getTitle());
                    zzcl2.zzd(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl);
                } else {
                    zzcl2.zzd(string3, bl);
                }
            }
            if (zzcl2.zzhq()) {
                this.zzasl.zzb(zzcl2);
            }
        }
        catch (JSONException jSONException) {
            zzkd.zzcv((String)"Json string may be malformed.");
        }
        catch (Throwable throwable) {
            zzkd.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzasm.zza(throwable, true);
        }
    }

    public zzcl zzib() {
        return this.zzasl.zzhy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.zzail;
        synchronized (object) {
            this.zzasj = false;
            this.zzail.notifyAll();
            zzkd.zzcv((String)"ContentFetchThread: wakeup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzic() {
        Object object = this.zzail;
        synchronized (object) {
            boolean bl = this.zzasj = true;
            zzkd.zzcv((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
        }
    }

    public boolean zzid() {
        return this.zzasj;
    }

    @zzin
    class zza {
        final int zzasx;
        final int zzasy;

        zza(int n, int n2) {
            this.zzasx = n;
            this.zzasy = n2;
        }
    }
}

