/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.support.customtabs.CustomTabsIntent;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.AdLauncherIntentInfoParcel;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zzin;
import com.google.android.gms.internal.zzkh;

@zzin
public class zzgy
implements MediationInterstitialAdapter {
    private Activity zzbpu;
    private zzdq zzbpv;
    private MediationInterstitialListener zzbpw;
    private Uri mUri;

    public static boolean zzp(Context context) {
        return zzdq.zzo(context);
    }

    public void requestInterstitialAd(Context context, MediationInterstitialListener mediationInterstitialListener, Bundle bundle, MediationAdRequest mediationAdRequest, Bundle bundle2) {
        this.zzbpw = mediationInterstitialListener;
        if (this.zzbpw == null) {
            zzb.zzcx((String)"Listener not set for mediation. Returning.");
            return;
        }
        if (!(context instanceof Activity)) {
            zzb.zzcx((String)"AdMobCustomTabs can only work with Activity context. Bailing out.");
            this.zzbpw.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        if (!zzgy.zzp(context)) {
            zzb.zzcx((String)"Default browser does not support custom tabs. Bailing out.");
            this.zzbpw.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        String string = bundle.getString("tab_url");
        if (TextUtils.isEmpty((CharSequence)string)) {
            zzb.zzcx((String)"The tab_url retrieved from mediation metadata is empty. Bailing out.");
            this.zzbpw.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        this.zzbpu = (Activity)context;
        this.mUri = Uri.parse((String)string);
        this.zzbpv = new zzdq();
        zzdq.zza zza2 = new zzdq.zza(){

            @Override
            public void zzkn() {
                zzb.zzcv((String)"Hinting CustomTabsService for the load of the new url.");
            }

            @Override
            public void zzko() {
                zzb.zzcv((String)"Disconnecting from CustomTabs service.");
            }
        };
        this.zzbpv.zza(zza2);
        this.zzbpv.zze(this.zzbpu);
        this.zzbpw.onAdLoaded((MediationInterstitialAdapter)this);
    }

    public void showInterstitial() {
        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder(this.zzbpv.zzkl()).build();
        customTabsIntent.intent.setData(this.mUri);
        AdLauncherIntentInfoParcel adLauncherIntentInfoParcel = new AdLauncherIntentInfoParcel(customTabsIntent.intent);
        final AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(adLauncherIntentInfoParcel, null, new zzg(){

            @Override
            public void zzdx() {
                zzb.zzcv((String)"AdMobCustomTabsAdapter overlay is closed.");
                zzgy.this.zzbpw.onAdClosed((MediationInterstitialAdapter)zzgy.this);
                zzgy.this.zzbpv.zzd(zzgy.this.zzbpu);
            }

            @Override
            public void onPause() {
                zzb.zzcv((String)"AdMobCustomTabsAdapter overlay is paused.");
            }

            @Override
            public void onResume() {
                zzb.zzcv((String)"AdMobCustomTabsAdapter overlay is resumed.");
            }

            @Override
            public void zzdy() {
                zzb.zzcv((String)"Opening AdMobCustomTabsAdapter overlay.");
                zzgy.this.zzbpw.onAdOpened((MediationInterstitialAdapter)zzgy.this);
            }
        }, null, new VersionInfoParcel(0, 0, false));
        zzkh.zzclc.post(new Runnable(){

            @Override
            public void run() {
                zzu.zzfo().zza((Context)zzgy.this.zzbpu, adOverlayInfoParcel);
            }
        });
        zzu.zzft().zzaf(false);
    }

    public void onDestroy() {
        zzb.zzcv((String)"Destroying AdMobCustomTabsAdapter adapter.");
        try {
            this.zzbpv.zzd(this.zzbpu);
        }
        catch (Exception exception) {
            zzb.zzb((String)"Exception while unbinding from CustomTabsService.", (Throwable)exception);
        }
    }

    public void onPause() {
        zzb.zzcv((String)"Pausing AdMobCustomTabsAdapter adapter.");
    }

    public void onResume() {
        zzb.zzcv((String)"Resuming AdMobCustomTabsAdapter adapter.");
    }
}

