/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zzin;
import java.util.Locale;

@zzin
public final class zziv {
    public final int zzcgd;
    public final boolean zzcge;
    public final boolean zzcgf;
    public final String zzcgg;
    public final String zzcgh;
    public final boolean zzcgi;
    public final boolean zzcgj;
    public final boolean zzcgk;
    public final boolean zzcgl;
    public final String zzcgm;
    public final String zzcgn;
    public final int zzcgo;
    public final int zzcgp;
    public final int zzcgq;
    public final int zzcgr;
    public final int zzcgs;
    public final int zzcgt;
    public final float zzcbd;
    public final int zzcbb;
    public final int zzcbc;
    public final double zzcgu;
    public final boolean zzcgv;
    public final boolean zzcgw;
    public final int zzcgx;
    public final String zzcgy;
    public final boolean zzcgz;

    zziv(int n, boolean bl, boolean bl2, String string2, String string3, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string4, String string5, int n2, int n3, int n4, int n5, int n6, int n7, float f, int n8, int n9, double d, boolean bl7, boolean bl8, int n10, String string6, boolean bl9) {
        this.zzcgd = n;
        this.zzcge = bl;
        this.zzcgf = bl2;
        this.zzcgg = string2;
        this.zzcgh = string3;
        this.zzcgi = bl3;
        this.zzcgj = bl4;
        this.zzcgk = bl5;
        this.zzcgl = bl6;
        this.zzcgm = string4;
        this.zzcgn = string5;
        this.zzcgo = n2;
        this.zzcgp = n3;
        this.zzcgq = n4;
        this.zzcgr = n5;
        this.zzcgs = n6;
        this.zzcgt = n7;
        this.zzcbd = f;
        this.zzcbb = n8;
        this.zzcbc = n9;
        this.zzcgu = d;
        this.zzcgv = bl7;
        this.zzcgw = bl8;
        this.zzcgx = n10;
        this.zzcgy = string6;
        this.zzcgz = bl9;
    }

    public static final class zza {
        private int zzcgd;
        private boolean zzcgk;
        private boolean zzcgl;
        private int zzcgo;
        private int zzcgs;
        private int zzcgt;
        private String zzcgg;
        private int zzcgp;
        private int zzcgq;
        private int zzcgr;
        private boolean zzcgw;
        private int zzcgx;
        private double zzcgu;
        private boolean zzcgv;
        private String zzcgy;
        private boolean zzcge;
        private boolean zzcgf;
        private String zzcgh;
        private boolean zzcgi;
        private boolean zzcgj;
        private String zzcgm;
        private String zzcgn;
        private float zzcbd;
        private int zzcbb;
        private int zzcbc;
        private boolean zzcgz;

        public zza(Context context) {
            PackageManager packageManager = context.getPackageManager();
            this.zzv(context);
            this.zza(context, packageManager);
            this.zzw(context);
            Locale locale = Locale.getDefault();
            this.zzcge = zza.zza(packageManager, "geo:0,0?q=donuts") != null;
            this.zzcgf = zza.zza(packageManager, "http://www.google.com") != null;
            this.zzcgh = locale.getCountry();
            this.zzcgi = zzm.zziw().zztw();
            this.zzcgj = zzi.zzcl((Context)context);
            this.zzcgm = locale.getLanguage();
            this.zzcgn = zza.zza(packageManager);
            Resources resources = context.getResources();
            if (resources == null) {
                return;
            }
            DisplayMetrics displayMetrics = resources.getDisplayMetrics();
            if (displayMetrics == null) {
                return;
            }
            this.zzcbd = displayMetrics.density;
            this.zzcbb = displayMetrics.widthPixels;
            this.zzcbc = displayMetrics.heightPixels;
        }

        public zza(Context context, zziv zziv2) {
            PackageManager packageManager = context.getPackageManager();
            this.zzv(context);
            this.zza(context, packageManager);
            this.zzw(context);
            this.zzx(context);
            this.zzcge = zziv2.zzcge;
            this.zzcgf = zziv2.zzcgf;
            this.zzcgh = zziv2.zzcgh;
            this.zzcgi = zziv2.zzcgi;
            this.zzcgj = zziv2.zzcgj;
            this.zzcgm = zziv2.zzcgm;
            this.zzcgn = zziv2.zzcgn;
            this.zzcbd = zziv2.zzcbd;
            this.zzcbb = zziv2.zzcbb;
            this.zzcbc = zziv2.zzcbc;
        }

        private void zzv(Context context) {
            AudioManager audioManager = zzu.zzfq().zzak(context);
            if (audioManager != null) {
                try {
                    this.zzcgd = audioManager.getMode();
                    this.zzcgk = audioManager.isMusicActive();
                    this.zzcgl = audioManager.isSpeakerphoneOn();
                    this.zzcgo = audioManager.getStreamVolume(3);
                    this.zzcgs = audioManager.getRingerMode();
                    this.zzcgt = audioManager.getStreamVolume(2);
                    return;
                }
                catch (Throwable throwable) {
                    zzu.zzft().zzb(throwable, true);
                }
            }
            this.zzcgd = -2;
            this.zzcgk = false;
            this.zzcgl = false;
            this.zzcgo = 0;
            this.zzcgs = 0;
            this.zzcgt = 0;
        }

        @TargetApi(value=16)
        private void zza(Context context, PackageManager packageManager) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            this.zzcgg = telephonyManager.getNetworkOperator();
            this.zzcgq = telephonyManager.getNetworkType();
            this.zzcgr = telephonyManager.getPhoneType();
            this.zzcgp = -2;
            this.zzcgw = false;
            this.zzcgx = -1;
            if (zzu.zzfq().zza(packageManager, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo != null) {
                    this.zzcgp = networkInfo.getType();
                    this.zzcgx = networkInfo.getDetailedState().ordinal();
                } else {
                    this.zzcgp = -1;
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    this.zzcgw = connectivityManager.isActiveNetworkMetered();
                }
            }
        }

        private void zzw(Context context) {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            if (intent != null) {
                int n = intent.getIntExtra("status", -1);
                int n2 = intent.getIntExtra("level", -1);
                int n3 = intent.getIntExtra("scale", -1);
                this.zzcgu = (float)n2 / (float)n3;
                this.zzcgv = n == 2 || n == 5;
            } else {
                this.zzcgu = -1.0;
                this.zzcgv = false;
            }
        }

        private void zzx(Context context) {
            this.zzcgy = Build.FINGERPRINT;
            this.zzcgz = zzdq.zzo(context);
        }

        private static String zza(PackageManager packageManager) {
            ResolveInfo resolveInfo = zza.zza(packageManager, "market://details?id=com.google.android.gms.ads");
            if (resolveInfo == null) {
                return null;
            }
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null) {
                return null;
            }
            try {
                String string2;
                PackageInfo packageInfo = packageManager.getPackageInfo(activityInfo.packageName, 0);
                if (packageInfo != null) {
                    int n = packageInfo.versionCode;
                    String string3 = String.valueOf(activityInfo.packageName);
                    string2 = new StringBuilder(12 + String.valueOf(string3).length()).append(n).append(".").append(string3).toString();
                } else {
                    string2 = null;
                }
                return string2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }

        private static ResolveInfo zza(PackageManager packageManager, String string2) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }

        public zziv zzrn() {
            return new zziv(this.zzcgd, this.zzcge, this.zzcgf, this.zzcgg, this.zzcgh, this.zzcgi, this.zzcgj, this.zzcgk, this.zzcgl, this.zzcgm, this.zzcgn, this.zzcgo, this.zzcgp, this.zzcgq, this.zzcgr, this.zzcgs, this.zzcgt, this.zzcbd, this.zzcbb, this.zzcbc, this.zzcgu, this.zzcgv, this.zzcgw, this.zzcgx, this.zzcgy, this.zzcgz);
        }
    }
}

