/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.TextureView;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdm;
import com.google.android.gms.internal.zzdo;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkx;
import java.util.concurrent.TimeUnit;

@zziy
public class zzx {
    private final Context mContext;
    private final String zzcaj;
    private final VersionInfoParcel zzaop;
    @Nullable
    private final zzdo zzcak;
    @Nullable
    private final zzdq zzcal;
    private final zzkx zzcam = new zzkx.zzb().zza("min_1", Double.MIN_VALUE, 1.0).zza("1_5", 1.0, 5.0).zza("5_10", 5.0, 10.0).zza("10_20", 10.0, 20.0).zza("20_30", 20.0, 30.0).zza("30_max", 30.0, Double.MAX_VALUE).zzuw();
    private final long[] zzcan;
    private final String[] zzcao;
    private boolean zzcap = false;
    private boolean zzcaq = false;
    private boolean zzcar = false;
    private boolean zzcas = false;
    private boolean zzcat;
    private zzi zzcau;
    private boolean zzcav;
    private boolean zzcaw;
    private long zzcax = -1L;

    public zzx(Context context, VersionInfoParcel versionInfoParcel, String string2, @Nullable zzdq zzdq2, @Nullable zzdo zzdo2) {
        this.mContext = context;
        this.zzaop = versionInfoParcel;
        this.zzcaj = string2;
        this.zzcal = zzdq2;
        this.zzcak = zzdo2;
        String string3 = zzdi.zzbbm.get();
        if (string3 == null) {
            this.zzcao = new String[0];
            this.zzcan = new long[0];
            return;
        }
        String[] stringArray = TextUtils.split((String)string3, (String)",");
        this.zzcao = new String[stringArray.length];
        this.zzcan = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.zzcan[i] = Long.parseLong(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                zzkn.zzd((String)"Unable to parse frame hash target time number.", (Throwable)numberFormatException);
                this.zzcan[i] = -1L;
            }
        }
    }

    public void zza(zzi zzi2) {
        zzdm.zza(this.zzcal, this.zzcak, "vpc2");
        this.zzcap = true;
        if (this.zzcal != null) {
            this.zzcal.zzh("vpn", zzi2.zzog());
        }
        this.zzcau = zzi2;
    }

    public void zzpj() {
        if (!this.zzcap || this.zzcaq) {
            return;
        }
        zzdm.zza(this.zzcal, this.zzcak, "vfr2");
        this.zzcaq = true;
    }

    public void onStop() {
        if (zzdi.zzbbl.get().booleanValue() && !this.zzcav) {
            Bundle bundle = new Bundle();
            bundle.putString("type", "native-player-metrics");
            bundle.putString("request", this.zzcaj);
            bundle.putString("player", this.zzcau.zzog());
            for (zzkx.zza object : this.zzcam.getBuckets()) {
                String string2 = String.valueOf("fps_c_");
                String string3 = String.valueOf(object.name);
                bundle.putString(string3.length() != 0 ? string2.concat(string3) : new String(string2), Integer.toString(object.count));
                String string4 = String.valueOf("fps_p_");
                String string5 = String.valueOf(object.name);
                bundle.putString(string5.length() != 0 ? string4.concat(string5) : new String(string4), Double.toString(object.zzcsg));
            }
            for (int i = 0; i < this.zzcan.length; ++i) {
                String string6 = this.zzcao[i];
                if (string6 == null) continue;
                String string7 = String.valueOf("fh_");
                String string8 = String.valueOf((Object)this.zzcan[i]);
                bundle.putString(new StringBuilder(0 + String.valueOf(string7).length() + String.valueOf(string8).length()).append(string7).append(string8).toString(), string6);
            }
            zzu.zzfz().zza(this.mContext, this.zzaop.zzcs, "gmob-apps", bundle, true);
            this.zzcav = true;
        }
    }

    public void zzb(zzi zzi2) {
        this.zzqe();
        this.zzc(zzi2);
    }

    private void zzqe() {
        if (this.zzcar && !this.zzcas) {
            zzdm.zza(this.zzcal, this.zzcak, "vff2");
            this.zzcas = true;
        }
        long l = zzu.zzgf().nanoTime();
        if (this.zzcat && this.zzcaw && this.zzcax != -1L) {
            double d = (double)TimeUnit.SECONDS.toNanos(1L) / (double)(l - this.zzcax);
            this.zzcam.zza(d);
        }
        this.zzcaw = this.zzcat;
        this.zzcax = l;
    }

    private void zzc(zzi zzi2) {
        long l = zzdi.zzbbn.get();
        long l2 = zzi2.getCurrentPosition();
        for (int i = 0; i < this.zzcao.length; ++i) {
            long l3;
            if (this.zzcao[i] != null || l <= Math.abs(l2 - (l3 = this.zzcan[i]))) continue;
            this.zzcao[i] = this.zza((TextureView)zzi2);
            break;
        }
    }

    @TargetApi(value=14)
    String zza(TextureView textureView) {
        Bitmap bitmap = textureView.getBitmap(8, 8);
        long l = 0L;
        long l2 = 63L;
        for (int i = 0; i < 8; ++i) {
            int n = 0;
            while (n < 8) {
                int n2 = bitmap.getPixel(n, i);
                int n3 = Color.blue((int)n2) + Color.red((int)n2) + Color.green((int)n2);
                long l3 = n3 > 128 ? 1L : 0L;
                l |= l3 << (int)l2;
                ++n;
                --l2;
            }
        }
        return String.format("%016X", l);
    }

    public void zzqf() {
        this.zzcat = true;
        if (this.zzcaq && !this.zzcar) {
            zzdm.zza(this.zzcal, this.zzcak, "vfp2");
            this.zzcar = true;
        }
    }

    public void zzqg() {
        this.zzcat = false;
    }
}

