/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkq;
import java.util.Map;

@zziy
public class zzku {
    private final Context mContext;
    private String zzcro;
    private String zzang;
    private final float zzbvv;
    private float zzcrp;
    private float zzcrq;
    private float zzcrr;
    private int mState = 0;

    public zzku(Context context) {
        this.mContext = context;
        this.zzbvv = context.getResources().getDisplayMetrics().density;
    }

    public zzku(Context context, String string2) {
        this(context);
        this.zzcro = string2;
    }

    public void zzg(MotionEvent motionEvent) {
        int n = motionEvent.getHistorySize();
        for (int i = 0; i < n; ++i) {
            this.zza(motionEvent.getActionMasked(), motionEvent.getHistoricalX(0, i), motionEvent.getHistoricalY(0, i));
        }
        this.zza(motionEvent.getActionMasked(), motionEvent.getX(), motionEvent.getY());
    }

    void zza(int n, float f, float f2) {
        if (n == 0) {
            this.mState = 0;
            this.zzcrp = f;
            this.zzcrq = f2;
            this.zzcrr = f2;
        } else {
            if (this.mState == -1) {
                return;
            }
            if (n == 2) {
                if (f2 > this.zzcrq) {
                    this.zzcrq = f2;
                } else if (f2 < this.zzcrr) {
                    this.zzcrr = f2;
                }
                if (this.zzcrq - this.zzcrr > 30.0f * this.zzbvv) {
                    this.mState = -1;
                    return;
                }
                if (this.mState == 0 || this.mState == 2) {
                    if (f - this.zzcrp >= 50.0f * this.zzbvv) {
                        this.zzcrp = f;
                        ++this.mState;
                    }
                } else if ((this.mState == 1 || this.mState == 3) && f - this.zzcrp <= -50.0f * this.zzbvv) {
                    this.zzcrp = f;
                    ++this.mState;
                }
                if (this.mState == 1 || this.mState == 3) {
                    if (f > this.zzcrp) {
                        this.zzcrp = f;
                    }
                } else if (this.mState == 2 && f < this.zzcrp) {
                    this.zzcrp = f;
                }
            } else if (n == 1 && this.mState == 4) {
                this.showDialog();
            }
        }
    }

    public void showDialog() {
        if (zzdi.zzbhq.get().booleanValue()) {
            this.zzur();
        } else {
            this.zzus();
        }
    }

    public void setAdUnitId(String string2) {
        this.zzang = string2;
    }

    public void zzcz(String string2) {
        this.zzcro = string2;
    }

    private void zzur() {
        if (!(this.mContext instanceof Activity)) {
            zzkn.zzde((String)"Can not create dialog without Activity Context");
            return;
        }
        Resources resources = zzu.zzgd().getResources();
        String string2 = resources != null ? resources.getString(R.string.debug_menu_title) : "Select a Debug Mode";
        String string3 = resources != null ? resources.getString(R.string.debug_menu_ad_information) : "Ad Information";
        String string4 = resources != null ? resources.getString(R.string.debug_menu_creative_preview) : "Creative Preview";
        String string5 = resources != null ? resources.getString(R.string.debug_menu_troubleshooting) : "Troubleshooting";
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)string2).setItems((CharSequence[])new String[]{string3, string4, string5}, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                switch (n) {
                    case 0: {
                        zzku.this.zzus();
                        break;
                    }
                    case 1: {
                        zzkn.zzdd((String)"Debug mode [Creative Preview] selected.");
                        zzkq.zza(new Runnable(){

                            @Override
                            public void run() {
                                zzu.zzgh().zzi(zzku.this.mContext, zzku.this.zzang);
                            }
                        });
                        break;
                    }
                    case 2: {
                        zzkn.zzdd((String)"Debug mode [Troubleshooting] selected.");
                        zzkq.zza(new Runnable(){

                            @Override
                            public void run() {
                                zzu.zzgh().zzj(zzku.this.mContext, zzku.this.zzang);
                            }
                        });
                        break;
                    }
                }
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    private void zzus() {
        if (!(this.mContext instanceof Activity)) {
            zzkn.zzde((String)"Can not create dialog without Activity Context");
            return;
        }
        final String string2 = zzku.zzda(this.zzcro);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext);
        builder.setMessage((CharSequence)string2);
        builder.setTitle((CharSequence)"Ad Information");
        builder.setPositiveButton((CharSequence)"Share", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzu.zzfz().zzb(zzku.this.mContext, Intent.createChooser((Intent)new Intent("android.intent.action.SEND").setType("text/plain").putExtra("android.intent.extra.TEXT", string2), (CharSequence)"Share via"));
            }
        });
        builder.setNegativeButton((CharSequence)"Close", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    static String zzda(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "No debug information";
        }
        string2 = string2.replaceAll("\\+", "%20");
        Uri uri = new Uri.Builder().encodedQuery(string2).build();
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> map = zzu.zzfz().zzg(uri);
        for (String string3 : map.keySet()) {
            stringBuilder.append(string3).append(" = ").append(map.get(string3)).append("\n\n");
        }
        String string4 = stringBuilder.toString().trim();
        return !TextUtils.isEmpty((CharSequence)string4) ? string4 : "No debug information";
    }
}

