/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.formats;

import android.graphics.Point;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.formats.zzb;
import com.google.android.gms.ads.internal.formats.zzg;
import com.google.android.gms.ads.internal.formats.zzh;
import com.google.android.gms.ads.internal.formats.zzi;
import com.google.android.gms.ads.internal.formats.zzj;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzlt;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zziy
public class zzl
extends zzdz.zza
implements View.OnClickListener,
View.OnTouchListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private final Object zzakd = new Object();
    private final FrameLayout zzblg;
    @Nullable
    private FrameLayout zzaks;
    private Map<String, WeakReference<View>> zzblh = new HashMap<String, WeakReference<View>>();
    @Nullable
    private zzb zzbli;
    @Nullable
    private zzi zzbkb;
    boolean zzblj = false;
    int zzblk;
    int zzbll;

    public zzl(FrameLayout frameLayout, FrameLayout frameLayout2) {
        this.zzblg = frameLayout;
        this.zzaks = frameLayout2;
        zzu.zzgx().zza((View)this.zzblg, this);
        zzu.zzgx().zza((View)this.zzblg, this);
        this.zzblg.setOnTouchListener((View.OnTouchListener)this);
        this.zzblg.setOnClickListener((View.OnClickListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzc(String string, zzd zzd2) {
        View view = (View)zze.zzae((zzd)zzd2);
        Object object = this.zzakd;
        synchronized (object) {
            if (view == null) {
                this.zzblh.remove(string);
            } else {
                this.zzblh.put(string, new WeakReference<View>(view));
                view.setOnTouchListener((View.OnTouchListener)this);
                view.setClickable(true);
                view.setOnClickListener((View.OnClickListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzd zzas(String string) {
        Object object = this.zzakd;
        synchronized (object) {
            WeakReference<View> weakReference = this.zzblh.get(string);
            return zze.zzac(weakReference == null ? null : (View)weakReference.get());
        }
    }

    void zzh(@Nullable View view) {
        zzi zzi2 = null;
        if (this.zzbkb != null && (zzi2 = this.zzbkb instanceof zzh ? ((zzh)this.zzbkb).zzlw() : this.zzbkb) != null) {
            zzi2.zzh(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zze(zzd zzd2) {
        Object object = this.zzakd;
        synchronized (object) {
            this.zzh(null);
            Object object2 = zze.zzae((zzd)zzd2);
            if (!(object2 instanceof zzj)) {
                zzkn.zzdf((String)"Not an instance of native engine. This is most likely a transient error");
                return;
            }
            if (this.zzaks != null) {
                this.zzaks.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(0, 0));
                this.zzblg.requestLayout();
            }
            this.zzblj = true;
            final zzj zzj2 = (zzj)object2;
            if (this.zzbkb != null && zzdi.zzbfz.get().booleanValue()) {
                this.zzbkb.zzb((View)this.zzblg, this.zzblh);
            }
            if (this.zzbkb instanceof zzh && ((zzh)this.zzbkb).zzlv()) {
                ((zzh)this.zzbkb).zzc(zzj2);
            } else {
                this.zzbkb = zzj2;
                if (zzj2 instanceof zzh) {
                    ((zzh)zzj2).zzc(null);
                }
            }
            if (zzdi.zzbfz.get().booleanValue()) {
                this.zzaks.setClickable(false);
            }
            this.zzaks.removeAllViews();
            this.zzbli = this.zzc(zzj2);
            if (this.zzbli != null) {
                this.zzblh.put("1007", new WeakReference<ViewGroup>(this.zzbli.zzlm()));
                this.zzaks.addView((View)this.zzbli);
            }
            zzj2.zza((View)this.zzblg, this.zzblh, this, this);
            zzkr.zzcrf.post(new Runnable(){

                @Override
                public void run() {
                    zzlt zzlt2 = zzj2.zzlx();
                    if (zzlt2 != null && zzl.this.zzaks != null) {
                        zzl.this.zzaks.addView(zzlt2.getView());
                    }
                    if (!(zzj2 instanceof zzh)) {
                        zzl.this.zzd(zzj2);
                    }
                }
            });
            this.zzh((View)this.zzblg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClick(View view) {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzbkb == null) {
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (Map.Entry<String, WeakReference<View>> jSONObject3 : this.zzblh.entrySet()) {
                View view2 = (View)jSONObject3.getValue().get();
                if (view2 == null) continue;
                Point point = this.zzi(view2);
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("width", this.zzz(view2.getWidth()));
                    jSONObject.put("height", this.zzz(view2.getHeight()));
                    jSONObject.put("x", this.zzz(point.x));
                    jSONObject.put("y", this.zzz(point.y));
                    jSONObject2.put(jSONObject3.getKey(), (Object)jSONObject);
                }
                catch (JSONException jSONException) {
                    String string = String.valueOf(jSONObject3.getKey());
                    zzkn.zzdf((String)(string.length() != 0 ? "Unable to get view rectangle for view ".concat(string) : new String("Unable to get view rectangle for view ")));
                }
            }
            JSONObject jSONObject5 = new JSONObject();
            try {
                jSONObject5.put("x", this.zzz(this.zzblk));
                jSONObject5.put("y", this.zzz(this.zzbll));
            }
            catch (JSONException jSONException) {
                zzkn.zzdf((String)"Unable to get click location");
            }
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("width", this.zzz(this.getMeasuredWidth()));
                jSONObject.put("height", this.zzz(this.getMeasuredHeight()));
            }
            catch (JSONException jSONException) {
                zzkn.zzdf((String)"Unable to get native ad view bounding box");
            }
            if (this.zzbli != null && this.zzbli.zzlm().equals(view)) {
                if (this.zzbkb instanceof zzh && ((zzh)this.zzbkb).zzlw() != null) {
                    ((zzh)this.zzbkb).zzlw().zza(view, "1007", jSONObject2, jSONObject5, jSONObject);
                } else {
                    this.zzbkb.zza(view, "1007", jSONObject2, jSONObject5, jSONObject);
                }
            } else {
                this.zzbkb.zza(view, this.zzblh, jSONObject2, jSONObject5, jSONObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGlobalLayout() {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzblj) {
                int n = this.getMeasuredWidth();
                int n2 = this.getMeasuredHeight();
                if (n != 0 && n2 != 0 && this.zzaks != null) {
                    this.zzaks.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(n, n2));
                    this.zzblj = false;
                }
            }
            if (this.zzbkb != null) {
                this.zzbkb.zzg((View)this.zzblg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScrollChanged() {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzbkb != null) {
                this.zzbkb.zzg((View)this.zzblg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTouch(View view, MotionEvent motionEvent) {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzbkb == null) {
                return false;
            }
            Point point = this.zze(motionEvent);
            this.zzblk = point.x;
            this.zzbll = point.y;
            MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
            motionEvent2.setLocation((float)point.x, (float)point.y);
            this.zzbkb.zzd(motionEvent2);
            motionEvent2.recycle();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.zzakd;
        synchronized (object) {
            if (this.zzaks != null) {
                this.zzaks.removeAllViews();
            }
            this.zzaks = null;
            this.zzblh = null;
            this.zzbli = null;
            this.zzbkb = null;
        }
    }

    Point zze(MotionEvent motionEvent) {
        int[] nArray = new int[2];
        this.zzblg.getLocationOnScreen(nArray);
        float f = motionEvent.getRawX() - (float)nArray[0];
        float f2 = motionEvent.getRawY() - (float)nArray[1];
        return new Point((int)f, (int)f2);
    }

    @Nullable
    zzb zzc(zzj zzj2) {
        return zzj2.zza(this);
    }

    int getMeasuredWidth() {
        return this.zzblg.getMeasuredWidth();
    }

    int getMeasuredHeight() {
        return this.zzblg.getMeasuredHeight();
    }

    int zzz(int n) {
        return zzm.zzjr().zzc(this.zzbkb.getContext(), n);
    }

    Point zzi(View view) {
        if (this.zzbli != null && this.zzbli.zzlm().equals(view)) {
            Point point = new Point();
            this.zzblg.getGlobalVisibleRect(new Rect(), point);
            Point point2 = new Point();
            view.getGlobalVisibleRect(new Rect(), point2);
            return new Point(point2.x - point.x, point2.y - point.y);
        }
        Point point = new Point();
        view.getGlobalVisibleRect(new Rect(), point);
        return point;
    }

    private void zzd(zzj zzj2) {
        if (!this.zzblh.containsKey("2011")) {
            zzj2.zzlz();
            return;
        }
        final View view = (View)this.zzblh.get("2011").get();
        if (!(view instanceof FrameLayout)) {
            zzj2.zzlz();
            return;
        }
        zzg zzg2 = new zzg(){

            @Override
            public void zzlu() {
                zzl.this.onClick(view);
            }

            @Override
            public void zzc(MotionEvent motionEvent) {
                zzl.this.onTouch(null, motionEvent);
            }
        };
        zzj2.zza(view, zzg2);
    }
}

