/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.View;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.purchase.GInAppPurchaseManagerInfoParcel;
import com.google.android.gms.ads.internal.purchase.zzc;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzj;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.CapabilityParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zzdq;
import com.google.android.gms.internal.zzex;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzgq;
import com.google.android.gms.internal.zzhu;
import com.google.android.gms.internal.zzhw;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzia;
import com.google.android.gms.internal.zzib;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkf;
import com.google.android.gms.internal.zzkg;
import com.google.android.gms.internal.zzkn;
import com.google.android.gms.internal.zzkr;
import com.google.android.gms.internal.zzlt;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Future;

@zziy
public abstract class zzb
extends zza
implements zzg,
zzj,
zzs,
zzex,
zzgi {
    protected final zzgq zzals;
    private final Messenger mMessenger;
    protected transient boolean zzalt;

    public zzb(Context context, AdSizeParcel adSizeParcel, String string2, zzgq zzgq2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        this(new zzv(context, adSizeParcel, string2, versionInfoParcel), zzgq2, null, zzd2);
    }

    protected zzb(zzv zzv2, zzgq zzgq2, @Nullable zzr zzr2, zzd zzd2) {
        super(zzv2, zzr2, zzd2);
        this.zzals = zzgq2;
        this.mMessenger = new Messenger((Handler)new zzhu(this.zzall.zzahn));
        this.zzalt = false;
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel, zzdq zzdq2) {
        if (!this.zzec()) {
            return false;
        }
        Bundle bundle = null;
        bundle = this.zza(zzu.zzgd().zzaa(this.zzall.zzahn));
        this.zzalk.cancel();
        this.zzall.zzarv = 0;
        zzkg zzkg2 = null;
        if (zzdi.zzbgq.get().booleanValue()) {
            zzkg2 = zzu.zzgd().zztw();
            zzu.zzgv().zza(this.zzall.zzahn, this.zzall.zzaqv, false, zzkg2, zzkg2 == null ? null : zzkg2.zzti(), this.zzall.zzaqt);
        }
        AdRequestInfoParcel.zza zza2 = this.zza(adRequestParcel, bundle, zzkg2);
        zzdq2.zzh("seq_num", zza2.zzcfx);
        zzdq2.zzh("request_id", zza2.zzcgj);
        zzdq2.zzh("session_id", zza2.zzcfy);
        if (zza2.zzcfv != null) {
            zzdq2.zzh("app_version", String.valueOf(zza2.zzcfv.versionCode));
        }
        this.zzall.zzaqx = zzu.zzfv().zza(this.zzall.zzahn, zza2, this.zzall.zzaqu, this);
        return true;
    }

    @Override
    public void zzb(zzke zzke2) {
        super.zzb(zzke2);
        if (zzke2.zzbte != null) {
            zzkn.zzdd((String)"Pinging network fill URLs.");
            zzu.zzgs().zza(this.zzall.zzahn, this.zzall.zzaqv.zzcs, zzke2, this.zzall.zzaqt, false, zzke2.zzbte.zzbrs);
            if (zzke2.zzcof != null && zzke2.zzcof.zzbsg != null && zzke2.zzcof.zzbsg.size() > 0) {
                zzkn.zzdd((String)"Pinging urls remotely");
                zzu.zzfz().zza(this.zzall.zzahn, zzke2.zzcof.zzbsg);
            }
        }
        if (zzke2.errorCode == 3 && zzke2.zzcof != null && zzke2.zzcof.zzbsf != null) {
            zzkn.zzdd((String)"Pinging no fill URLs.");
            zzu.zzgs().zza(this.zzall.zzahn, this.zzall.zzaqv.zzcs, zzke2, this.zzall.zzaqt, false, zzke2.zzcof.zzbsf);
        }
    }

    @Override
    protected boolean zza(@Nullable zzke zzke2, zzke zzke3) {
        if (zzke2 != null && zzke2.zzbth != null) {
            zzke2.zzbth.zza((zzgi)null);
        }
        if (zzke3.zzbth != null) {
            zzke3.zzbth.zza(this);
        }
        int n = 0;
        int n2 = 0;
        if (zzke3.zzcof != null) {
            n = zzke3.zzcof.zzbsp;
            n2 = zzke3.zzcof.zzbsq;
        }
        this.zzall.zzart.zzh(n, n2);
        return true;
    }

    @Override
    public void onAdClicked() {
        if (this.zzall.zzara == null) {
            zzkn.zzdf((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        if (this.zzall.zzara.zzcof != null && this.zzall.zzara.zzcof.zzbsd != null) {
            zzu.zzgs().zza(this.zzall.zzahn, this.zzall.zzaqv.zzcs, this.zzall.zzara, this.zzall.zzaqt, false, this.zzall.zzara.zzcof.zzbsd);
        }
        if (this.zzall.zzara.zzbte != null && this.zzall.zzara.zzbte.zzbrq != null) {
            zzu.zzgs().zza(this.zzall.zzahn, this.zzall.zzaqv.zzcs, this.zzall.zzara, this.zzall.zzaqt, false, this.zzall.zzara.zzbte.zzbrq);
        }
        super.onAdClicked();
    }

    @Override
    boolean zza(zzke zzke2) {
        AdRequestParcel adRequestParcel;
        boolean bl = false;
        if (this.zzalm != null) {
            adRequestParcel = this.zzalm;
            this.zzalm = null;
        } else {
            adRequestParcel = zzke2.zzcfu;
            bl = adRequestParcel.extras != null ? adRequestParcel.extras.getBoolean("_noRefresh", false) : false;
        }
        return this.zza(adRequestParcel, zzke2, bl);
    }

    protected boolean zza(AdRequestParcel adRequestParcel, zzke zzke2, boolean bl) {
        if (!bl && this.zzall.zzhc()) {
            if (zzke2.zzbsj > 0L) {
                this.zzalk.zza(adRequestParcel, zzke2.zzbsj);
            } else if (zzke2.zzcof != null && zzke2.zzcof.zzbsj > 0L) {
                this.zzalk.zza(adRequestParcel, zzke2.zzcof.zzbsj);
            } else if (!zzke2.zzchc && zzke2.errorCode == 2) {
                this.zzalk.zzh(adRequestParcel);
            }
        }
        return this.zzalk.zzfl();
    }

    @Override
    public void pause() {
        zzac.zzhq((String)"pause must be called on the main UI thread.");
        if (this.zzall.zzara != null && this.zzall.zzara.zzbyh != null && this.zzall.zzhc()) {
            zzu.zzgb().zzl(this.zzall.zzara.zzbyh);
        }
        if (this.zzall.zzara != null && this.zzall.zzara.zzbtf != null) {
            try {
                this.zzall.zzara.zzbtf.pause();
            }
            catch (RemoteException remoteException) {
                zzkn.zzdf((String)"Could not pause mediation adapter.");
            }
        }
        this.zzaln.zzl(this.zzall.zzara);
        this.zzalk.pause();
    }

    @Override
    public void resume() {
        zzac.zzhq((String)"resume must be called on the main UI thread.");
        zzlt zzlt2 = null;
        if (this.zzall.zzara != null && this.zzall.zzara.zzbyh != null) {
            zzlt2 = this.zzall.zzara.zzbyh;
        }
        if (zzlt2 != null && this.zzall.zzhc()) {
            zzu.zzgb().zzm(this.zzall.zzara.zzbyh);
        }
        if (this.zzall.zzara != null && this.zzall.zzara.zzbtf != null) {
            try {
                this.zzall.zzara.zzbtf.resume();
            }
            catch (RemoteException remoteException) {
                zzkn.zzdf((String)"Could not resume mediation adapter.");
            }
        }
        if (zzlt2 == null || !zzlt2.zzvx()) {
            this.zzalk.resume();
        }
        this.zzaln.zzm(this.zzall.zzara);
    }

    @Override
    protected boolean zzc(AdRequestParcel adRequestParcel) {
        return super.zzc(adRequestParcel) && !this.zzalt;
    }

    protected boolean zzec() {
        boolean bl = true;
        if (!zzu.zzfz().zza(this.zzall.zzahn.getPackageManager(), this.zzall.zzahn.getPackageName(), "android.permission.INTERNET") || !zzu.zzfz().zzac(this.zzall.zzahn)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void zzed() {
        this.zzaln.zzj(this.zzall.zzara);
        this.zzalt = false;
        this.zzdx();
        this.zzall.zzarc.zztb();
    }

    @Override
    public void zzee() {
        this.zzalt = true;
        this.zzdz();
    }

    @Override
    public void onPause() {
        this.zzaln.zzl(this.zzall.zzara);
    }

    @Override
    public void onResume() {
        this.zzaln.zzm(this.zzall.zzara);
    }

    @Override
    public void zzef() {
        this.onAdClicked();
    }

    @Override
    public void zzeg() {
        this.zzed();
    }

    @Override
    public void zzeh() {
        this.zzdu();
    }

    @Override
    public void zzei() {
        this.zzee();
    }

    @Override
    public void zzej() {
        if (this.zzall.zzara != null) {
            String string2 = this.zzall.zzara.zzbtg;
            zzkn.zzdf((String)new StringBuilder(74 + String.valueOf(string2).length()).append("Mediation adapter ").append(string2).append(" refreshed, but mediation adapters should never refresh.").toString());
        }
        this.zza(this.zzall.zzara, true);
        this.zzea();
    }

    @Override
    public void zzek() {
        this.recordImpression();
    }

    private AdRequestInfoParcel.zza zza(AdRequestParcel adRequestParcel, Bundle bundle, zzkg zzkg2) {
        String string2;
        int n;
        Object object;
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.zzall.zzahn.getApplicationInfo();
        try {
            packageManager = this.zzall.zzahn.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = this.zzall.zzahn.getResources().getDisplayMetrics();
        Bundle bundle2 = null;
        if (this.zzall.zzaqw != null && this.zzall.zzaqw.getParent() != null) {
            object = new int[2];
            this.zzall.zzaqw.getLocationOnScreen((int[])object);
            Object object2 = object[0];
            Object object3 = object[1];
            int n2 = this.zzall.zzaqw.getWidth();
            int n3 = this.zzall.zzaqw.getHeight();
            int n4 = 0;
            if (this.zzall.zzaqw.isShown() && object2 + n2 > 0 && object3 + n3 > 0 && object2 <= packageManager.widthPixels && object3 <= packageManager.heightPixels) {
                n4 = 1;
            }
            bundle2 = new Bundle(5);
            bundle2.putInt("x", (int)object2);
            bundle2.putInt("y", (int)object3);
            bundle2.putInt("width", n2);
            bundle2.putInt("height", n3);
            bundle2.putInt("visible", n4);
        }
        object = zzu.zzgd().zztk();
        this.zzall.zzarc = new zzkf((String)object, this.zzall.zzaqt);
        this.zzall.zzarc.zzt(adRequestParcel);
        String string3 = zzu.zzfz().zza(this.zzall.zzahn, (View)this.zzall.zzaqw, this.zzall.zzaqz);
        long l = 0L;
        if (this.zzall.zzarg != null) {
            try {
                l = this.zzall.zzarg.getValue();
            }
            catch (RemoteException remoteException) {
                zzkn.zzdf((String)"Cannot get correlation id, default to 0.");
            }
        }
        String string4 = UUID.randomUUID().toString();
        Bundle bundle3 = zzu.zzgd().zza(this.zzall.zzahn, this, (String)object);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.zzall.zzarm.size(); n += 1) {
            arrayList.add((String)this.zzall.zzarm.keyAt(n));
        }
        n = this.zzall.zzarh != null ? 1 : 0;
        boolean bl = this.zzall.zzari != null && zzu.zzgd().zzty();
        boolean bl2 = this.zzalo.zzame.zzr(this.zzall.zzahn);
        String string5 = "";
        if (zzdi.zzbhh.get().booleanValue()) {
            zzkn.zzdd((String)"Getting webview cookie from CookieManager.");
            string2 = zzu.zzgb().zzao(this.zzall.zzahn);
            if (string2 != null) {
                string5 = string2.getCookie("googleads.g.doubleclick.net");
            }
        }
        string2 = null;
        if (zzkg2 != null) {
            string2 = zzkg2.zzth();
        }
        return new AdRequestInfoParcel.zza(bundle2, adRequestParcel, this.zzall.zzaqz, this.zzall.zzaqt, applicationInfo, packageInfo, (String)object, zzu.zzgd().getSessionId(), this.zzall.zzaqv, bundle3, this.zzall.zzarr, arrayList, bundle, zzu.zzgd().zzto(), this.mMessenger, packageManager.widthPixels, packageManager.heightPixels, packageManager.density, string3, l, string4, zzdi.zzkr(), this.zzall.zzaqs, this.zzall.zzarn, new CapabilityParcel(n != 0, bl, bl2), this.zzall.zzhg(), zzu.zzfz().zzfe(), zzu.zzfz().zzfg(), zzu.zzfz().zzam(this.zzall.zzahn), zzu.zzfz().zzn((View)this.zzall.zzaqw), this.zzall.zzahn instanceof Activity, zzu.zzgd().zzts(), string5, string2, zzu.zzgd().zztv(), zzu.zzgw().zzmi(), zzu.zzfz().zzul(), zzu.zzgh().zzut());
    }

    @Override
    public void zza(zzhx zzhx2) {
        zzac.zzhq((String)"setInAppPurchaseListener must be called on the main UI thread.");
        this.zzall.zzarh = zzhx2;
    }

    @Override
    public void zza(zzib zzib2, @Nullable String string2) {
        zzac.zzhq((String)"setPlayStorePurchaseParams must be called on the main UI thread.");
        this.zzall.zzars = new zzk(string2);
        this.zzall.zzari = zzib2;
        if (!zzu.zzgd().zztn() && zzib2 != null) {
            Future cfr_ignored_0 = (Future)new zzc(this.zzall.zzahn, this.zzall.zzari, this.zzall.zzars).zzqw();
        }
    }

    @Override
    public void zza(String string2, ArrayList<String> arrayList) {
        com.google.android.gms.ads.internal.purchase.zzd zzd2 = new com.google.android.gms.ads.internal.purchase.zzd(string2, arrayList, this.zzall.zzahn, this.zzall.zzaqv.zzcs);
        if (this.zzall.zzarh == null) {
            zzkn.zzdf((String)"InAppPurchaseListener is not set. Try to launch default purchase flow.");
            if (!zzm.zzjr().zzas(this.zzall.zzahn)) {
                zzkn.zzdf((String)"Google Play Service unavailable, cannot launch default purchase flow.");
                return;
            }
            if (this.zzall.zzari == null) {
                zzkn.zzdf((String)"PlayStorePurchaseListener is not set.");
                return;
            }
            if (this.zzall.zzars == null) {
                zzkn.zzdf((String)"PlayStorePurchaseVerifier is not initialized.");
                return;
            }
            if (this.zzall.zzarw) {
                zzkn.zzdf((String)"An in-app purchase request is already in progress, abort");
                return;
            }
            this.zzall.zzarw = true;
            try {
                if (!this.zzall.zzari.isValidPurchase(string2)) {
                    this.zzall.zzarw = false;
                    return;
                }
            }
            catch (RemoteException remoteException) {
                zzkn.zzdf((String)"Could not start In-App purchase.");
                this.zzall.zzarw = false;
                return;
            }
            zzu.zzgn().zza(this.zzall.zzahn, this.zzall.zzaqv.zzctu, new GInAppPurchaseManagerInfoParcel(this.zzall.zzahn, this.zzall.zzars, (zzhw)zzd2, this));
        } else {
            try {
                this.zzall.zzarh.zza((zzhw)zzd2);
            }
            catch (RemoteException remoteException) {
                zzkn.zzdf((String)"Could not start In-App purchase.");
            }
        }
    }

    @Override
    public void zza(String string2, boolean bl, int n, final Intent intent, zzf zzf2) {
        try {
            if (this.zzall.zzari != null) {
                this.zzall.zzari.zza((zzia)new com.google.android.gms.ads.internal.purchase.zzg(this.zzall.zzahn, string2, bl, n, intent, zzf2));
            }
        }
        catch (RemoteException remoteException) {
            zzkn.zzdf((String)"Fail to invoke PlayStorePurchaseListener.");
        }
        zzkr.zzcrf.postDelayed(new Runnable(){

            @Override
            public void run() {
                int n = zzu.zzgn().zzd(intent);
                zzu.zzgn();
                if (n == 0 && zzb.this.zzall.zzara != null && zzb.this.zzall.zzara.zzbyh != null && zzb.this.zzall.zzara.zzbyh.zzvp() != null) {
                    zzb.this.zzall.zzara.zzbyh.zzvp().close();
                }
                zzb.this.zzall.zzarw = false;
            }
        }, 500L);
    }

    public void recordImpression() {
        this.zza(this.zzall.zzara, false);
    }

    protected void zza(@Nullable zzke zzke2, boolean bl) {
        if (zzke2 == null) {
            zzkn.zzdf((String)"Ad state was null when trying to ping impression URLs.");
            return;
        }
        super.zzc(zzke2);
        if (zzke2.zzcof != null && zzke2.zzcof.zzbse != null) {
            zzu.zzgs().zza(this.zzall.zzahn, this.zzall.zzaqv.zzcs, zzke2, this.zzall.zzaqt, bl, zzke2.zzcof.zzbse);
        }
        if (zzke2.zzbte != null && zzke2.zzbte.zzbrr != null) {
            zzu.zzgs().zza(this.zzall.zzahn, this.zzall.zzaqv.zzcs, zzke2, this.zzall.zzaqt, bl, zzke2.zzbte.zzbrr);
        }
    }

    public String getMediationAdapterClassName() {
        if (this.zzall.zzara == null) {
            return null;
        }
        return this.zzall.zzara.zzbtg;
    }

    public void showInterstitial() {
        throw new IllegalStateException("showInterstitial is not supported for current ad type");
    }

    @Override
    public void zzel() {
        zzu.zzfz().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                zzb.this.zzalk.pause();
            }
        });
    }

    @Override
    public void zzem() {
        zzu.zzfz().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                zzb.this.zzalk.resume();
            }
        });
    }
}

