/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.SearchAdRequestParcel;
import com.google.android.gms.ads.internal.formats.NativeAdOptionsParcel;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.AutoClickProtectionConfigurationParcel;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.safebrowsing.SafeBrowsingConfigParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdi;
import com.google.android.gms.internal.zziy;
import com.google.android.gms.internal.zziz;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzjl;
import com.google.android.gms.internal.zzkl;
import com.google.android.gms.internal.zzkn;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zziy
public final class zzjc {
    private static final SimpleDateFormat zzcjy = new SimpleDateFormat("yyyyMMdd", Locale.US);

    @Nullable
    public static JSONObject zza(Context context, zziz zziz2) {
        AdRequestInfoParcel adRequestInfoParcel = zziz2.zzcix;
        Location location = zziz2.zzawl;
        zzjh zzjh2 = zziz2.zzciy;
        Bundle bundle = zziz2.zzcgb;
        JSONObject jSONObject = zziz2.zzciz;
        try {
            boolean bl;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("extra_caps", zzdi.zzbfr.get());
            if (zziz2.zzcgk.size() > 0) {
                hashMap.put("eid", TextUtils.join((CharSequence)",", zziz2.zzcgk));
            }
            if (adRequestInfoParcel.zzcft != null) {
                hashMap.put("ad_pos", adRequestInfoParcel.zzcft);
            }
            zzjc.zza(hashMap, adRequestInfoParcel.zzcfu);
            if (adRequestInfoParcel.zzaqz.zzaxk == null) {
                hashMap.put("format", adRequestInfoParcel.zzaqz.zzaxi);
                if (adRequestInfoParcel.zzaqz.zzaxm) {
                    hashMap.put("fluid", "height");
                }
            } else {
                boolean bl2 = false;
                bl = false;
                for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzaqz.zzaxk) {
                    if (!adSizeParcel.zzaxm && !bl2) {
                        hashMap.put("format", adSizeParcel.zzaxi);
                        bl2 = true;
                    }
                    if (adSizeParcel.zzaxm && !bl) {
                        hashMap.put("fluid", "height");
                        bl = true;
                    }
                    if (bl2 && bl) break;
                }
            }
            if (adRequestInfoParcel.zzaqz.width == -1) {
                hashMap.put("smart_w", "full");
            }
            if (adRequestInfoParcel.zzaqz.height == -2) {
                hashMap.put("smart_h", "auto");
            }
            if (adRequestInfoParcel.zzaqz.zzaxk != null) {
                StringBuilder stringBuilder = new StringBuilder();
                bl = false;
                for (AdSizeParcel adSizeParcel : adRequestInfoParcel.zzaqz.zzaxk) {
                    if (adSizeParcel.zzaxm) {
                        bl = true;
                        continue;
                    }
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append("|");
                    }
                    stringBuilder.append(adSizeParcel.width == -1 ? (int)((float)adSizeParcel.widthPixels / zzjh2.zzcgg) : adSizeParcel.width);
                    stringBuilder.append("x");
                    stringBuilder.append(adSizeParcel.height == -2 ? (int)((float)adSizeParcel.heightPixels / zzjh2.zzcgg) : adSizeParcel.height);
                }
                if (bl) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.insert(0, "|");
                    }
                    stringBuilder.insert(0, "320x50");
                }
                hashMap.put("sz", stringBuilder);
            }
            if (adRequestInfoParcel.zzcga != 0) {
                hashMap.put("native_version", adRequestInfoParcel.zzcga);
                hashMap.put("native_templates", adRequestInfoParcel.zzarr);
                hashMap.put("native_image_orientation", zzjc.zzc(adRequestInfoParcel.zzarn));
                if (!adRequestInfoParcel.zzcgl.isEmpty()) {
                    hashMap.put("native_custom_templates", adRequestInfoParcel.zzcgl);
                }
            }
            if (adRequestInfoParcel.zzaqz.zzaxn) {
                hashMap.put("ene", true);
            }
            hashMap.put("slotname", adRequestInfoParcel.zzaqt);
            hashMap.put("pn", adRequestInfoParcel.applicationInfo.packageName);
            if (adRequestInfoParcel.zzcfv != null) {
                hashMap.put("vc", adRequestInfoParcel.zzcfv.versionCode);
            }
            hashMap.put("ms", zziz2.zzcfw);
            hashMap.put("seq_num", adRequestInfoParcel.zzcfx);
            hashMap.put("session_id", adRequestInfoParcel.zzcfy);
            hashMap.put("js", adRequestInfoParcel.zzaqv.zzcs);
            zzjc.zza(hashMap, zzjh2, zziz2.zzciv, adRequestInfoParcel.zzcgy, zziz2.zzciu);
            zzjc.zza(hashMap, zziz2.zzciw);
            hashMap.put("platform", Build.MANUFACTURER);
            hashMap.put("submodel", Build.MODEL);
            if (location != null) {
                zzjc.zza(hashMap, location);
            } else if (adRequestInfoParcel.zzcfu.versionCode >= 2 && adRequestInfoParcel.zzcfu.zzawl != null) {
                zzjc.zza(hashMap, adRequestInfoParcel.zzcfu.zzawl);
            }
            if (adRequestInfoParcel.versionCode >= 2) {
                hashMap.put("quality_signals", adRequestInfoParcel.zzcfz);
            }
            if (adRequestInfoParcel.versionCode >= 4 && adRequestInfoParcel.zzcgc) {
                hashMap.put("forceHttps", adRequestInfoParcel.zzcgc);
            }
            if (bundle != null) {
                hashMap.put("content_info", bundle);
            }
            if (adRequestInfoParcel.versionCode >= 5) {
                hashMap.put("u_sd", Float.valueOf(adRequestInfoParcel.zzcgg));
                hashMap.put("sh", adRequestInfoParcel.zzcgf);
                hashMap.put("sw", adRequestInfoParcel.zzcge);
            } else {
                hashMap.put("u_sd", Float.valueOf(zzjh2.zzcgg));
                hashMap.put("sh", zzjh2.zzcgf);
                hashMap.put("sw", zzjh2.zzcge);
            }
            if (adRequestInfoParcel.versionCode >= 6) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzcgh)) {
                    try {
                        hashMap.put("view_hierarchy", new JSONObject(adRequestInfoParcel.zzcgh));
                    }
                    catch (JSONException jSONException) {
                        zzkn.zzd((String)"Problem serializing view hierarchy to JSON", (Throwable)jSONException);
                    }
                }
                hashMap.put("correlation_id", adRequestInfoParcel.zzcgi);
            }
            if (adRequestInfoParcel.versionCode >= 7) {
                hashMap.put("request_id", adRequestInfoParcel.zzcgj);
            }
            if (adRequestInfoParcel.versionCode >= 11 && adRequestInfoParcel.zzcgn != null) {
                hashMap.put("capability", adRequestInfoParcel.zzcgn.toBundle());
            }
            if (adRequestInfoParcel.versionCode >= 12 && !TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzcgo)) {
                hashMap.put("anchor", adRequestInfoParcel.zzcgo);
            }
            if (adRequestInfoParcel.versionCode >= 13) {
                hashMap.put("android_app_volume", Float.valueOf(adRequestInfoParcel.zzcgp));
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                hashMap.put("android_app_muted", adRequestInfoParcel.zzcgv);
            }
            if (adRequestInfoParcel.versionCode >= 14 && adRequestInfoParcel.zzcgq > 0) {
                hashMap.put("target_api", adRequestInfoParcel.zzcgq);
            }
            if (adRequestInfoParcel.versionCode >= 15) {
                hashMap.put("scroll_index", adRequestInfoParcel.zzcgr == -1 ? -1 : adRequestInfoParcel.zzcgr);
            }
            if (adRequestInfoParcel.versionCode >= 16) {
                hashMap.put("_activity_context", adRequestInfoParcel.zzcgs);
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                if (!TextUtils.isEmpty((CharSequence)adRequestInfoParcel.zzcgw)) {
                    try {
                        hashMap.put("app_settings", new JSONObject(adRequestInfoParcel.zzcgw));
                    }
                    catch (JSONException jSONException) {
                        zzkn.zzd((String)"Problem creating json from app settings", (Throwable)jSONException);
                    }
                }
                hashMap.put("render_in_browser", adRequestInfoParcel.zzbsh);
            }
            if (adRequestInfoParcel.versionCode >= 18) {
                hashMap.put("android_num_video_cache_tasks", adRequestInfoParcel.zzcgx);
            }
            zzjc.zza(hashMap);
            hashMap.put("cache_state", jSONObject);
            if (adRequestInfoParcel.versionCode >= 19) {
                hashMap.put("gct", adRequestInfoParcel.zzcgz);
            }
            if (zzkn.zzbf((int)2)) {
                String string2 = zzu.zzfz().zzan(hashMap).toString(2);
                String string3 = String.valueOf(string2);
                zzkn.v(string3.length() != 0 ? "Ad Request JSON: ".concat(string3) : new String("Ad Request JSON: "));
            }
            return zzu.zzfz().zzan(hashMap);
        }
        catch (JSONException jSONException) {
            String string4 = String.valueOf(jSONException.getMessage());
            zzkn.zzdf((String)(string4.length() != 0 ? "Problem serializing ad request to JSON: ".concat(string4) : new String("Problem serializing ad request to JSON: ")));
            return null;
        }
    }

    private static void zza(HashMap<String, Object> hashMap) {
        Bundle bundle = new Bundle();
        Bundle bundle2 = new Bundle();
        bundle2.putString("cl", "134102376");
        bundle2.putString("rapid_rc", "dev");
        bundle2.putString("rapid_rollup", "HEAD");
        bundle.putBundle("build_meta", bundle2);
        bundle.putString("mf", Boolean.toString(zzdi.zzbft.get()));
        hashMap.put("sdk_env", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, String string2) {
        Bundle bundle = new Bundle();
        bundle.putString("doritos", string2);
        hashMap.put("pii", bundle);
    }

    private static void zza(HashMap<String, Object> hashMap, AdRequestParcel adRequestParcel) {
        String string2 = zzkl.zzub();
        if (string2 != null) {
            hashMap.put("abf", string2);
        }
        if (adRequestParcel.zzawd != -1L) {
            hashMap.put("cust_age", zzcjy.format(new Date(adRequestParcel.zzawd)));
        }
        if (adRequestParcel.extras != null) {
            hashMap.put("extras", adRequestParcel.extras);
        }
        if (adRequestParcel.zzawe != -1) {
            hashMap.put("cust_gender", adRequestParcel.zzawe);
        }
        if (adRequestParcel.zzawf != null) {
            hashMap.put("kw", adRequestParcel.zzawf);
        }
        if (adRequestParcel.zzawh != -1) {
            hashMap.put("tag_for_child_directed_treatment", adRequestParcel.zzawh);
        }
        if (adRequestParcel.zzawg) {
            hashMap.put("adtest", "on");
        }
        if (adRequestParcel.versionCode >= 2) {
            if (adRequestParcel.zzawi) {
                hashMap.put("d_imp_hdr", 1);
            }
            if (!TextUtils.isEmpty((CharSequence)adRequestParcel.zzawj)) {
                hashMap.put("ppid", adRequestParcel.zzawj);
            }
            if (adRequestParcel.zzawk != null) {
                zzjc.zza(hashMap, adRequestParcel.zzawk);
            }
        }
        if (adRequestParcel.versionCode >= 3 && adRequestParcel.zzawm != null) {
            hashMap.put("url", adRequestParcel.zzawm);
        }
        if (adRequestParcel.versionCode >= 5) {
            if (adRequestParcel.zzawo != null) {
                hashMap.put("custom_targeting", adRequestParcel.zzawo);
            }
            if (adRequestParcel.zzawp != null) {
                hashMap.put("category_exclusions", adRequestParcel.zzawp);
            }
            if (adRequestParcel.zzawq != null) {
                hashMap.put("request_agent", adRequestParcel.zzawq);
            }
        }
        if (adRequestParcel.versionCode >= 6 && adRequestParcel.zzawr != null) {
            hashMap.put("request_pkg", adRequestParcel.zzawr);
        }
        if (adRequestParcel.versionCode >= 7) {
            hashMap.put("is_designed_for_families", adRequestParcel.zzaws);
        }
    }

    private static void zza(HashMap<String, Object> hashMap, zzjh zzjh2, zzjl.zza zza2, Bundle bundle, Bundle bundle2) {
        Bundle bundle3;
        hashMap.put("am", zzjh2.zzclr);
        hashMap.put("cog", zzjc.zzac(zzjh2.zzcls));
        hashMap.put("coh", zzjc.zzac(zzjh2.zzclt));
        if (!TextUtils.isEmpty((CharSequence)zzjh2.zzclu)) {
            hashMap.put("carrier", zzjh2.zzclu);
        }
        hashMap.put("gl", zzjh2.zzclv);
        if (zzjh2.zzclw) {
            hashMap.put("simulator", 1);
        }
        if (zzjh2.zzclx) {
            hashMap.put("is_sidewinder", 1);
        }
        hashMap.put("ma", zzjc.zzac(zzjh2.zzcly));
        hashMap.put("sp", zzjc.zzac(zzjh2.zzclz));
        hashMap.put("hl", zzjh2.zzcma);
        if (!TextUtils.isEmpty((CharSequence)zzjh2.zzcmb)) {
            hashMap.put("mv", zzjh2.zzcmb);
        }
        hashMap.put("muv", zzjh2.zzcmc);
        if (zzjh2.zzcmd != -2) {
            hashMap.put("cnt", zzjh2.zzcmd);
        }
        hashMap.put("gnt", zzjh2.zzcme);
        hashMap.put("pt", zzjh2.zzcmf);
        hashMap.put("rm", zzjh2.zzcmg);
        hashMap.put("riv", zzjh2.zzcmh);
        Bundle bundle4 = new Bundle();
        bundle4.putString("build", zzjh2.zzcmm);
        Bundle bundle5 = new Bundle();
        bundle5.putBoolean("is_charging", zzjh2.zzcmj);
        bundle5.putDouble("battery_level", zzjh2.zzcmi);
        bundle4.putBundle("battery", bundle5);
        Bundle bundle6 = new Bundle();
        bundle6.putInt("active_network_state", zzjh2.zzcml);
        bundle6.putBoolean("active_network_metered", zzjh2.zzcmk);
        if (zza2 != null) {
            bundle3 = new Bundle();
            bundle3.putInt("predicted_latency_micros", 0);
            bundle3.putLong("predicted_down_throughput_bps", 0L);
            bundle3.putLong("predicted_up_throughput_bps", 0L);
            bundle6.putBundle("predictions", bundle3);
        }
        bundle4.putBundle("network", bundle6);
        bundle3 = new Bundle();
        bundle3.putBoolean("is_browser_custom_tabs_capable", zzjh2.zzcmn);
        bundle4.putBundle("browser", bundle3);
        if (bundle != null) {
            bundle4.putBundle("android_mem_info", zzjc.zzg(bundle));
        }
        Bundle bundle7 = new Bundle();
        bundle7.putBundle("parental_controls", bundle2);
        bundle4.putBundle("play_store", bundle7);
        hashMap.put("device", bundle4);
    }

    private static Bundle zzg(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        bundle2.putString("runtime_free", Long.toString(bundle.getLong("runtime_free_memory", -1L)));
        bundle2.putString("runtime_max", Long.toString(bundle.getLong("runtime_max_memory", -1L)));
        bundle2.putString("runtime_total", Long.toString(bundle.getLong("runtime_total_memory", -1L)));
        Debug.MemoryInfo memoryInfo = (Debug.MemoryInfo)bundle.getParcelable("debug_memory_info");
        if (memoryInfo != null) {
            bundle2.putString("debug_info_dalvik_private_dirty", Integer.toString(memoryInfo.dalvikPrivateDirty));
            bundle2.putString("debug_info_dalvik_pss", Integer.toString(memoryInfo.dalvikPss));
            bundle2.putString("debug_info_dalvik_shared_dirty", Integer.toString(memoryInfo.dalvikSharedDirty));
            bundle2.putString("debug_info_native_private_dirty", Integer.toString(memoryInfo.nativePrivateDirty));
            bundle2.putString("debug_info_native_pss", Integer.toString(memoryInfo.nativePss));
            bundle2.putString("debug_info_native_shared_dirty", Integer.toString(memoryInfo.nativeSharedDirty));
            bundle2.putString("debug_info_other_private_dirty", Integer.toString(memoryInfo.otherPrivateDirty));
            bundle2.putString("debug_info_other_pss", Integer.toString(memoryInfo.otherPss));
            bundle2.putString("debug_info_other_shared_dirty", Integer.toString(memoryInfo.otherSharedDirty));
        }
        return bundle2;
    }

    private static void zza(HashMap<String, Object> hashMap, Location location) {
        HashMap<String, Number> hashMap2 = new HashMap<String, Number>();
        Float f = Float.valueOf(location.getAccuracy() * 1000.0f);
        Long l = location.getTime() * 1000L;
        Long l2 = (long)(location.getLatitude() * 1.0E7);
        Long l3 = (long)(location.getLongitude() * 1.0E7);
        hashMap2.put("radius", f);
        hashMap2.put("lat", l2);
        hashMap2.put("long", l3);
        hashMap2.put("time", l);
        hashMap.put("uule", hashMap2);
    }

    private static void zza(HashMap<String, Object> hashMap, SearchAdRequestParcel searchAdRequestParcel) {
        String string2;
        String string3;
        if (Color.alpha((int)searchAdRequestParcel.zzazp) != 0) {
            hashMap.put("acolor", zzjc.zzaw(searchAdRequestParcel.zzazp));
        }
        if (Color.alpha((int)searchAdRequestParcel.backgroundColor) != 0) {
            hashMap.put("bgcolor", zzjc.zzaw(searchAdRequestParcel.backgroundColor));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzazq) != 0 && Color.alpha((int)searchAdRequestParcel.zzazr) != 0) {
            hashMap.put("gradientto", zzjc.zzaw(searchAdRequestParcel.zzazq));
            hashMap.put("gradientfrom", zzjc.zzaw(searchAdRequestParcel.zzazr));
        }
        if (Color.alpha((int)searchAdRequestParcel.zzazs) != 0) {
            hashMap.put("bcolor", zzjc.zzaw(searchAdRequestParcel.zzazs));
        }
        hashMap.put("bthick", Integer.toString(searchAdRequestParcel.zzazt));
        switch (searchAdRequestParcel.zzazu) {
            case 0: {
                string3 = "none";
                break;
            }
            case 1: {
                string3 = "dashed";
                break;
            }
            case 2: {
                string3 = "dotted";
                break;
            }
            case 3: {
                string3 = "solid";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            hashMap.put("btype", string3);
        }
        switch (searchAdRequestParcel.zzazv) {
            case 2: {
                string2 = "dark";
                break;
            }
            case 0: {
                string2 = "light";
                break;
            }
            case 1: {
                string2 = "medium";
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            hashMap.put("callbuttoncolor", string2);
        }
        if (searchAdRequestParcel.zzazw != null) {
            hashMap.put("channel", searchAdRequestParcel.zzazw);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzazx) != 0) {
            hashMap.put("dcolor", zzjc.zzaw(searchAdRequestParcel.zzazx));
        }
        if (searchAdRequestParcel.zzazy != null) {
            hashMap.put("font", searchAdRequestParcel.zzazy);
        }
        if (Color.alpha((int)searchAdRequestParcel.zzazz) != 0) {
            hashMap.put("hcolor", zzjc.zzaw(searchAdRequestParcel.zzazz));
        }
        hashMap.put("headersize", Integer.toString(searchAdRequestParcel.zzbaa));
        if (searchAdRequestParcel.zzbab != null) {
            hashMap.put("q", searchAdRequestParcel.zzbab);
        }
    }

    private static Integer zzac(boolean bl) {
        return bl ? 1 : 0;
    }

    private static String zzaw(int n) {
        return String.format(Locale.US, "#%06x", n & 0xFFFFFF);
    }

    private static String zzc(NativeAdOptionsParcel nativeAdOptionsParcel) {
        int n = nativeAdOptionsParcel != null ? nativeAdOptionsParcel.zzblc : 0;
        switch (n) {
            case 1: {
                return "portrait";
            }
            case 2: {
                return "landscape";
            }
        }
        return "any";
    }

    public static AdResponseParcel zza(Context context, AdRequestInfoParcel adRequestInfoParcel, String string2) {
        try {
            List<String> list;
            List<String> list2;
            List<String> list3;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("ad_base_url", null);
            String string4 = jSONObject.optString("ad_url", null);
            String string5 = jSONObject.optString("ad_size", null);
            String string6 = jSONObject.optString("ad_slot_size", string5);
            boolean bl = adRequestInfoParcel != null && adRequestInfoParcel.zzcga != 0;
            String string7 = jSONObject.optString("ad_json", null);
            if (string7 == null) {
                string7 = jSONObject.optString("ad_html", null);
            }
            if (string7 == null) {
                string7 = jSONObject.optString("body", null);
            }
            long l = -1L;
            String string8 = jSONObject.optString("debug_dialog", null);
            String string9 = jSONObject.optString("debug_signals", null);
            long l2 = jSONObject.has("interstitial_timeout") ? (long)(jSONObject.getDouble("interstitial_timeout") * 1000.0) : -1L;
            String string10 = jSONObject.optString("orientation", null);
            int n = -1;
            if ("portrait".equals(string10)) {
                n = zzu.zzgb().zzun();
            } else if ("landscape".equals(string10)) {
                n = zzu.zzgb().zzum();
            }
            AdResponseParcel adResponseParcel = null;
            if (TextUtils.isEmpty((CharSequence)string7) && !TextUtils.isEmpty((CharSequence)string4)) {
                adResponseParcel = zzjb.zza(adRequestInfoParcel, context, adRequestInfoParcel.zzaqv.zzcs, string4, null, null, null, null);
                string3 = adResponseParcel.zzbyj;
                string7 = adResponseParcel.body;
                l = adResponseParcel.zzchg;
            }
            if (string7 == null) {
                return new AdResponseParcel(0);
            }
            JSONArray jSONArray = jSONObject.optJSONArray("click_urls");
            List<String> list4 = list3 = adResponseParcel == null ? null : adResponseParcel.zzbsd;
            if (jSONArray != null) {
                list3 = zzjc.zza(jSONArray, list3);
            }
            JSONArray jSONArray2 = jSONObject.optJSONArray("impression_urls");
            List<String> list5 = list2 = adResponseParcel == null ? null : adResponseParcel.zzbse;
            if (jSONArray2 != null) {
                list2 = zzjc.zza(jSONArray2, list2);
            }
            JSONArray jSONArray3 = jSONObject.optJSONArray("manual_impression_urls");
            List<String> list6 = list = adResponseParcel == null ? null : adResponseParcel.zzche;
            if (jSONArray3 != null) {
                list = zzjc.zza(jSONArray3, list);
            }
            if (adResponseParcel != null) {
                if (adResponseParcel.orientation != -1) {
                    n = adResponseParcel.orientation;
                }
                if (adResponseParcel.zzchb > 0L) {
                    l2 = adResponseParcel.zzchb;
                }
            }
            String string11 = jSONObject.optString("active_view");
            String string12 = null;
            boolean bl2 = jSONObject.optBoolean("ad_is_javascript", false);
            if (bl2) {
                string12 = jSONObject.optString("ad_passback_url", null);
            }
            boolean bl3 = jSONObject.optBoolean("mediation", false);
            boolean bl4 = jSONObject.optBoolean("custom_render_allowed", false);
            boolean bl5 = jSONObject.optBoolean("content_url_opted_out", true);
            boolean bl6 = jSONObject.optBoolean("prefetch", false);
            long l3 = jSONObject.optLong("refresh_interval_milliseconds", -1L);
            long l4 = jSONObject.optLong("mediation_config_cache_time_milliseconds", -1L);
            String string13 = jSONObject.optString("gws_query_id", "");
            boolean bl7 = "height".equals(jSONObject.optString("fluid", ""));
            boolean bl8 = jSONObject.optBoolean("native_express", false);
            List<String> list7 = zzjc.zza(jSONObject.optJSONArray("video_start_urls"), null);
            List<String> list8 = zzjc.zza(jSONObject.optJSONArray("video_complete_urls"), null);
            RewardItemParcel rewardItemParcel = RewardItemParcel.zza((JSONArray)jSONObject.optJSONArray("rewards"));
            boolean bl9 = jSONObject.optBoolean("use_displayed_impression", false);
            AutoClickProtectionConfigurationParcel autoClickProtectionConfigurationParcel = AutoClickProtectionConfigurationParcel.zzi(jSONObject.optJSONObject("auto_protection_configuration"));
            String string14 = jSONObject.optString("set_cookie", "");
            List<String> list9 = zzjc.zza(jSONObject.optJSONArray("remote_ping_urls"), null);
            SafeBrowsingConfigParcel safeBrowsingConfigParcel = SafeBrowsingConfigParcel.zzk(jSONObject.optJSONObject("safe_browsing"));
            boolean bl10 = jSONObject.optBoolean("render_in_browser", adRequestInfoParcel.zzbsh);
            return new AdResponseParcel(adRequestInfoParcel, string3, string7, list3, list2, l2, bl3, l4, list, l3, n, string5, l, string8, bl2, string12, string11, bl4, bl, adRequestInfoParcel.zzcgc, bl5, bl6, string13, bl7, bl8, rewardItemParcel, list7, list8, bl9, autoClickProtectionConfigurationParcel, adRequestInfoParcel.zzcgt, string14, list9, bl10, string6, safeBrowsingConfigParcel, string9);
        }
        catch (JSONException jSONException) {
            String string15 = String.valueOf(jSONException.getMessage());
            zzkn.zzdf((String)(string15.length() != 0 ? "Could not parse the inline ad response: ".concat(string15) : new String("Could not parse the inline ad response: ")));
            return new AdResponseParcel(0);
        }
    }

    @Nullable
    private static List<String> zza(@Nullable JSONArray jSONArray, @Nullable List<String> list) throws JSONException {
        if (jSONArray == null) {
            return null;
        }
        if (list == null) {
            list = new LinkedList<String>();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            list.add(jSONArray.getString(i));
        }
        return list;
    }

    public static JSONObject zzc(AdResponseParcel adResponseParcel) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (adResponseParcel.zzbyj != null) {
            jSONObject.put("ad_base_url", (Object)adResponseParcel.zzbyj);
        }
        if (adResponseParcel.zzchf != null) {
            jSONObject.put("ad_size", (Object)adResponseParcel.zzchf);
        }
        jSONObject.put("native", adResponseParcel.zzaxl);
        if (adResponseParcel.zzaxl) {
            jSONObject.put("ad_json", (Object)adResponseParcel.body);
        } else {
            jSONObject.put("ad_html", (Object)adResponseParcel.body);
        }
        if (adResponseParcel.zzchh != null) {
            jSONObject.put("debug_dialog", (Object)adResponseParcel.zzchh);
        }
        if (adResponseParcel.zzchy != null) {
            jSONObject.put("debug_signals", (Object)adResponseParcel.zzchy);
        }
        if (adResponseParcel.zzchb != -1L) {
            jSONObject.put("interstitial_timeout", (double)adResponseParcel.zzchb / 1000.0);
        }
        if (adResponseParcel.orientation == zzu.zzgb().zzun()) {
            jSONObject.put("orientation", (Object)"portrait");
        } else if (adResponseParcel.orientation == zzu.zzgb().zzum()) {
            jSONObject.put("orientation", (Object)"landscape");
        }
        if (adResponseParcel.zzbsd != null) {
            jSONObject.put("click_urls", (Object)zzjc.zzl(adResponseParcel.zzbsd));
        }
        if (adResponseParcel.zzbse != null) {
            jSONObject.put("impression_urls", (Object)zzjc.zzl(adResponseParcel.zzbse));
        }
        if (adResponseParcel.zzche != null) {
            jSONObject.put("manual_impression_urls", (Object)zzjc.zzl(adResponseParcel.zzche));
        }
        if (adResponseParcel.zzchk != null) {
            jSONObject.put("active_view", (Object)adResponseParcel.zzchk);
        }
        jSONObject.put("ad_is_javascript", adResponseParcel.zzchi);
        if (adResponseParcel.zzchj != null) {
            jSONObject.put("ad_passback_url", (Object)adResponseParcel.zzchj);
        }
        jSONObject.put("mediation", adResponseParcel.zzchc);
        jSONObject.put("custom_render_allowed", adResponseParcel.zzchl);
        jSONObject.put("content_url_opted_out", adResponseParcel.zzchm);
        jSONObject.put("prefetch", adResponseParcel.zzchn);
        if (adResponseParcel.zzbsj != -1L) {
            jSONObject.put("refresh_interval_milliseconds", adResponseParcel.zzbsj);
        }
        if (adResponseParcel.zzchd != -1L) {
            jSONObject.put("mediation_config_cache_time_milliseconds", adResponseParcel.zzchd);
        }
        if (!TextUtils.isEmpty((CharSequence)adResponseParcel.zzchq)) {
            jSONObject.put("gws_query_id", (Object)adResponseParcel.zzchq);
        }
        jSONObject.put("fluid", (Object)(adResponseParcel.zzaxm ? "height" : ""));
        jSONObject.put("native_express", adResponseParcel.zzaxn);
        if (adResponseParcel.zzchs != null) {
            jSONObject.put("video_start_urls", (Object)zzjc.zzl(adResponseParcel.zzchs));
        }
        if (adResponseParcel.zzcht != null) {
            jSONObject.put("video_complete_urls", (Object)zzjc.zzl(adResponseParcel.zzcht));
        }
        if (adResponseParcel.zzchr != null) {
            jSONObject.put("rewards", (Object)adResponseParcel.zzchr.zzsx());
        }
        jSONObject.put("use_displayed_impression", adResponseParcel.zzchu);
        jSONObject.put("auto_protection_configuration", (Object)adResponseParcel.zzchv);
        jSONObject.put("render_in_browser", adResponseParcel.zzbsh);
        return jSONObject;
    }

    @Nullable
    static JSONArray zzl(List<String> list) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (String string2 : list) {
            jSONArray.put((Object)string2);
        }
        return jSONArray;
    }
}

