/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.ads.internal.overlay.zzw;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzdn;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzji
@TargetApi(value=14)
public class zzx
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzw.zza {
    private static final float[] zzcdd = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzw zzcde;
    private final float[] zzccz;
    private final float[] zzcdf;
    private final float[] zzcdg;
    private final float[] zzcdh;
    private final float[] zzcdi;
    private final float[] zzcdj;
    private final float[] zzcdk;
    private float zzcdl;
    private float zzcdm;
    private float zzcdn;
    private int zzaki;
    private int zzakh;
    private SurfaceTexture zzcdo;
    private SurfaceTexture zzcdp;
    private int zzcdq;
    private int zzcdr;
    private int zzcds;
    private FloatBuffer zzcdt = ByteBuffer.allocateDirect(zzcdd.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzcdu;
    private final Object zzcdv;
    private EGL10 zzcdw;
    private EGLDisplay zzcdx;
    private EGLContext zzcdy;
    private EGLSurface zzcdz;
    private volatile boolean zzcea;
    private volatile boolean zzceb;

    public zzx(Context context) {
        super("SphericalVideoProcessor");
        this.zzcdt.put(zzcdd).position(0);
        this.zzccz = new float[9];
        this.zzcdf = new float[9];
        this.zzcdg = new float[9];
        this.zzcdh = new float[9];
        this.zzcdi = new float[9];
        this.zzcdj = new float[9];
        this.zzcdk = new float[9];
        this.zzcdl = Float.NaN;
        this.zzcde = new zzw(context);
        this.zzcde.zza(this);
        this.zzcdu = new CountDownLatch(1);
        this.zzcdv = new Object();
    }

    public void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.zzakh = n;
        this.zzaki = n2;
        this.zzcdp = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzi(int n, int n2) {
        Object object = this.zzcdv;
        synchronized (object) {
            this.zzakh = n;
            this.zzaki = n2;
            this.zzcea = true;
            this.zzcdv.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzqs() {
        Object object = this.zzcdv;
        synchronized (object) {
            this.zzceb = true;
            this.zzcdp = null;
            this.zzcdv.notifyAll();
        }
    }

    public SurfaceTexture zzqt() {
        if (this.zzcdp == null) {
            return null;
        }
        try {
            this.zzcdu.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.zzcdo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzcds;
        Object object = this.zzcdv;
        synchronized (object) {
            this.zzcdv.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzpr() {
        Object object = this.zzcdv;
        synchronized (object) {
            this.zzcdv.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl;
        if (this.zzcdp == null) {
            zzkx.e((String)"SphericalVideoProcessor started with no output texture.");
            this.zzcdu.countDown();
            return;
        }
        boolean bl2 = this.zzqy();
        int n = this.zzqw();
        boolean bl3 = bl = this.zzcdq != 0;
        if (!bl2 || !bl) {
            String string2 = GLUtils.getEGLErrorString((int)this.zzcdw.eglGetError());
            String string3 = String.valueOf(string2);
            String string4 = string3.length() != 0 ? "EGL initialization failed: ".concat(string3) : new String("EGL initialization failed: ");
            zzkx.e((String)string4);
            zzu.zzgq().zza(new Throwable(string4), "SphericalVideoProcessor.run.1");
            this.zzrc();
            this.zzcdu.countDown();
            return;
        }
        this.zzcdo = new SurfaceTexture(n);
        this.zzcdo.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzcdu.countDown();
        this.zzcde.start();
        try {
            this.zzcea = true;
            while (!this.zzceb) {
                this.zzqu();
                if (this.zzcea) {
                    this.zzqv();
                    this.zzcea = false;
                }
                try {
                    Object object = this.zzcdv;
                    synchronized (object) {
                        if (!this.zzceb && !this.zzcea && this.zzcds == 0) {
                            this.zzcdv.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            zzkx.zzdi((String)"SphericalVideoProcessor halted unexpectedly.");
        }
        catch (Throwable throwable) {
            zzkx.zzb((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzu.zzgq().zza(throwable, "SphericalVideoProcessor.run.2");
        }
        finally {
            this.zzcde.stop();
            this.zzcdo.setOnFrameAvailableListener(null);
            this.zzcdo = null;
            this.zzrc();
        }
    }

    void zzqu() {
        while (this.zzcds > 0) {
            this.zzcdo.updateTexImage();
            --this.zzcds;
        }
        if (this.zzcde.zzb(this.zzccz)) {
            if (Float.isNaN(this.zzcdl)) {
                this.zzcdl = -this.zzc(this.zzccz);
            }
            this.zzb(this.zzcdj, this.zzcdl + this.zzcdm);
        } else {
            this.zza(this.zzccz, -1.5707964f);
            this.zzb(this.zzcdj, this.zzcdm);
        }
        this.zza(this.zzcdf, 1.5707964f);
        this.zza(this.zzcdg, this.zzcdj, this.zzcdf);
        this.zza(this.zzcdh, this.zzccz, this.zzcdg);
        this.zza(this.zzcdi, this.zzcdn);
        this.zza(this.zzcdk, this.zzcdi, this.zzcdh);
        GLES20.glUniformMatrix3fv((int)this.zzcdr, (int)1, (boolean)false, (float[])this.zzcdk, (int)0);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        this.zzcf("drawArrays");
        GLES20.glFinish();
        this.zzcdw.eglSwapBuffers(this.zzcdx, this.zzcdz);
    }

    private float zzc(float[] fArray) {
        float[] fArray2 = this.zza(fArray, new float[]{0.0f, 1.0f, 0.0f});
        return (float)Math.atan2(fArray2[1], fArray2[0]) - 1.5707964f;
    }

    public void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.zzakh > this.zzaki) {
            f4 = 1.7453293f * f / (float)this.zzakh;
            f3 = 1.7453293f * f2 / (float)this.zzakh;
        } else {
            f4 = 1.7453293f * f / (float)this.zzaki;
            f3 = 1.7453293f * f2 / (float)this.zzaki;
        }
        this.zzcdm -= f4;
        this.zzcdn -= f3;
        if (this.zzcdn < -1.5707964f) {
            this.zzcdn = -1.5707964f;
        }
        if (this.zzcdn > 1.5707964f) {
            this.zzcdn = 1.5707964f;
        }
    }

    private void zzqv() {
        GLES20.glViewport((int)0, (int)0, (int)this.zzakh, (int)this.zzaki);
        this.zzcf("viewport");
        int n = GLES20.glGetUniformLocation((int)this.zzcdq, (String)"uFOVx");
        int n2 = GLES20.glGetUniformLocation((int)this.zzcdq, (String)"uFOVy");
        if (this.zzakh > this.zzaki) {
            GLES20.glUniform1f((int)n, (float)0.87266463f);
            GLES20.glUniform1f((int)n2, (float)(0.87266463f * (float)this.zzaki / (float)this.zzakh));
        } else {
            GLES20.glUniform1f((int)n, (float)(0.87266463f * (float)this.zzakh / (float)this.zzaki));
            GLES20.glUniform1f((int)n2, (float)0.87266463f);
        }
    }

    private float[] zza(float[] fArray, float[] fArray2) {
        return new float[]{fArray[0] * fArray2[0] + fArray[1] * fArray2[1] + fArray[2] * fArray2[2], fArray[3] * fArray2[0] + fArray[4] * fArray2[1] + fArray[5] * fArray2[2], fArray[6] * fArray2[0] + fArray[7] * fArray2[1] + fArray[8] * fArray2[2]};
    }

    private void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    int zzqw() {
        this.zzcdq = this.zzqx();
        GLES20.glUseProgram((int)this.zzcdq);
        this.zzcf("useProgram");
        int n = GLES20.glGetAttribLocation((int)this.zzcdq, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)this.zzcdt);
        this.zzcf("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n);
        this.zzcf("enableVertexAttribArray");
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        this.zzcf("genTextures");
        int n2 = nArray[0];
        GLES20.glBindTexture((int)36197, (int)n2);
        this.zzcf("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        this.zzcf("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        this.zzcf("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        this.zzcf("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        this.zzcf("texParameteri");
        this.zzcdr = GLES20.glGetUniformLocation((int)this.zzcdq, (String)"uVMat");
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)this.zzcdr, (int)1, (boolean)false, (float[])fArray, (int)0);
        return n2;
    }

    private int zzqx() {
        int n = this.zzc(35633, this.zzra());
        if (n == 0) {
            return 0;
        }
        int n2 = this.zzc(35632, this.zzrb());
        if (n2 == 0) {
            return 0;
        }
        int n3 = GLES20.glCreateProgram();
        this.zzcf("createProgram");
        if (n3 != 0) {
            GLES20.glAttachShader((int)n3, (int)n);
            this.zzcf("attachShader");
            GLES20.glAttachShader((int)n3, (int)n2);
            this.zzcf("attachShader");
            GLES20.glLinkProgram((int)n3);
            this.zzcf("linkProgram");
            int[] nArray = new int[1];
            GLES20.glGetProgramiv((int)n3, (int)35714, (int[])nArray, (int)0);
            this.zzcf("getProgramiv");
            if (nArray[0] != 1) {
                Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n3));
                GLES20.glDeleteProgram((int)n3);
                this.zzcf("deleteProgram");
                n3 = 0;
            } else {
                GLES20.glValidateProgram((int)n3);
                this.zzcf("validateProgram");
            }
        }
        return n3;
    }

    private int zzc(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        this.zzcf("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string2);
            this.zzcf("shaderSource");
            GLES20.glCompileShader((int)n2);
            this.zzcf("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            this.zzcf("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                this.zzcf("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    boolean zzqy() {
        this.zzcdw = (EGL10)EGLContext.getEGL();
        this.zzcdx = this.zzcdw.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.zzcdx == EGL10.EGL_NO_DISPLAY) {
            return false;
        }
        int[] nArray = new int[2];
        if (!this.zzcdw.eglInitialize(this.zzcdx, nArray)) {
            return false;
        }
        EGLConfig eGLConfig = this.zzqz();
        if (eGLConfig == null) {
            return false;
        }
        int[] nArray2 = new int[]{12440, 2, 12344};
        this.zzcdy = this.zzcdw.eglCreateContext(this.zzcdx, eGLConfig, EGL10.EGL_NO_CONTEXT, nArray2);
        if (this.zzcdy == null || this.zzcdy == EGL10.EGL_NO_CONTEXT) {
            return false;
        }
        this.zzcdz = this.zzcdw.eglCreateWindowSurface(this.zzcdx, eGLConfig, (Object)this.zzcdp, null);
        if (this.zzcdz == null || this.zzcdz == EGL10.EGL_NO_SURFACE) {
            return false;
        }
        return this.zzcdw.eglMakeCurrent(this.zzcdx, this.zzcdz, this.zzcdz, this.zzcdy);
    }

    @Nullable
    private EGLConfig zzqz() {
        int[] nArray = new int[1];
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
        if (!this.zzcdw.eglChooseConfig(this.zzcdx, nArray2, eGLConfigArray, 1, nArray)) {
            return null;
        }
        if (nArray[0] > 0) {
            return eGLConfigArray[0];
        }
        return null;
    }

    private String zzra() {
        zzdn<String> zzdn2 = zzdr.zzbgo;
        if (!zzdn2.get().equals(zzdn2.zzlp())) {
            return zzdn2.get();
        }
        return "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
    }

    private String zzrb() {
        zzdn<String> zzdn2 = zzdr.zzbgp;
        if (!zzdn2.get().equals(zzdn2.zzlp())) {
            return zzdn2.get();
        }
        return "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
    }

    boolean zzrc() {
        boolean bl = false;
        if (this.zzcdz != null && this.zzcdz != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzcdw.eglMakeCurrent(this.zzcdx, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            bl |= this.zzcdw.eglDestroySurface(this.zzcdx, this.zzcdz);
            this.zzcdz = null;
        }
        if (this.zzcdy != null) {
            bl |= this.zzcdw.eglDestroyContext(this.zzcdx, this.zzcdy);
            this.zzcdy = null;
        }
        if (this.zzcdx != null) {
            bl |= this.zzcdw.eglTerminate(this.zzcdx);
            this.zzcdx = null;
        }
        return bl;
    }

    private void zzcf(String string2) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(": glError ").append(n).toString());
        }
    }
}

