/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zzc;
import com.google.android.gms.ads.internal.request.zze;
import com.google.android.gms.ads.internal.request.zzg;
import com.google.android.gms.ads.internal.request.zzk;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjk;
import com.google.android.gms.internal.zzjl;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzld;
import com.google.android.gms.internal.zzlw;

@zzji
public abstract class zzd
implements zzc.zza,
zzld<Void> {
    private final zzlw<AdRequestInfoParcel> zzcjm;
    private final zzc.zza zzcjn;
    private final Object zzako = new Object();

    public zzd(zzlw<AdRequestInfoParcel> zzlw2, zzc.zza zza2) {
        this.zzcjm = zzlw2;
        this.zzcjn = zza2;
    }

    public abstract void zztb();

    public abstract zzk zztc();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(AdResponseParcel adResponseParcel) {
        Object object = this.zzako;
        synchronized (object) {
            this.zzcjn.zzb(adResponseParcel);
            this.zztb();
        }
    }

    public Void zzrw() {
        final zzk zzk2 = this.zztc();
        if (zzk2 == null) {
            this.zzcjn.zzb(new AdResponseParcel(0));
            this.zztb();
            return null;
        }
        this.zzcjm.zza(new zzlw.zzc<AdRequestInfoParcel>(){

            public void zzc(AdRequestInfoParcel adRequestInfoParcel) {
                if (!zzd.this.zza(zzk2, adRequestInfoParcel)) {
                    zzd.this.zztb();
                }
            }

            @Override
            public /* synthetic */ void zzd(Object object) {
                this.zzc((AdRequestInfoParcel)((Object)object));
            }
        }, new zzlw.zza(){

            @Override
            public void run() {
                zzd.this.zztb();
            }
        });
        return null;
    }

    @Override
    public void cancel() {
        this.zztb();
    }

    boolean zza(zzk zzk2, AdRequestInfoParcel adRequestInfoParcel) {
        try {
            zzk2.zza(adRequestInfoParcel, new zzg(this));
            return true;
        }
        catch (RemoteException remoteException) {
            zzkx.zzc((String)"Could not fetch ad response from ad request service.", (Throwable)remoteException);
            zzu.zzgq().zza(remoteException, "AdRequestClientTask.getAdResponseFromService");
        }
        catch (NullPointerException nullPointerException) {
            zzkx.zzc((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)nullPointerException);
            zzu.zzgq().zza(nullPointerException, "AdRequestClientTask.getAdResponseFromService");
        }
        catch (SecurityException securityException) {
            zzkx.zzc((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)securityException);
            zzu.zzgq().zza(securityException, "AdRequestClientTask.getAdResponseFromService");
        }
        catch (Throwable throwable) {
            zzkx.zzc((String)"Could not fetch ad response from ad request service due to an Exception.", (Throwable)throwable);
            zzu.zzgq().zza(throwable, "AdRequestClientTask.getAdResponseFromService");
        }
        this.zzcjn.zzb(new AdResponseParcel(0));
        return false;
    }

    @Override
    public /* synthetic */ Object zzrz() {
        return this.zzrw();
    }

    @zzji
    public static class zzb
    extends zzd
    implements zze.zzb,
    zze.zzc {
        private Context mContext;
        private VersionInfoParcel zzanu;
        private zzlw<AdRequestInfoParcel> zzcjm;
        private final zzc.zza zzcjn;
        private final Object zzako = new Object();
        protected zze zzcjq;
        private boolean zzcjr;

        public zzb(Context context, VersionInfoParcel versionInfoParcel, zzlw<AdRequestInfoParcel> zzlw2, zzc.zza zza2) {
            super(zzlw2, zza2);
            Looper looper;
            this.mContext = context;
            this.zzanu = versionInfoParcel;
            this.zzcjm = zzlw2;
            this.zzcjn = zza2;
            if (zzdr.zzbek.get().booleanValue()) {
                this.zzcjr = true;
                looper = zzu.zzhc().zzwj();
            } else {
                looper = context.getMainLooper();
            }
            this.zzcjq = new zze(context, looper, this, this, this.zzanu.zzcyb);
            this.connect();
        }

        protected void connect() {
            this.zzcjq.zzavd();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public zzk zztc() {
            Object object = this.zzako;
            synchronized (object) {
                try {
                    return this.zzcjq.zzte();
                }
                catch (DeadObjectException | IllegalStateException throwable) {
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zztb() {
            Object object = this.zzako;
            synchronized (object) {
                if (this.zzcjq.isConnected() || this.zzcjq.isConnecting()) {
                    this.zzcjq.disconnect();
                }
                Binder.flushPendingCommands();
                if (this.zzcjr) {
                    zzu.zzhc().zzwk();
                    this.zzcjr = false;
                }
            }
        }

        zzld zztd() {
            return new zza(this.mContext, this.zzcjm, this.zzcjn);
        }

        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzkx.zzdg((String)"Cannot connect to remote service, fallback to local instance.");
            zzld zzld2 = this.zztd();
            zzld2.zzrz();
            Bundle bundle = new Bundle();
            bundle.putString("action", "gms_connection_failed_fallback_to_local");
            zzu.zzgm().zzb(this.mContext, this.zzanu.zzda, "gmob-apps", bundle, true);
        }

        public void onConnected(Bundle bundle) {
            Void cfr_ignored_0 = (Void)((zzd)this).zzrz();
        }

        public void onConnectionSuspended(int n) {
            zzkx.zzdg((String)"Disconnected from remote ad request service.");
        }

        @Override
        public /* synthetic */ Object zzrz() {
            return super.zzrw();
        }
    }

    @zzji
    public static final class zza
    extends zzd {
        private final Context mContext;

        public zza(Context context, zzlw<AdRequestInfoParcel> zzlw2, zzc.zza zza2) {
            super(zzlw2, zza2);
            this.mContext = context;
        }

        @Override
        public zzk zztc() {
            zzdk zzdk2 = new zzdk(zzdr.zzbcx.get());
            return zzjl.zza(this.mContext, zzdk2, zzjk.zzti());
        }

        @Override
        public void zztb() {
        }

        @Override
        public /* synthetic */ Object zzrz() {
            return super.zzrw();
        }
    }
}

