/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzfe;
import com.google.android.gms.internal.zzff;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zzge;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjj;
import com.google.android.gms.internal.zzjm;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzkw;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzlg;
import com.google.android.gms.internal.zzlw;
import com.google.android.gms.internal.zzmd;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzji
public class zzn
extends zzkw {
    static final long zzcmk = TimeUnit.SECONDS.toMillis(10L);
    private static final Object zzaox = new Object();
    static boolean zzcml = false;
    private static zzgh zzchl = null;
    private static zzff zzcmm = null;
    private static zzfj zzcmn = null;
    private static zzfe zzcmo = null;
    private final zza.zza zzcjh;
    private final AdRequestInfoParcel.zza zzcji;
    private final Object zzcgi = new Object();
    private final Context mContext;
    private zzgh.zzc zzcmp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzn(Context context, AdRequestInfoParcel.zza zza2, zza.zza zza3) {
        super(true);
        this.zzcjh = zza3;
        this.mContext = context;
        this.zzcji = zza2;
        Object object = zzaox;
        synchronized (object) {
            if (!zzcml) {
                zzcmn = new zzfj();
                zzcmm = new zzff(context.getApplicationContext(), zza2.zzari);
                zzcmo = new zzc();
                zzchl = new zzgh(this.mContext.getApplicationContext(), this.zzcji.zzari, zzdr.zzbcx.get(), new zzb(), new zza());
                zzcml = true;
            }
        }
    }

    protected static void zzb(zzge zzge2) {
        zzge2.zza("/loadAd", zzcmn);
        zzge2.zza("/fetchHttpRequest", zzcmm);
        zzge2.zza("/invalidRequest", zzcmo);
    }

    protected static void zzc(zzge zzge2) {
        zzge2.zzb("/loadAd", zzcmn);
        zzge2.zzb("/fetchHttpRequest", zzcmm);
        zzge2.zzb("/invalidRequest", zzcmo);
    }

    @Override
    public void zzfp() {
        zzkx.zzdg((String)"SdkLessAdLoaderBackgroundTask started.");
        AdRequestInfoParcel adRequestInfoParcel = new AdRequestInfoParcel(this.zzcji, null, -1L);
        AdResponseParcel adResponseParcel = this.zze(adRequestInfoParcel);
        long l = zzu.zzgs().elapsedRealtime();
        final zzko.zza zza2 = new zzko.zza(adRequestInfoParcel, adResponseParcel, null, null, adResponseParcel.errorCode, l, adResponseParcel.zzclf, null);
        com.google.android.gms.ads.internal.util.client.zza.zzcxr.post(new Runnable(){

            @Override
            public void run() {
                zzn.this.zzcjh.zza(zza2);
                if (zzn.this.zzcmp != null) {
                    zzn.this.zzcmp.release();
                    zzn.this.zzcmp = null;
                }
            }
        });
    }

    private AdResponseParcel zze(AdRequestInfoParcel adRequestInfoParcel) {
        JSONObject jSONObject;
        final String string2 = zzu.zzgm().zzvr();
        final JSONObject jSONObject2 = this.zza(adRequestInfoParcel, string2);
        if (jSONObject2 == null) {
            return new AdResponseParcel(0);
        }
        long l = zzu.zzgs().elapsedRealtime();
        Future<JSONObject> future = zzcmn.zzbd(string2);
        com.google.android.gms.ads.internal.util.client.zza.zzcxr.post(new Runnable(){

            @Override
            public void run() {
                zzn.this.zzcmp = zzchl.zzny();
                zzn.this.zzcmp.zza(new zzlw.zzc<zzgi>(){

                    public void zzb(zzgi zzgi2) {
                        try {
                            zzgi2.zza("AFMA_getAdapterLessMediationAd", jSONObject2);
                        }
                        catch (Exception exception) {
                            zzkx.zzb((String)"Error requesting an ad url", (Throwable)exception);
                            zzcmn.zzbe(string2);
                        }
                    }

                    @Override
                    public /* synthetic */ void zzd(Object object) {
                        this.zzb((zzgi)object);
                    }
                }, new zzlw.zza(){

                    @Override
                    public void run() {
                        zzcmn.zzbe(string2);
                    }
                });
            }
        });
        long l2 = zzcmk - (zzu.zzgs().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new AdResponseParcel(-1);
        }
        catch (TimeoutException timeoutException) {
            return new AdResponseParcel(2);
        }
        catch (ExecutionException executionException) {
            return new AdResponseParcel(0);
        }
        if (jSONObject == null) {
            return new AdResponseParcel(-1);
        }
        AdResponseParcel adResponseParcel = zzjm.zza(this.mContext, adRequestInfoParcel, jSONObject.toString());
        if (adResponseParcel.errorCode != -3 && TextUtils.isEmpty((CharSequence)adResponseParcel.body)) {
            return new AdResponseParcel(3);
        }
        return adResponseParcel;
    }

    private JSONObject zza(AdRequestInfoParcel adRequestInfoParcel, String string2) {
        Bundle bundle = adRequestInfoParcel.zzcju.extras.getBundle("sdk_less_server_data");
        if (bundle == null) {
            return null;
        }
        JSONObject jSONObject = zzjm.zza(this.mContext, new zzjj().zzf(adRequestInfoParcel).zza(zzu.zzgv().zzv(this.mContext)));
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            zzkx.zzc((String)"Cannot get advertising id info", (Throwable)throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string2);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzu.zzgm().zzap(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzcgi;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zza.zzcxr.post(new Runnable(){

                @Override
                public void run() {
                    if (zzn.this.zzcmp != null) {
                        zzn.this.zzcmp.release();
                        zzn.this.zzcmp = null;
                    }
                }
            });
        }
    }

    public static class zza
    implements zzlg<zzge> {
        public void zza(zzge zzge2) {
            zzn.zzc(zzge2);
        }

        @Override
        public /* synthetic */ void zzd(Object object) {
            this.zza((zzge)object);
        }
    }

    public static class zzb
    implements zzlg<zzge> {
        public void zza(zzge zzge2) {
            zzn.zzb(zzge2);
        }

        @Override
        public /* synthetic */ void zzd(Object object) {
            this.zza((zzge)object);
        }
    }

    public static class zzc
    implements zzfe {
        @Override
        public void zza(zzmd zzmd2, Map<String, String> map) {
            String string2 = map.get("request_id");
            String string3 = map.get("errors");
            String string4 = String.valueOf(string3);
            zzkx.zzdi((String)(string4.length() != 0 ? "Invalid request: ".concat(string4) : new String("Invalid request: ")));
            zzcmn.zzbe(string2);
        }
    }
}

