/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.os.Debug;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.ThinAdSizeParcel;
import com.google.android.gms.ads.internal.client.VideoOptionsParcel;
import com.google.android.gms.ads.internal.client.zzab;
import com.google.android.gms.ads.internal.client.zzf;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.client.zzw;
import com.google.android.gms.ads.internal.client.zzy;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.reward.mediation.client.RewardItemParcel;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzco;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzdx;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzed;
import com.google.android.gms.internal.zzfa;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzik;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjz;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzkp;
import com.google.android.gms.internal.zzkt;
import com.google.android.gms.internal.zzku;
import com.google.android.gms.internal.zzkx;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;

@zzji
public abstract class zza
extends zzu.zza
implements com.google.android.gms.ads.internal.client.zza,
zzp,
zza.zza,
zzfa,
zziu.zza,
zzkt {
    protected zzdz zzalt;
    protected zzdx zzalu;
    protected zzdx zzalv;
    protected boolean zzalw = false;
    protected final zzr zzalx;
    protected final zzv zzaly;
    @Nullable
    protected transient AdRequestParcel zzalz;
    protected final zzco zzama;
    protected final zzd zzamb;

    public zzd zzec() {
        return this.zzamb;
    }

    zza(zzv zzv2, @Nullable zzr zzr2, zzd zzd2) {
        this.zzaly = zzv2;
        this.zzalx = zzr2 != null ? zzr2 : new zzr(this);
        this.zzamb = zzd2;
        zzu.zzgm().zzz(this.zzaly.zzahs);
        zzu.zzgq().zzc(this.zzaly.zzahs, this.zzaly.zzari);
        zzu.zzgr().initialize(this.zzaly.zzahs);
        this.zzama = zzu.zzgq().zzvg();
        zzu.zzgp().initialize(this.zzaly.zzahs);
        this.zzed();
    }

    private void zzed() {
        if (zzdr.zzbjl.get().booleanValue()) {
            Timer timer = new Timer();
            CountDownLatch countDownLatch = new CountDownLatch(zzdr.zzbjn.get());
            TimerTask timerTask = this.zza(timer, countDownLatch);
            timer.schedule(timerTask, 0L, (long)zzdr.zzbjm.get());
        }
    }

    private TimerTask zza(final Timer timer, final CountDownLatch countDownLatch) {
        return new TimerTask(){

            @Override
            public void run() {
                if ((long)zzdr.zzbjn.get().intValue() != countDownLatch.getCount()) {
                    zzkx.zzdg((String)"Stopping method tracing");
                    Debug.stopMethodTracing();
                    if (countDownLatch.getCount() == 0L) {
                        timer.cancel();
                        return;
                    }
                }
                String string2 = String.valueOf(zza.this.zzaly.zzahs.getPackageName()).concat("_adsTrace_");
                try {
                    zzkx.zzdg((String)"Starting method tracing");
                    countDownLatch.countDown();
                    long l = zzu.zzgs().currentTimeMillis();
                    Debug.startMethodTracing((String)new StringBuilder(20 + String.valueOf(string2).length()).append(string2).append(l).toString(), (int)zzdr.zzbjo.get());
                }
                catch (Exception exception) {
                    zzkx.zzc((String)"Exception occurred while starting method tracing.", (Throwable)exception);
                    return;
                }
            }
        };
    }

    public void zzee() {
        this.zzalt = new zzdz(zzdr.zzbeq.get(), "load_ad", this.zzaly.zzarm.zzazq);
        this.zzalu = new zzdx(-1L, null, null);
        this.zzalv = new zzdx(-1L, null, null);
    }

    public void destroy() {
        zzaa.zzhs((String)"destroy must be called on the main UI thread.");
        this.zzalx.cancel();
        this.zzama.zzk(this.zzaly.zzarn);
        this.zzaly.destroy();
    }

    public com.google.android.gms.dynamic.zzd zzef() {
        zzaa.zzhs((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzac((Object)((Object)this.zzaly.zzarj));
    }

    @Nullable
    public AdSizeParcel zzeg() {
        zzaa.zzhs((String)"getAdSize must be called on the main UI thread.");
        return this.zzaly.zzarm == null ? null : new ThinAdSizeParcel(this.zzaly.zzarm);
    }

    public boolean isReady() {
        zzaa.zzhs((String)"isLoaded must be called on the main UI thread.");
        return this.zzaly.zzark == null && this.zzaly.zzarl == null && this.zzaly.zzarn != null;
    }

    public void setManualImpressionsEnabled(boolean bl) {
        throw new UnsupportedOperationException("Attempt to call setManualImpressionsEnabled for an unsupported ad type.");
    }

    private AdRequestParcel zza(AdRequestParcel adRequestParcel) {
        if (zzi.zzcj((Context)this.zzaly.zzahs) && adRequestParcel.zzayt != null) {
            return new zzf(adRequestParcel).zza(null).zzka();
        }
        return adRequestParcel;
    }

    public boolean zzb(AdRequestParcel adRequestParcel) {
        zzaa.zzhs((String)"loadAd must be called on the main UI thread.");
        zzu.zzgr().zzjt();
        if (zzdr.zzbge.get().booleanValue()) {
            AdRequestParcel.zzj((AdRequestParcel)adRequestParcel);
        }
        adRequestParcel = this.zza(adRequestParcel);
        if (this.zzaly.zzark != null || this.zzaly.zzarl != null) {
            if (this.zzalz != null) {
                zzkx.zzdi((String)"Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            } else {
                zzkx.zzdi((String)"Loading already in progress, saving this object for future refreshes.");
            }
            this.zzalz = adRequestParcel;
            return false;
        }
        zzkx.zzdh((String)"Starting ad request.");
        this.zzee();
        this.zzalu = this.zzalt.zzlz();
        if (!adRequestParcel.zzayo) {
            String string2 = String.valueOf(zzm.zzkr().zzao(this.zzaly.zzahs));
            zzkx.zzdh((String)new StringBuilder(71 + String.valueOf(string2).length()).append("Use AdRequest.Builder.addTestDevice(\"").append(string2).append("\") to get test ads on this device.").toString());
        }
        this.zzalx.zzg(adRequestParcel);
        this.zzalw = this.zza(adRequestParcel, this.zzalt);
        return this.zzalw;
    }

    protected abstract boolean zza(AdRequestParcel var1, zzdz var2);

    @Override
    public void zza(zzko.zza zza2) {
        long l;
        if (zza2.zzcsu.zzclf != -1L && !TextUtils.isEmpty((CharSequence)zza2.zzcsu.zzclo) && (l = this.zzx(zza2.zzcsu.zzclo)) != -1L) {
            zzdx zzdx2 = this.zzalt.zzc(zza2.zzcsu.zzclf + l);
            this.zzalt.zza(zzdx2, "stc");
        }
        this.zzalt.zzaz(zza2.zzcsu.zzclo);
        this.zzalt.zza(this.zzalu, "arf");
        this.zzalv = this.zzalt.zzlz();
        this.zzalt.zzg("gqi", zza2.zzcsu.zzclp);
        this.zzaly.zzark = null;
        this.zzaly.zzaro = zza2;
        this.zza(zza2, this.zzalt);
    }

    protected abstract void zza(zzko.zza var1, zzdz var2);

    boolean zza(zzko zzko2) {
        return false;
    }

    @Override
    public void zzb(zzko zzko2) {
        this.zzalt.zza(this.zzalv, "awr");
        this.zzaly.zzarl = null;
        if (zzko2.errorCode != -2 && zzko2.errorCode != 3) {
            zzu.zzgq().zzb(this.zzaly.zzhl());
        }
        if (zzko2.errorCode == -1) {
            this.zzalw = false;
            return;
        }
        if (this.zza(zzko2)) {
            zzkx.zzdg((String)"Ad refresh scheduled.");
        }
        if (zzko2.errorCode != -2) {
            this.zzh(zzko2.errorCode);
            return;
        }
        if (this.zzaly.zzasg == null) {
            this.zzaly.zzasg = new zzku(this.zzaly.zzarg);
        }
        this.zzama.zzj(this.zzaly.zzarn);
        if (this.zza(this.zzaly.zzarn, zzko2)) {
            this.zzaly.zzarn = zzko2;
            this.zzaly.zzhu();
            this.zzalt.zzg("is_mraid", this.zzaly.zzarn.zzic() ? "1" : "0");
            this.zzalt.zzg("is_mediation", this.zzaly.zzarn.zzclb ? "1" : "0");
            if (this.zzaly.zzarn.zzcbm != null && this.zzaly.zzarn.zzcbm.zzxc() != null) {
                this.zzalt.zzg("is_delay_pl", this.zzaly.zzarn.zzcbm.zzxc().zzxy() ? "1" : "0");
            }
            this.zzalt.zza(this.zzalu, "ttc");
            if (zzu.zzgq().zzuu() != null) {
                zzu.zzgq().zzuu().zza(this.zzalt);
            }
            if (this.zzaly.zzhp()) {
                this.zzen();
            }
        }
        if (zzko2.zzbvn != null) {
            zzu.zzgm().zza(this.zzaly.zzahs, zzko2.zzbvn);
        }
    }

    protected abstract boolean zza(@Nullable zzko var1, zzko var2);

    public void onAdClicked() {
        if (this.zzaly.zzarn == null) {
            zzkx.zzdi((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        zzkx.zzdg((String)"Pinging click URLs.");
        if (this.zzaly.zzarp != null) {
            this.zzaly.zzarp.zzuh();
        }
        if (this.zzaly.zzarn.zzbvk != null) {
            zzu.zzgm().zza(this.zzaly.zzahs, this.zzaly.zzari.zzda, this.zzaly.zzarn.zzbvk);
        }
        if (this.zzaly.zzarq != null) {
            try {
                this.zzaly.zzarq.onAdClicked();
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Could not notify onAdClicked event.", (Throwable)remoteException);
            }
        }
    }

    @Override
    public void zzeh() {
        this.zzel();
    }

    @Override
    public void onAppEvent(String string2, @Nullable String string3) {
        if (this.zzaly.zzars != null) {
            try {
                this.zzaly.zzars.onAppEvent(string2, string3);
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Could not call the AppEventListener.", (Throwable)remoteException);
            }
        }
    }

    public void zzei() {
        zzaa.zzhs((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzaly.zzarn == null) {
            zzkx.zzdi((String)"Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzkx.zzdg((String)"Pinging manual tracking URLs.");
        if (this.zzaly.zzarn.zzcld != null && !this.zzaly.zzarn.zzcss) {
            zzu.zzgm().zza(this.zzaly.zzahs, this.zzaly.zzari.zzda, this.zzaly.zzarn.zzcld);
            this.zzaly.zzarn.zzcss = true;
            this.zzd(this.zzaly.zzarn);
        }
    }

    public void pause() {
        zzaa.zzhs((String)"pause must be called on the main UI thread.");
    }

    public void resume() {
        zzaa.zzhs((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzc(AdRequestParcel adRequestParcel) {
        if (this.zzaly.zzarj == null) {
            return false;
        }
        ViewParent viewParent = this.zzaly.zzarj.getParent();
        if (!(viewParent instanceof View)) {
            return false;
        }
        View view = (View)viewParent;
        return zzu.zzgm().zza(view, view.getContext());
    }

    public void zzd(AdRequestParcel adRequestParcel) {
        if (this.zzc(adRequestParcel)) {
            this.zzb(adRequestParcel);
        } else {
            zzkx.zzdh((String)"Ad is not visible. Not refreshing ad.");
            this.zzalx.zzh(adRequestParcel);
        }
    }

    public void zza(zzq zzq2) {
        zzaa.zzhs((String)"setAdListener must be called on the main UI thread.");
        this.zzaly.zzarr = zzq2;
    }

    public void zza(com.google.android.gms.ads.internal.reward.client.zzd zzd2) {
        zzaa.zzhs((String)"setRewardedVideoAdListener can only be called from the UI thread.");
        this.zzaly.zzasd = zzd2;
    }

    public void setUserId(String string2) {
        zzkx.zzdi((String)"RewardedVideoAd.setUserId() is deprecated. Please do not call this method.");
    }

    public void zza(com.google.android.gms.ads.internal.client.zzp zzp2) {
        zzaa.zzhs((String)"setAdListener must be called on the main UI thread.");
        this.zzaly.zzarq = zzp2;
    }

    public void zza(AdSizeParcel adSizeParcel) {
        zzaa.zzhs((String)"setAdSize must be called on the main UI thread.");
        this.zzaly.zzarm = adSizeParcel;
        if (this.zzaly.zzarn != null && this.zzaly.zzarn.zzcbm != null && this.zzaly.zzasi == 0) {
            this.zzaly.zzarn.zzcbm.zza(adSizeParcel);
        }
        if (this.zzaly.zzarj == null) {
            return;
        }
        if (this.zzaly.zzarj.getChildCount() > 1) {
            this.zzaly.zzarj.removeView(this.zzaly.zzarj.getNextView());
        }
        this.zzaly.zzarj.setMinimumWidth(adSizeParcel.widthPixels);
        this.zzaly.zzarj.setMinimumHeight(adSizeParcel.heightPixels);
        this.zzaly.zzarj.requestLayout();
    }

    public void zza(zzw zzw2) {
        zzaa.zzhs((String)"setAppEventListener must be called on the main UI thread.");
        this.zzaly.zzars = zzw2;
    }

    public void zza(zzig zzig2) {
        throw new IllegalStateException("setInAppPurchaseListener is not supported for current ad type");
    }

    public void zza(zzed zzed2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    public void zza(zzik zzik2, String string2) {
        throw new IllegalStateException("setPlayStorePurchaseParams is not supported for current ad type");
    }

    public void zza(zzy zzy2) {
        zzaa.zzhs((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzaly.zzart = zzy2;
    }

    public void stopLoading() {
        zzaa.zzhs((String)"stopLoading must be called on the main UI thread.");
        this.zzalw = false;
        this.zzaly.zzi(true);
    }

    public boolean isLoading() {
        return this.zzalw;
    }

    public zzab zzej() {
        return null;
    }

    public void zza(@Nullable VideoOptionsParcel videoOptionsParcel) {
        zzaa.zzhs((String)"setVideoOptions must be called on the main UI thread.");
        this.zzaly.zzasb = videoOptionsParcel;
    }

    long zzx(String string2) {
        int n = string2.indexOf("ufe");
        int n2 = string2.indexOf(44, n);
        if (n2 == -1) {
            n2 = string2.length();
        }
        try {
            return Long.parseLong(string2.substring(n + 4, n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzkx.zzdi((String)"Invalid index for Url fetch time in CSI latency info.");
        }
        catch (NumberFormatException numberFormatException) {
            zzkx.zzdi((String)"Cannot find valid format of Url fetch time in CSI latency info.");
        }
        return -1L;
    }

    protected void zzb(View view) {
        zzv.zza zza2 = this.zzaly.zzarj;
        if (zza2 != null) {
            zza2.addView(view, zzu.zzgo().zzvz());
        }
    }

    protected void zzek() {
        zzkx.zzdh((String)"Ad closing.");
        if (this.zzaly.zzarr != null) {
            try {
                this.zzaly.zzarr.onAdClosed();
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Could not call AdListener.onAdClosed().", (Throwable)remoteException);
            }
        }
        if (this.zzaly.zzasd != null) {
            try {
                this.zzaly.zzasd.onRewardedVideoAdClosed();
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdClosed().", (Throwable)remoteException);
            }
        }
    }

    protected void zzel() {
        zzkx.zzdh((String)"Ad leaving application.");
        if (this.zzaly.zzarr != null) {
            try {
                this.zzaly.zzarr.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Could not call AdListener.onAdLeftApplication().", (Throwable)remoteException);
            }
        }
        if (this.zzaly.zzasd != null) {
            try {
                this.zzaly.zzasd.onRewardedVideoAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Could not call  RewardedVideoAdListener.onRewardedVideoAdLeftApplication().", (Throwable)remoteException);
            }
        }
    }

    protected void zzem() {
        zzkx.zzdh((String)"Ad opening.");
        if (this.zzaly.zzarr != null) {
            try {
                this.zzaly.zzarr.onAdOpened();
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Could not call AdListener.onAdOpened().", (Throwable)remoteException);
            }
        }
        if (this.zzaly.zzasd != null) {
            try {
                this.zzaly.zzasd.onRewardedVideoAdOpened();
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdOpened().", (Throwable)remoteException);
            }
        }
    }

    protected void zzen() {
        zzkx.zzdh((String)"Ad finished loading.");
        this.zzalw = false;
        if (this.zzaly.zzarr != null) {
            try {
                this.zzaly.zzarr.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Could not call AdListener.onAdLoaded().", (Throwable)remoteException);
            }
        }
        if (this.zzaly.zzasd != null) {
            try {
                this.zzaly.zzasd.onRewardedVideoAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdLoaded().", (Throwable)remoteException);
            }
        }
    }

    protected void zzh(int n) {
        zzkx.zzdi((String)new StringBuilder(30).append("Failed to load ad: ").append(n).toString());
        this.zzalw = false;
        if (this.zzaly.zzarr != null) {
            try {
                this.zzaly.zzarr.onAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
            }
        }
        if (this.zzaly.zzasd != null) {
            try {
                this.zzaly.zzasd.onRewardedVideoAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzkx.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdFailedToLoad().", (Throwable)remoteException);
            }
        }
    }

    protected void zzeo() {
        if (this.zzaly.zzasd == null) {
            return;
        }
        try {
            this.zzaly.zzasd.onRewardedVideoStarted();
        }
        catch (RemoteException remoteException) {
            zzkx.zzc((String)"Could not call RewardedVideoAdListener.onVideoStarted().", (Throwable)remoteException);
        }
    }

    protected void zza(@Nullable RewardItemParcel rewardItemParcel) {
        if (this.zzaly.zzasd == null) {
            return;
        }
        try {
            String string2 = "";
            int n = 0;
            if (rewardItemParcel != null) {
                string2 = rewardItemParcel.type;
                n = rewardItemParcel.zzcsc;
            }
            this.zzaly.zzasd.zza((com.google.android.gms.ads.internal.reward.client.zza)new zzjz(string2, n));
        }
        catch (RemoteException remoteException) {
            zzkx.zzc((String)"Could not call RewardedVideoAdListener.onRewarded().", (Throwable)remoteException);
        }
    }

    protected void zzc(@Nullable zzko zzko2) {
        if (zzko2 == null) {
            zzkx.zzdi((String)"Ad state was null when trying to ping impression URLs.");
            return;
        }
        zzkx.zzdg((String)"Pinging Impression URLs.");
        if (this.zzaly.zzarp != null) {
            this.zzaly.zzarp.zzug();
        }
        if (zzko2.zzbvl != null && !zzko2.zzcsr) {
            zzu.zzgm().zza(this.zzaly.zzahs, this.zzaly.zzari.zzda, zzko2.zzbvl);
            zzko2.zzcsr = true;
            this.zzd(zzko2);
        }
    }

    private void zzd(zzko zzko2) {
        if (!zzu.zzgu().zzwg() || zzko2.zzcst || TextUtils.isEmpty((CharSequence)zzko2.zzclx)) {
            return;
        }
        zzkx.zzdg((String)"Sending troubleshooting signals to the server.");
        zzu.zzgu().zza(this.zzaly.zzahs, this.zzaly.zzari.zzda, zzko2.zzclx, this.zzaly.zzarg);
        zzko2.zzcst = true;
    }

    @Override
    public void zza(HashSet<zzkp> hashSet) {
        this.zzaly.zza(hashSet);
    }
}

