/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Messenger;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.View;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.purchase.GInAppPurchaseManagerInfoParcel;
import com.google.android.gms.ads.internal.purchase.zzc;
import com.google.android.gms.ads.internal.purchase.zzf;
import com.google.android.gms.ads.internal.purchase.zzj;
import com.google.android.gms.ads.internal.purchase.zzk;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.CapabilityParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzr;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzdz;
import com.google.android.gms.internal.zzfg;
import com.google.android.gms.internal.zzgr;
import com.google.android.gms.internal.zzgz;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzij;
import com.google.android.gms.internal.zzik;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzko;
import com.google.android.gms.internal.zzkp;
import com.google.android.gms.internal.zzkq;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzmd;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Future;

@zzji
public abstract class zzb
extends zza
implements zzg,
zzj,
zzs,
zzfg,
zzgr {
    protected final zzgz zzamf;
    private final Messenger mMessenger;
    protected transient boolean zzamg;

    public zzb(Context context, AdSizeParcel adSizeParcel, String string2, zzgz zzgz2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        this(new zzv(context, adSizeParcel, string2, versionInfoParcel), zzgz2, null, zzd2);
    }

    protected zzb(zzv zzv2, zzgz zzgz2, @Nullable zzr zzr2, zzd zzd2) {
        super(zzv2, zzr2, zzd2);
        this.zzamf = zzgz2;
        this.mMessenger = new Messenger((Handler)new zzid(this.zzaly.zzahs));
        this.zzamg = false;
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel, zzdz zzdz2) {
        if (!this.zzep()) {
            return false;
        }
        Bundle bundle = null;
        bundle = zzu.zzgm().zzak(this.zzaly.zzahs);
        this.zzalx.cancel();
        this.zzaly.zzasi = 0;
        zzkq zzkq2 = null;
        if (zzdr.zzbjv.get().booleanValue()) {
            zzkq2 = zzu.zzgq().zzvf();
            zzu.zzhi().zza(this.zzaly.zzahs, this.zzaly.zzari, false, zzkq2, zzkq2.zzup(), this.zzaly.zzarg);
        }
        AdRequestInfoParcel.zza zza2 = this.zza(adRequestParcel, bundle, zzkq2);
        zzdz2.zzg("seq_num", zza2.zzcjx);
        zzdz2.zzg("request_id", zza2.zzcki);
        zzdz2.zzg("session_id", zza2.zzcjy);
        if (zza2.zzcjv != null) {
            zzdz2.zzg("app_version", String.valueOf(zza2.zzcjv.versionCode));
        }
        this.zzaly.zzark = zzu.zzgi().zza(this.zzaly.zzahs, zza2, this.zzaly.zzarh, this);
        return true;
    }

    @Override
    public void zzb(zzko zzko2) {
        super.zzb(zzko2);
        if (zzko2.zzbwm != null) {
            zzkx.zzdg((String)"Disable the debug gesture detector on the mediation ad frame.");
            if (this.zzaly.zzarj != null) {
                this.zzaly.zzarj.zzhx();
            }
            zzkx.zzdg((String)"Pinging network fill URLs.");
            zzu.zzhf().zza(this.zzaly.zzahs, this.zzaly.zzari.zzda, zzko2, this.zzaly.zzarg, false, zzko2.zzbwm.zzbuz);
            if (zzko2.zzcsk != null && zzko2.zzcsk.zzbvn != null && zzko2.zzcsk.zzbvn.size() > 0) {
                zzkx.zzdg((String)"Pinging urls remotely");
                zzu.zzgm().zza(this.zzaly.zzahs, zzko2.zzcsk.zzbvn);
            }
        } else {
            zzkx.zzdg((String)"Enable the debug gesture detector on the admob ad frame.");
            if (this.zzaly.zzarj != null) {
                this.zzaly.zzarj.zzhw();
            }
        }
        if (zzko2.errorCode == 3 && zzko2.zzcsk != null && zzko2.zzcsk.zzbvm != null) {
            zzkx.zzdg((String)"Pinging no fill URLs.");
            zzu.zzhf().zza(this.zzaly.zzahs, this.zzaly.zzari.zzda, zzko2, this.zzaly.zzarg, false, zzko2.zzcsk.zzbvm);
        }
    }

    @Override
    protected boolean zza(@Nullable zzko zzko2, zzko zzko3) {
        if (zzko2 != null && zzko2.zzbwp != null) {
            zzko2.zzbwp.zza((zzgr)null);
        }
        if (zzko3.zzbwp != null) {
            zzko3.zzbwp.zza(this);
        }
        int n = 0;
        int n2 = 0;
        if (zzko3.zzcsk != null) {
            n = zzko3.zzcsk.zzbvw;
            n2 = zzko3.zzcsk.zzbvx;
        }
        this.zzaly.zzasg.zzj(n, n2);
        return true;
    }

    @Override
    public void onAdClicked() {
        if (this.zzaly.zzarn == null) {
            zzkx.zzdi((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        if (this.zzaly.zzarn.zzcsk != null && this.zzaly.zzarn.zzcsk.zzbvk != null) {
            zzu.zzhf().zza(this.zzaly.zzahs, this.zzaly.zzari.zzda, this.zzaly.zzarn, this.zzaly.zzarg, false, this.zzaly.zzarn.zzcsk.zzbvk);
        }
        if (this.zzaly.zzarn.zzbwm != null && this.zzaly.zzarn.zzbwm.zzbux != null) {
            zzu.zzhf().zza(this.zzaly.zzahs, this.zzaly.zzari.zzda, this.zzaly.zzarn, this.zzaly.zzarg, false, this.zzaly.zzarn.zzbwm.zzbux);
        }
        super.onAdClicked();
    }

    @Override
    boolean zza(zzko zzko2) {
        AdRequestParcel adRequestParcel;
        boolean bl = false;
        if (this.zzalz != null) {
            adRequestParcel = this.zzalz;
            this.zzalz = null;
        } else {
            adRequestParcel = zzko2.zzcju;
            bl = adRequestParcel.extras != null ? adRequestParcel.extras.getBoolean("_noRefresh", false) : false;
        }
        return this.zza(adRequestParcel, zzko2, bl);
    }

    protected boolean zza(AdRequestParcel adRequestParcel, zzko zzko2, boolean bl) {
        if (!bl && this.zzaly.zzhp()) {
            if (zzko2.zzbvq > 0L) {
                this.zzalx.zza(adRequestParcel, zzko2.zzbvq);
            } else if (zzko2.zzcsk != null && zzko2.zzcsk.zzbvq > 0L) {
                this.zzalx.zza(adRequestParcel, zzko2.zzcsk.zzbvq);
            } else if (!zzko2.zzclb && zzko2.errorCode == 2) {
                this.zzalx.zzh(adRequestParcel);
            }
        }
        return this.zzalx.zzfy();
    }

    @Override
    public void pause() {
        zzaa.zzhs((String)"pause must be called on the main UI thread.");
        if (this.zzaly.zzarn != null && this.zzaly.zzarn.zzcbm != null && this.zzaly.zzhp()) {
            zzu.zzgo().zzl(this.zzaly.zzarn.zzcbm);
        }
        if (this.zzaly.zzarn != null && this.zzaly.zzarn.zzbwn != null) {
            try {
                this.zzaly.zzarn.zzbwn.pause();
            }
            catch (RemoteException remoteException) {
                zzkx.zzdi((String)"Could not pause mediation adapter.");
            }
        }
        this.zzama.zzl(this.zzaly.zzarn);
        this.zzalx.pause();
    }

    @Override
    public void resume() {
        zzaa.zzhs((String)"resume must be called on the main UI thread.");
        zzmd zzmd2 = null;
        if (this.zzaly.zzarn != null && this.zzaly.zzarn.zzcbm != null) {
            zzmd2 = this.zzaly.zzarn.zzcbm;
        }
        if (zzmd2 != null && this.zzaly.zzhp()) {
            zzu.zzgo().zzm(this.zzaly.zzarn.zzcbm);
        }
        if (this.zzaly.zzarn != null && this.zzaly.zzarn.zzbwn != null) {
            try {
                this.zzaly.zzarn.zzbwn.resume();
            }
            catch (RemoteException remoteException) {
                zzkx.zzdi((String)"Could not resume mediation adapter.");
            }
        }
        if (zzmd2 == null || !zzmd2.zzxj()) {
            this.zzalx.resume();
        }
        this.zzama.zzm(this.zzaly.zzarn);
    }

    @Override
    protected boolean zzc(AdRequestParcel adRequestParcel) {
        return super.zzc(adRequestParcel) && !this.zzamg;
    }

    protected boolean zzep() {
        boolean bl = true;
        if (!zzu.zzgm().zza(this.zzaly.zzahs.getPackageManager(), this.zzaly.zzahs.getPackageName(), "android.permission.INTERNET") || !zzu.zzgm().zzy(this.zzaly.zzahs)) {
            bl = false;
        }
        return bl;
    }

    @Override
    public void zzeq() {
        this.zzama.zzj(this.zzaly.zzarn);
        this.zzamg = false;
        this.zzek();
        this.zzaly.zzarp.zzui();
    }

    @Override
    public void zzer() {
        this.zzamg = true;
        this.zzem();
    }

    @Override
    public void onPause() {
        this.zzama.zzl(this.zzaly.zzarn);
    }

    @Override
    public void onResume() {
        this.zzama.zzm(this.zzaly.zzarn);
    }

    @Override
    public void zzes() {
        this.onAdClicked();
    }

    @Override
    public void zzet() {
        this.zzeq();
    }

    @Override
    public void zzeu() {
        this.zzeh();
    }

    @Override
    public void zzev() {
        this.zzer();
    }

    @Override
    public void zzew() {
        if (this.zzaly.zzarn != null) {
            String string2 = this.zzaly.zzarn.zzbwo;
            zzkx.zzdi((String)new StringBuilder(74 + String.valueOf(string2).length()).append("Mediation adapter ").append(string2).append(" refreshed, but mediation adapters should never refresh.").toString());
        }
        this.zza(this.zzaly.zzarn, true);
        this.zzen();
    }

    @Override
    public void zzex() {
        this.recordImpression();
    }

    private AdRequestInfoParcel.zza zza(AdRequestParcel adRequestParcel, Bundle bundle, zzkq zzkq2) {
        String string2;
        int n;
        Object object;
        PackageInfo packageInfo;
        PackageManager packageManager;
        ApplicationInfo applicationInfo = this.zzaly.zzahs.getApplicationInfo();
        try {
            packageManager = this.zzaly.zzahs.getPackageManager();
            packageInfo = packageManager.getPackageInfo(applicationInfo.packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = null;
        }
        packageManager = this.zzaly.zzahs.getResources().getDisplayMetrics();
        Bundle bundle2 = null;
        if (this.zzaly.zzarj != null && this.zzaly.zzarj.getParent() != null) {
            object = new int[2];
            this.zzaly.zzarj.getLocationOnScreen((int[])object);
            Object object2 = object[0];
            Object object3 = object[1];
            int n2 = this.zzaly.zzarj.getWidth();
            int n3 = this.zzaly.zzarj.getHeight();
            int n4 = 0;
            if (this.zzaly.zzarj.isShown() && object2 + n2 > 0 && object3 + n3 > 0 && object2 <= packageManager.widthPixels && object3 <= packageManager.heightPixels) {
                n4 = 1;
            }
            bundle2 = new Bundle(5);
            bundle2.putInt("x", (int)object2);
            bundle2.putInt("y", (int)object3);
            bundle2.putInt("width", n2);
            bundle2.putInt("height", n3);
            bundle2.putInt("visible", n4);
        }
        object = zzu.zzgq().zzus();
        this.zzaly.zzarp = new zzkp((String)object, this.zzaly.zzarg);
        this.zzaly.zzarp.zzt(adRequestParcel);
        String string3 = zzu.zzgm().zza(this.zzaly.zzahs, (View)this.zzaly.zzarj, this.zzaly.zzarm);
        long l = 0L;
        if (this.zzaly.zzart != null) {
            try {
                l = this.zzaly.zzart.getValue();
            }
            catch (RemoteException remoteException) {
                zzkx.zzdi((String)"Cannot get correlation id, default to 0.");
            }
        }
        String string4 = UUID.randomUUID().toString();
        Bundle bundle3 = zzu.zzgq().zza(this.zzaly.zzahs, this, (String)object);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < this.zzaly.zzarz.size(); n += 1) {
            arrayList.add((String)this.zzaly.zzarz.keyAt(n));
        }
        n = this.zzaly.zzaru != null ? 1 : 0;
        boolean bl = this.zzaly.zzarv != null && zzu.zzgq().zzvi();
        zzm cfr_ignored_0 = this.zzamb.zzamr;
        Context cfr_ignored_1 = this.zzaly.zzahs;
        boolean bl2 = false;
        String string5 = "";
        if (zzdr.zzbkn.get().booleanValue()) {
            zzkx.zzdg((String)"Getting webview cookie from CookieManager.");
            string2 = zzu.zzgo().zzal(this.zzaly.zzahs);
            if (string2 != null) {
                string5 = string2.getCookie("googleads.g.doubleclick.net");
            }
        }
        string2 = null;
        if (zzkq2 != null) {
            string2 = zzkq2.zzuo();
        }
        return new AdRequestInfoParcel.zza(bundle2, adRequestParcel, this.zzaly.zzarm, this.zzaly.zzarg, applicationInfo, packageInfo, (String)object, zzu.zzgq().getSessionId(), this.zzaly.zzari, bundle3, this.zzaly.zzase, arrayList, bundle, zzu.zzgq().zzuw(), this.mMessenger, packageManager.widthPixels, packageManager.heightPixels, packageManager.density, string3, l, string4, zzdr.zzlq(), this.zzaly.zzarf, this.zzaly.zzasa, new CapabilityParcel(n != 0, bl, false), this.zzaly.zzht(), zzu.zzgm().zzfr(), zzu.zzgm().zzft(), zzu.zzgm().zzai(this.zzaly.zzahs), zzu.zzgm().zzt((View)this.zzaly.zzarj), this.zzaly.zzahs instanceof Activity, zzu.zzgq().zzvb(), string5, string2, zzu.zzgq().zzve(), zzu.zzhj().zzni(), zzu.zzgm().zzvv(), zzu.zzgu().zzwf());
    }

    @Override
    public void zza(zzig zzig2) {
        zzaa.zzhs((String)"setInAppPurchaseListener must be called on the main UI thread.");
        this.zzaly.zzaru = zzig2;
    }

    @Override
    public void zza(zzik zzik2, @Nullable String string2) {
        zzaa.zzhs((String)"setPlayStorePurchaseParams must be called on the main UI thread.");
        this.zzaly.zzasf = new zzk(string2);
        this.zzaly.zzarv = zzik2;
        if (!zzu.zzgq().zzuv() && zzik2 != null) {
            Future cfr_ignored_0 = (Future)new zzc(this.zzaly.zzahs, this.zzaly.zzarv, this.zzaly.zzasf).zzrz();
        }
    }

    @Override
    public void zza(String string2, ArrayList<String> arrayList) {
        com.google.android.gms.ads.internal.purchase.zzd zzd2 = new com.google.android.gms.ads.internal.purchase.zzd(string2, arrayList, this.zzaly.zzahs, this.zzaly.zzari.zzda);
        if (this.zzaly.zzaru == null) {
            zzkx.zzdi((String)"InAppPurchaseListener is not set. Try to launch default purchase flow.");
            if (!com.google.android.gms.ads.internal.client.zzm.zzkr().zzap(this.zzaly.zzahs)) {
                zzkx.zzdi((String)"Google Play Service unavailable, cannot launch default purchase flow.");
                return;
            }
            if (this.zzaly.zzarv == null) {
                zzkx.zzdi((String)"PlayStorePurchaseListener is not set.");
                return;
            }
            if (this.zzaly.zzasf == null) {
                zzkx.zzdi((String)"PlayStorePurchaseVerifier is not initialized.");
                return;
            }
            if (this.zzaly.zzasj) {
                zzkx.zzdi((String)"An in-app purchase request is already in progress, abort");
                return;
            }
            this.zzaly.zzasj = true;
            try {
                if (!this.zzaly.zzarv.isValidPurchase(string2)) {
                    this.zzaly.zzasj = false;
                    return;
                }
            }
            catch (RemoteException remoteException) {
                zzkx.zzdi((String)"Could not start In-App purchase.");
                this.zzaly.zzasj = false;
                return;
            }
            zzu.zzha().zza(this.zzaly.zzahs, this.zzaly.zzari.zzcyc, new GInAppPurchaseManagerInfoParcel(this.zzaly.zzahs, this.zzaly.zzasf, (zzif)zzd2, this));
        } else {
            try {
                this.zzaly.zzaru.zza((zzif)zzd2);
            }
            catch (RemoteException remoteException) {
                zzkx.zzdi((String)"Could not start In-App purchase.");
            }
        }
    }

    @Override
    public void zza(String string2, boolean bl, int n, final Intent intent, zzf zzf2) {
        try {
            if (this.zzaly.zzarv != null) {
                this.zzaly.zzarv.zza((zzij)new com.google.android.gms.ads.internal.purchase.zzg(this.zzaly.zzahs, string2, bl, n, intent, zzf2));
            }
        }
        catch (RemoteException remoteException) {
            zzkx.zzdi((String)"Fail to invoke PlayStorePurchaseListener.");
        }
        zzlb.zzcvl.postDelayed(new Runnable(){

            @Override
            public void run() {
                int n = zzu.zzha().zzd(intent);
                zzu.zzha();
                if (n == 0 && zzb.this.zzaly.zzarn != null && zzb.this.zzaly.zzarn.zzcbm != null && zzb.this.zzaly.zzarn.zzcbm.zzxa() != null) {
                    zzb.this.zzaly.zzarn.zzcbm.zzxa().close();
                }
                zzb.this.zzaly.zzasj = false;
            }
        }, 500L);
    }

    public void recordImpression() {
        this.zza(this.zzaly.zzarn, false);
    }

    protected void zza(@Nullable zzko zzko2, boolean bl) {
        if (zzko2 == null) {
            zzkx.zzdi((String)"Ad state was null when trying to ping impression URLs.");
            return;
        }
        super.zzc(zzko2);
        if (zzko2.zzcsk != null && zzko2.zzcsk.zzbvl != null) {
            zzu.zzhf().zza(this.zzaly.zzahs, this.zzaly.zzari.zzda, zzko2, this.zzaly.zzarg, bl, zzko2.zzcsk.zzbvl);
        }
        if (zzko2.zzbwm != null && zzko2.zzbwm.zzbuy != null) {
            zzu.zzhf().zza(this.zzaly.zzahs, this.zzaly.zzari.zzda, zzko2, this.zzaly.zzarg, bl, zzko2.zzbwm.zzbuy);
        }
    }

    public String getMediationAdapterClassName() {
        if (this.zzaly.zzarn == null) {
            return null;
        }
        return this.zzaly.zzarn.zzbwo;
    }

    public void showInterstitial() {
        throw new IllegalStateException("showInterstitial is not supported for current ad type");
    }

    @Override
    public void zzey() {
        zzu.zzgm().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                zzb.this.zzalx.pause();
            }
        });
    }

    @Override
    public void zzez() {
        zzu.zzgm().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                zzb.this.zzalx.resume();
            }
        });
    }
}

