/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.client.VideoOptionsParcel;
import com.google.android.gms.ads.internal.client.zzab;
import com.google.android.gms.ads.internal.client.zzm;
import com.google.android.gms.ads.internal.client.zzp;
import com.google.android.gms.ads.internal.client.zzq;
import com.google.android.gms.ads.internal.client.zzu;
import com.google.android.gms.ads.internal.client.zzw;
import com.google.android.gms.ads.internal.client.zzy;
import com.google.android.gms.ads.internal.reward.client.zzd;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzcf;
import com.google.android.gms.internal.zzcg;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzed;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzik;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzla;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzji
public class zzt
extends zzu.zza {
    private final VersionInfoParcel zzanu;
    private final AdSizeParcel zzapp;
    private final Future<zzcf> zzapq;
    private final Context mContext;
    private final zzb zzapr;
    @Nullable
    private WebView zzaps;
    @Nullable
    private zzq zzanl;
    @Nullable
    private zzcf zzapt;
    private AsyncTask<Void, Void, String> zzapu;

    public zzt(Context context, AdSizeParcel adSizeParcel, String string2, VersionInfoParcel versionInfoParcel) {
        this.mContext = context;
        this.zzanu = versionInfoParcel;
        this.zzapp = adSizeParcel;
        this.zzaps = new WebView(this.mContext);
        this.zzapq = this.zzgc();
        this.zzapr = new zzb(string2);
        this.zzfz();
    }

    public com.google.android.gms.dynamic.zzd zzef() throws RemoteException {
        zzaa.zzhs((String)"getAdFrame must be called on the main UI thread.");
        return zze.zzac((Object)this.zzaps);
    }

    public void destroy() throws RemoteException {
        zzaa.zzhs((String)"destroy must be called on the main UI thread.");
        this.zzapu.cancel(true);
        this.zzapq.cancel(true);
        this.zzaps.destroy();
        this.zzaps = null;
    }

    public boolean isReady() throws RemoteException {
        return false;
    }

    public boolean zzb(AdRequestParcel adRequestParcel) throws RemoteException {
        zzaa.zzb((Object)this.zzaps, (Object)"This Search Ad has already been torn down");
        this.zzapr.zzi(adRequestParcel);
        this.zzapu = new zza().execute(new Void[0]);
        return true;
    }

    public void pause() throws RemoteException {
        zzaa.zzhs((String)"pause must be called on the main UI thread.");
    }

    public void resume() throws RemoteException {
        zzaa.zzhs((String)"resume must be called on the main UI thread.");
    }

    public void zza(zzq zzq2) throws RemoteException {
        this.zzanl = zzq2;
    }

    public void zza(zzw zzw2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void showInterstitial() throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void stopLoading() throws RemoteException {
    }

    public void zzei() throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public AdSizeParcel zzeg() throws RemoteException {
        return this.zzapp;
    }

    public void zza(AdSizeParcel adSizeParcel) throws RemoteException {
        throw new IllegalStateException("AdSize must be set before initialization");
    }

    public void zza(zzig zzig2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void zza(zzik zzik2, String string2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    @Nullable
    public String getMediationAdapterClassName() throws RemoteException {
        return null;
    }

    public void zza(zzed zzed2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void zza(zzp zzp2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void zza(zzy zzy2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void setManualImpressionsEnabled(boolean bl) throws RemoteException {
    }

    public boolean isLoading() throws RemoteException {
        return false;
    }

    public void zza(zzd zzd2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    public void setUserId(String string2) throws RemoteException {
        throw new IllegalStateException("Unused method");
    }

    @Nullable
    public zzab zzej() {
        return null;
    }

    public void zza(VideoOptionsParcel videoOptionsParcel) {
        throw new IllegalStateException("Unused method");
    }

    private void zzfz() {
        this.zzj(0);
        this.zzaps.setVerticalScrollBarEnabled(false);
        this.zzaps.getSettings().setJavaScriptEnabled(true);
        this.zzaps.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
                if (string2.startsWith(zzt.this.zzgb())) {
                    return false;
                }
                if (string2.startsWith(zzdr.zzbka.get())) {
                    if (zzt.this.zzanl != null) {
                        try {
                            zzt.this.zzanl.onAdFailedToLoad(3);
                        }
                        catch (RemoteException remoteException) {
                            zzkx.zzc((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
                        }
                    }
                    zzt.this.zzj(0);
                    return true;
                }
                if (string2.startsWith(zzdr.zzbkb.get())) {
                    if (zzt.this.zzanl != null) {
                        try {
                            zzt.this.zzanl.onAdFailedToLoad(0);
                        }
                        catch (RemoteException remoteException) {
                            zzkx.zzc((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
                        }
                    }
                    zzt.this.zzj(0);
                    return true;
                }
                if (string2.startsWith(zzdr.zzbkc.get())) {
                    if (zzt.this.zzanl != null) {
                        try {
                            zzt.this.zzanl.onAdLoaded();
                        }
                        catch (RemoteException remoteException) {
                            zzkx.zzc((String)"Could not call AdListener.onAdLoaded().", (Throwable)remoteException);
                        }
                    }
                    int n = zzt.this.zzab(string2);
                    zzt.this.zzj(n);
                    return true;
                }
                if (string2.startsWith("gmsg://")) {
                    return true;
                }
                if (zzt.this.zzanl != null) {
                    try {
                        zzt.this.zzanl.onAdLeftApplication();
                    }
                    catch (RemoteException remoteException) {
                        zzkx.zzc((String)"Could not call AdListener.onAdLeftApplication().", (Throwable)remoteException);
                    }
                }
                String string3 = zzt.this.zzac(string2);
                zzt.this.zzad(string3);
                return true;
            }

            public void onReceivedError(WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
                if (zzt.this.zzanl != null) {
                    try {
                        zzt.this.zzanl.onAdFailedToLoad(0);
                    }
                    catch (RemoteException remoteException) {
                        zzkx.zzc((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
                    }
                }
            }
        });
        this.zzaps.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (zzt.this.zzapt != null) {
                    try {
                        zzt.this.zzapt.zza(motionEvent);
                    }
                    catch (RemoteException remoteException) {
                        zzkx.zzc((String)"Unable to process ad data", (Throwable)remoteException);
                    }
                }
                return false;
            }
        });
    }

    int zzab(String string2) {
        String string3 = Uri.parse((String)string2).getQueryParameter("height");
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return 0;
        }
        try {
            return zzm.zzkr().zzb(this.mContext, Integer.parseInt(string3));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    void zzj(int n) {
        if (this.zzaps == null) {
            return;
        }
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, n);
        this.zzaps.setLayoutParams(layoutParams);
    }

    String zzga() {
        String string22;
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https://").appendEncodedPath(zzdr.zzbkd.get());
        builder.appendQueryParameter("query", this.zzapr.getQuery());
        builder.appendQueryParameter("pubId", this.zzapr.zzgf());
        Map<String, String> map = this.zzapr.zzgg();
        for (String string22 : map.keySet()) {
            builder.appendQueryParameter(string22, map.get(string22));
        }
        Uri uri = builder.build();
        if (this.zzapt != null) {
            try {
                uri = this.zzapt.zzc(uri, this.mContext);
            }
            catch (RemoteException | zzcg throwable) {
                zzkx.zzc((String)"Unable to process ad data", (Throwable)throwable);
            }
        }
        string22 = String.valueOf(this.zzgb());
        String string3 = String.valueOf(uri.getEncodedQuery());
        return new StringBuilder(1 + String.valueOf(string22).length() + String.valueOf(string3).length()).append(string22).append("#").append(string3).toString();
    }

    String zzgb() {
        String string2 = this.zzapr.zzge();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "www.google.com";
        }
        String string3 = String.valueOf("https://");
        String string4 = string2;
        String string5 = zzdr.zzbkd.get();
        return new StringBuilder(0 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string3).append(string4).append(string5).toString();
    }

    private String zzac(String string2) {
        if (this.zzapt == null) {
            return string2;
        }
        Uri uri = Uri.parse((String)string2);
        try {
            uri = this.zzapt.zzd(uri, this.mContext);
        }
        catch (RemoteException remoteException) {
            zzkx.zzc((String)"Unable to process ad data", (Throwable)remoteException);
        }
        catch (zzcg zzcg2) {
            zzkx.zzc((String)"Unable to parse ad click url", (Throwable)zzcg2);
        }
        return uri.toString();
    }

    private void zzad(String string2) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)string2));
        this.mContext.startActivity(intent);
    }

    private Future<zzcf> zzgc() {
        return zzla.zza(new Callable<zzcf>(){

            public zzcf zzgd() throws Exception {
                return new zzcf(((zzt)zzt.this).zzanu.zzda, zzt.this.mContext, false);
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.zzgd();
            }
        });
    }

    private static class zzb {
        private final String zzapw;
        private final Map<String, String> zzapx;
        private String zzapy;
        private String zzapz;

        public zzb(String string2) {
            this.zzapw = string2;
            this.zzapx = new TreeMap<String, String>();
        }

        public String zzge() {
            return this.zzapz;
        }

        public String getQuery() {
            return this.zzapy;
        }

        public String zzgf() {
            return this.zzapw;
        }

        public Map<String, String> zzgg() {
            return this.zzapx;
        }

        public void zzi(AdRequestParcel adRequestParcel) {
            this.zzapy = adRequestParcel.zzays.zzbcj;
            Bundle bundle = null;
            if (adRequestParcel.zzayv != null) {
                bundle = adRequestParcel.zzayv.getBundle(AdMobAdapter.class.getName());
            }
            if (bundle == null) {
                return;
            }
            String string2 = zzdr.zzbke.get();
            for (String string3 : bundle.keySet()) {
                if (string2.equals(string3)) {
                    this.zzapz = bundle.getString(string3);
                    continue;
                }
                if (!string3.startsWith("csa_")) continue;
                this.zzapx.put(string3.substring("csa_".length()), bundle.getString(string3));
            }
        }
    }

    private class zza
    extends AsyncTask<Void, Void, String> {
        private zza() {
        }

        protected String zza(Void ... voidArray) {
            try {
                zzt.this.zzapt = (zzcf)zzt.this.zzapq.get(zzdr.zzbkf.get(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException exception) {
                zzkx.zzc((String)"Failed to load ad data", (Throwable)exception);
            }
            catch (TimeoutException timeoutException) {
                zzkx.zzdi((String)"Timed out waiting for ad data");
            }
            return zzt.this.zzga();
        }

        protected void zzae(String string2) {
            if (zzt.this.zzaps != null && string2 != null) {
                zzt.this.zzaps.loadUrl(string2);
            }
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.zzae((String)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.zza((Void[])objectArray);
        }
    }
}

