/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzlm;
import java.lang.ref.WeakReference;
import java.util.HashSet;

@zzji
@TargetApi(value=14)
public class zzcu
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzauk = zzdr.zzbgu.get();
    private final Context zzatc;
    private Application zzaul;
    private final WindowManager zzati;
    private final PowerManager zzatj;
    private final KeyguardManager zzatk;
    @Nullable
    BroadcastReceiver zzatr;
    private WeakReference<ViewTreeObserver> zzaum;
    WeakReference<View> zzaun;
    private zzcv zzauo;
    private zzlm zzasn = new zzlm(zzauk);
    private boolean zzatq = false;
    private int zzaup = -1;
    private HashSet<zzb> zzauq = new HashSet();
    private DisplayMetrics zzaur;

    public zzcu(Context context, View view) {
        this.zzatc = context.getApplicationContext();
        this.zzati = (WindowManager)context.getSystemService("window");
        this.zzatj = (PowerManager)this.zzatc.getSystemService("power");
        this.zzatk = (KeyguardManager)context.getSystemService("keyguard");
        if (this.zzatc instanceof Application) {
            this.zzaul = (Application)this.zzatc;
            this.zzauo = new zzcv((Application)this.zzatc, this);
        }
        this.zzaur = context.getResources().getDisplayMetrics();
        this.zze(view);
    }

    public void zze(View view) {
        View view2;
        View view3 = view2 = this.zzaun != null ? (View)this.zzaun.get() : null;
        if (view2 != null) {
            view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzg(view2);
        }
        this.zzaun = new WeakReference<View>(view);
        if (view != null) {
            if (zzu.zzgo().isAttachedToWindow(view)) {
                this.zzf(view);
            }
            view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }
    }

    public void zza(zzb zzb2) {
        this.zzauq.add(zzb2);
        this.zzl(3);
    }

    private void zziw() {
        zzu.zzgm();
        zzlb.zzcvl.post(new Runnable(){

            @Override
            public void run() {
                zzcu.this.zzl(3);
            }
        });
    }

    public void onViewAttachedToWindow(View view) {
        this.zzaup = -1;
        this.zzf(view);
        this.zzl(3);
    }

    public void onViewDetachedFromWindow(View view) {
        this.zzaup = -1;
        this.zzl(3);
        this.zzg(view);
    }

    private void zza(Activity activity, int n) {
        if (this.zzaun == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzaun.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzaup = n;
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzl(3);
        this.zziw();
    }

    public void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzl(3);
        this.zziw();
    }

    public void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzl(3);
        this.zziw();
    }

    public void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzl(3);
        this.zziw();
    }

    public void onActivityStopped(Activity activity) {
        this.zzl(3);
        this.zziw();
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzl(3);
        this.zziw();
    }

    public void onActivityDestroyed(Activity activity) {
        this.zzl(3);
        this.zziw();
    }

    public void onGlobalLayout() {
        this.zzl(2);
    }

    public void onScrollChanged() {
        this.zzl(1);
    }

    private void zzie() {
        if (this.zzatr != null) {
            return;
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        this.zzatr = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                zzcu.this.zzl(3);
            }
        };
        this.zzatc.registerReceiver(this.zzatr, intentFilter);
    }

    private void zzif() {
        if (this.zzatr != null) {
            try {
                this.zzatc.unregisterReceiver(this.zzatr);
            }
            catch (IllegalStateException illegalStateException) {
                zzkx.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzu.zzgq().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            this.zzatr = null;
        }
    }

    private void zzl(int n) {
        boolean bl;
        if (this.zzauq.size() == 0) {
            return;
        }
        if (this.zzaun == null) {
            return;
        }
        View view = (View)this.zzaun.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        Rect rect5 = new Rect();
        rect5.right = this.zzati.getDefaultDisplay().getWidth();
        rect5.bottom = this.zzati.getDefaultDisplay().getHeight();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzkx.zzb((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzaup != -1 ? this.zzaup : n2;
        boolean bl6 = bl = !bl3 && zzu.zzgm().zza(view, this.zzatj, this.zzatk) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzasn.tryAcquire() && bl == this.zzatq) {
            return;
        }
        if (!bl && !this.zzatq && n == 1) {
            return;
        }
        zza zza2 = new zza(zzu.zzgs().elapsedRealtime(), this.zzatj.isScreenOn(), view != null ? zzu.zzgo().isAttachedToWindow(view) : false, view != null ? view.getWindowVisibility() : 8, this.zza(rect5), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzaur.density, bl);
        for (zzb zzb2 : this.zzauq) {
            zzb2.zza(zza2);
        }
        this.zzatq = bl;
    }

    Rect zza(Rect rect) {
        return new Rect(this.zzm(rect.left), this.zzm(rect.top), this.zzm(rect.right), this.zzm(rect.bottom));
    }

    private int zzm(int n) {
        float f = this.zzaur.density;
        return (int)((float)n / f);
    }

    private void zzf(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzaum = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.zzie();
        if (this.zzaul != null) {
            try {
                this.zzaul.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzauo);
            }
            catch (Exception exception) {
                zzkx.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private void zzg(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzaum != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzaum.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzaum = null;
            }
        }
        catch (Exception exception) {
            zzkx.zzb((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzkx.zzb((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        this.zzif();
        if (this.zzaul != null) {
            try {
                this.zzaul.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzauo);
            }
            catch (Exception exception) {
                zzkx.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    public static interface zzb {
        public void zza(zza var1);
    }

    public static class zza {
        public final long timestamp;
        public final boolean zzaut;
        public final boolean zzauu;
        public final int zzauv;
        public final Rect zzauw;
        public final Rect zzaux;
        public final Rect zzauy;
        public final boolean zzauz;
        public final Rect zzava;
        public final boolean zzavb;
        public final Rect zzavc;
        public final float zzavd;
        public final boolean zzave;

        public zza(long l, boolean bl, boolean bl2, int n, Rect rect, Rect rect2, Rect rect3, boolean bl3, Rect rect4, boolean bl4, Rect rect5, float f, boolean bl5) {
            this.timestamp = l;
            this.zzaut = bl;
            this.zzauu = bl2;
            this.zzauv = n;
            this.zzauw = rect;
            this.zzaux = rect2;
            this.zzauy = rect3;
            this.zzauz = bl3;
            this.zzava = rect4;
            this.zzavb = bl4;
            this.zzavc = rect5;
            this.zzavd = f;
            this.zzave = bl5;
        }
    }
}

