/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzcx;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzdr;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzkx;
import com.google.android.gms.internal.zzmd;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzji
@TargetApi(value=14)
public class zzda
extends Thread {
    private boolean mStarted = false;
    private boolean zzawh = false;
    private boolean zzbl = false;
    private final Object zzako;
    private final zzcy zzawi;
    private final zzjh zzawj;
    private final int zzawk;
    private final int zzavi;
    private final int zzawl;
    private final int zzavk;
    private final int zzawm;
    private final int zzawn;
    private final int zzawo;
    private final int zzawp;
    private final String zzawq;

    public zzda(zzcy zzcy2, zzjh zzjh2) {
        this.zzawi = zzcy2;
        this.zzawj = zzjh2;
        this.zzako = new Object();
        this.zzavi = zzdr.zzbev.get();
        this.zzawl = zzdr.zzbew.get();
        this.zzavk = zzdr.zzbex.get();
        this.zzawm = zzdr.zzbey.get();
        this.zzawn = zzdr.zzbfb.get();
        this.zzawo = zzdr.zzbfd.get();
        this.zzawp = zzdr.zzbfe.get();
        this.zzawk = zzdr.zzbez.get();
        this.zzawq = zzdr.zzbfg.get();
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzjh() {
        Object object = this.zzako;
        synchronized (object) {
            if (this.mStarted) {
                zzkx.zzdg((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object;
            if (false) break;
            try {
                if (this.zzji()) {
                    object = zzu.zzgp().getActivity();
                    if (object == null) {
                        zzkx.zzdg((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzjk();
                    } else {
                        this.zza((Activity)object);
                    }
                } else {
                    zzkx.zzdg((String)"ContentFetchTask: sleeping");
                    this.zzjk();
                }
                Thread.sleep(this.zzawk * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzkx.zzb((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Throwable throwable) {
                zzkx.zzb((String)"Error in ContentFetchTask", (Throwable)throwable);
                this.zzawj.zza(throwable, "ContentFetchTask.run");
            }
            object = this.zzako;
            synchronized (object) {
                while (this.zzawh) {
                    try {
                        zzkx.zzdg((String)"ContentFetchTask: waiting");
                        this.zzako.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    boolean zzh(final @Nullable View view) {
        if (view == null) {
            return false;
        }
        view.post(new Runnable(){

            @Override
            public void run() {
                zzda.this.zzi(view);
            }
        });
        return true;
    }

    void zzi(View view) {
        try {
            zzcx zzcx2 = new zzcx(this.zzavi, this.zzawl, this.zzavk, this.zzawm, this.zzawn, this.zzawo, this.zzawp);
            zza zza2 = this.zza(view, zzcx2);
            zzcx2.zzje();
            if (zza2.zzawy == 0 && zza2.zzawz == 0) {
                return;
            }
            if (zza2.zzawz == 0 && zzcx2.zzjf() == 0) {
                return;
            }
            if (zza2.zzawz == 0 && this.zzawi.zza(zzcx2)) {
                return;
            }
            this.zzawi.zzc(zzcx2);
        }
        catch (Exception exception) {
            zzkx.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzawj.zza(exception, "ContentFetchTask.fetchContent");
        }
    }

    boolean zzh(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    boolean zzji() {
        try {
            Context context = zzu.zzgp().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (!this.zza(runningAppProcessInfo) || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzh(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    boolean zza(ActivityManager.RunningAppProcessInfo runningAppProcessInfo) {
        return runningAppProcessInfo.importance == 100;
    }

    void zza(@Nullable Activity activity) {
        if (activity == null) {
            return;
        }
        View view = null;
        try {
            if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                view = activity.getWindow().getDecorView().findViewById(0x1020002);
            }
        }
        catch (Throwable throwable) {
            zzkx.zzdg((String)"Failed getting root view of activity. Content not extracted.");
        }
        if (view == null) {
            return;
        }
        this.zzh(view);
    }

    zza zza(@Nullable View view, zzcx zzcx2) {
        if (view == null) {
            return new zza(0, 0);
        }
        Context context = zzu.zzgp().getContext();
        if (context != null) {
            int n = context.getResources().getIdentifier(zzdr.zzbff.get(), "id", context.getPackageName());
            String string2 = (String)view.getTag(n);
            if (!TextUtils.isEmpty((CharSequence)this.zzawq) && string2 != null && string2.equals(this.zzawq)) {
                return new zza(0, 0);
            }
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            TextView textView = (TextView)view;
            CharSequence charSequence = textView.getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string3 = charSequence.toString();
                zzcx2.zzb(string3, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zza(1, 0);
            }
            return new zza(0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzmd)) {
            zzcx2.zzjd();
            if (this.zza((WebView)view, zzcx2, bl)) {
                return new zza(0, 1);
            }
            return new zza(0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zza zza2 = this.zza(viewGroup.getChildAt(i), zzcx2);
                n += zza2.zzawy;
                n2 += zza2.zzawz;
            }
            return new zza(n, n2);
        }
        return new zza(0, 0);
    }

    @TargetApi(value=19)
    boolean zza(final WebView webView, final zzcx zzcx2, final boolean bl) {
        if (!zzs.zzayu()) {
            return false;
        }
        zzcx2.zzjd();
        webView.post(new Runnable(){
            ValueCallback<String> zzawt = new ValueCallback<String>(){

                public void zzaf(String string2) {
                    zzda.this.zza(zzcx2, webView, string2, bl);
                }

                public /* synthetic */ void onReceiveValue(Object object) {
                    this.zzaf((String)object);
                }
            };

            @Override
            public void run() {
                if (webView.getSettings().getJavaScriptEnabled()) {
                    try {
                        webView.evaluateJavascript("(function() { return  {text:document.body.innerText}})();", this.zzawt);
                    }
                    catch (Throwable throwable) {
                        this.zzawt.onReceiveValue((Object)"");
                    }
                }
            }
        });
        return true;
    }

    void zza(zzcx zzcx2, WebView webView, String string2, boolean bl) {
        zzcx2.zzjc();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.optString("text");
                if (!TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = String.valueOf(webView.getTitle());
                    zzcx2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzcx2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzcx2.zzix()) {
                this.zzawi.zzb(zzcx2);
            }
        }
        catch (JSONException jSONException) {
            zzkx.zzdg((String)"Json string may be malformed.");
        }
        catch (Throwable throwable) {
            zzkx.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzawj.zza(throwable, "ContentFetchTask.processWebViewContent");
        }
    }

    public zzcx zzjj() {
        return this.zzawi.zzjg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.zzako;
        synchronized (object) {
            this.zzawh = false;
            this.zzako.notifyAll();
            zzkx.zzdg((String)"ContentFetchThread: wakeup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzjk() {
        Object object = this.zzako;
        synchronized (object) {
            boolean bl = this.zzawh = true;
            zzkx.zzdg((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
        }
    }

    public boolean zzjl() {
        return this.zzawh;
    }

    @zzji
    class zza {
        final int zzawy;
        final int zzawz;

        zza(int n, int n2) {
            this.zzawy = n;
            this.zzawz = n2;
        }
    }
}

